<?php
/*
Plugin Name: Kua Number Calculator
Description: محاسبه عدد کوآ بر اساس جنسیت و تاریخ تولد + نمایش محصولات مرتبط | powerd by Niloofar Vafaei [Weblabs]
Version: 1.0
Author: Weblabs | NilooFar Vafaei
Author URI: https://weblabs.ir
*/

if (!defined('ABSPATH'))exit;

if (!session_id()) session_start(); 


if (is_admin()) { require_once plugin_dir_path(__FILE__) . 'assets/include/admin-settings.php';
}

function kua_enqueue_styles() { wp_enqueue_style('kua-calculator-styles', plugin_dir_url(__FILE__) . 'assets/css/style.css');
}

require_once plugin_dir_path(__FILE__) . 'assets/include/kua-calculation.php';
add_action('wp_enqueue_scripts', 'kua_enqueue_styles');
add_shortcode('kua_calculator', 'kua_calculator_form');


function kua_calculator_form() {ob_start();
include plugin_dir_path(__FILE__) . 'assets/include/kua-calculator-form.php';
return ob_get_clean();
}
include plugin_dir_path(__FILE__) . 'assets/include/kua-product-metabox.php';   
include plugin_dir_path(__FILE__) . 'assets/include/kua-related-products.php'; 



add_action('wp_enqueue_scripts', 'kua_enqueue_owl_assets');
function kua_enqueue_owl_assets() {
    wp_register_style('owl-carousel', 'https://cdn.jsdelivr.net/npm/owl.carousel@2.3.4/dist/assets/owl.carousel.min.css');
    wp_register_style('owl-theme', 'https://cdn.jsdelivr.net/npm/owl.carousel@2.3.4/dist/assets/owl.theme.default.min.css');
    wp_register_script('owl-carousel', 'https://cdn.jsdelivr.net/npm/owl.carousel@2.3.4/dist/owl.carousel.min.js', ['jquery'], null, true);

    wp_enqueue_style('owl-carousel');
    wp_enqueue_style('owl-theme');
    wp_enqueue_script('owl-carousel');
}

add_action('wp_footer', 'kua_init_owl_script');
function kua_init_owl_script() {
    ?>
    <script>
        jQuery(document).ready(function($) {
            $('.kua-owl-carousel').owlCarousel({
                rtl: true,
                loop: true,
                margin: 20,
                nav: false,
                dots: false,
                autoplay: true,
                responsive: {
                    0: { items: 1 },
                    600: { items: 2 },
                    1000: { items: 5 }
                }
            });
        });
    </script>
    <?php
}