<?php
// نمایش محصولات مرتبط
add_shortcode('kua_related_products', 'kua_render_related_products');
function kua_render_related_products() {
    ob_start();

    // بررسی سشن
    if (!isset($_SESSION['kua_number']) || !isset($_SESSION['kua_gender'])) {
        return ''; // اگر سشن خالی است، هیچ چیزی نمایش نده
    }

    $kua = intval($_SESSION['kua_number']);
    $gender = sanitize_text_field($_SESSION['kua_gender']);

    // دریافت محصولات مرتبط
    $args = [
        'post_type' => 'product',
        'posts_per_page' => 10,
        'meta_query' => [
            [
                'key' => '_kua_number',
                'value' => $kua,
                'compare' => '='
            ],
            [
                'key' => '_kua_gender',
                'value' => [$gender, 'both'],
                'compare' => 'IN'
            ]
        ]
    ];

    $related_query = new WP_Query($args);

    if ($related_query->have_posts()) {
        echo '<h3 style="margin-top:30px;">محصولات مناسب عدد کوآ ' . $kua . '</h3>';
        echo '<div class="owl-carousel kua-owl-carousel">';
        
        while ($related_query->have_posts()) {
            $related_query->the_post();
            global $product;

            echo '<div class="item prod-style-3" style="text-align:center;">';
            echo '<a href="' . get_permalink() . '">';
            echo woocommerce_get_product_thumbnail();
            echo '<h4>' . get_the_title() . '</h4>';
            if ($product->is_on_sale()) {
    
        echo '<p class="price"><span class="discount-price">' . wc_price($product->get_sale_price()) . '</span> <span class="regular-price">' . wc_price($product->get_regular_price()) . '</span></p>';
    } else {
        
        echo '<p class="price">' . wc_price($product->get_price()) . '</p>';
    }
            echo '</a>';
            echo '</div>';
        }

        echo '</div>';
        wp_reset_postdata();
    }

    return ob_get_clean();
}
