<?php
add_action('add_meta_boxes', 'kua_add_product_metabox');
function kua_add_product_metabox() {
    add_meta_box(
        'kua_product_meta',
        'تنظیمات عدد کوآ و جنسیت محصول',
        'kua_render_product_metabox',
        'product',
        'side',
        'default'
    );
}

function kua_render_product_metabox($post) {
    $saved_kua = get_post_meta($post->ID, '_kua_number', true);
    $saved_gender = get_post_meta($post->ID, '_kua_gender', true);


    echo '<label for="kua_number">عدد کوآ:</label><br>';
    echo '<select name="kua_number" id="kua_number" style="width: 100%;">';
    echo '<option value="">-- انتخاب عدد --</option>';
    foreach ([1, 2, 3, 4, 6, 7, 8, 9] as $num) {
        echo '<option value="' . $num . '" ' . selected($saved_kua, $num, false) . '>' . $num . '</option>';
    }
    echo '</select><br><br>';

    
    echo '<label>جنسیت مناسب:</label><br>';
    $genders = ['male' => 'مرد', 'female' => 'زن', 'both' => 'هر دو'];
    foreach ($genders as $key => $label) {
        echo '<label><input type="radio" name="kua_gender" value="' . $key . '" ' . checked($saved_gender, $key, false) . '> ' . $label . '</label><br>';
    }
}


add_action('save_post_product', 'kua_save_product_meta');
function kua_save_product_meta($post_id) {
    if (isset($_POST['kua_number'])) {
        update_post_meta($post_id, '_kua_number', sanitize_text_field($_POST['kua_number']));
    }

    if (isset($_POST['kua_gender'])) {
        update_post_meta($post_id, '_kua_gender', sanitize_text_field($_POST['kua_gender']));
    }
}
