<?php
// شروع فرمی که قبلاً نوشته شده بود
?>

<div class="kua-form-section">
<h2>محاسبه گر عدد کوآ مهدیس استور</h2>
<form method="post" class="kua-form">
    <label>جنسیت:</label><br>
    <label><input type="radio" name="kua_gender" value="male" required> مرد</label>
    <label><input type="radio" name="kua_gender" value="female" required> زن</label><br><br>
<br>
    <label>تاریخ تولد (شمسی):</label><br>
    <select name="kua_day" required>
        <option value="">روز</option>
        <?php for ($i = 1; $i <= 31; $i++) echo "<option value='$i'>$i</option>"; ?>
    </select>

    <select name="kua_month" required>
        <option value="">ماه</option>
        <?php
        $months = ['فروردین', 'اردیبهشت', 'خرداد', 'تیر', 'مرداد', 'شهریور', 'مهر', 'آبان', 'آذر', 'دی', 'بهمن', 'اسفند'];
        for ($i = 1; $i <= 12; $i++) {
            echo "<option value='$i'>{$months[$i - 1]}</option>";
        }
        ?>
    </select>

    <input type="number" name="kua_year" placeholder="سال" required><br><br>

    <button type="submit" name="kua_submit">محاسبه عدد کوآ</button>
</form>
</div>
<br>

<?php

// بررسی ارسال فرم و محاسبه عدد کوآ
if (isset($_POST['kua_submit'])) {
    // دریافت اطلاعات فرم
    $gender = sanitize_text_field($_POST['kua_gender']);
    $day = isset($_POST['kua_day']) ? intval($_POST['kua_day']) : 0;
    $month = isset($_POST['kua_month']) ? intval($_POST['kua_month']) : 0;
    $year = isset($_POST['kua_year']) ? intval($_POST['kua_year']) : 0;

    $errors = [];

    // بررسی خطاها
    if (!$gender) $errors[] = 'لطفاً جنسیت خود را انتخاب کنید.';
    if (!$day) $errors[] = 'لطفاً روز تولد خود را وارد کنید.';
    if (!$month) $errors[] = 'لطفاً ماه تولد خود را وارد کنید.';
    if (!$year) $errors[] = 'لطفاً سال تولد خود را وارد کنید.';
    if ($day < 1 || $day > 31) $errors[] = 'عدد روز باید بین ۱ تا ۳۱ باشد.';
    if ($month < 1 || $month > 12) $errors[] = 'عدد ماه باید بین ۱ تا ۱۲ باشد.';
    if ($year < 1000 || $year > 1500) $errors[] = 'عدد سال باید ۴ رقمی و معتبر باشد.';

    // اگر خطا داشت، نمایش خطا
    if (!empty($errors)) {
        foreach ($errors as $err) {
            echo "<p style='color:red;'>$err</p>";
        }
        // اگر خطا داشت، سشن رو پاک کن
        unset($_SESSION['kua_number'], $_SESSION['kua_gender']);
    } else {
        // اگر ورودی معتبر بود، عدد کوآ رو محاسبه کن
        list($g_y, $g_m, $g_d) = kua_persian_to_gregorian($year, $month, $day);

        if ($g_y > 0) {
            $kua = calculate_kua_number($gender, $g_y);
            $_SESSION['kua_number'] = $kua;
            $_SESSION['kua_gender'] = $gender;

            // نمایش عدد کوآ
            $img_url = get_option("kua_img_$kua");
            $desc = get_option("kua_desc_$kua");

            echo '<div class="kua-output-box">';

            if ($img_url) {
                echo "<img src='" . esc_url($img_url) . "' alt='Kua " . $kua . "' style='max-width:150px;float:right;margin-left:20px;'>";
            }

            echo '<h3>عدد کوآ شما: <strong>' . $kua . '</strong></h3>';
            echo '<p>' . nl2br(esc_html($desc)) . '</p>';
            echo '<div style="clear:both;"></div>';
            echo '</div>';

            // نمایش محصولات مرتبط
            kua_render_related_products();
        } else {
            echo '<p style="color:red;">خطا در تبدیل تاریخ! لطفاً دوباره بررسی کنید.</p>';
        }
    }
}

?>
