<?php 


// ✅ تبدیل تاریخ شمسی به میلادی (تابع دستی ساده)
function kua_persian_to_gregorian($jy, $jm, $jd) {
    $gy = $jy + 621;
    $days = array(0, 31, ($gy % 4 == 0 && $gy % 100 != 0 || $gy % 400 == 0) ? 29 : 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
    $g_days = 79 + $jd;

    for ($i = 1; $i < $jm; ++$i) {
        $g_days += ($i <= 6) ? 31 : 30;
    }

    if ($g_days > ($gy % 4 == 0 && $gy % 100 != 0 || $gy % 400 == 0 ? 366 : 365)) {
        $gy++;
        $g_days -= ($gy % 4 == 0 && $gy % 100 != 0 || $gy % 400 == 0) ? 366 : 365;
    }

    for ($i = 1; $i <= 12 && $g_days > $days[$i]; $i++) {
        $g_days -= $days[$i];
    }

    return [$gy, $i, $g_days];
}

// ✅ محاسبه عدد کوآ
function calculate_kua_number($gender, $year) {
    $last_two_digits = $year % 100;
    $sum = array_sum(str_split($last_two_digits));

    while ($sum > 9) {
        $sum = array_sum(str_split($sum));
    }

    if ($gender === 'male') {
        $kua = 10 - $sum;
        if ($kua === 5) $kua = 2;
    } else {
        $kua = $sum + 5;
        if ($kua > 9) $kua = array_sum(str_split($kua));
        if ($kua === 5) $kua = 8;
    }

    return $kua;
}