<?php
add_action('admin_menu', 'kua_add_settings_menu');

function kua_add_settings_menu() {
    add_menu_page(
        'تنظیمات عدد کوآ',
        'تنظیمات عدد کوآ',
        'manage_options',
        'kua_settings',
        'kua_render_settings_page',
        'dashicons-calendar-alt',
        80
    );
}

function kua_render_settings_page() {
    if (!current_user_can('manage_options')) return;

    // ذخیره تنظیمات
    if (isset($_POST['kua_settings_submit'])) {
        foreach ([1, 2, 3, 4, 6, 7, 8, 9] as $i) {
            update_option("kua_desc_$i", wp_kses_post($_POST["kua_desc_$i"]));
            update_option("kua_img_$i", esc_url_raw($_POST["kua_img_$i"]));
        }
        echo '<div class="updated"><p>تنظیمات ذخیره شد.</p></div>';
    }

    ?>
    <div class="wrap">
        <h1>تنظیمات عدد کوآ</h1>
        <div class="kua-settings-container">
            <div class="kua-sidebar">
                <?php foreach ([1, 2, 3, 4, 6, 7, 8, 9] as $i): ?>
                    <button type="button" class="kua-tab-btn" data-tab="kua_tab_<?php echo $i; ?>">
                        عدد کوآ <?php echo $i; ?>
                    </button>
                <?php endforeach; ?>
            </div>

            <div class="kua-tab-content">
                <form method="post">
                    <?php foreach ([1, 2, 3, 4, 6, 7, 8, 9] as $i): 
                        $desc = get_option("kua_desc_$i", '');
                        $img = get_option("kua_img_$i", '');
                    ?>
                   <div class="kua-tab" id="kua_tab_<?php echo $i; ?>">
    <h2>تنظیمات عدد کوآ <?php echo $i; ?></h2>

    <div style="display: flex; gap: 30px;">
        <!-- ویرایشگر متن -->
        <div style="flex: 1;">
            <label>توضیح:</label><br>
            <?php
            wp_editor($desc, "kua_desc_$i", array(
                'textarea_name' => "kua_desc_$i",
                'media_buttons' => false,
                'textarea_rows' => 5,
            ));
            ?>
        </div>

        <!-- باکس تصویر -->
        <div style="width: 260px; background: #f9f9f9; padding: 10px; border: 1px solid #ccc;">
            <label>تصویر:</label><br>
            <input type="text" id="kua_img_<?php echo $i; ?>" name="kua_img_<?php echo $i; ?>" value="<?php echo esc_attr($img); ?>" style="width: 100%;" />
            <button class="button kua-upload-btn" data-target="kua_img_<?php echo $i; ?>" style="margin-top:5px;">آپلود تصویر</button>

            <?php if ($img): ?>
                <div><img src="<?php echo esc_url($img); ?>" style="max-width:100%;margin-top:10px;"></div>
            <?php endif; ?>
        </div>
    </div>
</div>

                    <?php endforeach; ?>

                    <br>
                    <input type="submit" name="kua_settings_submit" class="button button-primary" value="ذخیره تنظیمات">
                </form>
            </div>
        </div>

        <style>
            .kua-settings-container {
                display: flex;
                margin-top: 20px;
            }
            .kua-sidebar {
                width: 200px;
                border-right: 1px solid #ddd;
                padding-right: 10px;
            }
            .kua-tab-btn {
                display: block;
                width: 100%;
                padding: 10px;
                text-align: right;
                margin-bottom: 5px;
                background: #f1f1f1;
                border: none;
                cursor: pointer;
            }
            .kua-tab-btn.active {
                background-color: #007cba;
                color: white;
            }
            .kua-tab-content {
                flex: 1;
                padding-left: 20px;
            }
            .kua-tab {
                display: none;
            }
            .kua-tab.active {
                display: block;
            }
        </style>

        <script>
            document.addEventListener('DOMContentLoaded', function () {
                const buttons = document.querySelectorAll('.kua-tab-btn');
                const tabs = document.querySelectorAll('.kua-tab');

                buttons.forEach(btn => {
                    btn.addEventListener('click', function () {
                        buttons.forEach(b => b.classList.remove('active'));
                        tabs.forEach(t => t.classList.remove('active'));

                        btn.classList.add('active');
                        document.getElementById(btn.dataset.tab).classList.add('active');
                    });
                });

                if (buttons.length > 0) buttons[0].click();
            });
        </script>
    </div>
    <?php
}

add_action('admin_footer', 'kua_admin_media_script');
function kua_admin_media_script() {
    ?>
    <script>
        jQuery(document).ready(function ($) {
            $('.kua-upload-btn').click(function (e) {
                e.preventDefault();
                var button = $(this);
                var targetInput = $('#' + button.data('target'));

                var custom_uploader = wp.media({
                    title: 'انتخاب تصویر',
                    button: {
                        text: 'استفاده از این تصویر'
                    },
                    multiple: false
                })
                .on('select', function () {
                    var attachment = custom_uploader.state().get('selection').first().toJSON();
                    targetInput.val(attachment.url);
                })
                .open();
            });
        });
    </script>
    <?php
}
