<?php
/**
 * Simple product add to cart
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/add-to-cart/simple.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.0.1
 */

defined('ABSPATH') || exit;

global $product;

if (!$product->is_purchasable()) {
    return;
}

echo wc_get_stock_html($product); // WPCS: XSS ok.

if ($product->is_in_stock()) : ?>

    <?php do_action('woocommerce_before_add_to_cart_form'); ?>

    <form class="cart"
          action="<?php echo esc_url(apply_filters('woocommerce_add_to_cart_form_action', $product->get_permalink())); ?>"
          method="post" enctype='multipart/form-data'>
        <?php do_action('woocommerce_before_add_to_cart_button'); ?>

        <?php
        do_action('woocommerce_before_add_to_cart_quantity');

        woocommerce_quantity_input(
            array(
                'min_value' => apply_filters('woocommerce_quantity_input_min', $product->get_min_purchase_quantity(), $product),
                'max_value' => apply_filters('woocommerce_quantity_input_max', $product->get_max_purchase_quantity(), $product),
                'input_value' => isset($_POST['quantity']) ? wc_stock_amount(wp_unslash($_POST['quantity'])) : $product->get_min_purchase_quantity(), // WPCS: CSRF ok, input var ok.
            )
        );
        do_action('woocommerce_after_add_to_cart_quantity');
        ?>
        <div class="<?php echo esc_attr(apply_filters('woocommerce_product_price_class', 'price')); ?>">
            <div class="off">
                <?php echo $product->get_price_html(); ?>
            </div>
            <?php if ($product->is_on_sale()) : ?>
                <div class="sale-image">
                    <svg width="55px" height="40px" viewBox="0 0 112 73" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M102.419 41.4925L111.209 24.3437L96.8749 11.4984L80.325 0.00268555L54.6504 3.84369L0.60498 14.1263L11.3588 72.3025L65.7392 63.8317L91.0789 58.1786L102.419 41.4925ZM87.9999 36C92.4182 36 95.9999 32.4183 95.9999 28C95.9999 23.5818 92.4182 20 87.9999 20C83.5817 20 79.9999 23.5818 79.9999 28C79.9999 32.4183 83.5817 36 87.9999 36Z" fill="#FF8E6E"/>
</svg> 
                    <span><?= ultra_woocommerce_discount(get_the_id()); ?> % </span>
                </div>
            <?php endif; ?>
        </div>
        <button type="submit" name="add-to-cart" value="<?php echo esc_attr($product->get_id()); ?>"
                class="single_add_to_cart_button button alt<?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?> buy-btn"><?php echo esc_html($product->single_add_to_cart_text()); ?></button>

        <?php do_action('woocommerce_after_add_to_cart_button');
        global $ultra_options;
        $quantity = $product->get_stock_quantity();
        $custom_quantity = $ultra_options['number_stock_quantity_product'];

        if ($ultra_options['check_stock_quantity_product'] == 1) {
            if ($quantity < $custom_quantity && $quantity > 0) {
                ?>
                <span>فقط <?php echo $quantity; ?> عدد در انبار باقی مانده</span>
                <?php
            }
        }?>
    </form>

    <?php do_action('woocommerce_after_add_to_cart_form'); ?>

<?php endif; ?>
