<?php
if (!defined('ABSPATH')) {
    exit; // امنیت: جلوگیری از دسترسی مستقیم
}

class WC_Gateway_Card_To_Card extends WC_Payment_Gateway
{
    public function __construct()
    {
        $this->id = 'card_to_card';
        $this->icon = '';
        $this->has_fields = true;
        $this->method_title = 'کارت به کارت';
        $this->method_description = 'پرداخت از طریق کارت به کارت با قابلیت تنظیم شماره کارت و اطلاعات مورد نیاز.';

        $this->init_form_fields();
        $this->init_settings();

        $this->enabled = $this->get_option('enabled');
        $this->title = $this->get_option('title');
        $this->description = $this->get_option('description');
        $this->card_number = $this->get_option('card_number');
        $this->card_holder_name = $this->get_option('card_holder_name');

        add_action('woocommerce_update_options_payment_gateways_' . $this->id, array($this, 'process_admin_options'));
    }

    public function init_form_fields()
    {
        $this->form_fields = array(
            'enabled' => array(
                'title' => 'فعال‌سازی',
                'type' => 'checkbox',
                'label' => 'درگاه کارت به کارت را فعال کن',
                'default' => 'yes'
            ),
            'title' => array(
                'title' => 'عنوان درگاه',
                'type' => 'text',
                'default' => 'کارت به کارت',
                'desc_tip' => true,
                'description' => 'این عنوان در صفحه پرداخت نمایش داده می‌شود.'
            ),
            'description' => array(
                'title' => 'توضیحات',
                'type' => 'textarea',
                'default' => 'لطفاً مبلغ را به شماره کارت زیر واریز کنید و اطلاعات تراکنش را وارد نمایید.',
            ),
            'card_number' => array(
                'title' => 'شماره کارت',
                'type' => 'text',
                'description' => 'شماره کارت مقصد را وارد کنید.',
            ),
            'card_holder_name' => array(
                'title' => 'نام صاحب کارت',
                'type' => 'text',
                'description' => 'نام صاحب کارت را وارد کنید.',
            ),
        );
    }

    public function payment_fields()
    {
        ?>
        <div class="ultra-card">
            <p><?php echo esc_html($this->description); ?></p>
            <div class="ultra-cardtcard">
                <p>
                    <strong>شماره کارت: </strong>
                    <span id="website-card-number"><?php echo esc_html($this->card_number); ?></span>
                    <button type="button" id="copy-card-number" style="margin-right: 10px; padding: 5px 10px; cursor: pointer;">
                        کپی
                    </button>
                </p>
                <i class="fa-solid fa-sim-card"></i>
                <p><strong>نام صاحب کارت:</strong> <?php echo esc_html($this->card_holder_name); ?></p>
            </div>
        </div>

        <div class="ultra-card-info">
            <p>
                <label for="customer_card_last4">چهار رقم آخر کارت شما:</label>
                <input type="text" name="customer_card_last4" required>
            </p>
            <p>
                <label for="transaction_code">کد پیگیری تراکنش:</label>
                <input type="text" name="transaction_code" required>
            </p>
        </div>

        <script type="text/javascript">
            document.getElementById('copy-card-number').addEventListener('click', function () {
                const cardNumber = document.getElementById('website-card-number').textContent;
                navigator.clipboard.writeText(cardNumber).then(function () {
                    alert('شماره کارت کپی شد!');
                }).catch(function (err) {
                    alert('مشکلی در کپی کردن پیش آمد: ' + err);
                });
            });
        </script>
        <?php
    }

    public function process_payment($order_id)
    {
        $order = wc_get_order($order_id);
        $order->update_status('wc-card-to-card', 'پرداخت با کارت به کارت');
        wc_reduce_stock_levels($order_id);

        return array(
            'result' => 'success',
            'redirect' => $this->get_return_url($order)
        );
    }

    // اضافه کردن متد مورد نیاز برای رفع ارور
    public function get_plugin_file()
    {
        return __FILE__;
    }
}
?>