<?php
/**
 * My Account Dashboard
 *
 * Shows the first intro screen on the account dashboard.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/dashboard.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 4.4.0
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

$allowed_html = array(
    'a' => array(
        'href' => array(),
    ),
);
global $current_user;
global $ultra_options;
?>
    <section class="myaccount-detail">
        <div class="item-detail">
            <div class="detail-content">
                <h6>عضویت شما</h6>
             
                    <?php
                    //$user = wp_get_current_user();
                    //$udata = get_userdata( $current_user->id );
                    $register = $current_user->user_registered;
                    date_default_timezone_set("Asia/Tehran");
                    $now = time() - 3600;
                    $in = strtotime($register) + 12600;
                    echo '<span>' . human_time_diff($in, $now) . ' ' . __('قبل', 'ultra') . '</span>';
                    ?>
               
            </div>
        </div>
        <?php
        $current_user_id = get_current_user_id();
        $completed = wc_get_orders( array( 'status' => array( 'wc-completed' ), 'customer_id' => $current_user_id ) );
        ?>
        <div class="item-detail">
            <div class="detail-content">
                <h6>سفارشات موفق</h6>
                <span><?php echo count($completed); ?> سفارش</span>
            </div>
        </div>
        <div class="item-detail">
            <div class="detail-content">
                <h6>مجموع سفارشات</h6>
               
                    <?php
                    $user_id = get_current_user_id();
                    $iranwp_total_paid = wc_get_customer_total_spent($user_id) - '0.00';
                    // استفاده از number_format برای فرمت سه‌رقمی
                    echo '<span>' . number_format($iranwp_total_paid, 0, '.', ',') . " تومان" . '</span>';
                    ?>
               
            </div>
        </div>
        <div class="item-detail">
            <div class="detail-content">
                <h6>دیدگاه های شما</h6>
                    <?php
                    // دریافت تعداد دیدگاه‌های تأییدشده برای کاربر فعلی
                    $comment_count = get_comments(array(
                        'user_id' => get_current_user_id(), // استفاده از تابع بهینه برای دریافت ID کاربر
                        'status' => 'approve', // فیلتر برای نمایش دیدگاه‌های تأییدشده
                        'count' => true // تنها تعداد دیدگاه‌ها را برمی‌گرداند
                    ));
                    // نمایش تعداد دیدگاه‌ها
                    echo '<span>' . $comment_count . ' دیدگاه</span>';
                    ?>
            </div>
        </div>
    </section>
    <section class="notification-order">
        <div class="myAccount-order">
            <h6>آخرین سفارشات</h6>
            <ul class="recent-orders">
                <?php
                $customer_id = get_current_user_id();
                $args = array(
                    'customer_id' => $customer_id,
                    'limit' => 3,
                );

                $orders = wc_get_orders($args);

                if (!empty($orders)) {
                    foreach ($orders as $order) {
                        // شماره سفارش و وضعیت
                        $order_id = $order->get_id();
                        $status = wc_get_order_status_name($order->get_status());

                        // دریافت اولین آیتم سفارش
                        $items = $order->get_items();
                        $first_item = reset($items);  // گرفتن اولین آیتم

                        if ($first_item) {
                            $product = $first_item->get_product();
                            $product_name = $first_item->get_name();
                            $product_image = wp_get_attachment_image_src(get_post_thumbnail_id($product->get_id()), 'thumbnail');
                            ?>
                            <li>
                                <a href="<?php echo esc_url($order->get_view_order_url()); ?>">
                                    <?php if ($product_image): ?>
                                        <img src="<?php echo esc_url($product_image[0]); ?>"
                                             alt="<?php echo esc_attr($product_name); ?>"/>
                                    <?php else: ?>
                                        <img src="path-to-default-image.jpg"
                                             alt="<?php echo esc_attr($product_name); ?>"/>
                                    <?php endif; ?>
                                    <span>شماره سفارش: <?php echo esc_html($order_id); ?></span>
                                    <span>نام محصول: <?php echo esc_html($product_name); ?></span>
                                    <span>وضعیت: <?php echo esc_html($status); ?></span>
                                </a>
                            </li>
                            <?php
                        }
                    }
                } else {
                    echo '<li>شما هنوز سفارشی ثبت نکرده‌اید.</li>';
                }
                ?>
            </ul>
            <a class="view-more-orders" href="<?php echo esc_url(wc_get_account_endpoint_url('orders')); ?>">مشاهده
                بیشتر</a>
        </div>
        <div class="notification-address">
            <?php
            if ($ultra_options['check-notification-my-account'] == 1) { ?>
                <div class="myAccount-notification">
                    <div class="notif-head">
                       
                      <h6>  <?php echo $ultra_options['title-notification-my-account'] ?> </h6>
                 <div class="pulse-ultra">
                      <svg class="rotate-ultra circle-ultra svg-bell" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" fill="#000000" height="30px" width="30px" version="1.1" id="Capa_1" viewBox="0 0 611.999 611.999" xml:space="preserve">
<g>
  <g>
    <g>
      <path d="M570.107,500.254c-65.037-29.371-67.511-155.441-67.559-158.622v-84.578c0-81.402-49.742-151.399-120.427-181.203     C381.969,34,347.883,0,306.001,0c-41.883,0-75.968,34.002-76.121,75.849c-70.682,29.804-120.425,99.801-120.425,181.203v84.578     c-0.046,3.181-2.522,129.251-67.561,158.622c-7.409,3.347-11.481,11.412-9.768,19.36c1.711,7.949,8.74,13.626,16.871,13.626     h164.88c3.38,18.594,12.172,35.892,25.619,49.903c17.86,18.608,41.479,28.856,66.502,28.856     c25.025,0,48.644-10.248,66.502-28.856c13.449-14.012,22.241-31.311,25.619-49.903h164.88c8.131,0,15.159-5.676,16.872-13.626     C581.586,511.664,577.516,503.6,570.107,500.254z M484.434,439.859c6.837,20.728,16.518,41.544,30.246,58.866H97.32     c13.726-17.32,23.407-38.135,30.244-58.866H484.434z M306.001,34.515c18.945,0,34.963,12.73,39.975,30.082     c-12.912-2.678-26.282-4.09-39.975-4.09s-27.063,1.411-39.975,4.09C271.039,47.246,287.057,34.515,306.001,34.515z      M143.97,341.736v-84.685c0-89.343,72.686-162.029,162.031-162.029s162.031,72.686,162.031,162.029v84.826     c0.023,2.596,0.427,29.879,7.303,63.465H136.663C143.543,371.724,143.949,344.393,143.97,341.736z M306.001,577.485     c-26.341,0-49.33-18.992-56.709-44.246h113.416C355.329,558.493,332.344,577.485,306.001,577.485z"/>
      <path d="M306.001,119.235c-74.25,0-134.657,60.405-134.657,134.654c0,9.531,7.727,17.258,17.258,17.258     c9.531,0,17.258-7.727,17.258-17.258c0-55.217,44.923-100.139,100.142-100.139c9.531,0,17.258-7.727,17.258-17.258     C323.259,126.96,315.532,119.235,306.001,119.235z"/>
    </g>
  </g>
</g>
</svg>

                      </div> 
                    
                    </div>
                    <?php if ($ultra_options['content-notification-my-account']){ ?>
                    <p class="notif-text">
                        <?php echo $ultra_options['content-notification-my-account']; ?>
                    </p>
                    <?php }
                    else{
                        echo 'اطلاعیه ای وجود ندارد.';
                    }?>
                </div>
            <?php } ?>
            <div class="myAccount-address">
                <?php
                // گرفتن اطلاعات کاربر وارد شده
                $current_user = wp_get_current_user();
                // گرفتن آدرس حمل و نقل
                $shipping_address = WC()->customer->get_shipping_address();
                $shipping_city = WC()->customer->get_shipping_city();
                $shipping_postcode = WC()->customer->get_shipping_postcode();
                $shipping_country = WC()->customer->get_shipping_country();
                // اگر آدرس حمل و نقل موجود باشد، آن را نمایش بده
                if ($shipping_address || $shipping_city || $shipping_postcode || $shipping_country) {
                    echo '<h6>آدرس حمل و نقل شما</h6>';
                    echo '<p>' . $shipping_address . ', ' . $shipping_city . ', ' . $shipping_postcode . ', ' . $shipping_country . '</p>';

                    // لینک مدیریت آدرس حمل و نقل
                    echo '<a href="' . esc_url(wc_get_endpoint_url('edit-address', 'shipping', wc_get_page_permalink('myaccount'))) . '">مدیریت آدرس‌ها</a>';
                } else {
                    echo '<p>آدرس حمل و نقل ثبت نشده است.</p>';
                }
                ?>

            </div>
        </div>
    </section>

    <div class="panel-content" >
 
    <p>
        <?php
        printf(
        /* translators: 1: user display name 2: logout url */
            wp_kses(__('Hello %1$s (not %1$s? <a href="%2$s">Log out</a>)', 'woocommerce'), $allowed_html),
            '<strong>' . esc_html($current_user->display_name) . '</strong>',
            esc_url(wc_logout_url())
        );
        ?>
    </p>

    <p>
        <?php
        /* translators: 1: Orders URL 2: Address URL 3: Account URL. */
        $dashboard_desc = __('From your account dashboard you can view your <a href="%1$s">recent orders</a>, manage your <a href="%2$s">billing address</a>, and <a href="%3$s">edit your password and account details</a>.', 'woocommerce');
        if (wc_shipping_enabled()) {
            /* translators: 1: Orders URL 2: Addresses URL 3: Account URL. */
            $dashboard_desc = __('From your account dashboard you can view your <a href="%1$s">recent orders</a>, manage your <a href="%2$s">shipping and billing addresses</a>, and <a href="%3$s">edit your password and account details</a>.', 'woocommerce');
        }
        printf(
            wp_kses($dashboard_desc, $allowed_html),
            esc_url(wc_get_endpoint_url('orders')),
            esc_url(wc_get_endpoint_url('edit-address')),
            esc_url(wc_get_endpoint_url('edit-account'))
        );
        ?>
    </p>

    </div>

<?php
/**
 * My Account dashboard.
 *
 * @since 2.6.0
 */
do_action('woocommerce_account_dashboard');

/**
 * Deprecated woocommerce_before_my_account action.
 *
 * @deprecated 2.6.0
 */
do_action('woocommerce_before_my_account');

/**
 * Deprecated woocommerce_after_my_account action.
 *
 * @deprecated 2.6.0
 */
do_action('woocommerce_after_my_account');

/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
