<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.6.0
 */

defined('ABSPATH') || exit;

global $product;
global $ultra_options;
/**
 * Hook: woocommerce_before_single_product.
 *
 * @hooked woocommerce_output_all_notices - 10
 */
do_action('woocommerce_before_single_product');

if (post_password_required()) {
    echo get_the_password_form(); // WPCS: XSS ok.
    return;
}
?>
<div id="product-<?php the_ID(); ?>" <?php wc_product_class('', $product); ?>>
    <section class="main-product">
        <section class="product-box">
            <div class="product-top">
                <div class="image-side">
                    <?php
                    /**
                     * Hook: woocommerce_before_single_product_summary.
                     *
                     * @hooked woocommerce_show_product_sale_flash - 10
                     * @hooked woocommerce_show_product_images - 20
                     */
                    do_action('woocommerce_before_single_product_summary');
                    ?>
                </div>
                <div class="summary entry-summary">
                    <div class="top">
                        <h1><?php echo $product->get_name(); ?></h1>
                        <div class="action-side">
                            <?php
                            $video_product_box = get_field('video_product');
                            if (!empty($video_product_box)) {
                                $link_video_product = $video_product_box['link_video_product'];
                                $select_video_product = $video_product_box['select_video_product'];
                                if (!empty($select_video_product)) { ?>
                                    <div class="view_video_modal">
                                        <svg id="btn_modal_video" xmlns="http://www.w3.org/2000/svg" width="34"
                                             height="34"
                                             viewBox="0 0 11 12"
                                             fill="none">
                                            <path d="M9.35 6.95263L2.15 11.1096C1.41667 11.5329 0.499999 11.0037 0.499999 10.1569L0.5 1.84308C0.5 0.996297 1.41667 0.467059 2.15 0.89045L9.35 5.04737C10.0833 5.47076 10.0833 6.52924 9.35 6.95263Z"
                                                  stroke="#A8ADBE" stroke-width="0.7" stroke-linecap="round"
                                                  stroke-linejoin="round"></path>
                                        </svg>
                                        <div id="ultra-modal" class="ultra-modal">
                                            <!-- Modal content -->
                                            <div class="ultra_modal-content">
                                                <div class="header-modal">
                                                    <h5>ویدیو محصول</h5>
                                                    <span class="close_video_modal">&times;</span>
                                                </div>
                                                <video controls>
                                                    <source src="<?php echo $select_video_product; ?>" type="video/mp4">
                                                </video>
                                            </div>
                                        </div>
                                    </div>
                                <?php }
                                if (!empty($link_video_product) && empty($select_video_product)) { ?>
                                    <div class="view_video_modal">
                                        <svg id="btn_modal_video" xmlns="http://www.w3.org/2000/svg" width="34"
                                             height="34"
                                             viewBox="0 0 11 12"
                                             fill="none">
                                            <path d="M9.35 6.95263L2.15 11.1096C1.41667 11.5329 0.499999 11.0037 0.499999 10.1569L0.5 1.84308C0.5 0.996297 1.41667 0.467059 2.15 0.89045L9.35 5.04737C10.0833 5.47076 10.0833 6.52924 9.35 6.95263Z"
                                                  stroke="#A8ADBE" stroke-width="0.7" stroke-linecap="round"
                                                  stroke-linejoin="round"></path>
                                        </svg>
                                        <div id="ultra-modal" class="ultra-modal">
                                            <!-- Modal content -->
                                            <div class="ultra_modal-content">
                                                <div class="header-modal">
                                                    <h5>ویدیو محصول</h5>
                                                    <span class="close_video_modal">&times;</span>
                                                </div>
                                                <video controls>
                                                    <source src="<?php echo the_field('$link_video_product'); ?>"
                                                            type="video/mp4">
                                                </video>
                                            </div>
                                        </div>
                                    </div>
                                <?php }
                            } ?>
                            <?php if(function_exists( 'woosw_init' ) ){
                            $id = $product->get_id(); ?>
                            <?php echo do_shortcode("[woosw id=$id]"); } ?>
                            <div>
                                <button id="prod-share" class="btn-share">

                                    <svg xmlns="http://www.w3.org/2000/svg" width="34" height="34" viewBox="0 0 25 24"
                                         fill="none">
                                        <path d="M17.5 14.5C16.6169 14.5 15.8052 14.8054 15.1645 15.3162L11.1611 12.8141C11.2796 12.2778 11.2796 11.7221 11.1611 11.1859L15.1645 8.68375C15.8052 9.19457 16.6169 9.5 17.5 9.5C19.5711 9.5 21.25 7.82105 21.25 5.75C21.25 3.67895 19.5711 2 17.5 2C15.4289 2 13.75 3.67895 13.75 5.75C13.75 6.02961 13.7809 6.30195 13.8389 6.5641L9.83555 9.06621C9.1948 8.55543 8.38312 8.25 7.5 8.25C5.42895 8.25 3.75 9.92895 3.75 12C3.75 14.0711 5.42895 15.75 7.5 15.75C8.38312 15.75 9.1948 15.4446 9.83555 14.9338L13.8389 17.4359C13.7797 17.7032 13.7499 17.9762 13.75 18.25C13.75 20.3211 15.4289 22 17.5 22C19.5711 22 21.25 20.3211 21.25 18.25C21.25 16.1789 19.5711 14.5 17.5 14.5Z"
                                              stroke="#A8ADBE" stroke-width="1.5"></path>
                                    </svg>
                                </button>
                                <div class="overlay-prod" id="overlay-prod"></div>
                                <div class="modal-prod-share" id="modal-prod-share">
                                    <div class="share-modal-header">
                                        <span>اشتراک گذاری محتوا</span>

                                        <button class="modal-close-btn-prod-share" id="close-btn-prod-share">✖</button>
                                    </div>
                                    <div class="share-modal-body">
                                        <div class="shortlink">

                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                 viewBox="0 0 25 24"
                                                 fill="none">
                                                <path d="M17.5 14.5C16.6169 14.5 15.8052 14.8054 15.1645 15.3162L11.1611 12.8141C11.2796 12.2778 11.2796 11.7221 11.1611 11.1859L15.1645 8.68375C15.8052 9.19457 16.6169 9.5 17.5 9.5C19.5711 9.5 21.25 7.82105 21.25 5.75C21.25 3.67895 19.5711 2 17.5 2C15.4289 2 13.75 3.67895 13.75 5.75C13.75 6.02961 13.7809 6.30195 13.8389 6.5641L9.83555 9.06621C9.1948 8.55543 8.38312 8.25 7.5 8.25C5.42895 8.25 3.75 9.92895 3.75 12C3.75 14.0711 5.42895 15.75 7.5 15.75C8.38312 15.75 9.1948 15.4446 9.83555 14.9338L13.8389 17.4359C13.7797 17.7032 13.7499 17.9762 13.75 18.25C13.75 20.3211 15.4289 22 17.5 22C19.5711 22 21.25 20.3211 21.25 18.25C21.25 16.1789 19.5711 14.5 17.5 14.5Z"
                                                      stroke="#000" stroke-width="1.5"></path>
                                            </svg>
                                            <span>

                                                لینک کوتاه
                                            </span>
                                            <textarea readonly><?php echo wp_get_shortlink(); ?></textarea>
                                        </div>

                                        <div class="social-sharing">
                                            <p>این محتوا رو به اشتراک بگذارید</p>

                                            <div class="box-sharing">
                                                <a href="https://twitter.com/home?status=Reading: <?php the_permalink(); ?>"
                           title="<?php echo 'اشتراک گذاری در توییتر'; ?>" rel="nofollow" target="_blank" class="twitter-app">
                                                    <svg
                                                            xmlns="http://www.w3.org/2000/svg"
                                                            width="34"
                                                            height="34"
                                                            viewBox="0 0 25 25"
                                                            fill="none"
                                                    >
                                                        <path
                                                                d="M20.4442 8.42639C20.4569 8.60405 20.4569 8.78175 20.4569 8.9594C20.4569 14.3782 16.3326 20.6219 8.79444 20.6219C6.47209 20.6219 4.31473 19.9493 2.5 18.7818C2.82996 18.8198 3.14719 18.8325 3.48985 18.8325C5.40607 18.8325 7.17006 18.1853 8.5787 17.0813C6.77666 17.0432 5.2665 15.863 4.74618 14.2386C5.00001 14.2766 5.2538 14.302 5.52032 14.302C5.88833 14.302 6.25638 14.2513 6.599 14.1625C4.72083 13.7817 3.31215 12.132 3.31215 10.1396V10.0889C3.85782 10.3934 4.49239 10.5838 5.16493 10.6091C4.06087 9.87308 3.33754 8.61675 3.33754 7.19541C3.33754 6.434 3.54055 5.73603 3.8959 5.12689C5.91369 7.6142 8.9467 9.23854 12.3477 9.41624C12.2843 9.11167 12.2462 8.79444 12.2462 8.47717C12.2462 6.21826 14.0736 4.37817 16.3452 4.37817C17.5254 4.37817 18.5914 4.8731 19.3401 5.67259C20.2665 5.49494 21.1548 5.15228 21.9416 4.68275C21.637 5.63455 20.9898 6.43404 20.1396 6.94162C20.9645 6.85283 21.764 6.62435 22.5 6.30713C21.9417 7.11928 21.2437 7.8426 20.4442 8.42639Z"
                                                                fill="#FFBB91"
                                                        />
                                                    </svg>
                                                </a>
                                                <a href="#" class="pintrest-app">
                                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" height="34px" width="34px" version="1.1" id="Layer_1" viewBox="0 0 511.998 511.998" xml:space="preserve">
                                                    <path style="fill:#D7143A;" d="M405.017,52.467C369.774,18.634,321.001,0,267.684,0C186.24,0,136.148,33.385,108.468,61.39  c-34.114,34.513-53.675,80.34-53.675,125.732c0,56.993,23.839,100.737,63.76,117.011c2.68,1.098,5.377,1.651,8.021,1.651  c8.422,0,15.095-5.511,17.407-14.35c1.348-5.071,4.47-17.582,5.828-23.013c2.906-10.725,0.558-15.884-5.78-23.353  c-11.546-13.662-16.923-29.817-16.923-50.842c0-62.451,46.502-128.823,132.689-128.823c68.386,0,110.866,38.868,110.866,101.434  c0,39.482-8.504,76.046-23.951,102.961c-10.734,18.702-29.609,40.995-58.585,40.995c-12.53,0-23.786-5.147-30.888-14.121  c-6.709-8.483-8.921-19.441-6.222-30.862c3.048-12.904,7.205-26.364,11.228-39.376c7.337-23.766,14.273-46.213,14.273-64.122  c0-30.632-18.832-51.215-46.857-51.215c-35.616,0-63.519,36.174-63.519,82.354c0,22.648,6.019,39.588,8.744,46.092  c-4.487,19.01-31.153,132.03-36.211,153.342c-2.925,12.441-20.543,110.705,8.618,118.54c32.764,8.803,62.051-86.899,65.032-97.713  c2.416-8.795,10.869-42.052,16.049-62.495c15.817,15.235,41.284,25.535,66.064,25.535c46.715,0,88.727-21.022,118.298-59.189  c28.679-37.02,44.474-88.618,44.474-145.282C457.206,127.983,438.182,84.311,405.017,52.467z"/>
                                                </svg>
                                                </a>
                                                <a href="https://t.me/share/url?url=<?php the_permalink(); ?>&amp;title=<?php the_title(); ?>"
                                                   title="اشتراک گذاری در تلگرام" rel="nofollow" target="_blank">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="34px" height="34px" viewBox="0 0 21 20"
                                                         fill="none">
                                                        <path d="M10.834 0C5.30979 0 0.833984 4.47581 0.833984 10C0.833984 15.5242 5.30979 20 10.834 20C16.3582 20 20.834 15.5242 20.834 10C20.834 4.47581 16.3582 0 10.834 0ZM15.7453 6.85081L14.1041 14.5847C13.9832 15.1331 13.6566 15.2661 13.2009 15.0081L10.7009 13.1653L9.49527 14.3266C9.36221 14.4597 9.24931 14.5726 8.99124 14.5726L9.16866 12.0282L13.8017 7.84274C14.0033 7.66532 13.7574 7.56452 13.4912 7.74194L7.76544 11.3468L5.29769 10.5766C4.7614 10.4073 4.74931 10.0403 5.4106 9.78226L15.0517 6.06452C15.4993 5.90323 15.8904 6.17339 15.7453 6.85081Z"
                                                              fill="#2470e2"/>
                                                    </svg>
                                                </a>
                                                <a href="https://www.facebook.com/sharer.php?u=<?php the_permalink(); ?>&t=<?php the_title(); ?>"
                           rel="nofollow" target="_blank" class="facebook-app">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="34"
                                                height="34" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Icons" viewBox="0 0 32 32" xml:space="preserve">
<style type="text/css">
	.st0{fill:#FFFFFF;}
	.st1{fill:#3A559F;}
	.st2{fill:#F4F4F4;}
	.st3{fill:#FF0084;}
	.st4{fill:#0063DB;}
	.st5{fill:#00ACED;}
	.st6{fill:#FFEC06;}
	.st7{fill:#FF0000;}
	.st8{fill:#25D366;}
	.st9{fill:#0088FF;}
	.st10{fill:#314358;}
	.st11{fill:#EE6996;}
	.st12{fill:#01AEF3;}
	.st13{fill:#FFFEFF;}
	.st14{fill:#F06A35;}
	.st15{fill:#00ADEF;}
	.st16{fill:#1769FF;}
	.st17{fill:#1AB7EA;}
	.st18{fill:#6001D1;}
	.st19{fill:#E41214;}
	.st20{fill:#05CE78;}
	.st21{fill:#7B519C;}
	.st22{fill:#FF4500;}
	.st23{fill:#00F076;}
	.st24{fill:#FFC900;}
	.st25{fill:#00D6FF;}
	.st26{fill:#FF3A44;}
	.st27{fill:#FF6A36;}
	.st28{fill:#0061FE;}
	.st29{fill:#F7981C;}
	.st30{fill:#EE1B22;}
	.st31{fill:#EF3561;}
	.st32{fill:none;stroke:#FFFFFF;stroke-width:2;stroke-miterlimit:10;}
	.st33{fill:#0097D3;}
	.st34{fill:#01308A;}
	.st35{fill:#019CDE;}
	.st36{fill:#FFD049;}
	.st37{fill:#16A05D;}
	.st38{fill:#4486F4;}
	.st39{fill:none;}
	.st40{fill:#34A853;}
	.st41{fill:#4285F4;}
	.st42{fill:#FBBC05;}
	.st43{fill:#EA4335;}
</style>
<path class="st1" d="M23,0H9C4,0,0,4,0,9v14c0,5,4,9,9,9h14c5,0,9-4,9-9V9C32,4,28,0,23,0z"/>
<path class="st0" d="M26.8,15.4C26.6,15.2,26.3,15,26,15h-5v-3.8c0-0.1,0.1-0.2,0.2-0.2H25c0.6,0,1-0.4,1-1V7c0-0.6-0.4-1-1-1h-4  c-3.3,0-5,2.7-5,6v3h-4c-0.6,0-1,0.4-1,1v3c0,0.6,0.4,1,1,1h4v12h5V20h3c0.4,0,0.8-0.2,0.9-0.6l2-3C27.1,16.1,27,15.7,26.8,15.4z"/>
</svg>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                    <span><?php the_field('english_name'); ?></span>
                    <div class="meta-product">
                        <div class="meta-pro">
                        <svg class="svg-icon" id="Category" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M3 6.5C3 3.87479 3.02811 3 6.5 3C9.97189 3 10 3.87479 10 6.5C10 9.12521 10.0111 10 6.5 10C2.98893 10 3 9.12521 3 6.5Z" stroke="black" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                <path d="M17.5 10C21.0111 10 21 9.12521 21 6.5C21 3.87479 20.9719 3 17.5 3C14.0281 3 14 3.87479 14 6.5C14 7.83097 13.9972 8.712 14.4519 9.25721" stroke="black" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                <path d="M6.5 14C3.02811 14 3 14.8748 3 17.5C3 20.1252 2.98893 21 6.5 21C10.0111 21 10 20.1252 10 17.5C10 16.361 9.99471 15.5515 9.70516 15" stroke="black" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M14 17.5C14 14.8748 14.0281 14 17.5 14C20.9719 14 21 14.8748 21 17.5C21 20.1252 21.0111 21 17.5 21C13.9889 21 14 20.1252 14 17.5Z" stroke="black" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                            </svg>
                            <span class="product_cat">دسته: </span>
                            <?php
                            $cats = get_the_terms($product->get_id(), 'product_cat');
                            ?>
                            <a href="<?= get_term_link($cats[0]->term_id); ?>"
                               target="_blank"><?= $cats[0]->name; ?></a>
                        </div>
                        <?php
                        $brands = get_the_terms(get_the_ID(), 'product_brand');
                        if ($brands) :
                            ?>
                            <div class="meta-pro">
                            <svg class="svg-icon" id="Ticket" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13.3593 3.59998V6.25523" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
<path d="M13.3593 17.5439V19.7641" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
<path d="M13.3593 14.5439V9.25525" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
<path fill-rule="evenodd" clip-rule="evenodd" d="M21.5 14.0504C18.8093 14.0504 18.8093 9.94867 21.5 9.94867C21.5 5.19622 21.5 3.5 12 3.5C2.5 3.5 2.5 5.19622 2.5 9.94867C5.19074 9.94867 5.19074 14.0504 2.5 14.0504C2.5 18.8038 2.5 20.5 12 20.5C21.5 20.5 21.5 18.8038 21.5 14.0504Z" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
</svg>
                                <span class="brand-product">برند: </span>
                                <a href="<?php echo get_term_link($brands[0]->term_id); ?>"
                                   target="_blank"><?php echo $brands[0]->name; ?></a>
                            </div>
                        <?php endif; ?>
                        <?php if ($ultra_options['ultra-Exp-check'] == 1) { ?>
                            <div class="meta-pro">
                                <p class="product_date exp">تاریخ انقضا:
                                    <?php $confirm = get_field('product_date');
                                    if ($confirm) {
                                        echo $confirm;
                                    } else echo $ultra_options['ultra-exp-default']; ?>
                                </p>
                            </div>
                        <?php } ?>
                        <?php if ($ultra_options['ultra-Exp-check'] == 0) { ?>
                            <div class="meta-pro">
                                <p class="product_date">
                                <span class="icon-select">
                                    <?php echo '<i class="' . $ultra_options['icon_select_4_product'] . '"></i>'; ?>
                                </span>
                                    <span class="name-icon">
                                    <?php echo $ultra_options['name_icon_select_4_product'] ?>
                                </span>
                                </p>
                            </div>
                        <?php } ?>
                        <?php if ($ultra_options['icon_select_1_product']) { ?>
                            <div class="meta-pro">
                                <p class="product_date">
                                <span class="icon-select">
                                    <?php echo '<i class="' . $ultra_options['icon_select_1_product'] . '"></i>'; ?>
                                </span>
                                    <span class="name-icon">
                                    <?php echo $ultra_options['name_icon_select_1_product'] ?>
                                </span>
                                </p>
                            </div>
                        <?php } ?>
                        <?php if ($ultra_options['icon_select_2_product']) { ?>
                            <div class="meta-pro">
                                <p class="product_date">
                                <span class="icon-select">
                                    <?php echo '<i class="' . $ultra_options['icon_select_2_product'] . '"></i>'; ?>
                                </span>
                                    <span class="name-icon">
                                    <?php echo $ultra_options['name_icon_select_2_product'] ?>
                                </span>
                                </p>
                            </div>
                        <?php } ?>
                        <?php if ($ultra_options['icon_select_3_product']) { ?>
                            <div class="meta-pro">
                                <p class="product_date">
                                <span class="icon-select">
                                    <?php echo '<i class="' . $ultra_options['icon_select_3_product'] . '"></i>'; ?>
                                </span>
                                    <span class="name-icon">
                                    <?php echo $ultra_options['name_icon_select_3_product'] ?>
                                </span>
                                </p>
                            </div>
                        <?php } ?>
                    </div>
                    <?php if ($ultra_options['ultra-total-sales-check'] == 1) { ?>
                        <div class="count-sales">
                            <?php
                            $real_sales = $ultra_options['ultra-min-total-sales-show-real'];
                            $fake_sales = $ultra_options['ultra-min-total-sales-show-fake'];
                            $units_sold = $product->get_total_sales();
                            if ($ultra_options['ultra-total-real-fake-check'] == 1 && $units_sold >= $real_sales) {
                                if ($ultra_options['ultra-total-sales-icon-check'] == 1) {
                                    echo '<i class="' . $ultra_options['icon_total_sales_product'] . '"></i>';
                                } else { ?>
                                <svg class="svg-icon" id="Ticket Star" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M21.4399 13.9939C18.7789 13.9939 18.7789 9.87952 21.4399 9.87952C21.4399 5.11236 21.4399 3.41089 12.0449 3.41089C2.6499 3.41089 2.6499 5.11236 2.6499 9.87952C5.3109 9.87952 5.3109 13.9939 2.6499 13.9939C2.6499 18.762 2.6499 20.4635 12.0449 20.4635C21.4399 20.4635 21.4399 18.762 21.4399 13.9939Z" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
<path fill-rule="evenodd" clip-rule="evenodd" d="M12.0449 9.17102C11.3619 9.17102 11.2969 10.2605 10.8909 10.6461C10.4839 11.0307 9.22087 10.5911 9.04487 11.2742C8.86987 11.9582 10.0069 12.1903 10.1479 12.7767C10.2879 13.3631 9.59387 14.1873 10.1869 14.5985C10.7809 15.0078 11.4199 14.0803 12.0449 14.0803C12.6699 14.0803 13.3089 15.0078 13.9029 14.5985C14.4969 14.1873 13.8019 13.3631 13.9419 12.7767C14.0829 12.1903 15.2199 11.9582 15.0449 11.2742C14.8689 10.5911 13.6059 11.0307 13.1989 10.6461C12.7929 10.2605 12.7279 9.17102 12.0449 9.17102Z" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
</svg>
                                <?php } ?>
                                <p><?= $ultra_options['ultra-total-sales-name']; ?></p>
                                <p><?php if ($units_sold) echo $units_sold; else echo 'صفر'; ?></p>
                            <?php }


                            if ($ultra_options['ultra-total-real-fake-check'] == 0) {
                                if ($ultra_options['ultra-total-sales-icon-check'] == 1) {
                                    echo '<i class="' . $ultra_options['icon_total_sales_product'] . '"></i>';
                                } else { ?>
                                    <svg class="svg-icon" id="Ticket Star" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M21.4399 13.9939C18.7789 13.9939 18.7789 9.87952 21.4399 9.87952C21.4399 5.11236 21.4399 3.41089 12.0449 3.41089C2.6499 3.41089 2.6499 5.11236 2.6499 9.87952C5.3109 9.87952 5.3109 13.9939 2.6499 13.9939C2.6499 18.762 2.6499 20.4635 12.0449 20.4635C21.4399 20.4635 21.4399 18.762 21.4399 13.9939Z" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
<path fill-rule="evenodd" clip-rule="evenodd" d="M12.0449 9.17102C11.3619 9.17102 11.2969 10.2605 10.8909 10.6461C10.4839 11.0307 9.22087 10.5911 9.04487 11.2742C8.86987 11.9582 10.0069 12.1903 10.1479 12.7767C10.2879 13.3631 9.59387 14.1873 10.1869 14.5985C10.7809 15.0078 11.4199 14.0803 12.0449 14.0803C12.6699 14.0803 13.3089 15.0078 13.9029 14.5985C14.4969 14.1873 13.8019 13.3631 13.9419 12.7767C14.0829 12.1903 15.2199 11.9582 15.0449 11.2742C14.8689 10.5911 13.6059 11.0307 13.1989 10.6461C12.7929 10.2605 12.7279 9.17102 12.0449 9.17102Z" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
</svg>
                                <?php } ?>
                                <p><?= $ultra_options['ultra-total-sales-name']; ?></p>
                                <p><?php echo $ultra_options['ultra-min-total-sales-show-fake'] + $units_sold; ?></p>
                            <?php }
                            ?>
                        </div>
                        <?php
                    }
                    $layout = isset($ultra_options['ultra-single-product-layout']) ? $ultra_options['ultra-single-product-layout'] : 'default_layout';
                        if ($layout === 'full_width_top_buy') {
                            ?>
                            <div class="cart-box">
                                <?php if ($ultra_options['ultra-text-description-aside-product'] || get_field('information_top_btn_add_to_cart')) : ?>
                                    <div class="alert-prod">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="55" height="55" viewBox="0 0 21 20"
                                             fill="none">
                                            <path d="M2.76675 9.99996C2.76675 5.73056 6.22947 2.26663 10.5001 2.26663C14.7707 2.26663 18.2334 5.73056 18.2334 9.99996C18.2334 14.2719 14.7708 17.7333 10.5001 17.7333C6.22934 17.7333 2.76675 14.2719 2.76675 9.99996ZM12.5114 6.77415C12.5114 5.66335 11.6109 4.76286 10.5001 4.76286C9.38927 4.76286 8.48879 5.66335 8.48879 6.77415C8.48879 7.39815 8.77295 7.95578 9.21893 8.32469H9.02159C8.46754 8.32469 8.01836 8.77386 8.01836 9.32792V10.1344C8.01836 10.6211 8.36497 11.0268 8.82481 11.1183V12.1074C8.36497 12.1989 8.01836 12.6047 8.01836 13.0914V13.8978C8.01836 14.4519 8.46753 14.901 9.02159 14.901H11.9786C12.5326 14.901 12.9818 14.4519 12.9818 13.8978V13.0914C12.9818 12.6047 12.6352 12.1989 12.1754 12.1074V9.32792C12.1754 8.9399 11.9551 8.60333 11.6327 8.43645C12.1632 8.07431 12.5114 7.4649 12.5114 6.77415Z"
                                                  stroke="#A8ADBE" stroke-width="1.2"></path>
                                        </svg>
                                        <?php
                                        $field_value = get_field('information_top_btn_add_to_cart');
                                        if ($field_value) {
                                            echo $field_value;
                                        } else {
                                            echo $ultra_options['ultra-text-description-aside-product'];
                                        }
                                        ?>

                                    </div>
                                <?php endif; ?>
                                <div class="middle">
                                    <?php woocommerce_template_single_add_to_cart();
                                    if (function_exists('PWSMS') || function_exists('PWooSMS')) {
                                        echo do_shortcode('[woo_ps_sms]');
                                    }
                                    ?>
                                </div>


                                <?php
                                if (empty(wc_get_price_to_display($product))) {
                                    echo '<span class="call-product">تماس بگیرید</span>';
                                }
                                $review_count = $product->get_review_count();
                                $average = $product->get_average_rating();
                                if ($ultra_options['check_view_comments_rating_product'] == 1) : ?>
                                <a href="#reviews" class="cm-show">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 27 26" fill="none">
                                        <path d="M7.10713 20.5833C5.69867 20.4447 4.64356 20.0217 3.93595 19.314C2.66675 18.0449 2.66675 16.0021 2.66675 11.9166V11.3749C2.66675 7.28941 2.66675 5.24666 3.93595 3.97745C5.20516 2.70825 7.2479 2.70825 11.3334 2.70825H15.6667C19.7522 2.70825 21.7951 2.70825 23.0642 3.97745C24.3334 5.24666 24.3334 7.28941 24.3334 11.3749V11.9166C24.3334 16.0021 24.3334 18.0449 23.0642 19.314C21.7951 20.5833 19.7522 20.5833 15.6667 20.5833C15.0595 20.5968 14.5759 20.6429 14.1009 20.7512C12.8026 21.0501 11.6005 21.7144 10.4124 22.2937C8.71965 23.1191 7.87325 23.5319 7.34208 23.1454C6.32591 22.3886 7.31917 20.0436 7.54175 18.9583"
                                              fill="#A8ADBE"></path>
                                        <path d="M9.16675 14.6249H17.8334M9.16675 9.20825H13.5001" stroke="#F3F3F3"
                                              stroke-width="1.21875" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </svg>

                                    <div class="anchor-cm-ultra">
                                        <span><?php echo $ultra_options['text_view_comments_product']; ?></span>
                                        <span>(<?php echo $review_count; ?>)</span>
                                    </div>

                                    <div class="star">
                                        <span><?php echo $average; ?></span>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="17" height="16" viewBox="0 0 17 16"
                                             fill="none">
                                            <path d="M7.63661 1.47751C8.02265 0.816883 8.97735 0.816882 9.36339 1.47751L11.1934 4.60909C11.3345 4.85063 11.5704 5.022 11.8437 5.0816L15.3875 5.85429C16.1351 6.01729 16.4301 6.92527 15.9211 7.49656L13.5083 10.2047C13.3222 10.4135 13.2321 10.6908 13.2599 10.9692L13.6201 14.5783C13.6961 15.3397 12.9237 15.9009 12.2231 15.5933L8.90195 14.1354C8.64578 14.023 8.35422 14.023 8.09806 14.1354L4.77689 15.5933C4.07627 15.9009 3.3039 15.3397 3.37989 14.5783L3.74011 10.9692C3.7679 10.6908 3.6778 10.4135 3.4917 10.2047L1.07888 7.49656C0.569884 6.92527 0.864903 6.01729 1.61249 5.85429L5.15628 5.0816C5.42962 5.022 5.6655 4.85063 5.80664 4.60909L7.63661 1.47751Z"
                                                  fill="#F8DD80"></path>
                                        </svg>
                                    </div>
                                    <?php endif; ?>
                                </a>
                            </div>
                        <?php }
                    if ($ultra_options['ultra-short-description-product-check'] == 1 && !empty($product->get_short_description()) ) {?>
                        <div class="short-text-ultra">
                            <?php if ($product->get_short_description()) : ?>
                                <p class="text-wrapper">
                                    <?php //echo $product->post->post_excerpt; ?>
                                    <?php echo $product->get_short_description(); ?>
                                </p>
                            <?php endif; ?>
                        </div>
                    <?php } ?>
                    <?php if (!empty($product->get_attributes()) && $ultra_options['ultra-additional-info-product-check'] == 1) : ?>
                        <div class="attr-product">
                            <?php
                            /**
                             * display Additional Information Product
                             */
                            do_action('woocommerce_product_additional_information', $product);
                            ?>
                            <a href="#tb-link">مشاهده همه ویژگی ها</a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            <?php
            /**
             * Hook: woocommerce_single_product_summary.
             *
             * @hooked woocommerce_template_single_title - 5
             * @hooked woocommerce_template_single_rating - 10
             * @hooked woocommerce_template_single_price - 10
             * @hooked woocommerce_template_single_excerpt - 20
             * @hooked woocommerce_template_single_add_to_cart - 30
             * @hooked woocommerce_template_single_meta - 40
             * @hooked woocommerce_template_single_sharing - 50
             * @hooked WC_Structured_Data::generate_product_data() - 60
             */
            //do_action('woocommerce_single_product_summary');
            ?>
            <?php
            /**
             * Hook: woocommerce_after_single_product_summary.
             *
             * @hooked woocommerce_output_product_data_tabs - 10
             * @hooked woocommerce_upsell_display - 15
             * @hooked woocommerce_output_related_products - 20
             */
            do_action('woocommerce_after_single_product_summary');
            ?>
        </section>
        <?php if ($layout === 'default_layout') { ?>
            <aside class="cart-side-ultra">
                <div class="cart-box">
                    <?php if ($ultra_options['ultra-text-description-aside-product'] || get_field('information_top_btn_add_to_cart')) : ?>
                        <div class="alert-prod">
                            <svg xmlns="http://www.w3.org/2000/svg" width="55" height="55" viewBox="0 0 21 20"
                                 fill="none">
                                <path d="M2.76675 9.99996C2.76675 5.73056 6.22947 2.26663 10.5001 2.26663C14.7707 2.26663 18.2334 5.73056 18.2334 9.99996C18.2334 14.2719 14.7708 17.7333 10.5001 17.7333C6.22934 17.7333 2.76675 14.2719 2.76675 9.99996ZM12.5114 6.77415C12.5114 5.66335 11.6109 4.76286 10.5001 4.76286C9.38927 4.76286 8.48879 5.66335 8.48879 6.77415C8.48879 7.39815 8.77295 7.95578 9.21893 8.32469H9.02159C8.46754 8.32469 8.01836 8.77386 8.01836 9.32792V10.1344C8.01836 10.6211 8.36497 11.0268 8.82481 11.1183V12.1074C8.36497 12.1989 8.01836 12.6047 8.01836 13.0914V13.8978C8.01836 14.4519 8.46753 14.901 9.02159 14.901H11.9786C12.5326 14.901 12.9818 14.4519 12.9818 13.8978V13.0914C12.9818 12.6047 12.6352 12.1989 12.1754 12.1074V9.32792C12.1754 8.9399 11.9551 8.60333 11.6327 8.43645C12.1632 8.07431 12.5114 7.4649 12.5114 6.77415Z"
                                      stroke="#A8ADBE" stroke-width="1.2"></path>
                            </svg>
                            <?php
                            $field_value = get_field('information_top_btn_add_to_cart');
                            if ($field_value) {
                                echo $field_value;
                            } else {
                                echo $ultra_options['ultra-text-description-aside-product'];
                            }
                            ?>

                        </div>
                    <?php endif; ?>


                    <div class="middle">
                        <?php woocommerce_template_single_add_to_cart();
                        if (function_exists('PWSMS') || function_exists('PWooSMS')) {
                            echo do_shortcode('[woo_ps_sms]');
                        }
                        ?>
                    </div>


                    <?php
                    if (empty(wc_get_price_to_display($product))) {
                        echo '<span class="call-product">تماس بگیرید</span>';
                    }

                    $review_count = $product->get_review_count();
                    $average = $product->get_average_rating();
                    if ($ultra_options['check_view_comments_rating_product'] == 1) : ?>
                    <a href="#reviews" class="cm-show">
                        <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 27 26" fill="none">
                            <path d="M7.10713 20.5833C5.69867 20.4447 4.64356 20.0217 3.93595 19.314C2.66675 18.0449 2.66675 16.0021 2.66675 11.9166V11.3749C2.66675 7.28941 2.66675 5.24666 3.93595 3.97745C5.20516 2.70825 7.2479 2.70825 11.3334 2.70825H15.6667C19.7522 2.70825 21.7951 2.70825 23.0642 3.97745C24.3334 5.24666 24.3334 7.28941 24.3334 11.3749V11.9166C24.3334 16.0021 24.3334 18.0449 23.0642 19.314C21.7951 20.5833 19.7522 20.5833 15.6667 20.5833C15.0595 20.5968 14.5759 20.6429 14.1009 20.7512C12.8026 21.0501 11.6005 21.7144 10.4124 22.2937C8.71965 23.1191 7.87325 23.5319 7.34208 23.1454C6.32591 22.3886 7.31917 20.0436 7.54175 18.9583"
                                  fill="#A8ADBE"></path>
                            <path d="M9.16675 14.6249H17.8334M9.16675 9.20825H13.5001" stroke="#F3F3F3"
                                  stroke-width="1.21875" stroke-linecap="round" stroke-linejoin="round"></path>
                        </svg>

                        <div class="anchor-cm-ultra">
                            <span><?php echo $ultra_options['text_view_comments_product']; ?></span>
                            <span>(<?php echo $review_count; ?>)</span>
                        </div>

                        <div class="star">
                            <span><?= $average; ?></span>
                            <svg xmlns="http://www.w3.org/2000/svg" width="17" height="16" viewBox="0 0 17 16"
                                 fill="none">
                                <path d="M7.63661 1.47751C8.02265 0.816883 8.97735 0.816882 9.36339 1.47751L11.1934 4.60909C11.3345 4.85063 11.5704 5.022 11.8437 5.0816L15.3875 5.85429C16.1351 6.01729 16.4301 6.92527 15.9211 7.49656L13.5083 10.2047C13.3222 10.4135 13.2321 10.6908 13.2599 10.9692L13.6201 14.5783C13.6961 15.3397 12.9237 15.9009 12.2231 15.5933L8.90195 14.1354C8.64578 14.023 8.35422 14.023 8.09806 14.1354L4.77689 15.5933C4.07627 15.9009 3.3039 15.3397 3.37989 14.5783L3.74011 10.9692C3.7679 10.6908 3.6778 10.4135 3.4917 10.2047L1.07888 7.49656C0.569884 6.92527 0.864903 6.01729 1.61249 5.85429L5.15628 5.0816C5.42962 5.022 5.6655 4.85063 5.80664 4.60909L7.63661 1.47751Z"
                                      fill="#F8DD80"></path>
                            </svg>
                        </div>
                        <?php endif; ?>
                    </a>
                </div>
            </aside>
        <?php } ?>
    </section>
</div>

<?php do_action('woocommerce_after_single_product'); ?>
