<?php
/**
 * Checkout Form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/form-checkout.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}?>
<section class="checkout-process">
    <ol class="steps">
        <li class="step complete" data-step="۱">
            <a href="<?php echo esc_url( wc_get_cart_url() ); ?>">سبد خرید</a>
            <span class="checked">✔</span>
            <span class="num">1</span>
        </li>
        <li class="step is-active" data-step="۲">
            <a href="<?php echo esc_url( wc_get_checkout_url() ); ?>">تسویه حساب</a>
            <span class="checked">✔</span>
            <span class="num">2</span>
        </li>
        <li class="step" data-step="۳">
        <p>پایان</p>
            <span class="checked">✔</span>
            <span class="num">3</span>
        </li>
    </ol>
</section>
<?php
global $ultra_options;
if($ultra_options['check-free-delivery']){
	$free_shipping_amount = $ultra_options['free-delivery'];
    $cart_total = WC()->cart->subtotal;
    $remaining_amount = $free_shipping_amount - $cart_total;
    echo '<div class="free-shipping-notice" >';
    if ($remaining_amount > 0) {
        echo 'فقط <strong>' . number_format($remaining_amount) . ' تومان</strong> دیگر خرید کنید تا ارسال رایگان داشته باشید!';
    } else {
        echo '<strong>' . $ultra_options["text-after-free-delivery"] . '</strong>';
    }
    echo '</div>';
}
do_action( 'woocommerce_before_checkout_form', $checkout );

// If checkout registration is disabled and not logged in, the user cannot checkout.
if ( ! $checkout->is_registration_enabled() && $checkout->is_registration_required() && ! is_user_logged_in() ) {
	echo esc_html( apply_filters( 'woocommerce_checkout_must_be_logged_in_message', __( 'You must be logged in to checkout.', 'woocommerce' ) ) );
	return;
}

?>

<form name="checkout" method="post" class="checkout woocommerce-checkout" action="<?php echo esc_url( wc_get_checkout_url() ); ?>" enctype="multipart/form-data">

	<?php if ( $checkout->get_checkout_fields() ) : ?>

		<?php do_action( 'woocommerce_checkout_before_customer_details' ); ?>

		<div class="hero-checkout" id="customer_details">
			<div class="ultra-order-form">
				<?php do_action( 'woocommerce_checkout_billing' ); ?>
			</div>
            <div class="ultra-order-review">
                <div id="order_review" class="woocommerce-checkout-review-order">
                    <?php do_action( 'woocommerce_checkout_order_review' ); ?>
                </div>
            </div>


		</div>
        <div class="different-address-form">
            <?php do_action( 'woocommerce_checkout_shipping' ); ?>
        </div>
		<?php do_action( 'woocommerce_checkout_after_customer_details' ); ?>

	<?php endif; ?>
	
	<?php do_action( 'woocommerce_checkout_before_order_review_heading' ); ?>
	
<!--	<h3 id="order_review_heading">--><?php //esc_html_e( 'Your order', 'woocommerce' ); ?><!--</h3>-->
	
	<?php do_action( 'woocommerce_checkout_before_order_review' ); ?>

	<?php do_action( 'woocommerce_checkout_after_order_review' ); ?>

</form>

<?php do_action( 'woocommerce_after_checkout_form', $checkout ); ?>
