<?php
/**
 * Cross-sells
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cross-sells.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.6.0
 */
global $ultra_options;
if ($ultra_options['check-cross-sells-cart'] == 1) {

    defined('ABSPATH') || exit;

    if ($cross_sells) : ?>

        <div class="cross-sells">
            <?php
            $heading = $ultra_options['name-cross-sells-cart'];

            if ($heading) :
                ?>
                <h2><?php echo esc_html($heading); ?></h2>
            <?php endif; ?>
          
                <?php woocommerce_product_loop_start(); ?>
                <div class="owl-carousel owl-theme cross-sell-slider">
                    <?php foreach ($cross_sells as $cross_sell) : ?>
                        <?php
                        $post_object = get_post($cross_sell->get_id());

                        setup_postdata($GLOBALS['post'] =& $post_object); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited, Squiz.PHP.DisallowMultipleAssignments.Found

                        //wc_get_template_part( 'content', 'product' );
                        get_template_part('template/product/cross-sell');
                        ?>

                    <?php endforeach; ?>
                </div>
                <?php woocommerce_product_loop_end(); ?>
           
        </div>
    <?php
    endif;

    wp_reset_postdata();
} // End if Setting Theme "check-cross-sells-cart"
