<?php
/**
 * Empty cart page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart-empty.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.0.1
 */

defined('ABSPATH') || exit;

/*
 * @hooked wc_empty_cart_message - 10
 */
do_action('woocommerce_cart_is_empty');

if (wc_get_page_id('shop') > 0) { ?>
<div class="empty-cart-ultra">
    <p class="return-to-shop">
    <?php
    global $product;
    global $ultra_options;
    if ($ultra_options['check-custom-empty-cart'] == 0) { ?>
        <a class="button wc-backward<?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?>"
           href="<?php echo esc_url(apply_filters('woocommerce_return_to_shop_redirect', wc_get_page_permalink('shop'))); ?>">
            <?php
            /**
             * Filter "Return To Shop" text.
             *
             * @param string $default_text Default text.
             * @since 4.6.0
             */
            echo esc_html(apply_filters('woocommerce_return_to_shop_text', __('Return to shop', 'woocommerce')));
            ?>
        </a>
    <?php }
    if ($ultra_options['check-custom-empty-cart'] == 1) { ?>
        <img src="<?php echo $ultra_options['image-gallery-cart-empty']['url']; ?>" alt="سبد خرید شما خالی است.">
        <p class="empty-message-ultra"><?php echo $ultra_options['name-empty-cart']; ?></p>
        <span><?php echo $ultra_options['sub-name-empty-cart']; ?></span>
        <?php if ($ultra_options['check-menu-empty-cart'] == 1) {
            if (has_nav_menu('cart-empty-menu')) {
                wp_nav_menu(array('theme_location' => 'cart-empty-menu', 'container' => ''));
            } else {
                echo "<p>جایگاه فهرست سبد خالی سایت (در بخش فهرست ها، یک فهرست ایجاد کنید و به منو اصلی متصل کنید).</p> ";
            }
        }

        ?>   </div> <?php
        if ($ultra_options['check-total-sales-empty-cart'] == 1) {
            ?>
            <section class="choosen-product">
                <div class="product-title">
                   <i class="fas fa-store"></i>
                    <h2>محصولات پیشنهادی</h2>
                </div>
                <div class="product-items">
                    <div class="owl-carousel owl-theme related-products-prod">
                        <?php
$args = array(
    'post_type' => 'product',
    'posts_per_page' => 10,
    'orderby' => 'title', // می‌توانید به جای مرتب‌سازی بر اساس فروش، بر اساس نام یا سایر ویژگی‌ها مرتب کنید
    'order' => 'ASC',     // می‌توانید ترتیب را تغییر دهید
    'meta_query' => array(
        array(
            'key' => '_stock_status',
            'value' => 'instock',
            'compare' => '=', // اگر فقط محصولات موجود می‌خواهید
        ),
    ),
);
                        $loop = new WP_Query($args);
                        if ($loop->have_posts()) {
                            while ($loop->have_posts()) : $loop->the_post();  // حلقه برای نمایش محصولات
                                 get_template_part('template/product/cross-sell');
                            endwhile;
                        }
                        wp_reset_postdata();
                        ?>
                    </div>
                </div>
            </section>
        <?php }
    }
} ?>
