<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 8.6.0
 */

defined('ABSPATH') || exit;

get_header('shop'); ?>
<?php
/**
 * Hook: woocommerce_before_main_content.
 *
 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
 * @hooked woocommerce_breadcrumb - 20
 * @hooked WC_Structured_Data::generate_website_data() - 30
 */
//do_action('woocommerce_before_main_content');
?>
    <div class="archive-product category-product-page">
        <div class="container">
            <?php woocommerce_breadcrumb(); ?>
			
			<?php
			
			global $ultra_options;
			$hide_empty = $ultra_options['hide_empty_setting'] ?? true;
// گرفتن اطلاعات دسته فعلی
$current_category = get_queried_object();

// بررسی وجود زیر دسته‌ها در taxonomy: product_cat
$subcategories = get_terms(array(
    'taxonomy' => 'product_cat', // نام taxonomy
    'parent' => $current_category->term_id ?? 0, // فقط زیر دسته‌ها
    'hide_empty' => $hide_empty, // نمایش زیر دسته‌ها حتی اگر خالی باشند
));

if (!empty($subcategories) && $ultra_options['category_shop_setting']) : ?>
    <div class="subcategories-container">
        <h2>
            <?php 
            if (is_shop()) {
                echo 'زیر دسته‌های فروشگاه';
            } else {
                echo 'زیر دسته‌های "' . esc_html($current_category->name) . '"';
            }
            ?>
        </h2>
        <div class="subcategories-grid">
            <?php foreach ($subcategories as $subcategory) :
                $thumbnail_id = get_term_meta($subcategory->term_id, 'thumbnail_id', true);
                $thumbnail_url = $thumbnail_id ? wp_get_attachment_url($thumbnail_id) : get_template_directory_uri() . '/assets/image/empty.webp';
                ?>
                <div class="subcategory-item">
                    <a href="<?php echo get_term_link($subcategory->term_id); ?>">
                        <img src="<?php echo esc_url($thumbnail_url); ?>" alt="<?php echo esc_attr($subcategory->name); ?>">
                        <h3><?php echo esc_html($subcategory->name); ?></h3>
                    </a>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
<?php endif; ?>


            <div class="archive-content">
                <?php if (is_active_sidebar('ultra_sidebar_shop')) { ?>
                    <aside id="side-shop" class="side-single side-shop">
                    <a href="javascript:void(0)" class="closebtnshop" onclick="closeNav()">&times;</a>
                        <?php dynamic_sidebar('ultra_sidebar_shop'); ?>
                    </aside>
                <?php } ?>
                <section class="category-product">
                    <?php global $ultra_options;
                    if ($ultra_options['check-display-h1-category'] == 1): ?>
                        <div class="product-title">
                            <h1><?php woocommerce_page_title(); ?></h1>
                        </div>
                    <?php endif; ?>

                    <?php
                    /**
                     * Hook: woocommerce_shop_loop_header.
                     *
                     * @since 8.6.0
                     *
                     * @hooked woocommerce_product_taxonomy_archive_header - 10
                     */
                    //do_action( 'woocommerce_shop_loop_header' );

                    if (woocommerce_product_loop()) {

                        /**
                         * Hook: woocommerce_before_shop_loop.
                         *
                         * @hooked woocommerce_output_all_notices - 10
                         * @hooked woocommerce_result_count - 20
                         * @hooked woocommerce_catalog_ordering - 30
                         */
                        ?>
                        <div class="order-ultra-top"><?php
                        do_action('woocommerce_before_shop_loop');
                        ?></div><?php

                        //woocommerce_product_loop_start();
//                            ?>
                        <div class="product-items ultra-style"><?php
                        if (wc_get_loop_prop('total')) {
                            while (have_posts()) {
                                the_post();

                                /**
                                 * Hook: woocommerce_shop_loop.
                                 */
                                do_action('woocommerce_shop_loop');
                                wc_get_template_part('template/product/content', 'product');
                            }
                        } ?></div><?php

                        //woocommerce_product_loop_end();

                        /**
                         * Hook: woocommerce_after_shop_loop.
                         *
                         * @hooked woocommerce_pagination - 10
                         */
                        do_action('woocommerce_after_shop_loop');
                    } else {
                        /**
                         * Hook: woocommerce_no_products_found.
                         *
                         * @hooked wc_no_products_found - 10
                         */
                        do_action('woocommerce_no_products_found');
                    }
                    ?>
                    <?php global $ultra_options;
                    if ($ultra_options['check-display-description-category'] == 1) :?>
                        <div class="description-category">
                            <?php echo category_description(); ?>
                        </div>
                    <?php endif; ?>
                    <?php
                    /**
                     * Hook: woocommerce_after_main_content.
                     *
                     * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
                     */
                    do_action('woocommerce_after_main_content');

                    /**
                     * Hook: woocommerce_sidebar.
                     *
                     * @hooked woocommerce_get_sidebar - 10
                     */
                    do_action('woocommerce_sidebar');
                    ?>
                </section>
            </div>
        </div>
    </div>
<?php
get_footer('shop');