<?php global $product;
global $ultra_options;
if (is_cart()) { ?>
    <div class="item">
        <a class="product-image" href="<?php the_permalink(); ?>">
            <div class="product-icon">
                <?php $id = $product->get_id(); ?>
                <?php echo do_shortcode("[woosw id=$id]"); ?>
            </div>
            <figure>
                <?php if (has_post_thumbnail()) {
                    the_post_thumbnail('product');
                } else { ?>
                    <img src="<?= get_template_directory_uri() . '/assets/image/empty.webp' ?>"
                <?php } ?>
            </figure>
        </a>

        <a href="<?php the_permalink(); ?>"><h3><?php the_title(); ?></h3></a>
        <?php if ($product->is_in_stock() && $product->get_price_html()) { ?>
            <div class="price">
                <?= $product->get_price_html(); ?>
            </div>
        <?php } elseif (!$product->is_in_stock()) {
            echo "<div class='not_stock'>موجود نیست !</div>";
        } else {
            echo "<div class='no_price'>تماس بگیرید !</div>";
        }
        ?>
    </div>
<?php }
else {
if ($ultra_options['select_template_product_cross_sell'] == 'standard_layout') :?>
    <div class="item">
        <a class="product-image" href="<?php the_permalink(); ?>">
           
            <figure>
                <?php if (has_post_thumbnail()) {
                    the_post_thumbnail('product');
                } else { ?>
                    <img src="<?= get_template_directory_uri() . '/assets/image/empty.webp' ?>"
                <?php } ?>
            </figure>
        </a>

        <a href="<?php the_permalink(); ?>"><h3><?php the_title(); ?></h3></a>
        <?php if ($product->is_in_stock() && $product->get_price_html()) { ?>
            <div class="price">
                <?= $product->get_price_html(); ?>
            </div>
        <?php } elseif (!$product->is_in_stock()) {
            echo "<div class='not_stock'>موجود نیست !</div>";
        } else {
            echo "<div class='no_price'>تماس بگیرید !</div>";
        }
        ?>
    </div>
<?php endif;
if ($ultra_options['select_template_product_cross_sell'] == 'grid_fixed_button') : ?>
    <div class="item prod-style-3">
        <div class="product-image">
            <a href="<?php the_permalink(); ?>">
                <img class="main-image" src="<?php echo wp_get_attachment_url(get_post_thumbnail_id()); ?>">
            </a>
            <?php
            // بررسی وجود گالری
            $product = wc_get_product(get_the_ID());
            $gallery = $product->get_gallery_image_ids();
            if (!empty($gallery)) {
                $first_gallery_image = wp_get_attachment_url($gallery[0]); // تصویر اول گالری
                ?>
                <a href="<?php the_permalink(); ?>">
                    <img class="ultra-img-hover" src="<?php echo esc_url($first_gallery_image); ?>">
                </a>
            <?php } ?>
        </div>
        <a href="<?php the_permalink(); ?>"><h3><?php the_title(); ?></h3></a>
        <!-- مثل اسلایدر کالا منتخب صفحه اصلی مبلغش رو تبدیل کن استایلاش فیکس میشه کدای اون قسمت رو برداشتم من   -->
        <?php if ($product->is_in_stock() && $product->get_price_html()) { ?>
            <div class="price">
                <?= $product->get_price_html(); ?>
            </div>
        <?php } elseif (!$product->is_in_stock()) {
            echo "<div class='not_stock'>موجود نیست !</div>";
        } else {
            echo "<div class='no_price'>تماس بگیرید !</div>";
        }
        ?>
        <div class="addtocart_button">
            <?php
            if ($product->is_in_stock() && $product->get_price_html()) {
                echo sprintf('<a href="%s" data-quantity="1" class="%s add-cart-btn" %s><svg id="Buy" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M5.52377 7.00012C9.41427 5.74398 13.9724 5.45585 16 5.50012C18.0276 5.5444 18.8831 6.26642 19.5 7.50012C20.5 9.50012 20.289 14.4882 18.5 16.0872C16.712 17.6862 9.33015 17.8382 6.87015 16.0872C4.27115 14.2362 5.629 9.19212 5.544 5.74312C5.595 3.81312 3.5 3.50012 3.5 3.50012" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                <path d="M13 10.5001H15.773" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                <path fill-rule="evenodd" clip-rule="evenodd" d="M7.26399 20.1276C7.56399 20.1276 7.80799 20.3716 7.80799 20.6716C7.80799 20.9726 7.56399 21.2166 7.26399 21.2166C6.96299 21.2166 6.71899 20.9726 6.71899 20.6716C6.71899 20.3716 6.96299 20.1276 7.26399 20.1276Z" fill="#000000" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                <path fill-rule="evenodd" clip-rule="evenodd" d="M17.5955 20.1276C17.8965 20.1276 18.1405 20.3716 18.1405 20.6716C18.1405 20.9726 17.8965 21.2166 17.5955 21.2166C17.2955 21.2166 17.0515 20.9726 17.0515 20.6716C17.0515 20.3716 17.2955 20.1276 17.5955 20.1276Z" fill="#000000" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
            </svg><span>افزودن به سبد خرید</span></a>',
                    esc_url($product->add_to_cart_url()),
                    esc_attr(implode(' ', array_filter(array(
                        'button', 'product_type_' . $product->get_type(),
                        $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
                        $product->supports('ajax_add_to_cart') ? 'ajax_add_to_cart' : '',
                    )))),
                    wc_implode_html_attributes(array(
                        'data-product_id' => $product->get_id(),
                        'data-product_sku' => $product->get_sku(),
                        'aria-label' => $product->add_to_cart_description(),
                        'rel' => 'nofollow',
                    )),
                    esc_html($product->add_to_cart_text())
                );
            } ?>
        </div>
    </div>
<?php endif;
if ($ultra_options['select_template_product_cross_sell'] == 'classic_grid') :?>
    <div class="item prod-style-6">
        <div class="product-image">
            <a href="<?php the_permalink(); ?>"><figure>
                    <?php if (has_post_thumbnail()) {
                        the_post_thumbnail('product');
                    } else { ?>
                        <img src="<?= get_template_directory_uri() . '/assets/image/empty.webp' ?>"
                    <?php } ?>
                </figure></a>
        </div>
        <a href="<?php the_permalink(); ?>"><h3><?php the_title(); ?></h3></a>
        <!-- مثل اسلایدر کالا منتخب صفحه اصلی مبلغش رو تبدیل کن استایلاش فیکس میشه کدای اون قسمت رو برداشتم من   -->
        <?php if ($product->is_in_stock() && $product->get_price_html()) { ?>
            <div class="price">
                <?= $product->get_price_html(); ?>
            </div>
        <?php } elseif (!$product->is_in_stock()) {
            echo "<div class='not_stock'>موجود نیست !</div>";
        } else {
            echo "<div class='no_price'>تماس بگیرید !</div>";
        }
        ?>

    </div>
<?php endif;
if ($ultra_options['select_template_product_cross_sell'] == 'hover_effect_grid') :?>
    <div class="item prod-style-8">
        <div class="product-image">
            <a href="<?php the_permalink(); ?>"><figure>
                    <?php if (has_post_thumbnail()) {
                        the_post_thumbnail('product');
                    } else { ?>
                        <img src="<?= get_template_directory_uri() . '/assets/image/empty.webp' ?>"
                    <?php } ?>
                </figure></a>
        </div>

        <div class="prod-content">
            <a href="<?php the_permalink(); ?>"><h3><?php the_title(); ?></h3></a>

            <?php if ($product->is_in_stock() && $product->get_price_html()) { ?>
                <div class="price">
                    <?= $product->get_price_html(); ?>
                </div>
            <?php } elseif (!$product->is_in_stock()) {
                echo "<div class='not_stock'>موجود نیست !</div>";
            } else {
                echo "<div class='no_price'>تماس بگیرید !</div>";
            }
            ?>
            <?php
            if ($product->is_in_stock() && $product->get_price_html()) {
                echo sprintf('<a href="%s" data-quantity="1" class="%s add-cart-btn" %s><svg id="Buy" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M5.52377 7.00012C9.41427 5.74398 13.9724 5.45585 16 5.50012C18.0276 5.5444 18.8831 6.26642 19.5 7.50012C20.5 9.50012 20.289 14.4882 18.5 16.0872C16.712 17.6862 9.33015 17.8382 6.87015 16.0872C4.27115 14.2362 5.629 9.19212 5.544 5.74312C5.595 3.81312 3.5 3.50012 3.5 3.50012" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                    <path d="M13 10.5001H15.773" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M7.26399 20.1276C7.56399 20.1276 7.80799 20.3716 7.80799 20.6716C7.80799 20.9726 7.56399 21.2166 7.26399 21.2166C6.96299 21.2166 6.71899 20.9726 6.71899 20.6716C6.71899 20.3716 6.96299 20.1276 7.26399 20.1276Z" fill="#000000" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M17.5955 20.1276C17.8965 20.1276 18.1405 20.3716 18.1405 20.6716C18.1405 20.9726 17.8965 21.2166 17.5955 21.2166C17.2955 21.2166 17.0515 20.9726 17.0515 20.6716C17.0515 20.3716 17.2955 20.1276 17.5955 20.1276Z" fill="#000000" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                </svg><span>افزودن به سبد خرید</span></a>',
                    esc_url($product->add_to_cart_url()),
                    esc_attr(implode(' ', array_filter(array(
                        'button', 'product_type_' . $product->get_type(),
                        $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
                        $product->supports('ajax_add_to_cart') ? 'ajax_add_to_cart' : '',
                    )))),
                    wc_implode_html_attributes(array(
                        'data-product_id' => $product->get_id(),
                        'data-product_sku' => $product->get_sku(),
                        'aria-label' => $product->add_to_cart_description(),
                        'rel' => 'nofollow',
                    )),
                    esc_html($product->add_to_cart_text())
                );
            } ?>
        </div>
    </div>
<?php endif;
}?>
