<div class="container">
    <section class="product-sale">
        <div class="sale-title">
            <span>شگفت انگیز ها</span>

            <img src="<?= get_template_directory_uri() . '/assets/image/sand.png' ?>" alt="">

            <a href="#">مشاهده همه</a>
        </div>
        <div class="sale-slider">
            <div class="owl-carousel owl-theme loop">
                <?php
                global $product;
                $choosen_product = new WP_Query(array(
                    'post_type' => 'product',
                    'posts_per_page' => 5,
                    'no_found_rows' => true,
                    'meta_query' => array(
                        array(
                            'key' => 'status_timer_offer',
                            'value' => 'yes',
                            'compare' => '=',
                        ),
                    ),
                ));
                if ($choosen_product->have_posts()) :
                    while ($choosen_product->have_posts()) : $choosen_product->the_post(); ?>
                        <div class="item">
                            <div class="item-content">
                                <a href="<?php the_permalink(); ?>">
                                    <figure>
                                        <?php if (has_post_thumbnail()) {
                                            the_post_thumbnail('product');
                                        } else { ?>
                                            <img src="<?php echo get_template_directory_uri() . '/assets/image/empty.webp' ?>"
                                        <?php } ?>
                                    </figure>
                                    <?php if ($product->is_on_sale()) : ?>
                                    <div class="sale-image">
                                       <svg width="112" height="73" viewBox="0 0 112 73" fill="none" xmlns="http://www.w3.org/2000/svg">
											<path fill-rule="evenodd" clip-rule="evenodd" d="M102.419 41.4925L111.209 24.3437L96.8749 11.4984L80.325 0.00268555L54.6504 3.84369L0.60498 14.1263L11.3588 72.3025L65.7392 63.8317L91.0789 58.1786L102.419 41.4925ZM87.9999 36C92.4182 36 95.9999 32.4183 95.9999 28C95.9999 23.5818 92.4182 20 87.9999 20C83.5817 20 79.9999 23.5818 79.9999 28C79.9999 32.4183 83.5817 36 87.9999 36Z" fill="#FF8E6E"/>
											</svg>
                                        <span><?= ultra_woocommerce_discount(get_the_id()); ?> % </span>
                                    </div>
                                    <?php endif; ?>
                                    <h3><?php the_title(); ?></h3>
                                    <?php if ($product->is_in_stock() && $product->get_price_html()) { ?>
                                    <div class="price-section">
                                        <?= $product->get_price_html(); ?>
                                        </div>
                                        <?php }
                                        elseif (!$product->is_in_stock()) {
                                            echo "<div class='not_stock'>موجود نیست !</div>";
                                        } else {
                                            echo "<div class='no_price'>تماس بگیرید !</div>";
                                        }
                                        ?>
                                 
                                    <?php get_template_part('template/index/timer'); ?>
                                </a>
                            </div>
                        </div>
                    <?php
                    endwhile;
                endif;
                wp_reset_postdata();
                ?>
            </div>
        </div>
    </section>

</div>