<?php get_header();
global $ultra_options;
?>
    <section class="single-post-ultra">
    <div class="container">
    <div class="post-head">
<?php while (have_posts()): the_post(); ?>
    <figure>
        <?php if (has_post_thumbnail()) {
            the_post_thumbnail();
        } else { ?>
            <img src="<?= get_template_directory_uri() . '/assets/image/empty.webp' ?>"
        <?php } ?>
    </figure>
		
		
		<div class="title-content" >
    <div class="category">
        <?php the_category(' '); ?>
    </div>
    <h1><?php the_title(); ?></h1>
    <div class="author-box">
        <div class="author">
            <?php echo get_avatar(get_the_author_meta('ID')); ?>
            <span><?php the_author(); ?></span>
        </div>
        <span><?php the_date('j F, Y'); ?></span>
    </div>
		</div>
		
    </div>
    <div class="post-content">
        <div class="main-box">
            <nav class="breadcrumb-ultra">
                <?php if (function_exists('ultra_breadcrumb')) {
                    echo ultra_breadcrumb();
                } ?>
            </nav>
            <div class="text-box">
                <?php the_content(); ?>
                <?php
                $tags_list = get_the_tag_list('', '، ', '');
                if ($tags_list) : ?>
                    <div class="post-tag">
                        <span><i class="fa-solid fa-tags"></i> <?php esc_html_e(' برچسب ها: ', 'ultramarket'); ?></span>
                        <?php echo $tags_list; ?>
                    </div>
                <?php endif; ?>
            </div>
            <?php if ($ultra_options['active_author_box_post']): ?>
                <div class="author-box">
                    <div class="author">
                        <?php echo get_avatar(get_the_author_meta('ID')); ?>
                        <div class="info">
                            <span class="author-name"><?php the_author(); ?></span>
                            <span>نویسنده |  <span> <?php the_date('j F, Y'); ?> </span></span>
                        </div>
                    </div>
                    <div class="social">
                        <a href="https://t.me/share/url?url=<?php the_permalink(); ?>&amp;title=<?php the_title(); ?>"
                           title="اشتراک گذاری در تلگرام" rel="nofollow" target="_blank">
                            <svg xmlns="http://www.w3.org/2000/svg" width="42" height="42" viewBox="0 0 21 20"
                                 fill="none">
                                <path d="M10.834 0C5.30979 0 0.833984 4.47581 0.833984 10C0.833984 15.5242 5.30979 20 10.834 20C16.3582 20 20.834 15.5242 20.834 10C20.834 4.47581 16.3582 0 10.834 0ZM15.7453 6.85081L14.1041 14.5847C13.9832 15.1331 13.6566 15.2661 13.2009 15.0081L10.7009 13.1653L9.49527 14.3266C9.36221 14.4597 9.24931 14.5726 8.99124 14.5726L9.16866 12.0282L13.8017 7.84274C14.0033 7.66532 13.7574 7.56452 13.4912 7.74194L7.76544 11.3468L5.29769 10.5766C4.7614 10.4073 4.74931 10.0403 5.4106 9.78226L15.0517 6.06452C15.4993 5.90323 15.8904 6.17339 15.7453 6.85081Z"
                                      fill="white"/>
                            </svg>
                        </a>
                        <a href="whatsapp://send?text=<?php the_permalink(); ?>" data-action="share/whatsapp/share"
                           title="اشتراک گذاری در واتساپ" rel="nofollow" target="_blank">
                            <svg xmlns="http://www.w3.org/2000/svg" width="42" height="42" viewBox="0 0 21 20"
                                 fill="none">
                                <path d="M17.8384 2.90625C15.9679 1.03125 13.4768 0 10.8295 0C5.36523 0 0.918806 4.44643 0.918806 9.91071C0.918806 11.6562 1.37416 13.3616 2.24023 14.8661L0.833984 20L6.08845 18.6205C7.53488 19.4107 9.16434 19.8259 10.8251 19.8259H10.8295C16.2893 19.8259 20.834 15.3795 20.834 9.91518C20.834 7.26786 19.709 4.78125 17.8384 2.90625ZM10.8295 18.1563C9.34738 18.1563 7.89648 17.7589 6.63309 17.0089L6.33398 16.8304L3.21791 17.6473L4.04827 14.6071L3.85184 14.2946C3.02595 12.9821 2.59291 11.4688 2.59291 9.91071C2.59291 5.37054 6.28934 1.67411 10.834 1.67411C13.0349 1.67411 15.1018 2.53125 16.6554 4.08929C18.209 5.64732 19.1643 7.71429 19.1599 9.91518C19.1599 14.4598 15.3697 18.1563 10.8295 18.1563ZM15.3474 11.9866C15.1018 11.8616 13.8831 11.2634 13.6554 11.183C13.4277 11.0982 13.2626 11.058 13.0974 11.308C12.9322 11.558 12.459 12.1116 12.3117 12.2813C12.1688 12.4464 12.0215 12.4688 11.7759 12.3438C10.3206 11.6161 9.36523 11.0446 8.40541 9.39732C8.15095 8.95982 8.65988 8.99107 9.13309 8.04464C9.21345 7.87946 9.17327 7.73661 9.11077 7.61161C9.04827 7.48661 8.55273 6.26786 8.34738 5.77232C8.14648 5.29018 7.94113 5.35714 7.78934 5.34821C7.64648 5.33929 7.48131 5.33929 7.31613 5.33929C7.15095 5.33929 6.88309 5.40179 6.65541 5.64732C6.42773 5.89732 5.78934 6.49554 5.78934 7.71429C5.78934 8.93304 6.67773 10.1116 6.79827 10.2768C6.92327 10.442 8.54381 12.942 11.0304 14.0179C12.6018 14.6964 13.2179 14.7545 14.0036 14.6384C14.4813 14.567 15.4679 14.0402 15.6733 13.4598C15.8786 12.8795 15.8786 12.3839 15.8161 12.2813C15.7581 12.1696 15.5929 12.1071 15.3474 11.9866Z"
                                      fill="white"/>
                            </svg>
                        </a>
                        <a href="https://www.facebook.com/sharer.php?u=<?php the_permalink(); ?>&t=<?php the_title(); ?>"
                           rel="nofollow" target="_blank">
                         <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" fill="white" hwidth="42" height="42" version="1.1" id="Layer_1" viewBox="-143 145 512 512" xml:space="preserve">
<g>
	<path d="M113,145c-141.4,0-256,114.6-256,256s114.6,256,256,256s256-114.6,256-256S254.4,145,113,145z M272.8,560.7   c-20.8,20.8-44.9,37.1-71.8,48.4c-27.8,11.8-57.4,17.7-88,17.7c-30.5,0-60.1-6-88-17.7c-26.9-11.4-51.1-27.7-71.8-48.4   c-20.8-20.8-37.1-44.9-48.4-71.8C-107,461.1-113,431.5-113,401s6-60.1,17.7-88c11.4-26.9,27.7-51.1,48.4-71.8   c20.9-20.8,45-37.1,71.9-48.5C52.9,181,82.5,175,113,175s60.1,6,88,17.7c26.9,11.4,51.1,27.7,71.8,48.4   c20.8,20.8,37.1,44.9,48.4,71.8c11.8,27.8,17.7,57.4,17.7,88c0,30.5-6,60.1-17.7,88C309.8,515.8,293.5,540,272.8,560.7z"/>
	<path d="M146.8,313.7c10.3,0,21.3,3.2,21.3,3.2l6.6-39.2c0,0-14-4.8-47.4-4.8c-20.5,0-32.4,7.8-41.1,19.3   c-8.2,10.9-8.5,28.4-8.5,39.7v25.7H51.2v38.3h26.5v133h49.6v-133h39.3l2.9-38.3h-42.2v-29.9C127.3,317.4,136.5,313.7,146.8,313.7z"/>
</g>
</svg>
                        </a>
                        <a href="https://twitter.com/home?status=Reading: <?php the_permalink(); ?>"
                           title="<?php echo 'اشتراک گذاری در توییتر'; ?>" rel="nofollow" target="_blank">
                            <svg xmlns="http://www.w3.org/2000/svg" width="42" height="42" viewBox="0 0 24 24"
                                 fill="none">
                                <path d="M19.9442 7.92639C19.9569 8.10405 19.9569 8.28175 19.9569 8.4594C19.9569 13.8782 15.8326 20.1219 8.29444 20.1219C5.97209 20.1219 3.81473 19.4493 2 18.2818C2.32996 18.3198 2.64719 18.3325 2.98985 18.3325C4.90607 18.3325 6.67006 17.6853 8.0787 16.5813C6.27666 16.5432 4.7665 15.363 4.24618 13.7386C4.50001 13.7766 4.7538 13.802 5.02032 13.802C5.38833 13.802 5.75638 13.7513 6.099 13.6625C4.22083 13.2817 2.81215 11.632 2.81215 9.6396V9.58886C3.35782 9.89343 3.99239 10.0838 4.66493 10.1091C3.56087 9.37308 2.83754 8.11675 2.83754 6.69541C2.83754 5.934 3.04055 5.23603 3.3959 4.62689C5.41369 7.1142 8.4467 8.73854 11.8477 8.91624C11.7843 8.61167 11.7462 8.29444 11.7462 7.97717C11.7462 5.71826 13.5736 3.87817 15.8452 3.87817C17.0254 3.87817 18.0914 4.3731 18.8401 5.17259C19.7665 4.99494 20.6548 4.65228 21.4416 4.18275C21.137 5.13455 20.4898 5.93404 19.6396 6.44162C20.4645 6.35283 21.264 6.12435 22 5.80713C21.4417 6.61928 20.7437 7.3426 19.9442 7.92639Z"
                                      fill="white"/>
                            </svg>
                        </a>
                    </div>
                </div>
            <?php endif;

            if ($ultra_options['active_related_post']) : ?>
            <?php
            $related = get_posts(array(
                'category__in' => wp_get_post_categories($post->ID),
                'numberposts' => 3,
                'post__not_in' => array($post->ID)
            ));
            if ($related) : // بررسی وجود مقالات مرتبط
            ?>
            <section class="related">
                <h3>مقالات دیگر</h3>
                <div class="related-blogs">
                    <?php foreach ($related as $post) {
                        setup_postdata($post); ?>
                        <div class="blog-item">
                            <figure>
                                <?php if (has_post_thumbnail()) {
                                    the_post_thumbnail();
                                } else { ?>
                                    <img src="<?= get_template_directory_uri() . '/assets/image/empty.webp' ?>" alt="No image available">
                                <?php } ?>
                            </figure>
                            <div class="info-blog">
                                <a href="<?php the_permalink(); ?>"><h3><?php the_title(); ?></h3></a>
                                <p class="excerpt"><?php the_excerpt(); ?></p>
                                <span class="cat"><?php the_category('، '); ?></span>
                                <div class="author">
                                    <span>نویسنده :  <?php the_author(); ?></span>
                                    <span><?php the_date('j F, Y'); ?></span>
                                </div>
                                <a class="view" href="<?php the_permalink(); ?>">مشاهده</a>
                            </div>
                        </div>
                    <?php } ?>
                    <?php wp_reset_postdata(); ?>
                </div>
            </section>
            <?php endif; ?>
            <?php endif; ?>

<?php
if (comments_open() || get_comments_number()) :
?>
    <div id="comments" class="cm-section">
        <?php comments_template(); ?>
    </div>
<?php
endif;
?>


            
        </div>
        <?php if (is_active_sidebar('ultra_sidebar_blog') && $ultra_options['sidebar_position_single'] != 'none') { ?>
            <aside class="side-single">
                <?php dynamic_sidebar('ultra_sidebar_blog'); ?>
            </aside>
        <?php } ?>
        <?php if ($ultra_options['sidebar_position_single'] == 'left') { ?>
            <style>
                .single-post-ultra .post-content {
                    flex-direction: row;
                }
            </style>
        <?php } else {
            ?>
            <style>
                .single-post-ultra .post-content .main-box {
                    width: 100%
                }
            </style>
            <?php
        }
        ?>
    </div>
    </div>

    </section>
<?php endwhile;
get_footer(); ?>