<?php get_header(); ?>
<section class="single-post-ultra single-tv-ultra">
    <div class="container">
        <?php
        global $ultra_options;

        // اعمال CSS برای سایدبار سمت چپ
        if (!empty($ultra_options['sidebar_position_tv']) && $ultra_options['sidebar_position_tv'] == 'left'): ?>
            <style>
                .single-post-ultra .post-content {
                    flex-direction: row;
                }
            </style>
        <?php endif; ?>
        <?php while (have_posts()) :
        the_post(); ?>
        <div class="post-head">
            <figure>
                <?php
                $video_data = get_field('select_video_tv');
                $video_url = $video_data['link_video'] ?? '';
                $video_file = $video_data['uploud_video'] ?? '';
                $video_poster = get_the_post_thumbnail_url();

                if ($video_file) {
                    ?>
                    <video width="1120" height="653" poster="<?php echo esc_url($video_poster); ?>" controls>
                        <source src="<?php echo esc_url($video_file); ?>" type="video/mp4">
                        مرورگر شما از ویدیو پشتیبانی نمی‌کند.
                    </video>
                    <?php
                } elseif ($video_url) {
                    ?>
                    <video width="1120" height="653" poster="<?php echo esc_url($video_poster); ?>" controls>
                        <source src="<?php echo esc_url($video_url); ?>" type="video/mp4">
                        مرورگر شما از ویدیو پشتیبانی نمی‌کند.
                    </video>
                    <?php
                } else {
                    the_post_thumbnail();
                }
                ?>
            </figure>
        </div>

        <div class="post-content">
            <div class="main-box">
                <nav class="breadcrumb-ultra">
                    <?php echo ultra_breadcrumb(); ?>
                </nav>
                <div class="text-box">
                    <div class="info">
                        <h1><?php the_title(); ?></h1>
                        <div class="category">
                            <?php the_category(' . '); ?>
                        </div>
                    </div>
                    <?php the_content(); ?>
                </div>
                <?php if (!empty($ultra_options['active_author_box_tv'])) : ?>
                    <div class="author-box">
                        <div class="author">
                            <?php echo get_avatar(get_the_author_meta('ID')); ?>
                            <div class="info">
                                <span class="author-name"><?php the_author(); ?></span>
                                <span>نویسنده <span><?php the_date('j F, Y'); ?></span></span>
                            </div>
                        </div>
                        <div class="social">
                        <a href="https://t.me/share/url?url=<?php the_permalink(); ?>&amp;title=<?php the_title(); ?>"
                           title="اشتراک گذاری در تلگرام" rel="nofollow" target="_blank">
                            <svg xmlns="http://www.w3.org/2000/svg" width="42" height="42" viewBox="0 0 21 20"
                                 fill="none">
                                <path d="M10.834 0C5.30979 0 0.833984 4.47581 0.833984 10C0.833984 15.5242 5.30979 20 10.834 20C16.3582 20 20.834 15.5242 20.834 10C20.834 4.47581 16.3582 0 10.834 0ZM15.7453 6.85081L14.1041 14.5847C13.9832 15.1331 13.6566 15.2661 13.2009 15.0081L10.7009 13.1653L9.49527 14.3266C9.36221 14.4597 9.24931 14.5726 8.99124 14.5726L9.16866 12.0282L13.8017 7.84274C14.0033 7.66532 13.7574 7.56452 13.4912 7.74194L7.76544 11.3468L5.29769 10.5766C4.7614 10.4073 4.74931 10.0403 5.4106 9.78226L15.0517 6.06452C15.4993 5.90323 15.8904 6.17339 15.7453 6.85081Z"
                                      fill="white"/>
                            </svg>
                        </a>
                        <a href="whatsapp://send?text=<?php the_permalink(); ?>" data-action="share/whatsapp/share"
                           title="اشتراک گذاری در واتساپ" rel="nofollow" target="_blank">
                            <svg xmlns="http://www.w3.org/2000/svg" width="42" height="42" viewBox="0 0 21 20"
                                 fill="none">
                                <path d="M17.8384 2.90625C15.9679 1.03125 13.4768 0 10.8295 0C5.36523 0 0.918806 4.44643 0.918806 9.91071C0.918806 11.6562 1.37416 13.3616 2.24023 14.8661L0.833984 20L6.08845 18.6205C7.53488 19.4107 9.16434 19.8259 10.8251 19.8259H10.8295C16.2893 19.8259 20.834 15.3795 20.834 9.91518C20.834 7.26786 19.709 4.78125 17.8384 2.90625ZM10.8295 18.1563C9.34738 18.1563 7.89648 17.7589 6.63309 17.0089L6.33398 16.8304L3.21791 17.6473L4.04827 14.6071L3.85184 14.2946C3.02595 12.9821 2.59291 11.4688 2.59291 9.91071C2.59291 5.37054 6.28934 1.67411 10.834 1.67411C13.0349 1.67411 15.1018 2.53125 16.6554 4.08929C18.209 5.64732 19.1643 7.71429 19.1599 9.91518C19.1599 14.4598 15.3697 18.1563 10.8295 18.1563ZM15.3474 11.9866C15.1018 11.8616 13.8831 11.2634 13.6554 11.183C13.4277 11.0982 13.2626 11.058 13.0974 11.308C12.9322 11.558 12.459 12.1116 12.3117 12.2813C12.1688 12.4464 12.0215 12.4688 11.7759 12.3438C10.3206 11.6161 9.36523 11.0446 8.40541 9.39732C8.15095 8.95982 8.65988 8.99107 9.13309 8.04464C9.21345 7.87946 9.17327 7.73661 9.11077 7.61161C9.04827 7.48661 8.55273 6.26786 8.34738 5.77232C8.14648 5.29018 7.94113 5.35714 7.78934 5.34821C7.64648 5.33929 7.48131 5.33929 7.31613 5.33929C7.15095 5.33929 6.88309 5.40179 6.65541 5.64732C6.42773 5.89732 5.78934 6.49554 5.78934 7.71429C5.78934 8.93304 6.67773 10.1116 6.79827 10.2768C6.92327 10.442 8.54381 12.942 11.0304 14.0179C12.6018 14.6964 13.2179 14.7545 14.0036 14.6384C14.4813 14.567 15.4679 14.0402 15.6733 13.4598C15.8786 12.8795 15.8786 12.3839 15.8161 12.2813C15.7581 12.1696 15.5929 12.1071 15.3474 11.9866Z"
                                      fill="white"/>
                            </svg>
                        </a>
                        <a href="https://www.facebook.com/sharer.php?u=<?php the_permalink(); ?>&t=<?php the_title(); ?>"
                           rel="nofollow" target="_blank">
                            <svg xmlns="http://www.w3.org/2000/svg" width="42" height="42" viewBox="0 0 21 22"
                                 fill="none">
                                <path d="M10.419 5.65982C7.46305 5.65982 5.07878 8.0441 5.07878 11C5.07878 13.956 7.46305 16.3402 10.419 16.3402C13.3749 16.3402 15.7592 13.956 15.7592 11C15.7592 8.0441 13.3749 5.65982 10.419 5.65982ZM10.419 14.4719C8.50878 14.4719 6.94715 12.9149 6.94715 11C6.94715 9.08518 8.50414 7.5282 10.419 7.5282C12.3338 7.5282 13.8908 9.08518 13.8908 11C13.8908 12.9149 12.3292 14.4719 10.419 14.4719ZM17.2232 5.44138C17.2232 6.13389 16.6655 6.68697 15.9776 6.68697C15.2851 6.68697 14.7321 6.12924 14.7321 5.44138C14.7321 4.75352 15.2898 4.1958 15.9776 4.1958C16.6655 4.1958 17.2232 4.75352 17.2232 5.44138ZM20.7601 6.70556C20.6811 5.03703 20.3 3.55906 19.0777 2.34136C17.86 1.12366 16.382 0.742553 14.7135 0.658895C12.9938 0.561293 7.83951 0.561293 6.11986 0.658895C4.45599 0.737906 2.97802 1.11902 1.75567 2.33672C0.533324 3.55441 0.15686 5.03238 0.0732013 6.70091C-0.0244004 8.42056 -0.0244004 13.5749 0.0732013 15.2945C0.152212 16.963 0.533324 18.441 1.75567 19.6587C2.97802 20.8764 4.45134 21.2575 6.11986 21.3412C7.83951 21.4388 12.9938 21.4388 14.7135 21.3412C16.382 21.2622 17.86 20.8811 19.0777 19.6587C20.2954 18.441 20.6765 16.963 20.7601 15.2945C20.8577 13.5749 20.8577 8.42521 20.7601 6.70556ZM18.5385 17.1397C18.176 18.0506 17.4742 18.7524 16.5586 19.1196C15.1875 19.6634 11.9341 19.5379 10.419 19.5379C8.90384 19.5379 5.6458 19.6587 4.27937 19.1196C3.36842 18.7571 2.66662 18.0553 2.29945 17.1397C1.75567 15.7686 1.88116 12.5152 1.88116 11C1.88116 9.48489 1.76032 6.22684 2.29945 4.86042C2.66197 3.94947 3.36378 3.24767 4.27937 2.8805C5.65045 2.33672 8.90384 2.4622 10.419 2.4622C11.9341 2.4622 15.1922 2.34136 16.5586 2.8805C17.4696 3.24302 18.1714 3.94482 18.5385 4.86042C19.0823 6.23149 18.9568 9.48489 18.9568 11C18.9568 12.5152 19.0823 15.7732 18.5385 17.1397Z"
                                      fill="white"/>
                            </svg>
                        </a>
                        <a href="https://twitter.com/home?status=Reading: <?php the_permalink(); ?>"
                           title="<?php echo 'اشتراک گذاری در توییتر'; ?>" rel="nofollow" target="_blank">
                            <svg xmlns="http://www.w3.org/2000/svg" width="42" height="42" viewBox="0 0 24 24"
                                 fill="none">
                                <path d="M19.9442 7.92639C19.9569 8.10405 19.9569 8.28175 19.9569 8.4594C19.9569 13.8782 15.8326 20.1219 8.29444 20.1219C5.97209 20.1219 3.81473 19.4493 2 18.2818C2.32996 18.3198 2.64719 18.3325 2.98985 18.3325C4.90607 18.3325 6.67006 17.6853 8.0787 16.5813C6.27666 16.5432 4.7665 15.363 4.24618 13.7386C4.50001 13.7766 4.7538 13.802 5.02032 13.802C5.38833 13.802 5.75638 13.7513 6.099 13.6625C4.22083 13.2817 2.81215 11.632 2.81215 9.6396V9.58886C3.35782 9.89343 3.99239 10.0838 4.66493 10.1091C3.56087 9.37308 2.83754 8.11675 2.83754 6.69541C2.83754 5.934 3.04055 5.23603 3.3959 4.62689C5.41369 7.1142 8.4467 8.73854 11.8477 8.91624C11.7843 8.61167 11.7462 8.29444 11.7462 7.97717C11.7462 5.71826 13.5736 3.87817 15.8452 3.87817C17.0254 3.87817 18.0914 4.3731 18.8401 5.17259C19.7665 4.99494 20.6548 4.65228 21.4416 4.18275C21.137 5.13455 20.4898 5.93404 19.6396 6.44162C20.4645 6.35283 21.264 6.12435 22 5.80713C21.4417 6.61928 20.7437 7.3426 19.9442 7.92639Z"
                                      fill="white"/>
                            </svg>
                        </a>
                    </div>
                    </div>
                <?php endif; ?>
                <?php
if (comments_open() || get_comments_number()) :
?>
    <div id="comments" class="cm-section">
        <?php comments_template(); ?>
    </div>
<?php
endif;
?>
                <?php endwhile; ?>
            </div> <!-- پایان main-box -->
            <?php if (is_active_sidebar('ultra_sidebar_tv')) : ?>
                <aside class="side-single">
                    <?php dynamic_sidebar('ultra_sidebar_tv'); ?>
                </aside>
            <?php endif; ?>
        </div> <!-- پایان post-content -->
    </div> <!-- پایان container -->
</section>
<?php get_footer(); ?>
