<?php get_header(); ?>
<div class="archive-product category-product-page">
    <div class="container">
        <?php if (function_exists('ultra_breadcrumb')) { ?>
            <nav class="breadcrumb-ultra">
                <?php echo ultra_breadcrumb(); ?>
            </nav>
        <?php } ?>
        <div class="archive-content">
            <?php if (is_active_sidebar('ultra_sidebar_search')) { ?>
                <aside class="side-single">
                    <?php dynamic_sidebar('ultra_sidebar_search'); ?>
                </aside>
            <?php } ?>
            <section class="category-product">
                <div class="result-search">
                    <div class="product-title">
                        <h1> نتایج جستجو: <span><?php echo get_search_query(); ?></span></h1>
                    </div>

                    <div class="product-items">
                        <?php
                        // تنظیمات کوئری برای نمایش محصولات
                        $args = array(
                            'post_type'      => 'product',
                            'posts_per_page' => 12,
                            'paged'          => (get_query_var('paged')) ? get_query_var('paged') : 1,
                            's'              => get_search_query()
                        );
                        $product_query = new WP_Query($args);

                        if ($product_query->have_posts()) {
                            while ($product_query->have_posts()) : $product_query->the_post();
                                get_template_part('template/product/content', 'product');
                            endwhile;
                            wp_reset_postdata();
                        } else {
                            echo '<p class="not-found">متاسفانه محصولی یافت نشد...!</p>';
                        }
                        ?>
                    </div>
                    <div class="navigation">
                        <nav class="ultra-pagination">
                            <ul class="pagination justify-content-center mt-5 mb-5">
                                <?php
                                echo paginate_links(array(
                                    'base'      => str_replace(999999999, '%#%', esc_url(get_pagenum_link(999999999))),
                                    'total'     => $product_query->max_num_pages,
                                    'current'   => max(1, get_query_var('paged')),
                                    'format'    => '?paged=%#%',
                                    'show_all'  => false,
                                    'type'      => 'plain',
                                    'end_size'  => 2,
                                    'mid_size'  => 1,
                                    'prev_next' => true,
                                    'prev_text' => 'قبلی',
                                    'next_text' => 'بعدی',
                                    'add_args'  => false,
                                    'add_fragment' => '',
                                ));
                                ?>
                            </ul>
                        </nav>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
<?php get_footer(); ?>
