<?php
/*
Template Name: آرشیو تلویزیون
*/
get_header(); ?>
    <div class="archive-page archive-product category-product-page category-blogs">
        <div class="container">

            <nav class="breadcrumb-ultra">
                <?php echo ultra_breadcrumb(); ?>
            </nav>


            <div class="archive-content">

                <?php if (is_active_sidebar('ultra_sidebar_tv')) { ?>
                    <aside class="side-single">
                        <?php dynamic_sidebar('ultra_sidebar_tv'); ?>
                    </aside>
                <?php } ?>


                <section class="category-product blogs-content category-page">
                    <div class="product-title">
                        <h1><?php single_term_title(); ?></h1>
                    </div>


                    <section class="tv-sec">
                        <div class="tv-box">
                            <div class="main-tv">
                                <?php
                                if (have_posts()) :
                                    while (have_posts()) : the_post(); ?>
                                        <div class="tv-item">
                                            <figure>
                                            <?php if (has_post_thumbnail()) {
                                                the_post_thumbnail();
                                            } else { ?>
                                                <img src="<?= get_template_directory_uri() . '/assets/image/empty.webp' ?>"/>
                                            <?php } ?>
                                            </figure>
                                            <a href="<?php the_permalink(); ?>">
                                                <svg class="svg-icon" id="Play" width="40px" height="40px"
                                                     viewBox="0 0 24 24" version="1.1"
                                                     xmlns="http://www.w3.org/2000/svg"
                                                     xmlns:xlink="http://www.w3.org/1999/xlink">
                                                    <title>Iconly/Bold/Play</title>
                                                    <g id="Iconly/Bold/Play" stroke="none" stroke-width="0" fill="none"
                                                       fill-rule="evenodd">
                                                        <g id="Play" transform="translate(2.000000, 2.000000)"
                                                           fill="#fff" fill-rule="nonzero">
                                                            <path d="M10,0 C15.511583,0 20,4.48625181 20,10.0057887 C20,15.5137482 15.511583,20 10,20 C4.48841699,20 0,15.5137482 0,10.0057887 C0,4.48625181 4.48841699,0 10,0 Z M8.86100386,6.02990835 C8.64864865,6.02990835 8.44594595,6.07814761 8.25289575,6.17462615 C8.01158301,6.30969609 7.81853282,6.52194887 7.71235521,6.77279305 C7.64478764,6.94645441 7.53861004,7.46743849 7.53861004,7.47708635 C7.43243243,8.0463097 7.37451737,8.97250362 7.37451737,9.99517607 C7.37451737,10.970574 7.43243243,11.8572118 7.51930502,12.436083 C7.52895753,12.4457308 7.63513514,13.092137 7.75096525,13.3140376 C7.96332046,13.7192475 8.37837838,13.9700917 8.82239382,13.9700917 L8.82239382,13.9700917 L8.86100386,13.9700917 C9.15057915,13.9604438 9.75868726,13.7095996 9.75868726,13.6999518 C10.7818533,13.2754462 12.7992278,11.9536903 13.6100386,11.0757356 L13.6100386,11.0757356 L13.6679537,11.0178485 C13.7741313,10.9117221 13.9092664,10.7477086 13.9382239,10.7091172 C14.0926641,10.5065123 14.1698842,10.2556681 14.1698842,10.0057887 C14.1698842,9.72503618 14.0830116,9.46454414 13.9189189,9.25229137 C13.8803089,9.21369995 13.7355212,9.04968644 13.6003861,8.9146165 C12.8088803,8.0656054 10.7432432,6.67631452 9.66216216,6.25180897 C9.4980695,6.18523878 9.08301158,6.0395562 8.86100386,6.02990835 Z"></path>
                                                        </g>
                                                    </g>
                                                </svg>
                                            </a>
                                            <a href="<?php the_permalink(); ?>"><h4><?php the_title(); ?></h4></a>

                                        </div>
                                    <?php endwhile;
                                endif;
                                wp_reset_postdata();
                                ?>
                            </div>


                    </section>
                    <div class="navigation">
                        <?php the_posts_pagination(); ?>
                    </div>
                </section>
            </div>


        </div>
    </div>
<?php get_footer();
