<?php
/*
Template Name: نمایش تمام برندها
*/

get_header(); ?>
<section class="single-post-ultra page-post-ultra ultra-page">
    <div class="container">
        <div class="post-content">
            <div class="main-box">
                <nav class="breadcrumb-ultra">
                    <?php
                    if (function_exists('ultra_breadcrumb')) {
                        echo ultra_breadcrumb();
                    }
                    //get_template_part('inc/breadcrumb/breadcrumb'); ?>
                </nav>
                <div class="text-box">
                    <div class="header-page">
             <svg id="Ticket" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13.3593 3.59998V6.25523" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
<path d="M13.3593 17.5439V19.7641" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
<path d="M13.3593 14.5439V9.25525" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
<path fill-rule="evenodd" clip-rule="evenodd" d="M21.5 14.0504C18.8093 14.0504 18.8093 9.94867 21.5 9.94867C21.5 5.19622 21.5 3.5 12 3.5C2.5 3.5 2.5 5.19622 2.5 9.94867C5.19074 9.94867 5.19074 14.0504 2.5 14.0504C2.5 18.8038 2.5 20.5 12 20.5C21.5 20.5 21.5 18.8038 21.5 14.0504Z" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
</svg>
<h1><?php the_title(); ?></h1>
                    </div>
                    <div class="brands">
                        <?php
                        $brands = get_terms(array(
                            'taxonomy' => 'product_brand',
                            'hide_empty' => false, // نمایش برندهای خالی
                        ));
                        if (!empty($brands) && !is_wp_error($brands)) {
                            foreach ($brands as $brand) { ?>
                                <div class="brand-item">
                                    <a href="<?php echo get_term_link($brand->term_id) ?>" target="_blank">
                                        <figure>
                                            <?php
                                            $attach_id = get_term_meta($brand->term_id, 'brand_thumbnail', 1);
                                            echo wp_get_attachment_image($attach_id,'full');
                                            ?>
                                        </figure>
                                        <p><?php echo esc_html($brand->name); ?></p>
                                    </a>
                                </div>
                          <?php  }
                        } else {
                            echo '<div>برندی یافت نشد.</div>';
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php get_footer(); ?>
