<?php
/*
Template Name: آرشیو مقالات
*/
get_header();
global $ultra_options;

// تنظیمات صفحه‌بندی
$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
$args = array(
    'post_type' => 'post',
    'posts_per_page' => get_option('posts_per_page'), // تعداد مقالات داینامیک
    'paged' => $paged
);
$query = new WP_Query($args);
?>

<div class="archive-page archive-product category-product-page category-blogs">
    <div class="container">
        <div class="archive-content">
            <?php if (is_active_sidebar('ultra_sidebar_blog')) { ?>
                <aside class="side-single">
                    <?php dynamic_sidebar('ultra_sidebar_blog'); ?>
                </aside>
            <?php } ?>

            <section class="category-product blogs-content">
                <div class="product-title">
                    <h1>مقالات</h1>
                </div>

                <?php if ($ultra_options['select_template_blog'] == 'one_blog') : ?>
                    <div class="blogs-sec blogs-show-1">
                        <?php if ($query->have_posts()) : while ($query->have_posts()) : $query->the_post(); ?>
                            <div class="blog-item">
                                <figure>
                                    <?php if (has_post_thumbnail()) {
                                        the_post_thumbnail();
                                    } else { ?>
                                        <img src="<?= get_template_directory_uri() . '/assets/image/empty.webp' ?>">
                                    <?php } ?>
                                </figure>
                                <div class="info-blog">
                                    <a href="<?php the_permalink(); ?>"><h3><?php the_title(); ?></h3></a>
                                    <p class="excerpt"><?php echo get_the_excerpt(); ?></p>
                                    <span class="cat"><?php the_category('. '); ?></span>
                                    <div class="author">
                                        <span>نویسنده : <span><?php the_author(); ?></span></span>
                                        <span><?php echo get_the_date('j F, Y'); ?></span>
                                    </div>
                                    <a class="view" href="<?php the_permalink(); ?>"> مشاهده</a>
                                </div>
                            </div>
                        <?php endwhile; endif; wp_reset_postdata(); ?>
                    </div>
                <?php endif; ?>

                <?php if ($ultra_options['select_template_blog'] == 'two_blog') : ?>
                    <div class="blogs-sec blogs-show-2">
                        <?php if ($query->have_posts()) : while ($query->have_posts()) : $query->the_post(); ?>
                            <div class="blog-item">
                                <figure>
                                    <?php if (has_post_thumbnail()) {
                                        the_post_thumbnail();
                                    } else { ?>
                                        <img src="<?= get_template_directory_uri() . '/assets/image/empty.webp' ?>">
                                    <?php } ?>
                                </figure>
                                <div class="info-blog">
                                    <a href="<?php the_permalink(); ?>"><h3><?php the_title(); ?></h3></a>
                                    <p class="excerpt"><?php echo get_the_excerpt(); ?></p>
                                    <span class="cat"><?php the_category('. '); ?></span>
                                    <div class="author">
                                        <span>نویسنده : <span><?php the_author(); ?></span></span>
                                        <span><?php echo get_the_date('j F, Y'); ?></span>
                                    </div>
                                    <a class="view" href="<?php the_permalink(); ?>"> مشاهده</a>
                                </div>
                            </div>
                        <?php endwhile; endif; wp_reset_postdata(); ?>
                    </div>
                <?php endif; ?>

                <?php if ($ultra_options['select_template_blog'] == 'three_blog') : ?>
                    <div class="blogs-sec blogs-show-3">
                        <?php if ($query->have_posts()) : while ($query->have_posts()) : $query->the_post(); ?>
                            <div class="blog-item">
                                <figure>
                                    <?php if (has_post_thumbnail()) {
                                        the_post_thumbnail();
                                    } else { ?>
                                        <img src="<?= get_template_directory_uri() . '/assets/image/empty.webp' ?>">
                                    <?php } ?>
                                </figure>
                                <div class="info-blog">
                                    <a href="<?php the_permalink(); ?>"><h3><?php the_title(); ?></h3></a>
                                    <p class="excerpt"><?php echo get_the_excerpt(); ?></p>
                                    <span class="cat"><?php the_category('. '); ?></span>
                                    <div class="author">
                                        <span>نویسنده : <span><?php the_author(); ?></span></span>
                                        <span><?php echo get_the_date('j F, Y'); ?></span>
                                    </div>
                                    <a class="view" href="<?php the_permalink(); ?>"> مشاهده</a>
                                </div>
                            </div>
                        <?php endwhile; endif; wp_reset_postdata(); ?>
                    </div>
                <?php endif; ?>

                <div class="navigation">
    <?php
    // صفحه‌بندی
    echo paginate_links(array(
        'total' => $query->max_num_pages,
        'current' => $paged,
        'mid_size' => 2,
        'prev_text' => __('« قبلی'),
        'next_text' => __('بعدی »')
    ));
    ?>
</div>

            </section>
        </div>
    </div>
</div>

<?php get_footer(); ?>