<?php
// Number Product in Shop Page
add_action('pre_get_posts', 'customize_shop_products_per_page');
function customize_shop_products_per_page($query)
{
    global $ultra_options;

    if (!is_admin() && $query->is_main_query() && is_shop()) {
        // گرفتن مقدار از تنظیمات ریداکس
        $products_per_page = isset($ultra_options['products_per_page_for_shop']) ? $ultra_options['products_per_page_for_shop'] : 12; // مقدار پیش‌فرض 12
        $query->set('posts_per_page', $products_per_page);
    }
}

//ajax add-to-cart
add_filter('woocommerce_add_to_cart_fragments', function ($fragments) {
    ob_start();
    ?>
    <span class="number-cart">
        <?php echo WC()->cart->get_cart_contents_count(); ?>
    </span>
    <?php $fragments['.number-cart'] = ob_get_clean();
    return $fragments;
});
add_filter('woocommerce_add_to_cart_fragments', function ($fragments) {
    ob_start();
    ?>
    <div class="cart-content">
        <?php woocommerce_mini_cart(); ?>
    </div>
    <?php $fragments['.cart-content'] = ob_get_clean();
    return $fragments;
});

remove_action('woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10);
remove_action('woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10);
add_action('woocommerce_before_main_content', 'my_theme_wrapper_start', 10);
add_action('woocommerce_after_main_content', 'my_theme_wrapper_end', 10);

function my_theme_wrapper_start()
{
    echo '<section class="single-product-ultra"> <div class="container">';
}

function my_theme_wrapper_end()
{
    echo '</div></section>';
}

remove_action('woocommerce_sidebar', 'woocommerce_get_sidebar', 10);
remove_action('woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10);

add_action('woocommerce_before_quantity_input_field', 'before_add_control_input_woocommerce');
function before_add_control_input_woocommerce()
{
    echo '<button class="plus" type="button">+</button>';
}

add_action('woocommerce_after_quantity_input_field', 'after_add_control_input_woocommerce');
function after_add_control_input_woocommerce()
{
    echo '<button class="minus" type="button">-</button>';
}

/*
 * Display Discount
 */
function ultra_woocommerce_discount($id)
{
    $product = wc_get_product($id);
    if ($product->is_on_sale()) {
        if ($product->is_type('variable')) {
            $regular_price = $product->get_variation_regular_price('min');
            $sale_price = $product->get_variation_sale_price('min');
        } else {
            $regular_price = $product->get_regular_price();
            $sale_price = $product->get_sale_price();
        }

        $insale_price = (int)$regular_price - (int)$sale_price;
        $discount_price = round(($insale_price / $regular_price) * 100);
        return $discount_price;
    }
}

remove_action('woocommerce_single_variation', 'woocommerce_single_variation', 10);
/**
 * Remove product data tabs
 */
add_filter('woocommerce_product_tabs', 'woo_remove_product_tabs', 98);

function woo_remove_product_tabs($tabs)
{

    unset($tabs['description']);        // Remove the description tab
    unset($tabs['reviews']);            // Remove the reviews tab
    unset($tabs['additional_information']);    // Remove the additional information tab

    return $tabs;
}

/**
 * افزودن توضیحات محصول بعد از خلاصه محصول
 */
add_action('woocommerce_after_single_product_summary', 'display_product_description', 5);
function display_product_description()
{
    global $post;
    $product_description = apply_filters('the_content', $post->post_content);

    if ($product_description) {
        echo '<div class="woocommerce-product-description">';
        echo '<h2>' . __('توضیحات محصول:') . '</h2>';
        echo $product_description;
        echo '</div>';
    }
}

// افزودن توضیحات تکمیلی بعد از توضیحات محصول
add_action('woocommerce_after_single_product_summary', 'display_additional_information', 6);
function display_additional_information()
{
    global $product;
    if ($product && ($product->has_attributes() || apply_filters('wc_product_enable_dimensions_display', $product->has_weight() || $product->has_dimensions()))) {
        echo '<div class="woocommerce-product-additional-information">';
        echo '<h2 id="tb-link">' . __('توضیحات تکمیلی محصول:') . '</h2>';
        wc_display_product_attributes(wc_get_product());
        echo '</div>';
    }
}


// افزودن محصولات خریداری شده همراه با محصول
add_action('woocommerce_after_single_product_summary', 'display_cross_sell_products', 7);
function display_cross_sell_products()
{
    $cross_id = get_post_meta(get_the_ID(), '_crosssell_ids', true);
    if ($cross_id) {
        ?>
        <div class="ultra-cross-sell">
            <h2><?php _e('در کنار این کالا خریداری می‌شوند'); ?></h2>
            <div class="product-cross-sell">
                <div class="product-items">
                    <div class="owl-carousel owl-theme related-products-prod">
                        <?php
                        $cross_sell = new WP_Query(array(
                            'post_type' => 'product',
                            'no_found_rows' => true,
                            'post__in' => $cross_id,
                        ));

                        if ($cross_sell->have_posts()) :
                            while ($cross_sell->have_posts()) : $cross_sell->the_post(); ?>
                                <?php
                                wc_get_template_part('template/product/cross', 'sell');

                            endwhile;
                        endif;

                        wp_reset_postdata();
                        ?>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
}


// افزودن نظرات بعد از توضیحات تکمیلی
add_action('woocommerce_after_single_product_summary', 'display_reviews', 8);
function display_reviews()
{
    comments_template();
}

// حذف نمایش پیش‌فرض محصولات مرتبط
remove_action('woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20);

// // افزودن محصولات مشابه
// add_action('woocommerce_after_single_product_summary', 'display_related_products', 9);
// function display_related_products()
// {
//     // تنظیم تعداد محصولات و ستون‌ها
//     woocommerce_related_products(array(
//         'posts_per_page' => 4, // تعداد محصولات مشابه
//         'columns' => 4, // تعداد ستون‌ها
//     ));
// }

get_template_part('inc/review/review-product');
remove_action('woocommerce_review_before', 'woocommerce_review_display_gravatar', 10);

// حذف تگ "تخفیف!" از نمایش محصولات فروش ویژه
add_filter('woocommerce_sale_flash', 'remove_sale_flash', 10, 3);
function remove_sale_flash($html, $post, $product)
{
    // برگشت مقدار خالی برای حذف تگ "تخفیف!"
    return '';
}

/**
 * Product Add/Edit custom tabs
 *
 */
add_filter('woocommerce_product_data_tabs', 'wk_product_edit_tab', 10, 1);
function wk_product_edit_tab($default_tabs)
{
    $tabs = array(
        'wk_custom_tab' => array(
            'label' => 'فروش ویژه',
            'target' => 'wk_custom_tab', // ID of tab field
            'priority' => 20,
            'class' => array(),
        ),
    );
    $default_tabs = array_merge($default_tabs, $tabs);
    return $default_tabs;
}

/**
 * Product Add/Edit custom tab field
 *
 * @return void
 */
add_action('woocommerce_product_data_panels', 'wk_product_tab_field');
function wk_product_tab_field()
{
    global $post;
    ?>
    <div id="wk_custom_tab" class="panel woocommerce_options_panel">
        <?php
        // بررسی وضعیت تیک چک‌باکس
        $status_timer_offer = get_post_meta($post->ID, 'status_timer_offer', true);
        woocommerce_wp_checkbox(
            array(
                'id' => 'status_timer_offer',
                'label' => 'فروش ویژه..؟',
                'description' => 'فعال',
                'value' => $status_timer_offer,  // تعیین وضعیت تیک چک‌باکس
            )
        );
        $start_date = get_post_meta($post->ID, 'event_start_date', true);
        $end_date = get_post_meta($post->ID, 'event_end_date', true);
        ?>
        <p class="form-field">
            <label for="datepicker1">تاریخ شروع</label>
            <input type="date" value="<?php echo $start_date; ?>" name="event_start_date" id="datepicker1">
        </p>
        <p class="form-field">
            <label for="datepicker2">تاریخ پایان</label>
            <input type="date" value="<?php echo $end_date; ?>" name="event_end_date" id="datepicker2">
        </p>
    </div>
    <?php
}


/**
 * Save custom data
 *
 * @return boolean
 */
add_action('save_post_product', 'wk_save_custom_tab_data', 10, 3);
function wk_save_custom_tab_data($post_id)
{
    // چک کردن اینکه آیا این محصول در حال ویرایش است
    if (isset($_POST['status_timer_offer'])) {
        update_post_meta($post_id, 'status_timer_offer', esc_attr($_POST['status_timer_offer']));
    } else {
        // اگر تیک چک‌باکس زده نشده باشد، مقدار 0 ذخیره می‌شود
        update_post_meta($post_id, 'status_timer_offer', '0');
    }

    // ذخیره تاریخ شروع و پایان
    if (isset($_POST['event_start_date'])) {
        update_post_meta($post_id, 'event_start_date', esc_attr($_POST['event_start_date']));
    }
    if (isset($_POST['event_end_date'])) {
        update_post_meta($post_id, 'event_end_date', esc_attr($_POST['event_end_date']));
    }
}


// Add CSS - icon
add_action('admin_head', 'action_admin_head');
function action_admin_head()
{
    echo '<style>
        
        #woocommerce-product-data ul.wc-tabs li.special_sale_time a:before {
        content: "\f508";
        }
    </style>';
}

get_template_part('inc/customPostType/brand-product');
/**
 * My Account
 */
add_action('woocommerce_before_account_navigation', 'ultra_before_account_navigation');
function ultra_before_account_navigation()
{
    echo '<div class="ultra-myAccount">';
}

add_action('woocommerce_account_content', 'ultra_after_woocommerce_MyAccount_content');
function ultra_after_woocommerce_MyAccount_content()
{
    echo '</div>';
}

/**
 * File Form Edit Account
 */
add_action('woocommerce_before_edit_account_form', 'ultra_before_edit_account_form');
function ultra_before_edit_account_form()
{
    echo '<div class="panel-content">';
}

add_action('woocommerce_after_edit_account_form', 'ultra_after_edit_account_form');
function ultra_after_edit_account_form()
{
    echo '</div>';
}

/**
 * File Form Edit Address
 */
add_action('woocommerce_before_edit_account_address_form', 'ultra_before_edit_account_address_form');
function ultra_before_edit_account_address_form()
{
    echo '<div class="panel-content">';
}

add_action('woocommerce_after_edit_account_address_form', 'ultra_after_edit_account_address_form');
function ultra_after_edit_account_address_form()
{
    echo '</div>';
}

/**
 * File Downloads
 */
add_action('woocommerce_before_account_downloads', 'ultra_before_account_downloads');
function ultra_before_account_downloads()
{
    echo '<div class="panel-content">';
}

add_action('woocommerce_after_account_downloads', 'ultra_after_account_downloads');
function ultra_after_account_downloads()
{
    echo '</div>';
}

/**
 * File Orders
 */
add_action('woocommerce_before_account_orders', 'ultra_before_account_orders');
function ultra_before_account_orders()
{
    echo '<div class="panel-content">';
}

add_action('woocommerce_after_account_orders', 'ultra_after_account_orders');
function ultra_after_account_orders()
{
    echo '</div>';
}

/**
 * Add Bottom Header In Cart For Mobile (File: woocommerce/cart/cart-totals.php)
 */
add_action('woocommerce_after_cart_totals', 'ultra_cart_line_bottom');
function ultra_cart_line_bottom()
{
    ?>
    <div class="cart-line-bottom">
        <div class="order-total">
            <span><?php esc_html_e('مبلغ نهایی', 'woocommerce'); ?></span>
            <span data-title="<?php esc_attr_e('Total', 'woocommerce'); ?>">
                <?php wc_cart_totals_order_total_html(); ?>
            </span>
        </div>
        <?php do_action('woocommerce_proceed_to_checkout'); ?>
    </div>
    <?php
}
/**
 *  کارت به کارت
 */
// امن‌ترین روش: فقط بعد از لود کامل ووکامرس درگاه کارت به کارت را اضافه کن
add_action('plugins_loaded', function() {
    if (class_exists('WooCommerce')) {
        add_filter('woocommerce_payment_gateways', function($gateways) {
            if (!class_exists('WC_Gateway_Card_To_Card')) {
                require_once get_template_directory() . '/woocommerce/payment-gateways/class-wc-gateway-card-to-card.php';
            }
            $gateways[] = 'WC_Gateway_Card_To_Card';
            return $gateways;
        });
    }
});


// اعتبارسنجی فیلدهای کارت به کارت
add_action('woocommerce_checkout_process', 'validate_card_to_card_fields');
function validate_card_to_card_fields()
{
    if (isset($_POST['payment_method']) && $_POST['payment_method'] === 'card_to_card') {
        if (empty($_POST['customer_card_last4'])) {
            wc_add_notice('لطفاً چهار رقم آخر کارت خود را وارد کنید.', 'error');
        }
        if (empty($_POST['transaction_code'])) {
            wc_add_notice('کد پیگیری تراکنش الزامی است.', 'error');
        }
    }
}

// ذخیره اطلاعات پرداخت کارت به کارت در متای سفارش
add_action('woocommerce_checkout_update_order_meta', 'save_card_to_card_fields');
function save_card_to_card_fields($order_id)
{
    if (isset($_POST['payment_method']) && $_POST['payment_method'] === 'card_to_card') {
        update_post_meta($order_id, '_customer_card_last4', sanitize_text_field($_POST['customer_card_last4']));
        update_post_meta($order_id, '_transaction_code', sanitize_text_field($_POST['transaction_code']));
    }
}

// نمایش اطلاعات پرداخت کارت به کارت در صفحه کاربر
add_action('woocommerce_order_details_after_order_table', 'display_card_to_card_info', 10, 1);
function display_card_to_card_info($order)
{
    $last4 = get_post_meta($order->get_id(), '_customer_card_last4', true);
    $transaction_code = get_post_meta($order->get_id(), '_transaction_code', true);

    if ($last4 || $transaction_code) {
        echo '<div class="payment-ultra-ctc">';
        echo '<h2>' . __('اطلاعات پرداخت') . '</h2>';
        if ($last4) {
            echo '<p>' . __('چهار رقم آخر کارت:') . ' ' . esc_html($last4) . '</p>';
        }
        if ($transaction_code) {
            echo '<p>' . __('کد پیگیری تراکنش:') . ' ' . esc_html($transaction_code) . '</p>';
        }
        echo '</div>';
    }
}

// نمایش اطلاعات پرداخت در پنل مدیریت
add_action('woocommerce_admin_order_data_after_order_details', 'display_card_to_card_info_in_admin_order_details', 10, 1);
function display_card_to_card_info_in_admin_order_details($order)
{
    $last4 = get_post_meta($order->get_id(), '_customer_card_last4', true);
    $transaction_code = get_post_meta($order->get_id(), '_transaction_code', true);

    if ($last4 || $transaction_code) {
        echo '<h3>' . __('اطلاعات پرداخت کارت به کارت') . '</h3>';
        if ($last4) {
            echo '<p><strong>' . __('چهار رقم آخر کارت:') . '</strong> ' . esc_html($last4) . '</p>';
        }
        if ($transaction_code) {
            echo '<p><strong>' . __('کد پیگیری تراکنش:') . '</strong> ' . esc_html($transaction_code) . '</p>';
        }
    }
}

// اضافه کردن وضعیت سفارش "کارت به کارت"
add_action('init', 'add_card_to_card_order_status');
function add_card_to_card_order_status()
{
    register_post_status('wc-card-to-card', array(
        'label' => 'کارت به کارت',
        'public' => true,
        'exclude_from_search' => false,
        'show_in_admin_all_list' => true,
        'show_in_admin_status_list' => true,
        'show_in_front' => true,
        'label_count' => _n_noop('کارت به کارت <span class="count">(%s)</span>', 'کارت به کارت <span class="count">(%s)</span>'),
    ));
}

// اضافه کردن وضعیت به لیست وضعیت‌های سفارش
add_filter('wc_order_statuses', 'add_card_to_card_order_status_to_list');
function add_card_to_card_order_status_to_list($order_statuses)
{
    $order_statuses['wc-card-to-card'] = 'کارت به کارت';
    return $order_statuses;
}

// استایل وضعیت "کارت به کارت"
add_action('admin_head', 'ultra_custom_css');
function ultra_custom_css()
{
    echo '<style>
    .order-status.status-card-to-card {
        background-color: blue !important;
        color: white !important;
    }
    </style>';
}
/**
 * Add Div CheckOut in File checkout\review-order.php
 */
add_action('woocommerce_review_order_before_shipping', 'ultra_review_order_before_shipping');
function ultra_review_order_before_shipping()
{
    echo '<div class="ultra-shipping">';
}

add_action('woocommerce_review_order_after_shipping', 'ultra_review_order_after_shipping');
function ultra_review_order_after_shipping()
{
    echo '</div>';
}
// min DOM Site (Price Product)
add_filter('woocommerce_get_price_html', 'taktheme_dom_price_html', 10, 2);
function taktheme_dom_price_html($price, $product) {
    // استخراج نماد ارز
    $currency_symbol = get_woocommerce_currency_symbol();
    
    // حذف تگ <bdi> و </bdi> از قیمت
    $price = str_replace(['<bdi>', '</bdi>'], '', $price);

    // تغییر محتوای داخل تگ <span class="woocommerce-Price-currencySymbol"> به نماد ارز
    $price = preg_replace('/<span class="woocommerce-Price-currencySymbol">.*?<\/span>/', 
                          '<span class="woocommerce-Price-currencySymbol">' . $currency_symbol . '</span>', 
                          $price);

    // حذف تگ‌های screen-reader-text
    $price = preg_replace('/<span class="screen-reader-text">.*?<\/span>/', '', $price);

    return $price;
}

// start az in variable product
add_filter( 'woocommerce_variable_price_html', 'variation_price_format_min', 9999, 2 );
function variation_price_format_min( $price, $product ) {
   $prices = $product->get_variation_prices( true );
   $min_price = current( $prices['price'] );
   $max_price = end( $prices['price'] );
   $min_reg_price = current( $prices['regular_price'] );
   $max_reg_price = end( $prices['regular_price'] );
   if ( $min_price !== $max_price || ( $product->is_on_sale() && $min_reg_price === $max_reg_price ) ) {
      $price = '<span class="start-price">شروع از: </span>' . wc_price( $min_price ) . $product->get_price_suffix();
   }
   return $price;
}
/**
 *  Free First Delivery
 */
add_filter('woocommerce_coupon_is_valid', 'only_first_order_coupon', 10, 2);
function only_first_order_coupon($valid, $coupon) {
    global $ultra_options;
    $free_first = $ultra_options['code-free-first-delivery'];
    if ($free_first === $coupon->get_code()) { // جایگزین با کد تخفیف شما
        if (!is_user_logged_in()) {
            wc_add_notice(__('برای استفاده از این کد تخفیف باید وارد حساب کاربری خود شوید.', 'woocommerce'), 'error');
            return false; // کوپن نامعتبر می‌شود
        }

        $user_orders = wc_get_orders(array(
            'customer_id' => get_current_user_id(),
            'limit' => 1,
        ));

        if (!empty($user_orders)) {
            wc_add_notice(__('این کد تخفیف فقط برای اولین خرید قابل استفاده است.', 'woocommerce'), 'error');
            return false; // اگر کاربر قبلاً خرید داشته باشد، کوپن نامعتبر است
        }
    }
    return $valid;
}
/**
 * Start Tracking Form
 */
// ✅ نمایش فیلدها در جزئیات سفارش (پنل مدیریت)
add_action('woocommerce_admin_order_data_after_order_details', 'custom_shipping_fields_inside_order');
function custom_shipping_fields_inside_order($order){
    $tracking_code = get_post_meta($order->get_id(), '_tracking_code', true);
    $shipping_method = get_post_meta($order->get_id(), '_shipping_method_custom', true);
    $shipping_date = get_post_meta($order->get_id(), '_shipping_date_custom', true);
    ?>
    <p class="form-field form-field-wide" style="margin-top:30px; padding:20px; border:1px solid #ccc; background:#f9f9f9; border-radius:6px;">
    <h3 style="margin-bottom:15px;">📦 اطلاعات ارسال سفارش</h3>

    <p>
        <label for="_tracking_code"><strong>کد رهگیری:</strong></label><br>
        <input type="text" name="_tracking_code" id="_tracking_code" style="width:100%;" value="<?php echo esc_attr($tracking_code); ?>">
    </p>

    <p>
        <label for="_shipping_method_custom"><strong>نوع سیستم حمل و نقل:</strong></label><br>
        <input type="text" name="_shipping_method_custom" id="_shipping_method_custom" style="width:100%;" value="<?php echo esc_attr($shipping_method); ?>">
    </p>

    <p>
        <label for="_shipping_date_custom"><strong>تاریخ ارسال:</strong></label><br>
        <input type="text" name="_shipping_date_custom"
               class="date-picker"
               value="<?php echo esc_attr($shipping_date); ?>"
               style="width: 100%;">
    </p>
    <?php
}

// ✅ ذخیره اطلاعات هنگام ذخیره سفارش
add_action('woocommerce_process_shop_order_meta', 'save_custom_shipping_fields_from_order');
function save_custom_shipping_fields_from_order($order_id){
    foreach (['_tracking_code', '_shipping_method_custom', '_shipping_date_custom'] as $field) {
        if (isset($_POST[$field])) {
            update_post_meta($order_id, $field, sanitize_text_field($_POST[$field]));
        }
    }
}

/**
 *
 */
add_shortcode('order_tracking', 'custom_order_tracking_shortcode');

function custom_order_tracking_shortcode() {
    ob_start();
    ?>
    <form class="ultra-delivery" method="post">
        <label for="order_input">شماره سفارش یا شماره موبایل:</label>
        <input type="text" name="order_input" required style="margin-right:10px;">
        <button type="submit">بررسی وضعیت سفارش</button>
    </form>
    <?php

    if (!empty($_POST['order_input'])) {
        $input = sanitize_text_field($_POST['order_input']);

        // اگر عدد کوتاه باشه = شماره سفارش
        if (is_numeric($input) && strlen($input) < 10) {
            $order = wc_get_order((int)$input);
            if ($order) {
                echo render_tracking_info_html($order);
            } else {
                echo '<p>سفارشی با این شماره یافت نشد.</p>';
            }
        } else {
            // جستجو با شماره موبایل
            $args = array(
                'limit' => 3,
                'orderby' => 'date',
                'order' => 'DESC',
                'billing_phone' => $input,
            );
            $orders = wc_get_orders($args);

            if (!empty($orders)) {
                foreach ($orders as $order) {
                    echo render_tracking_info_html($order);
                }
            } else {
                echo '<p>سفارشی با این شماره همراه یافت نشد.</p>';
            }
        }
    }

    return ob_get_clean();
}

function render_tracking_info_html($order) {
    $order_id = $order->get_id();
    $tracking_code = get_post_meta($order_id, '_tracking_code', true);
    $shipping_method = get_post_meta($order_id, '_shipping_method_custom', true);
    $shipping_date = get_post_meta($order_id, '_shipping_date_custom', true);
    $status = $order->get_status();

// تعریف آیکون + رنگ + پیام برای هر وضعیت سفارش
    $status_styles = [
        'pending' => [
            'icon' => '⏳',
            'color' => '#999',
            'text' => 'در انتظار پرداخت',
        ],
        'processing' => [
            'icon' => '🟠',
            'color' => '#e67e22',
            'text' => 'در حال انجام (سفارش شما با موفقیت دریافت شده)',
        ],
        'on-hold' => [
            'icon' => '🕒',
            'color' => '#f39c12',
            'text' => 'در انتظار تأیید مدیریت',
        ],
        'completed' => [
            'icon' => '✅',
            'color' => '#27ae60',
            'text' => 'تکمیل شده (سفارش شما ارسال شده است)',
        ],
        'cancelled' => [
            'icon' => '❌',
            'color' => '#c0392b',
            'text' => 'سفارش لغو شده است',
        ],
        'refunded' => [
            'icon' => '💸',
            'color' => '#3498db',
            'text' => 'مبلغ سفارش به شما بازپرداخت شده',
        ],
        'failed' => [
            'icon' => '⚠️',
            'color' => '#e74c3c',
            'text' => 'پرداخت ناموفق بوده است',
        ]
    ];

    $status_data = $status_styles[$status] ?? [
        'icon' => '❔',
        'color' => '#bdc3c7',
        'text' => 'وضعیت نامشخص',
    ];

    ob_start();
    ?>
    <div style="padding:20px; background:#f0f9ff; border:1px solid #ccc; border-radius:8px; margin-top:15px;">
        <p><strong>شماره سفارش:</strong> <?php echo $order_id; ?></p>

        <p>
            <strong>وضعیت سفارش:</strong>
            <span style="display:inline-block; padding:6px 12px; background:<?php echo $status_data['color']; ?>; color:white; border-radius:5px;">
                <?php echo $status_data['icon'] . ' ' . $status_data['text']; ?>
            </span>
        </p>

        <?php if ($tracking_code): ?>
            <p><strong>کد پیگیری:</strong> <?php echo esc_html($tracking_code); ?></p>
        <?php endif; ?>

        <?php if ($shipping_method): ?>
            <p><strong>روش ارسال:</strong> <?php echo esc_html($shipping_method); ?></p>
        <?php endif; ?>

        <?php if ($shipping_date): ?>
		<p><strong>تاریخ ارسال:</strong> <span style=" direction: ltr;  unicode-bidi: plaintext;  display: inline-block;" > <?php echo esc_html($shipping_date); ?></span></p> 
        <?php endif; ?>

        <?php if (!$tracking_code && !$shipping_method && !$shipping_date): ?>
            <p>اطلاعات ارسال هنوز ثبت نشده است.</p>
        <?php endif; ?>
    </div>
    <?php
    return ob_get_clean();
}
// Add express shipping checkbox to product admin
add_action('woocommerce_product_options_general_product_data', function() {
    echo '<div class="options_group">';
    woocommerce_wp_checkbox([
        'id' => 'fast_sending_express_shipping',
        'label' => 'ارسال فوری',
        'description' => 'فعال کردن ارسال فوری برای این محصول',
        'wrapper_class' => 'fast-express-checkbox',
    ]);
    echo '</div>';
});
// Save express shipping checkbox
add_action('woocommerce_admin_process_product_object', function($product) {
    $product->update_meta_data('fast_sending_express_shipping', isset($_POST['fast_sending_express_shipping']) ? 'yes' : 'no');
});