<?php

// Creating the widget
class up_button_footer extends WP_Widget
{
    function __construct()
    {
        parent::__construct(
        // Base ID of your widget
            'up_button_footer',

            // Widget name will appear in UI
            __('دکمه بازگشت به بالا در فوتر ( اختصاصی قالب اولترا)', 'textdomain'),

            // Widget description
            [
                'description' => __('', 'textdomain'),
            ]
        );
    }

    // Creating widget front-end
    public function widget($args, $instance)
    {
        $title_back_up = $instance['title_back_up'];
        // before and after widget arguments are defined by themes
        echo $args['before_widget'];
        if (!empty($title_back_up)) {
            echo $args['before_title'] . $title_back_up . $args['after_title'];
        }

        // This is where you run the code and display the output
        ?>
        <a class="up" href="#">برگشت به بالا</a>
        <?php echo $args['after_widget'];
    }

    // Widget Settings Form
    public function form($instance)
    {
        $title_back_up = !empty($instance['title_back_up']) ? $instance['title_back_up'] : 'سرتیتر را وارد کنید';
    }

    // Updating widget replacing old instances with new
    public function update($new_instance, $old_instance)
    {
        $instance = array();
        $instance['title_back_up'] = (!empty($new_instance['title_back_up'])) ? strip_tags($new_instance['title_back_up']) : '';
        return $instance;
    }

    // Class wpb_widget ends here
}

// Register and load the widget
function up_button_footer_widget()
{
    register_widget('up_button_footer');
}

add_action('widgets_init', 'up_button_footer_widget');