<?php

// Creating the widget
class social_media_footer extends WP_Widget
{
    function __construct()
    {
        parent::__construct(
        // Base ID of your widget
            'social_media_footer',

            // Widget name will appear in UI
            __('شبکه‌های اجتماعی در فوتر ( اختصاصی قالب اولترا)', 'textdomain'),

            // Widget description
            [
                'description' => __('نمایش بنر و لینک دانلود اپ از بازار، مایکت و ...', 'textdomain'),
            ]
        );
    }

    // Creating widget front-end
    public function widget($args, $instance)
    {
        $title_social_media = $instance['title_social_media'];
        $title_social_media1 = $instance['title_social_media1'];
        $link_title_social_media1 = $instance['link_title_social_media1'];
        $title_social_media2 = $instance['title_social_media2'];
        $link_title_social_media2 = $instance['link_title_social_media2'];
        $title_social_media3 = $instance['title_social_media3'];
        $link_title_social_media3 = $instance['link_title_social_media3'];
        $title_social_media4 = $instance['title_social_media4'];
        $link_title_social_media4 = $instance['link_title_social_media4'];

        // before and after widget arguments are defined by themes
        echo $args['before_widget'];
        if (!empty($title_social_media)) {
            echo $args['before_title'] . $title_social_media . $args['after_title'];
        }

        // This is where you run the code and display the output
        ?>
        <div class="f-w-content">
            <div class="social">
                <?php if ($title_social_media1) { ?>
                    <a href="<?= $link_title_social_media1; ?>">
                        <img src="<?= $title_social_media1; ?>"/>
                    </a>
                <?php } ?>
                <?php if ($title_social_media2) { ?>
                    <a href="<?= $link_title_social_media2; ?>">
                        <img src="<?= $title_social_media2; ?>"/>
                    </a>
                <?php } ?>
                <?php if ($title_social_media3) { ?>
                    <a href="<?= $link_title_social_media3; ?>">
                        <img src="<?= $title_social_media3 ?>"/>
                    </a>
                <?php } ?>
                <?php if ($title_social_media4) { ?>
                    <a href="<?= $link_title_social_media4; ?>">
                        <img src="<?= $title_social_media4 ?>"/>
                    </a>
                <?php } ?>
            </div>
        </div>
        <?php echo $args['after_widget'];
    }

    // Widget Settings Form
    public function form($instance)
    {
        $title_social_media = !empty($instance['title_social_media']) ? $instance['title_social_media'] : 'سرتیتر را وارد کنید';
        $title_social_media1 = !empty($instance['title_social_media1']) ? $instance['title_social_media1'] : '';
        $link_title_social_media1 = !empty($instance['link_title_social_media1']) ? $instance['link_title_social_media1'] : 'لینک اپ را وارد کنید';
        $title_social_media2 = !empty($instance['title_social_media2']) ? $instance['title_social_media2'] : '';
        $link_title_social_media2 = !empty($instance['link_title_social_media2']) ? $instance['link_title_social_media2'] : '';
        $title_social_media3 = !empty($instance['title_social_media3']) ? $instance['title_social_media3'] : '';
        $link_title_social_media3 = !empty($instance['link_title_social_media3']) ? $instance['link_title_social_media3'] : '';
        $title_social_media4 = !empty($instance['title_social_media4']) ? $instance['title_social_media4'] : '';
        $link_title_social_media4 = !empty($instance['link_title_social_media4']) ? $instance['link_title_social_media4'] : '';

        // Widget admin form
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title_social_media'); ?>">
                <?php _e('سرتیتر را وارد کنید:', 'textdomain'); ?>
            </label>
            <input
                    class="widefat" id="<?php echo $this->get_field_id('title_social_media'); ?>"
                    name="<?php echo $this->get_field_name('title_social_media'); ?>"
                    type="text"
                    value="<?php echo esc_attr($title_social_media); ?>"
            />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('title_social_media1'); ?>">تصویر اپلیکیشن 1 را انتخاب
                کنید:</label><br/>
            <img class="custom_media_image" id="namd1_image" src="<?php echo $title_social_media1; ?>"
                 style="margin-bottom:15px;padding:0;max-width:100%;"/>
            <input type="text" class="widefat custom_media_url"
                   name="<?php echo $this->get_field_name('title_social_media1'); ?>"
                   id="namd1_url" value="<?php echo $title_social_media1; ?>">
            <input type="button" value="<?php _e('انتخاب تصویر'); ?>"
                   class="button custom_media_upload custom_image_namd1" id="custom_image_namd1"/>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('link_title_social_media1'); ?>">
                <?php _e('لینک شبکه اجتماعی:', 'textdomain'); ?>
            </label>
            <input
                    class="widefat" id="<?php echo $this->get_field_id('link_title_social_media1'); ?>"
                    name="<?php echo $this->get_field_name('link_title_social_media1'); ?>"
                    type="text"
                    value="<?php echo esc_attr($link_title_social_media1); ?>"
            />
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('title_social_media2'); ?>">تصویر اپلیکیشن 2 را انتخاب
                کنید:</label><br/>
            <img class="custom_media_image" id="namd2_image" src="<?php echo $title_social_media2; ?>"
                 style="margin-bottom:15px;padding:0;max-width:100%;"/>
            <input type="text" class="widefat custom_media_url"
                   name="<?php echo $this->get_field_name('title_social_media2'); ?>"
                   id="namd2_url" value="<?php echo $title_social_media2; ?>">
            <input type="button" value="<?php _e('انتخاب تصویر'); ?>"
                   class="button custom_media_upload custom_image_namd2" id="custom_image_namd2"/>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('link_title_social_media2'); ?>">
                <?php _e('لینک شبکه اجتماعی:', 'textdomain'); ?>
            </label>
            <input
                    class="widefat" id="<?php echo $this->get_field_id('link_title_social_media2'); ?>"
                    name="<?php echo $this->get_field_name('link_title_social_media2'); ?>"
                    type="text"
                    value="<?php echo esc_attr($link_title_social_media2); ?>"
            />
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('title_social_media3'); ?>">تصویر اپلیکیشن 3 را انتخاب
                کنید:</label><br/>
            <img class="custom_media_image" id="namd3_image" src="<?php echo $title_social_media3; ?>"
                 style="margin-bottom:15px;padding:0;max-width:100%;"/>
            <input type="text" class="widefat custom_media_url"
                   name="<?php echo $this->get_field_name('title_social_media3'); ?>"
                   id="namd3_url" value="<?php echo $title_social_media3; ?>">
            <input type="button" value="<?php _e('انتخاب تصویر'); ?>"
                   class="button custom_media_upload custom_image_namd3" id="custom_image_namd3"/>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('link_title_social_media3'); ?>">
                <?php _e('لینک شبکه اجتماعی:', 'textdomain'); ?>
            </label>
            <input
                    class="widefat" id="<?php echo $this->get_field_id('link_title_social_media3'); ?>"
                    name="<?php echo $this->get_field_name('link_title_social_media3'); ?>"
                    type="text"
                    value="<?php echo esc_attr($link_title_social_media3); ?>"
            />
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('title_social_media4'); ?>">تصویر اپلیکیشن 4 را انتخاب
                کنید:</label><br/>
            <img class="custom_media_image" id="namd3_image" src="<?php echo $title_social_media4; ?>"
                 style="margin-bottom:15px;padding:0;max-width:100%;"/>
            <input type="text" class="widefat custom_media_url"
                   name="<?php echo $this->get_field_name('title_social_media4'); ?>"
                   id="namd3_url" value="<?php echo $title_social_media4; ?>">
            <input type="button" value="<?php _e('انتخاب تصویر'); ?>"
                   class="button custom_media_upload custom_image_namd3" id="custom_image_namd3"/>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('link_title_social_media4'); ?>">
                <?php _e('لینک شبکه اجتماعی:', 'textdomain'); ?>
            </label>
            <input
                    class="widefat" id="<?php echo $this->get_field_id('link_title_social_media4'); ?>"
                    name="<?php echo $this->get_field_name('link_title_social_media4'); ?>"
                    type="text"
                    value="<?php echo esc_attr($link_title_social_media4); ?>"
            />
        </p>


        <?php
    }

    // Updating widget replacing old instances with new
    public function update($new_instance, $old_instance)
    {
        $instance = array();
        $instance['title_social_media'] = (!empty($new_instance['title_social_media'])) ? strip_tags($new_instance['title_social_media']) : '';
        $instance['title_social_media1'] = (!empty($new_instance['title_social_media1'])) ? strip_tags($new_instance['title_social_media1']) : '';
        $instance['link_title_social_media1'] = (!empty($new_instance['link_title_social_media1'])) ? strip_tags($new_instance['link_title_social_media1']) : '';
        $instance['title_social_media2'] = (!empty($new_instance['title_social_media2'])) ? strip_tags($new_instance['title_social_media2']) : '';
        $instance['link_title_social_media2'] = (!empty($new_instance['link_title_social_media2'])) ? strip_tags($new_instance['link_title_social_media2']) : '';
        $instance['title_social_media3'] = (!empty($new_instance['title_social_media3'])) ? strip_tags($new_instance['title_social_media3']) : '';
        $instance['link_title_social_media3'] = (!empty($new_instance['link_title_social_media3'])) ? strip_tags($new_instance['link_title_social_media3']) : '';
        $instance['title_social_media4'] = (!empty($new_instance['title_social_media4'])) ? strip_tags($new_instance['title_social_media4']) : '';
        $instance['link_title_social_media4'] = (!empty($new_instance['link_title_social_media4'])) ? strip_tags($new_instance['link_title_social_media4']) : '';

        return $instance;
    }

    // Class wpb_widget ends here
}

// Register and load the widget
function social_media_footer_widget()
{
    register_widget('social_media_footer');
}

add_action('widgets_init', 'social_media_footer_widget');