<?php

// Creating the widget
class application_footer extends WP_Widget
{
    function __construct()
    {
        parent::__construct(
            // Base ID of your widget
            'application_footer',

            // Widget name will appear in UI
            __('دانلود اپلیکیشن در فوتر ( اختصاصی قالب اولترا)', 'textdomain'),

            // Widget description
            [
                'description' => __('نمایش بنر و لینک دانلود اپ از بازار، مایکت و ...', 'textdomain'),
            ]
        );
    }

    // Creating widget front-end
    public function widget($args, $instance)
    {
        $title_application = $instance['title_application'];
        $application1 = $instance['application1'];
        $link_application1 = $instance['link_application1'];
        $application2 = $instance['application2'];
        $link_application2 = $instance['link_application2'];
        $application3 = $instance['application3'];
        $link_application3 = $instance['link_application3'];

        // before and after widget arguments are defined by themes
        echo $args['before_widget'];
        if (!empty($title_application)) {
            echo $args['before_title'] . $title_application . $args['after_title'];
        }

        // This is where you run the code and display the output
        ?>
        <div class="f-w-content">
            <div class="app-link">
                <?php if (!empty($application1) && !empty($link_application1)): ?>
                    <a href="<?= $link_application1; ?>"><img src="<?= $application1; ?>" alt=""/></a>
                <?php endif; ?>

                <?php if (!empty($application2) && !empty($link_application2)): ?>
                    <a href="<?= $link_application2; ?>"><img src="<?= $application2; ?>" alt=""/></a>
                <?php endif; ?>

                <?php if (!empty($application3) && !empty($link_application3)): ?>
                    <a href="<?= $link_application3; ?>"><img src="<?= $application3; ?>" alt=""/></a>
                <?php endif; ?>
            </div>
        </div>
        <?php echo $args['after_widget'];
    }

    // Widget Settings Form
    public function form($instance)
    {
        $title_application = !empty($instance['title_application']) ? $instance['title_application'] : 'نام فروشگاه را وارد کنید';
        $application1 = !empty($instance['application1']) ? $instance['application1'] : '';
        $link_application1 = !empty($instance['link_application1']) ? $instance['link_application1'] : 'لینک اپ را وارد کنید';
        $application2 = !empty($instance['application2']) ? $instance['application2'] : '';
        $link_application2 = !empty($instance['link_application2']) ? $instance['link_application2'] : '';
        $application3 = !empty($instance['application3']) ? $instance['application3'] : '';
        $link_application3 = !empty($instance['link_application3']) ? $instance['link_application3'] : '';

        // Widget admin form
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title_application'); ?>">
                <?php _e('سرتیتر را وارد کنید:', 'textdomain'); ?>
            </label>
            <input
                class="widefat" id="<?php echo $this->get_field_id('title_application'); ?>"
                name="<?php echo $this->get_field_name('title_application'); ?>"
                type="text"
                value="<?php echo esc_attr($title_application); ?>"
            />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('application1'); ?>">تصویر اپلیکیشن 1 را انتخاب کنید:</label><br/>
            <img class="custom_media_image" id="namd1_image" src="<?php echo $application1; ?>"
                 style="margin-bottom:15px;padding:0;max-width:100%;"/>
            <input type="text" class="widefat custom_media_url" name="<?php echo $this->get_field_name('application1'); ?>"
                   id="namd1_url" value="<?php echo $application1; ?>">
            <input type="button" value="<?php _e('انتخاب تصویر'); ?>"
                   class="button custom_media_upload custom_image_namd1" id="custom_image_namd1"/>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('link_application1'); ?>">
                <?php _e('لینک برنامه:', 'textdomain'); ?>
            </label>
            <input
                    class="widefat" id="<?php echo $this->get_field_id('link_application1'); ?>"
                    name="<?php echo $this->get_field_name('link_application1'); ?>"
                    type="text"
                    value="<?php echo esc_attr($link_application1); ?>"
            />
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('application2'); ?>">تصویر اپلیکیشن 2 را انتخاب کنید:</label><br/>
            <img class="custom_media_image" id="namd2_image" src="<?php echo $application2; ?>"
                 style="margin-bottom:15px;padding:0;max-width:100%;"/>
            <input type="text" class="widefat custom_media_url" name="<?php echo $this->get_field_name('application2'); ?>"
                   id="namd2_url" value="<?php echo $application2; ?>">
            <input type="button" value="<?php _e('انتخاب تصویر'); ?>"
                   class="button custom_media_upload custom_image_namd2" id="custom_image_namd2"/>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('link_application2'); ?>">
                <?php _e('لینک برنامه:', 'textdomain'); ?>
            </label>
            <input
                    class="widefat" id="<?php echo $this->get_field_id('link_application2'); ?>"
                    name="<?php echo $this->get_field_name('link_application2'); ?>"
                    type="text"
                    value="<?php echo esc_attr($link_application2); ?>"
            />
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('application3'); ?>">تصویر اپلیکیشن 3 را انتخاب کنید:</label><br/>
            <img class="custom_media_image" id="namd3_image" src="<?php echo $application3; ?>"
                 style="margin-bottom:15px;padding:0;max-width:100%;"/>
            <input type="text" class="widefat custom_media_url" name="<?php echo $this->get_field_name('application3'); ?>"
                   id="namd3_url" value="<?php echo $application3; ?>">
            <input type="button" value="<?php _e('انتخاب تصویر'); ?>"
                   class="button custom_media_upload custom_image_namd3" id="custom_image_namd3"/>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('link_application3'); ?>">
                <?php _e('لینک برنامه:', 'textdomain'); ?>
            </label>
            <input
                    class="widefat" id="<?php echo $this->get_field_id('link_application3'); ?>"
                    name="<?php echo $this->get_field_name('link_application3'); ?>"
                    type="text"
                    value="<?php echo esc_attr($link_application3); ?>"
            />
        </p>
        <?php
    }

    // Updating widget replacing old instances with new
    public function update($new_instance, $old_instance)
    {
        $instance = array();
        $instance['title_application'] = (!empty($new_instance['title_application'])) ? strip_tags($new_instance['title_application']) : '';
        $instance['application1'] = (!empty($new_instance['application1'])) ? strip_tags($new_instance['application1']) : '';
        $instance['link_application1'] = (!empty($new_instance['link_application1'])) ? strip_tags($new_instance['link_application1']) : '';
        $instance['application2'] = (!empty($new_instance['application2'])) ? strip_tags($new_instance['application2']) : '';
        $instance['link_application2'] = (!empty($new_instance['link_application2'])) ? strip_tags($new_instance['link_application2']) : '';
        $instance['application3'] = (!empty($new_instance['application3'])) ? strip_tags($new_instance['application3']) : '';
        $instance['link_application3'] = (!empty($new_instance['link_application3'])) ? strip_tags($new_instance['link_application3']) : '';

        return $instance;
    }
}

// Register and load the widget
function application_footer_widget()
{
    register_widget('application_footer');
}

add_action('widgets_init', 'application_footer_widget');