<?php

// Creating the widget
class address_footer extends WP_Widget
{
    function __construct()
    {
        parent::__construct(
        // Base ID of your widget
            'address_footer',

            // Widget name will appear in UI
            __('نمایش آدرس فروشگاه در فوتر (اختصاصی قالب اولترا)', 'textdomain'),

            // Widget description
            [
                'description' => __('نمایش آدرس فروشگاه + نقشه', 'textdomain'),
            ]
        );
    }

    // Creating widget front-end
    public function widget($args, $instance)
    {
        $title_address = !empty($instance['title_address']) ? $instance['title_address'] : '';
        $text_address = !empty($instance['text_address']) ? $instance['text_address'] : '';
        $embed_address = !empty($instance['embed_address']) ? $instance['embed_address'] : '';

        // before and after widget arguments are defined by themes
        echo $args['before_widget'];
        if (!empty($title_address)) {
            echo $args['before_title'] . esc_html($title_address) . $args['after_title'];
        }

        // This is where you run the code and display the output
        ?>
        <div class="f-w-content">
            <div class="address">
                <div class="text">
                    <p><?php echo esc_html($text_address); ?></p>
                </div>
                <?php echo wp_kses($embed_address, $this->get_allowed_html_tags()); ?>
            </div>
        </div>
        <?php
        echo $args['after_widget'];
    }

    // Widget Settings Form
    public function form($instance)
    {
        $title_address = !empty($instance['title_address']) ? $instance['title_address'] : '';
        $text_address = !empty($instance['text_address']) ? $instance['text_address'] : '';
        $embed_address = !empty($instance['embed_address']) ? $instance['embed_address'] : '';

        // Widget admin form
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title_address'); ?>">
                <?php _e('سرتیتر را وارد کنید:', 'textdomain'); ?>
            </label>
            <input
                    class="widefat" id="<?php echo $this->get_field_id('title_address'); ?>"
                    name="<?php echo $this->get_field_name('title_address'); ?>"
                    type="text"
                    value="<?php echo esc_attr($title_address); ?>"
            />
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('text_address'); ?>">
                <?php _e('آدرس را وارد کنید:', 'textdomain'); ?>
            </label>
            <textarea class="widefat" id="<?php echo $this->get_field_id('text_address'); ?>"
                      name="<?php echo $this->get_field_name('text_address'); ?>"
                      rows="5"><?php echo esc_textarea($text_address); ?></textarea>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('embed_address'); ?>">
                <?php _e('کد embed مپ را وارد کنید:', 'textdomain'); ?>
            </label>
            <textarea
                    class="widefat" id="<?php echo $this->get_field_id('embed_address'); ?>"
                    name="<?php echo $this->get_field_name('embed_address'); ?>"
                    rows="5"><?php echo esc_textarea($embed_address); ?></textarea>
        </p>
        <?php
    }

    // Updating widget replacing old instances with new
    public function update($new_instance, $old_instance)
    {
        $instance = array();
        $instance['title_address'] = (!empty($new_instance['title_address'])) ? strip_tags($new_instance['title_address']) : '';
        $instance['text_address'] = (!empty($new_instance['text_address'])) ? sanitize_textarea_field($new_instance['text_address']) : '';
        $instance['embed_address'] = (!empty($new_instance['embed_address'])) ? wp_kses($new_instance['embed_address'], $this->get_allowed_html_tags()) : '';

        return $instance;
    }

    // Define allowed HTML tags
    private function get_allowed_html_tags()
    {
        return array(
            'iframe' => array(
                'src'             => array(),
                'width'           => array(),
                'height'          => array(),
                'frameborder'     => array(),
                'allowfullscreen' => array(),
                'loading'         => array(),
            ),
            'p' => array(),
            'a' => array(
                'href' => array(),
                'title' => array(),
            ),
            'br' => array(),
            'em' => array(),
            'strong' => array(),
        );
    }
}

// Register and load the widget
function address_footer_widget()
{
    register_widget('address_footer');
}

add_action('widgets_init', 'address_footer_widget');
