<?php

class about_footer extends WP_Widget
{
    function __construct()
    {
        parent::__construct(
            'about_footer',
            __('نمایش اطلاعات فروشگاه در فوتر (اختصاصی قالب اولترا)', 'textdomain'),
            ['description' => __('نمایش نام، توضیحات، ایمیل، تلفن و نمادهای فروشگاه', 'textdomain')]
        );
    }

    public function widget($args, $instance)
    {
        $name_shop_title = $instance['name_shop_title'] ?? '';
        $logo_shop = $instance['logo_shop'] ?? '';
        $desc = $instance['desc'] ?? '';
        $email = $instance['email'] ?? '';
        $tel = $instance['tel'] ?? '';
        $namd1 = $instance['namd1'] ?? '';
        $link_namd1 = $instance['link_namd1'] ?? '';
        $namd2 = $instance['namd2'] ?? '';
        $link_namd2 = $instance['link_namd2'] ?? '';
        $namd3 = $instance['namd3'] ?? '';
        $link_namd3 = $instance['link_namd3'] ?? '';

        echo $args['before_widget'];
        ?>
        <div class="f-w-content">
            <?php if (!empty($logo_shop) || !empty($name_shop_title)): ?>
                <div class="logo">
                    <?php if (!empty($logo_shop)): ?>
                        <img src="<?= esc_url($logo_shop); ?>" alt=""/>
                    <?php endif; ?>
                    <?php if (!empty($name_shop_title)): ?>
                        <span><?= esc_html($name_shop_title); ?></span>
                    <?php endif; ?>
                </div>
            <?php endif; ?>

            <?php if (!empty($desc)): ?>
                <p><?= esc_html($desc); ?></p>
            <?php endif; ?>

            <div class="info">
                <?php if (!empty($email)): ?>
             
                    <span>
						   <svg
                    class="svg-icon"
                    id="Message"
                    width="24"
                    height="24"
                    viewBox="0 0 25 25"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
            >
              <path
                      d="M17.8188 9.58521C17.8188 9.58521 14.6088 13.4382 12.2608 13.4382C9.91385 13.4382 6.66785 9.58521 6.66785 9.58521"
                      stroke="black"
                      stroke-width="1.5"
                      stroke-linecap="round"
                      stroke-linejoin="round"
              />
              <path
                      d="M12.25 21.6517C5.10695 21.6517 2.72595 19.3717 2.72595 12.5347C2.72595 5.69672 5.10695 3.41772 12.25 3.41772C19.393 3.41772 21.774 5.69672 21.774 12.5347C21.774 17.9127 20.301 20.4707 16.197 21.3177"
                      stroke="black"
                      stroke-width="1.5"
                      stroke-linecap="round"
                      stroke-linejoin="round"
              />
            </svg>
                        <a href="mailto:<?= esc_attr($email); ?>"><?= esc_html($email); ?></a>
                    </span>
                <?php endif; ?>

                <?php if (!empty($tel)): ?>
          
                    <span>
						      <svg
                    class="svg-icon"
                    id="Call"
                    width="24"
                    height="24"
                    viewBox="0 0 26 24"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
            >
              <path
                      d="M8.44994 15.7988C1.55294 8.89982 2.53294 5.74082 3.26094 4.72282C3.35394 4.55882 5.65594 1.11182 8.12494 3.13382C14.2509 8.17982 6.49494 7.46582 11.6389 12.6108C16.7849 17.7558 16.0709 9.99982 21.1159 16.1248C23.1379 18.5938 19.6909 20.8968 19.5279 20.9888C18.6369 21.6258 16.1059 22.4568 10.8649 18.0328"
                      stroke="black"
                      stroke-width="1.5"
                      stroke-linecap="round"
                      stroke-linejoin="round"
              />
            </svg>
                        <a href="tel:<?= esc_attr($tel); ?>"><?= esc_html($tel); ?></a>
                    </span>
                <?php endif; ?>
            </div>

            <?php if ($namd1 || $namd2 || $namd3): ?>
                <div class="nemad">
                    <?php if ($namd1): ?>
                        <a href="<?= esc_url($link_namd1); ?>"><img src="<?= esc_url($namd1); ?>" alt=""/></a>
                    <?php endif; ?>
                    <?php if ($namd2): ?>
                        <a href="<?= esc_url($link_namd2); ?>"><img src="<?= esc_url($namd2); ?>" alt=""/></a>
                    <?php endif; ?>
                    <?php if ($namd3): ?>
                        <a href="<?= esc_url($link_namd3); ?>"><img src="<?= esc_url($namd3); ?>" alt=""/></a>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
        <?php
        echo $args['after_widget'];
    }

    public function form($instance)
    {
        $defaults = [
            'name_shop_title' => '',
            'logo_shop' => '',
            'desc' => '',
            'email' => '',
            'tel' => '',
            'namd1' => '',
            'link_namd1' => '',
            'namd2' => '',
            'link_namd2' => '',
            'namd3' => '',
            'link_namd3' => '',
        ];
        $instance = wp_parse_args((array)$instance, $defaults);

        foreach ($defaults as $key => $value) {
            $$key = esc_attr($instance[$key]);
        }

        ?>
        <p>
            <label><?php _e('نام فروشگاه:', 'textdomain'); ?></label>
            <input class="widefat" name="<?= $this->get_field_name('name_shop_title'); ?>" type="text" value="<?= $name_shop_title; ?>"/>
        </p>
        <p>
            <label>تصویر لوگو:</label><br/>
            <img class="custom_media_image" src="<?= $logo_shop; ?>" style="max-width:100%;"/><br/>
            <input type="text" class="widefat custom_media_url" name="<?= $this->get_field_name('logo_shop'); ?>" value="<?= $logo_shop; ?>">
            <input type="button" value="<?php _e('انتخاب تصویر'); ?>" class="button custom_media_upload"/>
        </p>
        <p>
            <label><?php _e('توضیحات:', 'textdomain'); ?></label>
            <textarea class="widefat" name="<?= $this->get_field_name('desc'); ?>" rows="5"><?= $desc; ?></textarea>
        </p>
        <p>
            <label><?php _e('ایمیل:', 'textdomain'); ?></label>
            <input class="widefat" name="<?= $this->get_field_name('email'); ?>" type="text" value="<?= $email; ?>"/>
        </p>
        <p>
            <label><?php _e('تلفن:', 'textdomain'); ?></label>
            <input class="widefat" name="<?= $this->get_field_name('tel'); ?>" type="text" value="<?= $tel; ?>"/>
        </p>
        <hr/>
        <p>
            <label>نماد اول:</label><br/>
            <img class="custom_media_image" src="<?= $namd1; ?>" style="max-width:100%;"/><br/>
            <input class="widefat custom_media_url" name="<?= $this->get_field_name('namd1'); ?>" type="text" value="<?= $namd1; ?>"/>
            <input class="button custom_media_upload" type="button" value="<?php _e('انتخاب تصویر'); ?>"/>
            <input class="widefat" name="<?= $this->get_field_name('link_namd1'); ?>" type="text" placeholder="لینک نماد اول" value="<?= $link_namd1; ?>"/>
        </p>
        <p>
            <label>نماد دوم:</label><br/>
            <img class="custom_media_image" src="<?= $namd2; ?>" style="max-width:100%;"/><br/>
            <input class="widefat custom_media_url" name="<?= $this->get_field_name('namd2'); ?>" type="text" value="<?= $namd2; ?>"/>
            <input class="button custom_media_upload" type="button" value="<?php _e('انتخاب تصویر'); ?>"/>
            <input class="widefat" name="<?= $this->get_field_name('link_namd2'); ?>" type="text" placeholder="لینک نماد دوم" value="<?= $link_namd2; ?>"/>
        </p>
        <p>
            <label>نماد سوم:</label><br/>
            <img class="custom_media_image" src="<?= $namd3; ?>" style="max-width:100%;"/><br/>
            <input class="widefat custom_media_url" name="<?= $this->get_field_name('namd3'); ?>" type="text" value="<?= $namd3; ?>"/>
            <input class="button custom_media_upload" type="button" value="<?php _e('انتخاب تصویر'); ?>"/>
            <input class="widefat" name="<?= $this->get_field_name('link_namd3'); ?>" type="text" placeholder="لینک نماد سوم" value="<?= $link_namd3; ?>"/>
        </p>
        <?php
    }

    public function update($new_instance, $old_instance)
    {
        $fields = ['name_shop_title', 'logo_shop', 'desc', 'email', 'tel', 'namd1', 'link_namd1', 'namd2', 'link_namd2', 'namd3', 'link_namd3'];
        $instance = [];
        foreach ($fields as $field) {
            $instance[$field] = !empty($new_instance[$field]) ? strip_tags($new_instance[$field]) : '';
        }
        return $instance;
    }
}

// ثبت ویجت
function about_footer_widget()
{
    register_widget('about_footer');
}
add_action('widgets_init', 'about_footer_widget');

// لود اسکریپت مدیا برای انتخاب تصویر
function about_footer_Script()
{
    wp_enqueue_media();
    wp_enqueue_script('about_footer', get_template_directory_uri() . '/assets/js/admin.js');
}
add_action('admin_enqueue_scripts', 'about_footer_Script');