<?php
Redux::set_section(
    $opt_name,
    array(
        'title' => 'تنطیمات عمومی',
        'id' => 'option_basic',
        'customizer_width' => '400px',
        'icon' => 'el el-home',
    )
);
/**
 * Public Setting
 */
Redux::set_section(
    $opt_name,
    array(
        'title' => 'همگانی',
        'id' => 'ultra-logo',
        'customizer_width' => '400px',
        'icon' => 'el el-picasa',
        'subsection' => true,
        'fields' => array(
            array(
                'id' => 'ultra-logo-img',
                'type' => 'media',
                'url' => true,
                'title' => 'تصویر لوگو',
                'desc' => 'لوگوی خود را انتخاب کنید.',
                'important' => true,
                'default' => array(
                    'url' => get_template_directory_uri() . '/assets/image/crown.png'
                ),
            ),
            array(
                'id' => 'width-logo-option',
                'type' => 'slider',
                'title' => 'بیشترین پهنای تصویر لوگو (px)',
                'desc' => 'بیشترین عرض برای تصویر لوگو در سربرگ را تنظیم کنید. به پیکسل',
                "default" => 32,
                "min" => 10,
                "step" => 1,
                "max" => 200,
                'display_value' => 'text'
            ),
			
            array(
                'id' => 'width-logo-option-mob',
                'type' => 'slider',
                'title' => 'بیشترین پهنای تصویر لوگو (px) در موبایل',
                'desc' => 'بیشترین عرض برای تصویر لوگو در سربرگ موبایل را تنظیم کنید. به پیکسل',
                "default" => 32,
                "min" => 10,
                "step" => 1,
                "max" => 300,
                'display_value' => 'text'
            ),
			 array(
                'id' => 'width-logo-option-foot',
                'type' => 'slider',
                'title' => 'بیشترین پهنای تصویر لوگو (px) در فوتر',
                'desc' => 'بیشترین عرض برای تصویر لوگو در پاورقی را تنظیم کنید. به پیکسل',
                "default" => 100,
                "min" => 10,
                "step" => 1,
                "max" => 300,
                'display_value' => 'text'
            ),
            array(
                'id' => 'ultra-logo-background',
                'type' => 'switch',
                'title' => 'پس زمینه لوگو',
                'default' => false,
                'on' => 'فعال',
                'off' => 'غیرفعال',
            ),
            array(
                'id' => 'logo-background-color',
                'type' => 'color',
                'title' => esc_html__('انتخاب رنگ'),
                'default' => '#ffe86e',
                'validate' => 'color',
                'required' => array('ultra-logo-background', '=', true),
            ),
            array(
                'id' => 'ultra-logo-check',
                'type' => 'switch',
                'title' => 'متن کنار لوگو',
                'subtitle' => 'اگر تمایل دارید در کنار لوگو متن داشته باشید، فعال کنید.',
                'default' => true,
                'on' => 'فعال',
                'off' => 'غیرفعال',
            ),
            array(
                'id' => 'ultra-logo-name',
                'type' => 'text',
                'title' => 'نام',
                'placeholder' => 'اولترا مارکت',
                'default' => 'اولترا مارکت',
                'required' => array('ultra-logo-check', '=', true),
            ),
            array(
                'id' => 'ultra-favicon',
                'type' => 'media',
                'url' => true,
                'title' => 'تصویر فایوآیکون',
                'desc' => 'آپلود تصویر:png, jpg or gif file',
                'default' => array(
                    'url' => get_template_directory_uri() . '/assets/image/fav.png'
                ),
            ),
            array(
                'id' => 'container-option',
                'type' => 'slider',
                'title' => 'عرض محدوده محتوا - کانتینر (%)',
                'subtitle' => 'عرض محتوا پیشفرض 80% است',
                'desc' => 'اندازه پیشنهادی ما 80% میباشد، اگر قصد دارین کل صفحه در بر گرفته بشه میتونید 100 % در نظر بگیرید',
                "default" => 80,
                "min" => 50,
                "step" => 1,
                "max" => 100,
                'display_value' => 'text'
            ),
        ),
    )
);
//Public Setting

/**
 * Theme Style
 */
Redux::set_section(
    $opt_name,
    array(
        'title' => 'استایل قالب',
        'id' => 'ultra-style',
        'customizer_width' => '400px',
        'icon' => 'el el-brush',
        'subsection' => true,
        'fields' => array(
            array(
                'id' => 'second-color-option',
                'type' => 'color',
                'title' => 'رنگ اصلی قالب',
                'subtitle' => 'رنگ اصلی قالب را انتخاب کنید',
                'default' => '#FF8E6E',
                'validate' => 'color',
                'transparent' => false,
            ),
            array(
                'id' => 'primary-color-option',
                'type' => 'color',
                'title' => 'رنگ مکمل قالب ',
                'subtitle' => 'رنگ ثانویه ( در بخش های مکمل قالب استفاده میشه )',
                'default' => '#FFBB91',
                'validate' => 'color',
                'transparent' => false,
            ),
            array(
                'id' => 'accent-color-option',
                'type' => 'color',
                'title' => 'رنگ اصلی دوم قالب ',
                'subtitle' => 'رنگ اصلی دوم ( که در بخش هایی با درصد کمتری استفاده میشه + هاور + نوشته ها و نام محصولات)',
                'default' => '#515070',
                'validate' => 'color',
                'transparent' => false,
            ),
            array(
                'id' => 'menu-color-option',
                'type' => 'color',
                'title' => 'رنگ منو قالب ',
                'subtitle' => 'رنگ منو قالب را تنظیم کنید. ',
                'default' => '#A8ADBE',
                'validate' => 'color',
                'transparent' => false,
            ),
            array(
                'id' => 'transparent-color-option',
                'type' => 'color',
                'title' => 'رنگ شیشه ای پس زمینه قالب ',
                'subtitle' => 'این رنگ در هاور برخی از المان های سایت نمایش داده می شود. (مانند : منو)',
                'default' => '#FFe3d6',
                'validate' => 'color',
                'transparent' => false,
            ),
            array(
                'id' => 'switch_bg_back_site',
                'type' => 'switch',
                'title' => esc_html__('انتخاب مدل پس زمینه سایت'),
                'subtitle' => esc_html__('Look, it\'s on!', 'your-textdomain-here'),
                'default' => true,
                'on' => 'رنگ گرادینت',
                'off' => 'رنگ ثابت',
            ),
            array(
                'id' => 'bg-body-option',
                'type' => 'color',
                'title' => 'پس زمینه سایت',
                'validate' => 'color',
                'transparent' => false,
                'subtitle' => 'برای بک گراند سایت میتوانید یک رنگ یا تصویر انتخاب کنید - پیشفرض سفید است',
                'default' => '#fff',
                'required' => array('switch_bg_back_site', '=', false),
            ),

            array(
                'id' => 'background-gradient-color-option',
                'type' => 'color',
                'title' => 'رنگ گرادینت پس‌زمینه سایت',
                'subtitle' => 'رنگ پس‌زمینه سایت را انتخاب کنید.',
                'default' => '#FF8E6E', // رنگ پیش‌فرض
                'validate' => 'color',
                'transparent' => false,
                'required' => array('switch_bg_back_site', '=', true),
            ),
            array(
                'id' => 'divider_header_2',
                'type' => 'divide'
            ),
            array(
                'id' => 'color-highlight-text',
                'type' => 'color',
                'title' => 'رنگ متن هایلایت',
                'default' => '#DEDEDE',
                'validate' => 'color',
                'transparent' => false,
            ),
            array(
                'id' => 'color-light-text',
                'type' => 'color',
                'title' => 'رنگ متن روشن',
                'default' => '#bababa',
                'validate' => 'color',
                'transparent' => false,
            ),
            array(
                'id' => 'color-text',
                'type' => 'color',
                'title' => 'رنگ متن',
                'default' => '#303030',
                'validate' => 'color',
                'transparent' => false,
            ),
            array(
                'id' => 'color-white',
                'type' => 'color',
                'title' => 'پس زمینه دوم',
                'subtitle' => 'برای طراحی قالب بصورت تیره میتوانید رنگ دوم رو تغییر دهید، بصورت پیشفرض سفید میباشد.',
                'default' => '#fff',
                'validate' => 'color',
                'transparent' => false,
            ),
            array(
                'id' => 'color-light-white',
                'type' => 'color',
                'title' => 'پس زمینه دوم روشن',
                'subtitle' => 'این قسمت در بخش های مکمل رنگ دوم با تناژ رنگی روشن تر استفاده میشود.',
                'default' => '#f6f6f6',
                'validate' => 'color',
                'transparent' => false,
            ),
            array(
                'id' => 'color-white-text',
                'type' => 'color',
                'title' => 'متن دوم',
                'default' => '#fff',
                'validate' => 'color',
                'transparent' => false,
            ),
        ),
    )
);
//Theme Style

/**
 *  Header Setting
 */
Redux::set_section(
    $opt_name,
    array(
        'title' => esc_html__('هدر (سربرگ)'),
        'id' => 'header-setting',
        'icon' => 'fa-solid fa-heading fa-fw',
        'subsection' => true,
        'fields' => array(
            // انتخاب سربرگ
            array(
                'id' => 'choose_header',
                'type' => 'select',
                'title' => esc_html__('انتخاب سربرگ'),
                'subtitle' => esc_html__('سربرگ مورد نظر خود را انتخاب کنید.'),
                'options' => array(
                    '1' => esc_html__('سربرگ 1'),
                    '2' => esc_html__('سربرگ 2'),
                    '3' => esc_html__('سربرگ 3'),
                    '4' => esc_html__('سربرگ 4'),
                ),
                'default' => '1',
            ),

            // تنظیمات سربرگ 1
            array(
                'id' => 'on_off_up_menu_header1',
                'type' => 'switch',
                'title' => esc_html__('نوار بالا'),
                'subtitle' => esc_html__('نمایش یا عدم نمایش نوار بالای سربرگ'),
                'default' => true,
                'on' => esc_html__('نمایش'),
                'off' => esc_html__('مخفی'),
                'required' => array('choose_header', '=', '1'), // فقط برای سربرگ 1
            ),
            array(
                'id' => 'top_menu_right_header1',
                'type' => 'editor',
                'title' => esc_html__('متن دلخواه سمت راست'),
                'default' => esc_html__('اگر سوال یا مشکلی دارید با پشتیبانی تماس بگیرید.'),
                'args' => array(
                    'teeny' => true,
                    'textarea_rows' => 10,
                ),
                'required' => array('on_off_up_menu_header1', '=', true), // فقط وقتی نوار بالا نمایش داده شده باشد
            ),
            array(
                'id' => 'bullet_switch',
                'type' => 'switch',
                'title' => esc_html__('نمایش بولت'),
                'default' => true,
                'on' => esc_html__('نمایش'),
                'off' => esc_html__('مخفی'),
                'required' => array('on_off_up_menu_header1', '=', true),
            ),
            array(
                'id' => 'top_menu_left_header1',
                'type' => 'editor',
                'title' => esc_html__('متن دلخواه سمت چپ'),
                'default' => 'اگر سوال یا مشکلی دارید با پشتیبانی تماس بگیرید یا روی <a href="https://weblabs.ir/" target="_blank" rel="noopener">این کلینک کلیک کنید</a>.',
                'args' => array(
                    'teeny' => true,
                    'textarea_rows' => 10
                ),
                'required' => array('on_off_up_menu_header1', '=', true),
            ),
            array(
                'id' => 'text_tel_header',
                'type' => 'text',
                'title' => 'متن مورد نظر خود را وارد کنید',
                'placeholder' => 'پاسخگویی از 12 تا 18',
                'required' => array('choose_header', '=', '1'),
            ),
            array(
                'id' => 'number_tel_header',
                'type' => 'text',
                'title' => 'شماره تماس خود را وارد کنید.',
                'placeholder' => '09120000000',
                'required' => array('choose_header', '=', '1'),
            ),
            array(
                'id' => 'active_wishlist_header',
                'type' => 'switch',
                'title' => esc_html__('نمایش دکمه علاقه‌مندی‌ها'),
                'default' => true,
                'on' => esc_html__('نمایش'),
                'off' => esc_html__('مخفی'),
                'required' => array('on_off_up_menu_header1', '=', true),
            ),
            array(
                'id' => 'active_mega_menu_header',
                'type' => 'switch',
                'title' => 'نمایش مگامنو',
                'default' => true,
                'on' => 'نمایش',
                'off' => 'مخفی',
                'required' => array('choose_header', '=', '1'),
            ),
            array(
                'id' => 'title_mega_menu_header',
                'type' => 'text',
                'title' => 'عنوان مگامنو',
                'default' => 'دسته بندی محصول',
                'placeholder' => 'دسته بندی محصول',
                'required' => array('active_mega_menu_header', '=', true),
            ),
            array(
                'id' => 'choose_icon_mega_menu_header',
                'type' => 'switch',
                'title' => 'آیکون مگامنو',
                'default' => false,
                'on' => 'دلخواه',
                'off' => 'پیش فرض',
                'required' => array('active_mega_menu_header', '=', true),
            ),
            array(
                'id' => 'icon_select_mega_menu',
                'type' => 'icon_select',
                'title' => 'انتخاب آیکون مگامنو',
                'subtitle' => 'آیکون دلخواه خود را که قبل از نوشته نمایش داده میشود را انتخاب کنید.',
                'default' => 'fas fa-bars',
                'required' => array('choose_icon_mega_menu_header', '=', true),
            ),
            // تنظیمات سربرگ 2
            array(
                'id' => 'on_off_up_menu_header_two',
                'type' => 'switch',
                'title' => esc_html__('نوار بالا'),
                'subtitle' => esc_html__('نمایش یا عدم نمایش نوار بالای سربرگ'),
                'default' => true,
                'on' => esc_html__('نمایش'),
                'off' => esc_html__('مخفی'),
                'required' => array('choose_header', '=', '2'), // فقط برای سربرگ 2
            ),
            array(
                'id' => 'top_menu_right_header2',
                'type' => 'text',
                'title' => esc_html__('شماره تماس'),
                'default' => '0912000000',
                'required' => array('on_off_up_menu_header_two', '=', true), // فقط وقتی نوار بالا نمایش داده شده باشد
            ),
            array(
                'id' => 'contact_telegram_header2',
                'type' => 'text',
                'title' => esc_html__('آیدی تلگرام'),
                'required' => array('on_off_up_menu_header_two', '=', true),
            ),
            array(
                'id' => 'contact_whatsup_header2',
                'type' => 'text',
                'title' => esc_html__('شماره واتساپ'),
                'subtitle' => esc_html__('شماره را در فرمت بین‌المللی وارد کنید (مثال: 989101234567)'),
                'required' => array('on_off_up_menu_header_two', '=', true),
            ),
            array(
                'id' => 'choose_mega_menu',
                'type' => 'switch',
                'title' => 'مگا منو / فهرست اصلی',
                'subtitle' => 'میخاهید مگا منو نمایش داده شود یا فهرست؟',
                'default' => true,
                'on' => 'مگامنو',
                'off' => 'فهرست',
                'required' => array('choose_header', '=', '2'),
            ),

            array(
                'id' => 'active_cart_header',
                'type' => 'switch',
                'title' => esc_html__('نمایش دکمه سبد خرید'),
                'default' => true,
                'on' => esc_html__('نمایش'),
                'off' => esc_html__('مخفی'),
            ),
            array(
                'id' => 'active_main_menu_header',
                'type' => 'switch',
                'title' => 'نمایش منو اصلی سایت',
                'default' => true,
                'on' => 'نمایش',
                'off' => 'مخفی',
                'required' => array('choose_header', '=', array('1', '3')),
            ),
            array(
                'id' => 'header_sticky',
                'type' => 'switch',
                'title' => esc_html__('هدر چسبان (Sticky)'),
                'subtitle' => esc_html__('بعد از اسکرول کردن هدر در بالای صفحه مرورگر کاربر نمایش داده میشود.'),
                'default' => true,
                'on' => esc_html__('هدر چسبان فعال'),
                'off' => esc_html__('هدر چسبان غیر فعال'),
            ),
            array(
                'id' => 'tel_header4',
                'type' => 'text',
                'title' => esc_html__('شماره تماس'),
                'subtitle' => esc_html__('شماره تماس خود را وارد کنید.'),
                'required' => array('choose_header', '=', '4'),
            ),
            array(
                'id' => 'text_tel_header4',
                'type' => 'text',
                'title' => esc_html__('متن دلخواه خود را وارد کنید:'),
                'subtitle' => esc_html__('این متن زیر شماره تماس نمایش داده میشود. به عنوان مثال: پشتیبانی ۲۴/۷'),
                'required' => array('choose_header', '=', '4'),
            ),
        ),
    )
);
// End Header Setting


/**
 * Footer Setting
 */
Redux::set_section(
    $opt_name,
    array(
        'title' => 'فوتر (پاورقی)',
        'id' => 'footer_options',
        'customizer_width' => '400px',
        'icon' => 'fa-solid fa-shoe-prints',
        'subsection' => true,
        'fields' => array(
            array(
                'id' => 'ultra-logo-background-footer',
                'type' => 'switch',
                'title' => 'پس زمینه لوگو',
                'default' => false,
                'on' => 'فعال',
                'off' => 'غیرفعال',
            ),
            array(
                'id' => 'logo-background-color-footer',
                'type' => 'color',
                'title' => esc_html__('انتخاب رنگ'),
                'default' => '#ffe86e',
                'validate' => 'color',
                'required' => array('ultra-logo-background-footer', '=', true),
            ),
            array(
                'id' => 'display_copyright',
                'type' => 'switch',
                'title' => esc_html__('نمایش متن کپی رایت'),
                'default' => true, // به صورت پیش‌فرض فعال باشد
                'on' => 'فعال',
                'off' => 'غیرفعال',
            ),
            array(
                'id' => 'copyright_text',
                'type' => 'editor',
                'title' => esc_html__('متن کپی رایت'),
                'default' => '<span>تمامی حقوق برای اولترا مارکت محفوظ میباشد | طراحی و پیاده سازی توسط <a href="https://weblabs.ir" target="_blank">وبلبز</a></span>',
                'args' => array(
                    'wpautop' => true,
                    'media_buttons' => false,
                    'textarea_rows' => 5,
                    'teeny' => true,
                ),
                'required' => array('display_copyright', '=', true),
            ),
        ),
    )
);
// end Footer


/**
 * Message
 */
Redux::set_section(
    $opt_name,
    array(
        'title' => 'پیغام',
        'id' => 'ultra-message',
        'customizer_width' => '400px',
        'icon' => 'fa-regular fa-message fa-fw',
        'subsection' => true,
        'fields' => array(
            array(
                'id' => 'active_message_header',
                'type' => 'switch',
                'title' => 'نمایش پیغام در بالای سربرگ',
                'subtitle' => 'این پیغام در بالای سربرگ (Header) نمایش داده می شود.',
                'default' => false,
                'on' => 'نمایش',
                'off' => 'مخفی',
            ),
            array(
                'id' => 'text_custom_message_header',
                'type' => 'text',
                'title' => 'پیغام دلخواه خود را وارد کنید',
                'placeholder' => 'ارسال رایگان برای سفارش اول',
                'required' => array('active_message_header', '=', true),
            ),
            array(
                'id' => 'text_custom_btn_message_header',
                'type' => 'text',
                'title' => 'نام دکمه را وارد کنید',
                'placeholder' => 'مشاهده',
                'required' => array('active_message_header', '=', true),
            ),
            array(
                'id' => 'link_custom_message_header',
                'type' => 'text',
                'title' => 'لینک صفحه مورد نظر خود را وارد کنید',
                'placeholder' => 'https://yoursite.com/.....',
                'required' => array('active_message_header', '=', true),
            ),
            array(
                'id' => 'background_message_header',
                'type' => 'background',
                'title' => 'پس‌زمینه پیغام',
                'subtitle' => 'پس‌زمینه‌ای برای پیغام انتخاب کنید. می‌توانید از رنگ، تصویر یا گیف استفاده کنید.',
                'output' => array('.top-head-cus'), // خروجی استایل در CSS
                'required' => array('active_message_header', '=', true),
                'default' => array(
                    'background-color' => '#f4f4f4',
                    'background-image' => '',
                    'background-repeat' => 'no-repeat',
                    'background-size' => 'cover',
                    'background-attachment' => 'scroll',
                    'background-position' => 'center center',
                ),
            ),
        ),
    )
);
// End Message


/**
 * typography
 */
Redux::set_section(
    $opt_name,
    array(
        'title' => 'تایپوگرافی',
        'id' => 'typography_options',
        //'desc'             => esc_html__( 'These are really basic fields!', 'your-textdomain-here' ),
        'customizer_width' => '400px',
        'icon' => 'el el-font',
        'fields' => array(
            array(
                'id' => 'font_body',
                'type' => 'typography',
                'title' => 'فونت بدنه سایت',
                'subtitle' => 'ترجیحا تغییر ندید چون الان در بهترین حالته',
                'description' => 'فونت های گوگل برای سرعت بهتر قالب حذف شده است.',
                'output' => array('body'),
                'units' => 'px',
                'subsets' => false,
                'google' => false,
                'default' => array(
                    'color' => '#303030',
                    'font-style' => 'normal',
                    'font-weight' => '400',
                    'font-family' => 'YekanBakh',
                    'google' => false,
                    'font-backup' => "'MS Sans Serif', Geneva, sans-serif",
                    'font-size' => '14px',
                    'line-height' => 'normal'
                ),
            ),
            array(
                'id' => 'active_custom_font_size',
                'type' => 'switch',
                'title' => 'اندازه دلخواه فونت ها',
                'subtitle' => 'در صورتی که تمایل دارید اندازه سرتیترها، فهرست و مگامنو را تعیین کنید فعال کنید.',
                'default' => true,
                'on' => 'فعال',
                'off' => 'غیرفعال',
            ),
            array(
                'id' => 'custom_font_size_megaMenu',
                'type' => 'typography',
                'title' => 'انتخاب و اندازه فونت مگامنو ',
                'output' => array('.main-header .middle-header .menu-side .ultra-megamenu'),
                'units' => 'px',
                'subsets' => false,
                'text-align' => false,
                'google' => false,
                'default' => array(
                    'color' => '#303030',
                    'font-style' => 'normal',
                    'font-weight' => '300',
                    'font-family' => 'YekanBakh',
                    //'google'      => true,
                    'font-backup' => "'MS Sans Serif', Geneva, sans-serif",
                    'font-size' => '14px',
                    'line-height' => 'normal'
                ),
                'required' => array('active_custom_font_size', '=', true),
            ),
            array(
                'id' => 'custom_font_size_menu',
                'type' => 'typography',
                'title' => 'انتخاب و اندازه فونت منو ',
                'output' => array('.main-header .middle-header .menu-side .main-menu, .main-header .middle-header .menu-side .main-menu ul li a span,.main-header .middle-header .menu-side .main-menu ul li a'),
                'units' => 'px',
                'subsets' => false,
                'text-align' => false,
                'google' => false,
                'default' => array(
                    'color' => '#A8ADBE',
                    'font-style' => 'normal',
                    'font-family' => 'YekanBakh',
                    //'google'      => true,
                    'font-backup' => "'MS Sans Serif', Geneva, sans-serif",
                    'font-size' => '12px',
                    'line-height' => 'normal'
                ),
                'required' => array('active_custom_font_size', '=', true),
            ),
        ),
    )
);
// end typography


/**
 * Blog Setting
 */
Redux::set_section(
    $opt_name,
    array(
        'title' => 'نوشته ها',
        'id' => 'blog_options',
        'customizer_width' => '400px',
        'icon' => 'el el-pencil',
        'fields' => array(
            array(
                'id' => 'sidebar_position_single',
                'type' => 'image_select',
                'title' => esc_html__('موقعیت سایدبار صفحه نوشته ها', 'ultraMarket'),
                'subtitle' => esc_html__('میتوانید سایدبار را سمت چپ/راست قرار دهید یا مخفی کنید', 'ultraMarket'),
                'default' => 'right',
                'options' => array(
                    'none' => array(
                        'alt' => esc_html__('بدون سایدبار', 'ultraMarket'),
                        'img' => ReduxFramework::$_url . 'assets/img/1col.png'
                    ),
                    'left' => array(
                        'alt' => esc_html__('سایدبار سمت چپ', 'ultraMarket'),
                        'img' => ReduxFramework::$_url . 'assets/img/2cl.png'
                    ),
                    'right' => array(
                        'alt' => esc_html__('سایدبار سمت راست', 'ultraMarket'),
                        'img' => ReduxFramework::$_url . 'assets/img/2cr.png'
                    ),

                )
            ),
            array(
                'id' => 'active_author_box_post',
                'type' => 'switch',
                'title' => 'نمایش باکس نویسنده',
                'default' => true,
                'on' => 'نمایش',
                'off' => 'مخفی',
            ),
            array(
                'id' => 'active_related_post',
                'type' => 'switch',
                'title' => 'نمایش مطالب مرتبط',
                'default' => true,
                'on' => 'نمایش',
                'off' => 'مخفی',
            ),
            array(
                'id' => 'related_post_custom_expert',
                'type' => 'slider',
                'title' => 'تعداد کلمات خلاصه مقالات مرتبط ',
                'subtitle' => 'تعداد محتوای خلاصه پیشفرض 20 است',
                "default" => 20,
                "min" => 10,
                "step" => 1,
                "max" => 100,
                'display_value' => 'text'
            ),
            array(
                'id' => 'select_template_blog',
                'type' => 'select',
                'title' => 'انتخاب طرح نمایش مقالات',
                'subtitle' => 'انتخاب کنید کدام طرح برای مقالات می خواهید نمایش داده شود',

                'options' => array(
                    'one_blog' => 'طرح ستونی',
                    'two_blog' => 'طرح پله ای',
                    'three_blog' => 'طرح کاشی',
                ),
                'default' => 'one_blog',
            ),
        ),
    )
);
Redux::setSection($opt_name, array(
    'title' => 'راهنمای استفاده از شورت‌کد بیشتر بخوانید',
    'id' => 'more_read_shortcode_section',
    'desc' => 'در این بخش، نحوه استفاده از شورت‌کد برای لینک‌دهی به مطالب دیگر توضیح داده شده است.',
    'subsection' => true,
    'icon' => 'el el-info-circle',
    'fields' => array(
        array(
            'id' => 'more_read_shortcode_info',
            'type' => 'info',
            'style' => 'info', // نوع استایل: می‌تواند 'info', 'success', 'warning', 'critical' باشد.
            'title' => 'نحوه استفاده از شورت‌کد بیشتر بخوانید',
            'desc' => '
                اگر قصد دارید در میان محتوای وبلاگ خود، وبلاگ دیگری را به کاربران معرفی کنید، می‌توانید از شورت‌کد زیر استفاده کنید:
                <pre>[more_read id="123"]</pre>
                <strong>id</strong>: شناسه (ID) نوشته‌ای است که می‌خواهید به آن لینک دهید. این شناسه به صورت خودکار عنوان و لینک نوشته مقصد را نمایش می‌دهد.
                <br><br>
                <strong>چگونه شناسه (ID) نوشته را پیدا کنیم؟</strong>
                <ol>
                    <li>به صفحه <strong>نوشته‌ها</strong> در پیشخوان وردپرس بروید.</li>
                    <li>نوشته موردنظر خود را پیدا کنید.</li>
                    <li>ماوس را روی عنوان نوشته نگه دارید؛ در پایین مرورگر، لینکی مشابه زیر نمایش داده می‌شود: <br>
                        <code>https://yourwebsite.com/wp-admin/post.php?post=123&action=edit</code></li>
                </ol>
                <br>
                <strong>نمونه استفاده:</strong><br>
                فرض کنید می‌خواهید به نوشته‌ای با شناسه 123 لینک دهید. کافی است شورت‌کد زیر را در محتوای خود قرار دهید:
                <pre>[more_read id="123"]</pre>
                <br>
                خروجی این شورت‌کد به صورت خودکار عنوان نوشته مقصد را دریافت کرده و به کاربران نمایش می‌دهد، مانند:<br>
                <em>بیشتر بخوانید: چرا وردپرس بهترین است؟</em>
                <br><br>
                <strong>مزایای این روش:</strong>
                <ul>
                    <li>لینک‌دهی پویا به محتوای مرتبط بدون نیاز به نوشتن دستی عنوان</li>
                    <li>مدیریت آسان لینک‌ها و محتوا</li>
                    <li>تجربه کاربری بهتر برای بازدیدکنندگان سایت</li>
                </ul>
                <br>
                <strong>توجه:</strong> این قابلیت به‌طور پیش‌فرض در قالب شما فعال است و نیازی به تنظیمات اضافی ندارد. فقط کافی است شورت‌کد را در محتوای نوشته یا صفحه‌ای که می‌خواهید استفاده کنید، قرار دهید.
            ',
        ),
    ),
));

// end blog

/**
 * Instagram Setting
 */
Redux::set_section(
    $opt_name,
    array(
        'title' => 'اینستاگرام',
        'id' => 'insta_options',
        'customizer_width' => '400px',
        'icon' => 'dashicons dashicons-instagram',
        'fields' => array(
            array(
                'id' => 'active_related_post_insta',
                'type' => 'switch',
                'title' => 'نمایش مطالب مرتبط',
                'default' => true,
                'on' => 'نمایش',
                'off' => 'مخفی',
            ),
        ),
    )
);
// end insta

/**
 * Tv Setting
 */
Redux::set_section(
    $opt_name,
    array(
        'title' => 'تلویزیون',
        'id' => 'tv_options',
        'customizer_width' => '400px',
        'icon' => 'dashicons dashicons-video-alt',
        'fields' => array(
            array(
                'id' => 'sidebar_position_tv',
                'type' => 'image_select',
                'title' => esc_html__('موقعیت سایدبار در صفحه تلویزیون', 'ultraMarket'),
                'subtitle' => esc_html__('میتوانید سایدبار را سمت چپ/راست قرار دهید', 'ultraMarket'),
                'default' => 'right',
                'options' => array(
                    'left' => array(
                        'alt' => esc_html__('سایدبار سمت چپ', 'ultraMarket'),
                        'img' => ReduxFramework::$_url . 'assets/img/2cl.png'
                    ),
                    'right' => array(
                        'alt' => esc_html__('سایدبار سمت راست', 'ultraMarket'),
                        'img' => ReduxFramework::$_url . 'assets/img/2cr.png'
                    ),

                )
            ),
            array(
                'id' => 'active_author_box_tv',
                'type' => 'switch',
                'title' => 'نمایش باکس نویسنده و اشتراک گذاری',
                'default' => true,
                'on' => 'نمایش',
                'off' => 'مخفی',
            ),
            array(
                'id' => 'active_related_post_tv',
                'type' => 'switch',
                'title' => 'نمایش مطالب مرتبط',
                'default' => true,
                'on' => 'نمایش',
                'off' => 'مخفی',
            ),
        ),
    )
);
// end tv
/**
 * Woocommerce Setting
 */
Redux::set_section(
    $opt_name,
    array(
        'title' => 'تنطیمات ووکامرس',
        'id' => 'option_woocommerce',
        'customizer_width' => '400px',
        //'icon' => 'fa-solid fa-store fa-fw',
        'icon' => 'fa-solid fa-store fa-fw',
    )
);
// Woocommerce Setting

/**
 * Choose Product
 */
Redux::set_section(
    $opt_name,
    array(
        'title' => 'انتخاب طرح نمایش محصولات',
        'id' => 'ultra-product-custom-template',
        'customizer_width' => '400px',
        'icon' => 'dashicons-before dashicons-archive',
        'subsection' => true,
        'fields' => array(
            array(
                'id' => 'select_template_product',
                'type' => 'select',
                'title' => 'انتخاب طرح نمایش محصول',
                'subtitle' => 'انتخاب کنید کدام طرح برای محصولات می خواهید نمایش داده شود',
                'options' => array(
                    'standard_layout' => 'طرح استاندارد',
                    'grid_fixed_button' => 'شبکه‌ای با دکمه ثابت',        
                    'classic_grid' => 'شبکه‌ای کلاسیک',
                    'hover_effect_grid' => 'شبکه‌ای با افکت هاور',
                    'expandable_tile' => 'کاشی بازشو',
                    'hover_grid' => 'شبکه ای با هاور',
                ),
                'default' => 'standard_layout',
            ),
            array(
                'id' => 'select_template_product_cross_sell',
                'type' => 'select',
                'title' => 'انتخاب طرح نمایش محصولات پیشنهاد برای خرید (cross sell)',
                'subtitle' => 'انتخاب کنید کدام طرح برای محصولات می خواهید نمایش داده شود',
                'options' => array(
                    'standard_layout' => 'طرح استاندارد',
                    'grid_fixed_button' => 'شبکه‌ای با دکمه ثابت',
                    'classic_grid' => 'شبکه‌ای کلاسیک',
                    'hover_effect_grid' => 'شبکه‌ای با افکت هاور',
                ),
                'default' => 'standard_layout',
            ),
            array(
                'id' => 'select_template_product_related',
                'type' => 'select',
                'title' => 'انتخاب طرح نمایش محصولات مرتبط و تشویق برای خرید (Up Sells)',
                'subtitle' => 'انتخاب کنید کدام طرح برای محصولات می خواهید نمایش داده شود',
                'options' => array(
                    'standard_layout' => 'طرح استاندارد',
                    'grid_fixed_button' => 'شبکه‌ای با دکمه ثابت',
                    'classic_grid' => 'شبکه‌ای کلاسیک',
                    'hover_effect_grid' => 'شبکه‌ای با افکت هاور',
                ),
                'default' => 'standard_layout',
            ),

            array(
                'id' => 'text_modal_add_to_cart',
                'type' => 'text',
                'title' => 'عنوان مدال (Modal)',
                'subtitle' => 'این عنوان به محض اضافه شدن به سبد خرید به کاربر نمایش داده می شود.',
                'description' => '',
                'default' => 'محصول به سبد خرید اضافه شد',
            ),
            array(
                'id' => 'icon_select_add_to_cart',
                'type' => 'icon_select',
                'title' => 'انتخاب آیکون ',
                'subtitle' => 'آیکون دلخواه خود را که قبل از نوشته نمایش داده میشود را انتخاب کنید.',
                'default' => 'fa-solid fa-check',
            ),
        ),
    )
);

//choose Product

/**
 * Shop Setting
 */
Redux::set_section(
    $opt_name,
    array(
        'title' => 'برگه فروشگاه',
        'id' => 'ultra_Shop_options',
        'customizer_width' => '400px',
        'icon' => 'fa-solid fa-shop fa-fw',
        'subsection' => true,
        'fields' => array(
            array(
                'id' => 'sidebar_position_shop',
                'type' => 'image_select',
                'title' => esc_html__('موقعیت سایدبار در صفحه فروشگاه', 'ultraMarket'),
                'subtitle' => esc_html__('میتوانید سایدبار را سمت چپ/راست قرار دهید', 'ultraMarket'),
                'default' => 'right',
                'options' => array(
                    'none' => array(
                        'alt' => esc_html__('بدون سایدبار', 'ultraMarket'),
                        'img' => ReduxFramework::$_url . 'assets/img/1col.png'
                    ),
                    'left' => array(
                        'alt' => esc_html__('سایدبار سمت چپ', 'ultraMarket'),
                        'img' => ReduxFramework::$_url . 'assets/img/2cl.png'
                    ),
                    'right' => array(
                        'alt' => esc_html__('سایدبار سمت راست', 'ultraMarket'),
                        'img' => ReduxFramework::$_url . 'assets/img/2cr.png'
                    ),

                )
            ),
            array(
                'id' => 'products_per_page_for_shop',
                'type' => 'spinner',
                'title' => __('تعداد نمایش محصولات در هر صفحه'),
                'default' => 12,
                'min' => 1,
                'step' => 1,
                'max' => 30,
            ),
            array(
                'id' => 'ultra_enable_canonical',
                'type' => 'switch',
                'title' => 'فعال کردن کنونیکال',
                'subtitle' => 'فعال کردن تگ کنونیکال صفحه بندی دو به بعد روی صفحه اول',
                'description' => 'در صورتی که افزونه سئو نداشته باشید کار میکند.',
                'default' => true,
                'on' => 'فعال',
                'off' => 'غیرفعال',
            ),
            array(
                'id' => 'category_shop_setting',
                'type' => 'switch',
                'title' => 'نمایش دسته بندی برگه فروشگاه و دسته بندی',
                'subtitle' => 'آیا می‌خواهید دسته‌ها نمایش داده شوند؟',
                'default' => true, // مقدار پیش‌فرض
                'on' => 'نمایش',
                'off' => 'عدم نمایش',
            ),
            array(
                'id' => 'hide_empty_setting',
                'type' => 'switch',
                'title' => 'نمایش دسته‌های خالی',
                'subtitle' => 'آیا می‌خواهید دسته‌های خالی نمایش داده شوند؟',
                'default' => true, // مقدار پیش‌فرض
                'on' => 'نمایش',
                'off' => 'عدم نمایش',
                'required' => array('category_shop_setting', '=', true),
            ),
            array(
                'title' => 'انتقال محصولات ناموجود به انتها',
                'id' => 'move_out_of_stock_to_end',
                'type' => 'switch',
                'on' => 'فعال',
                'off' => 'غیرفعال',
                'default' => false,
                'subtitle' => 'با فعال کردن این گزینه، محصولات ناموجود در صفحات فروشگاه به انتهای لیست منتقل می‌شوند.',
            ),
        ),
    )
);
// end Shop


/**
 * Single Product
 */
Redux::set_section(
    $opt_name,
    array(
        'title' => 'صفحه محصول',
        'id' => 'ultra-product-custom',
        'customizer_width' => '400px',
        'icon' => 'el el-photo',
        'subsection' => true,
        'fields' => array(
            array(
                'id' => 'ultra-share-product-check',
                'type' => 'switch',
                'title' => 'نمایش اشتراک گذاری محصول',
                'subtitle' => 'اگر تمایل دارید آیکون اشتراک گذاری محصول در شبکه های اجتماعی نمایش داده شود، فعال کنید.',
                'default' => true,
                'on' => 'فعال',
                'off' => 'غیرفعال',
            ),
            array(
                'id' => 'ultra-short-description-product-check',
                'type' => 'switch',
                'title' => 'نمایش توضیحات کوتاه محصول',
                'subtitle' => 'اگر تمایل دارید توضیحات کوتاه محصول در کنار عکس محصول نمایش داده شود، فعال کنید.',
                'default' => true,
                'on' => 'فعال',
                'off' => 'غیرفعال',
            ),
            array(
                'id' => 'ultra-additional-info-product-check',
                'type' => 'switch',
                'title' => 'نمایش ویژگی‌های محصول',
                'subtitle' => 'اگر تمایل دارید توضیحات تکمیلی محصول (کادر های رنگی) در کنار عکس محصول نمایش داده شود، فعال کنید.',
                'default' => true,
                'on' => 'فعال',
                'off' => 'غیرفعال',
            ),
            array(
                'id' => 'bg-additional-info-product',
                'type' => 'color',
                'title' => 'رنگ زمینه ویژگی‌های محصول ',
                'default' => '#F3F3F3',
                'validate' => 'color',
                'transparent' => false,
                'required' => array('ultra-additional-info-product-check', '=', true),
            ),
            array(
                'id' => 'border-additional-info-product',
                'type' => 'border',
                'title' => 'رنگ border(خط کادر) ویژگی‌های محصول ',
                'required' => array('ultra-additional-info-product-check', '=', true),
                'default' => array(
                    'border-color' => '#EBEAEA',
                    'border-style' => 'solid',
                    'border-top' => '1px',
                    'border-right' => '1px',
                    'border-bottom' => '1px',
                    'border-left' => '1px'
                )
            ),
            array(
                'id' => 'divider_product',
                'desc' => esc_html__('امکان شخصی سازی صفحه داخلی محصول', 'your-textdomain-here'),
                'type' => 'divide'
            ),
            array(
                'id'       => 'ultra-single-product-layout',
                'type'     => 'select',
                'title'    => 'انتخاب نوع چیدمان صفحه محصول',
                'subtitle' => 'مدل نمایش صفحه محصول را انتخاب کنید. در مدل دوم، بخش خرید بالای توضیحات کوتاه و بدون سایدبار نمایش داده می‌شود.',
                'options'  => array(
                    'default_layout'     => 'مدل کلاسیک (با سایدبار سمت چپ)',
                    'full_width_top_buy' => 'مدل فشرده (بدون سایدبار + خرید بالا)',
                ),
                'default'  => 'default_layout',
            ),
        ),
    )
);
//Single Product

/**
 * Description Ideal
 */
Redux::set_section(
    $opt_name,
    array(
        'title' => 'توضیحات دلخواه',
        'id' => 'ultra-desc-ideal',
        'customizer_width' => '400px',
        'icon' => 'dashicons dashicons-welcome-write-blog',
        'subsection' => true,
        'fields' => array(
            array(
                'id' => 'icon_select_1_product',
                'type' => 'icon_select',
                'title' => 'انتخاب آیکون اول',
                'subtitle' => 'آیکون دلخواه خود را که قبل از نوشته نمایش داده میشود را انتخاب کنید.',
            ),
            array(
                'id' => 'name_icon_select_1_product',
                'type' => 'text',
                'title' => 'نام نمایش در کنار آیکون اول',
                'placeholder' => 'تضمین اصالت کالا',
                'default' => 'تضمین اصالت کالا',
            ),
            array(
                'id' => 'icon_select_2_product',
                'type' => 'icon_select',
                //'required' => array('switch-fold','equals','0'),
                'title' => 'انتخاب آیکون دوم',
                'subtitle' => 'آیکون دلخواه خود را که قبل از نوشته نمایش داده میشود را انتخاب کنید.',
                //'default' 	=> '',
                //'options' => array(), // key/value pair, value is the title
                //'enqueue' => false, // Disable auto-enqueue of stylesheet if present in the panel
                //'enqueue_frontend' => false, // Disable auto-enqueue of stylesheet on the front-end
                //'stylesheet' => 'http://netdna.bootstrapcdn.com/font-awesome/4.0.3/css/font-awesome.css', // full path OR url to stylesheet
                //'prefix' => 'fa', // If needed to initialize the icon
                //'selector' => 'fa-', // How each icons begins for this given font
                //'height' => 300 // Change the height of the container. defaults to 300px;
            ),
            array(
                'id' => 'name_icon_select_2_product',
                'type' => 'text',
                'title' => 'نام نمایش در کنار آیکون دوم',
                'placeholder' => 'تحویل در کمترین زمان ممکن',
                'default' => 'تحویل در کمترین زمان ممکن',
            ),
            array(
                'id' => 'icon_select_3_product',
                'type' => 'icon_select',
                //'required' => array('switch-fold','equals','0'),
                'title' => 'انتخاب آیکون سوم',
                'subtitle' => 'آیکون دلخواه خود را که قبل از نوشته نمایش داده میشود را انتخاب کنید.',
                //'default' 	=> '',
                //'options' => array(), // key/value pair, value is the title
                //'enqueue' => false, // Disable auto-enqueue of stylesheet if present in the panel
                //'enqueue_frontend' => false, // Disable auto-enqueue of stylesheet on the front-end
                //'stylesheet' => 'http://netdna.bootstrapcdn.com/font-awesome/4.0.3/css/font-awesome.css', // full path OR url to stylesheet
                //'prefix' => 'fa', // If needed to initialize the icon
                //'selector' => 'fa-', // How each icons begins for this given font
                //'height' => 300 // Change the height of the container. defaults to 300px;
            ),
            array(
                'id' => 'name_icon_select_3_product',
                'type' => 'text',
                'title' => 'نام نمایش در کنار آیکون سوم',
                'placeholder' => 'تضمین بهترین قیمت بازار',
                'default' => 'تضمین بهترین قیمت بازار',
            ),
            array(
                'id' => 'divider_1',
                'desc' => 'تنظیمات زیر برای تنظیمات تاریخ انقضا محصول / نمایش یا عدم نمایش و جایگذاری است',
                'type' => 'divide'
            ),
            array(
                'id' => 'ultra-Exp-check',
                'type' => 'switch',
                'title' => 'فعال سازی تاریخ انقضا محصولات',
                'subtitle' => 'اگر خاموش کنید می‌توانید به جای نمایش تاریخ انقضای محصول متن دلخواه را وارد کنید.',
                'default' => true,
                'on' => 'فعال',
                'off' => 'غیرفعال',
            ),
            array(
                'id' => 'ultra-exp-default',
                'type' => 'text',
                'title' => 'نمایش متن کلی برای تاریخ انقضا محصولات',
                'placeholder' => 'بیشتر از یکسال',
                'default' => 'بیشتر از یکسال',
                'desc' => 'اگر برای هر محصول تاریخ انقضا را وارد کرده باشید اولویت با تاریخ وارد شده در ویرایش محصول شده است.',
                'required' => array('ultra-Exp-check', '=', true),
            ),
            array(
                'id' => 'icon_select_4_product',
                'type' => 'icon_select',
                //'required' => array('switch-fold','equals','0'),
                'title' => 'انتخاب آیکون چهارم',
                'subtitle' => 'آیکون دلخواه خود را که قبل از نوشته نمایش داده میشود را انتخاب کنید.',
                'required' => array('ultra-Exp-check', '=', false),
                //'default' 	=> '',
                //'options' => array(), // key/value pair, value is the title
                //'enqueue' => false, // Disable auto-enqueue of stylesheet if present in the panel
                //'enqueue_frontend' => false, // Disable auto-enqueue of stylesheet on the front-end
                //'stylesheet' => 'http://netdna.bootstrapcdn.com/font-awesome/4.0.3/css/font-awesome.css', // full path OR url to stylesheet
                //'prefix' => 'fa', // If needed to initialize the icon
                //'selector' => 'fa-', // How each icons begins for this given font
                //'height' => 300 // Change the height of the container. defaults to 300px;
            ),
            array(
                'id' => 'name_icon_select_4_product',
                'type' => 'text',
                'title' => 'نام نمایش در کنار آیکون چهارم',
                'placeholder' => 'ارسال از 1 روز کاری بعد',
                'default' => 'ارسال از 1 روز کاری بعد',
                'required' => array('ultra-Exp-check', '=', false),
            ),
            array(
                'id' => 'divider_2',
                'type' => 'divide'
            ),
            array(
                'id' => 'width_icon_select',
                'type' => 'slider',
                'title' => 'سایز آیکون‌ها (px)',
                "default" => 14,
                "min" => 10,
                "step" => 1,
                "max" => 20,
                'display_value' => 'text'
            ),
            array(
                'id' => 'color_icon_select',
                'type' => 'color',
                'title' => 'رنگ آیکون‌ها ',
                'default' => '#333',
                'validate' => 'color',
                'transparent' => false,
            ),
        ),
    )
);
//Description Ideal

/**
 * SideBar Single Product
 */
Redux::set_section(
    $opt_name,
    array(
        'title' => 'سایدبار (ستون کناری) صفحه محصول',
        'id' => 'ultra-side-product',
        'customizer_width' => '400px',
        'icon' => 'dashicons dashicons-format-aside',
        'subsection' => true,
        'fields' => array(
            array(
                'id' => 'ultra-description-aside-product',
                'type' => 'switch',
                'title' => 'نمایش توضیحات',
                'subtitle' => 'در صورت نمایش متن در ستون کناری محصول روشن کنید.',
                'default' => true,
                'on' => 'فعال',
                'off' => 'غیرفعال',
            ),
            array(
                'id' => 'ultra-text-description-aside-product',
                'type' => 'editor',
                'title' => 'توضیحات',
                'subtitle' => 'توضیحات دلخواه خود را وارد کنید.',
                'desc' => 'اولویت با وارد کردن توضیحات در ویرایش محصول است.(اگر برای محصولی توضیحی ننویسید بصورت پیش فرض متن بالا نمایش داده میشود.)',
                'required' => array('ultra-description-aside-product', '=', true),
                'args' => array(
                    'teeny' => true,
                    'textarea_rows' => 10
                ),
            ),
            array(
                'id' => 'divider_3',
                'type' => 'divide'
            ),
            array(
                'id' => 'check_stock_quantity_product',
                'type' => 'switch',
                'title' => 'نمایش تعداد موجودی محصول',
                'default' => true,
                'on' => 'فعال',
                'off' => 'غیرفعال',
            ),
            array(
                'id' => 'number_stock_quantity_product',
                'type' => 'text',
                'title' => 'تعداد موجودی محصول',
                'desc' => 'عددی که وارد میکنید اگر تعداد محصول از عدد وارد شده کمتر باشد متن "فقط 6 عدد در انبار باقی مانده" نمایش داده میشود.',
                'placeholder' => '15',
                'required' => array('check_stock_quantity_product', '=', true),
            ),
            array(
                'id' => 'divider_4',
                'type' => 'divide'
            ),
            array(
                'id' => 'check_view_comments_rating_product',
                'type' => 'switch',
                'title' => 'نمایش مشاهده نظرات و امتیاز محصول',
                'default' => true,
                'on' => 'فعال',
                'off' => 'غیرفعال',
            ),
            array(
                'id' => 'text_view_comments_product',
                'type' => 'text',
                'title' => 'نام نمایشی',
                'desc' => 'نام نمایشی مورد نظر خود را وارد کنید.',
                'placeholder' => 'مشاهده نظرات',
                'default' => 'مشاهده نظرات',
                'required' => array('check_view_comments_rating_product', '=', true),
            ),
            array(
                'id' => 'color_view_comments_rating_product',
                'type' => 'color',
                'title' => 'رنگ زمینه باکس ',
                'default' => '#F8F8F8',
                'validate' => 'color',
                'transparent' => false,
                'required' => array('check_view_comments_rating_product', '=', true),
            ),
            array(
                'id' => 'border_view_comments_rating_product',
                'type' => 'border',
                'title' => 'رنگ border(خط کادر) کادر نظرات و امتیاز محصول',
                'required' => array('check_view_comments_rating_product', '=', true),
                'default' => array(
                    'border-color' => '#F4F4F4',
                    'border-style' => 'solid',
                    'border-top' => '1px',
                    'border-right' => '1px',
                    'border-bottom' => '1px',
                    'border-left' => '1px'
                )
            ),
        ),
    )
);
//SideBar Single Product

/**
 * Number Sales Product
 */
Redux::set_section(
    $opt_name,
    array(
        'title' => 'تعداد فروش',
        'id' => 'ultra-sales-product-setting',
        'customizer_width' => '400px',
        'icon' => 'fa-solid fa-hand-holding-dollar',
        'subsection' => true,
        'fields' => array(
            array(
                'id' => 'ultra-total-sales-check',
                'type' => 'switch',
                'title' => 'نمایش تعداد کل فروش محصول',
                'subtitle' => 'اگر تمایل دارید تعداد کل فروش محصول نمایش داده شود، فعال کنید.',
                'default' => true,
                'on' => 'فعال',
                'off' => 'غیرفعال',
            ),
            array(
                'id' => 'ultra-total-sales-name',
                'type' => 'text',
                'title' => 'نام',
                'placeholder' => 'تعداد فروش محصول:',
                'default' => 'تعداد فروش محصول:',
                'required' => array('ultra-total-sales-check', '=', true),
            ),
            array(
                'id' => 'ultra-total-sales-icon-check',
                'type' => 'switch',
                'title' => 'نمایش آیکون دلخواه',
                'subtitle' => 'اگر تمایل دارید آیکون دلخواه خود را قبل از متن نمایش دهید، فعال کنید.',
                'default' => false,
                'required' => array('ultra-total-sales-check', '=', true),
                'on' => 'فعال',
                'off' => 'غیرفعال',
            ),
            array(
                'id' => 'icon_total_sales_product',
                'type' => 'icon_select',
                //'required' => array('switch-fold','equals','0'),
                'title' => 'انتخاب آیکون',
                'subtitle' => 'آیکون دلخواه خود را که قبل از نوشته نمایش داده میشود را انتخاب کنید.',
                'required' => array('ultra-total-sales-icon-check', '=', true),
                //'default' 	=> '',
                //'options' => array(), // key/value pair, value is the title
                //'enqueue' => false, // Disable auto-enqueue of stylesheet if present in the panel
                //'enqueue_frontend' => false, // Disable auto-enqueue of stylesheet on the front-end
                //'stylesheet' => 'http://netdna.bootstrapcdn.com/font-awesome/4.0.3/css/font-awesome.css', // full path OR url to stylesheet
                //'prefix' => 'fa', // If needed to initialize the icon
                //'selector' => 'fa-', // How each icons begins for this given font
                //'height' => 300 // Change the height of the container. defaults to 300px;
            ),
            array(
                'id' => 'ultra-total-real-fake-check',
                'type' => 'switch',
                'title' => 'نمایش تعداد فروش محصول',
                'subtitle' => 'تعیین کنید تعداد فروش محصول چگونه نمایش داده شود، نمایش واقعی فروش یا غیر واقعی.',
                'default' => true,
                'on' => 'واقعی',
                'off' => 'فیک',
                'required' => array('ultra-total-sales-check', '=', true),
            ),
            array(
                'id' => 'ultra-min-total-sales-show-real',
                'type' => 'text',
                'title' => 'حداقل مقدار فروش جهت نمایش',
                'subtitle' => 'عددی که وارد می کنید به عنوان حداقل فروش نمایش داده میشود و فروش باید برابر یا بالاتر (=<) از این عدد باشد تا نمایش داده شود.',
                'description' => 'اگر تعداد فروش از تعدادی که وارد میکنید کمتر باشد نمایش داده نمیشود. برای نمایش حتی هیچ فروش عدد 0 را وارد کنید.',
                'placeholder' => '10',
                'default' => '0',
                'required' => array('ultra-total-real-fake-check', '=', true),
            ),
            array(
                'id' => 'ultra-min-total-sales-show-fake',
                'type' => 'text',
                'title' => 'حداقل مقدار فروش جهت نمایش',
                'subtitle' => 'عددی که وارد می کنید به عنوان حداقل فروش نمایش داده میشود و فروش جدید + عدد میشود.',
                'description' => 'عددی که وارد میکنید + فروش جدید میشود.',
                'placeholder' => '10',
                'default' => '0',
                'required' => array('ultra-total-real-fake-check', '=', false),
            ),
        ),
    )
);
//Number Sales Product

/**
 * Category Woocommerce
 */
Redux::set_section(
    $opt_name,
    array(
        'title' => 'صفحه دسته بندی',
        'id' => 'option_category_woocommerce',
        'customizer_width' => '400px',
        'icon' => 'fa-solid fa-list fa-fw',
        'subsection' => true,
        'fields' => array(
            array(
                'id' => 'check-display-description-category',
                'type' => 'switch',
                'title' => 'نمایش توضیحات دسته بندی',
                'default' => true,
                'on' => 'نمایش',
                'off' => 'مخفی',
            ),
            array(
                'id' => 'up-down-display-description-category',
                'type' => 'switch',
                'title' => 'مکان نمایش توضیحات دسته بندی',
                'subtitle' => 'می توانید نمایش توضیحات را در بالا یا پایین صفحه دسته بندی تعیین کنید',
                'default' => false,
                'on' => 'بالا',
                'off' => 'پایین',
                'required' => array('check-display-description-category', '=', true),
            ),
            array(
                'id' => 'check-display-h1-category',
                'type' => 'switch',
                'title' => 'نمایش هدینگ 1 (سرتیتر) دسته بندی',
                'default' => true,
                'on' => 'نمایش',
                'off' => 'مخفی',
            ),
        ),
    )
);
//Category Woocommerce

/**
 * Cart Woocommerce
 */
Redux::set_section(
    $opt_name,
    array(
        'title' => 'صفحه سبد خرید',
        'id' => 'option_cart_woocommerce',
        'customizer_width' => '400px',
        'icon' => 'fa-solid fa-basket-shopping fa-fw',
        'subsection' => true,
        'fields' => array(
            array(
                'id' => 'check-cross-sells-cart',
                'type' => 'switch',
                'title' => 'نمایش محصولات مشابه (Cross-Sells)',
                'default' => true,
                'on' => 'فعال',
                'off' => 'غیرفعال',
            ),
            array(
                'id' => 'name-cross-sells-cart',
                'type' => 'text',
                'title' => 'نام نمایش محصولات مشابه',
                'desc' => 'نام نمایش محصولات مشابه (Cross-Sells) مورد نظر خود را وارد کنید.',
                'default' => 'ممکن است علاقه‌مند باشید به…',
                'placeholder' => 'ممکن است علاقه‌مند باشید به…',
                'required' => array('check-cross-sells-cart', '=', true),
            ),
            array(
                'id' => 'divider_cart',
                'title' => 'تنظیمات صفحه سبد خالی',
                'type' => 'divide'
            ),
            array(
                'id' => 'check-custom-empty-cart',
                'type' => 'switch',
                'title' => 'سبد خرید اختصاصی',
                'subtitle' => 'اگر تمایل دارید سبد خرید خالی بصورت پیش فرض نباشد و اختصاصی باشد فعال کنید.',
                'default' => true,
                'on' => 'فعال',
                'off' => 'غیرفعال',
            ),
            array(
                'id' => 'image-gallery-cart-empty',
                'type' => 'media',
                'title' => 'انتخاب عکس',
                'subtitle' => 'اگر سبد خرید کاربر خالی باشد. عکس انتخابی شما نمایش داده می‌شود',
                'url' => true,
                'default' => array(
                    'url' => get_template_directory_uri() . '/assets/image/empty-cart.svg'
                ),
                'required' => array('check-custom-empty-cart', '=', true),
            ),
            array(
                'id' => 'name-empty-cart',
                'type' => 'text',
                'title' => 'نام سبد خرید خالی',
                'desc' => 'نام نمایشی مورد نظر خود را وارد کنید.',
                'default' => 'سبد خرید شما خالی است.',
                'placeholder' => 'سبد خرید شما خالی است…',
                'required' => array('check-custom-empty-cart', '=', true),
            ),
            array(
                'id' => 'sub-name-empty-cart',
                'type' => 'text',
                'title' => 'زیر تایتل سبد خرید خالی',
                'desc' => 'نام نمایشی مورد نظر خود را وارد کنید.',
                'default' => 'می‌توانید برای مشاهده محصولات بیشتر به صفحات زیر بروید:',
                'placeholder' => 'می‌توانید برای مشاهده محصولات بیشتر به صفحات زیر بروید:',
                'required' => array('check-custom-empty-cart', '=', true),
            ),
            array(
                'id' => 'check-menu-empty-cart',
                'type' => 'switch',
                'title' => 'نمایش فهرست',
                'subtitle' => 'اگر تمایل دارید فهرست را نمایش دهد، فعال کنید.
                جایگاه فهرست سبد خرید خالی سایت (در بخش نمایش -> فهرست ها، یک فهرست ایجاد کنید و به جایگاه سبد خرید متصل کنید)',
                'default' => true,
                'on' => 'فعال',
                'off' => 'غیرفعال',
                'required' => array('check-custom-empty-cart', '=', true),
            ),
            array(
                'id' => 'check-total-sales-empty-cart',
                'type' => 'switch',
                'title' => 'نمایش محصولات پر فروش',
                'subtitle' => 'اگر تمایل دارید محصولات پر فروش که موجودی دارند را نمایش دهد، فعال کنید.',
                'default' => true,
                'on' => 'فعال',
                'off' => 'غیرفعال',
                'required' => array('check-custom-empty-cart', '=', true),
            ),
            array(
                'id' => 'divider_cart_1',
                'title' => 'تنظیمات مراحل در سبد خرید',
                'subtitle' => 'تنظیمات "step" در 3 صفحه سبد خرید، پرداخت، تشکر',
                'type' => 'divide'
            ),
            array(
                'id' => 'color_default_step_site',
                'type' => 'color',
                'title' => esc_html__('انتخاب رنگ پیش فرض مراحل'),
                'subtitle' => esc_html__('این رنگ بصورت پیش فرض و قبل از انجام مراحل نمایش داده می شود. رنگ پیش فرض: #bcbcbc'),
                'default' => '#bcbcbc',
                'validate' => 'color',
            ),
            array(
                'id' => 'color_primary_step_site',
                'type' => 'color',
                'title' => esc_html__('انتخاب رنگ دومیه مراحل'),
                'subtitle' => esc_html__('این رنگ بصورت فعال و بعد از انجام مراحل نمایش داده می شود. رنگ پیش فرض: #FFBB91'),
                'default' => '#FFBB91',
                'validate' => 'color',
            ),
        ),
    )
);
//Cart Woocommerce
/**
 * Free First Delivery
 */
Redux::set_section(
    $opt_name,
    array(
        'title' => 'ارسال رایگان اولین خرید',
        'id' => 'option_cart_free_first_delivery',
        'customizer_width' => '400px',
        'icon' => 'fa-solid fa-truck fa-fw',
        'subsection' => true, // به عنوان زیرمجموعه تعریف می‌شود
        'fields' => array(
            array(
                'id' => 'check-free-delivery',
                'type' => 'switch',
                'title' => 'نمایش ارسال رایگان',
                'default' => true,
                'on' => 'فعال',
                'off' => 'غیرفعال',
            ),
            array(
                'id' => 'free-delivery',
                'type' => 'text',
                'title' => 'قیمت ارسال رایگان',
                'subtitle' => 'قیمت را بدون هیچ علائم نگارشی (، / ,) وارد کنید.',
                'placeholder' => '900000',
                'required' => array('check-free-delivery', '=', true),
            ),
            array(
                'id' => 'text-after-free-delivery',
                'type' => 'text',
                'title' => 'متن بعد از ارسال رایگان',
                'default' => 'تبریک! ارسال سفارش شما رایگان شد 🎉',
                'required' => array('check-free-delivery', '=', true),
            ),
            array(
                'id' => 'free-delivery-color',
                'type' => 'color',
                'title' => esc_html__('رنگ متن', 'your-textdomain-here'),
                'default' => '#303030',
                'validate' => 'color',
                'required' => array('check-free-delivery', '=', true),
            ),
            array(
                'id' => 'free-delivery-backgrand',
                'type' => 'color',
                'title' => esc_html__('رنگ بکگراند', 'your-textdomain-here'),
                'default' => '#f2f6fc',
                'validate' => 'color',
                'required' => array('check-free-delivery', '=', true),
            ),
            array(
                'id' => 'check-free-first-delivery',
                'type' => 'switch',
                'title' => 'فعال‌سازی ارسال رایگان اولین خرید',
                'default' => false,
                'on' => 'فعال',
                'off' => 'غیرفعال',
            ),
            array(
                'id' => 'dividerfree',
                'type' => 'divide'
            ),
            array(
                'id' => 'code-free-first-delivery',
                'type' => 'text',
                'title' => 'کد تخفیف اولین خرید را وارد کنید ',
                'placeholder' => 'first',
                'required' => array('check-free-first-delivery', '=', true),
            ),
        ),
    )
);
// Free First Delivery

/**
 * Checkout Woocommerce
 */
Redux::set_section(
    $opt_name,
    array(
        'title' => 'صفحه پرداخت',
        'id' => 'option_checkout_woocommerce',
        'customizer_width' => '400px',
        'icon' => 'fa-regular fa-credit-card fa-fw',
        'subsection' => true,
        'fields' => array(
            array(
                'id' => 'check-review-order-checkout',
                'type' => 'switch',
                'title' => 'نمایش خلاصه سفارش ( نمایش محصولات در سبد خرید در سایدبار صفحه پرداخت)',
                'default' => true,
                'on' => 'فعال',
                'off' => 'غیرفعال',
            ),
            array(
                'id' => 'name-review-order-checkout',
                'type' => 'text',
                'title' => 'نام مورد نظر خود را وارد کنید',
                'subtitle' => 'نام مورد نظر نمایش خلاصه سفارش ( نمایش محصولات در سبد خرید در سایدبار صفحه پرداخت) را وارد کنید.',
                'default' => 'خلاصه سفارش',
                'placeholder' => 'مرور محصولات',
                'required' => array('check-review-order-checkout', '=', true),
            ),
            array(
                'id' => 'name-cart-subtotal-checkout',
                'type' => 'text',
                'title' => 'نام مورد نظر خود را وارد کنید',
                'subtitle' => 'نام مورد نظر نمایش مبلغ کل سبد خرید را وارد کنید.',
                'default' => 'مبلغ کل سبد خرید',
                'placeholder' => 'کل سبد خرید',
                //'required' => array('check-review-order-checkout', '=', true),
            ),
            array(
                'id' => 'name-order-total-checkout',
                'type' => 'text',
                'title' => 'نام مورد نظر خود را وارد کنید',
                'subtitle' => 'نام مورد نظر نمایش مبلغ نهایی پرداخت (سبد خرید + حمل و نقل) را وارد کنید.',
                'default' => 'مبلغ نهایی',
                'placeholder' => 'مبلغ نهایی',
                //'required' => array('check-review-order-checkout', '=', true),
            ),
        ),
    )
);
// Checkout Woocommerce

/**
 * ThankYou Woocommerce
 */
Redux::set_section(
    $opt_name,
    array(
        'title' => 'صفحه تشکر',
        'id' => 'option_thankyou_woocommerce',
        'customizer_width' => '400px',
        'icon' => 'fa-solid fa-file-invoice-dollar fa-fw',
        'subsection' => true,
        'fields' => array(
            array(
                'id' => 'check-image-thankyou',
                'type' => 'switch',
                'title' => 'نمایش تصویر در صفحه تشکر خرید ',
                'default' => true,
                'on' => 'فعال',
                'off' => 'غیرفعال',
            ),
            array(
                'id' => 'choose_image_thankyou',
                'type' => 'media',
                'title' => 'انتخاب عکس',
                'subtitle' => 'اگر سبد خرید کاربر خالی باشد. عکس انتخابی شما نمایش داده می‌شود',
                'url' => true,
                'default' => array(
                    'url' => get_template_directory_uri() . '/assets/image/success-payment-image.svg'
                ),
                'required' => array('check-image-thankyou', '=', true),
            ),
        ),
    )
);
// ThankYou Woocommerce

/**
 * MyAccount Woocommerce
 */
Redux::set_section(
    $opt_name,
    array(
        'title' => 'صفحه حساب کاربری',
        'id' => 'option_myaccount_woocommerce',
        'customizer_width' => '400px',
        'icon' => 'fa-solid fa-user-pen fa-fw',
        'subsection' => true,
        'fields' => array(
            array(
                'id' => 'check-notification-my-account',
                'type' => 'switch',
                'title' => 'نمایش اطلاعیه داخل پنل کاربری ',
                'default' => true,
                'on' => 'فعال',
                'off' => 'غیرفعال',
            ),
            array(
                'id' => 'title-notification-my-account',
                'type' => 'text',
                'title' => 'سرتیتر اطلاعیه را وارد کنید.',
                'default' => 'عنوان اطلاعیه',
                'placeholder' => 'مبلغ نهایی',
                'required' => array('check-notification-my-account', '=', true),
            ),
            array(
                'id' => 'content-notification-my-account',
                'type' => 'editor',
                'title' => 'متن اطلاعیه',
                'subtitle' => 'توضیحات دلخواه خود را وارد کنید.',
                'required' => array('check-notification-my-account', '=', true),
                'args' => array(
                    'teeny' => true,
                    'textarea_rows' => 10
                ),
            ),
        ),
    )
);
// MyAccount Woocommerce

/**
 * reviews product
 */
Redux::set_section(
    $opt_name,
    array(
        'title' => 'نظرات کاربران (صفحه محصول)',
        'id' => 'option_reviews_single_product',
        'customizer_width' => '400px',
        'icon' => 'fa-regular fa-message fa-fw',
        'subsection' => true,
        'fields' => array(

            array(
                'id' => 'active_reviews_single_product_check',
                'type' => 'switch',
                'title' => 'نمایش آیتم های اسلایدر در نظرات',
                'default' => true,
                'on' => 'نمایش',
                'off' => 'مخفی',
            ),

            array(
                'id' => 'review_value_buy',
                'type' => 'text',
                'title' => 'عنوان آیتم اول',
                'default' => 'ارزش خرید',
                'required' => array('active_reviews_single_product_check', '=', true),
            ),
            array(
                'id' => 'review_exp_date',
                'type' => 'text',
                'title' => 'عنوان آیتم دوم',
                'default' => 'تاریخ اعتبار',
                'required' => array('active_reviews_single_product_check', '=', true),
            ),
            array(
                'id' => 'review_speed_delivery',
                'type' => 'text',
                'title' => 'عنوان آیتم سوم',
                'default' => 'سرعت ارسال',
                'required' => array('active_reviews_single_product_check', '=', true),
            ),
            array(
                'id' => 'review_quality_packaging',
                'type' => 'text',
                'title' => 'عنوان آیتم چهارم',
                'default' => 'کیفیت بسته بندی',
                'required' => array('active_reviews_single_product_check', '=', true),
            ),
            array(
                'id' => 'review_support',
                'type' => 'text',
                'title' => 'عنوان آیتم پنجم',
                'default' => 'پشتیبانی',
                'required' => array('active_reviews_single_product_check', '=', true),
            ),
        ),
    )
);
// reviews product
/**
 * Sms Marketing
 */
Redux::set_section(
    $opt_name,
    array(
        'title' => 'خبرنامه پیامکی',
        'id' => 'option_sms_woocommerce',
        'customizer_width' => '400px',
        'icon' => 'fa-solid fa-envelope',
        'subsection' => true,
        'fields' => array(
            array(
                'id' => 'sms_enabled',
                'type' => 'switch',
                'title' => 'فعال سازی پیامک',
                'default' => false,
                'disabled' => !function_exists('PWSMS') && !function_exists('PWooSMS'), // غیر فعال کردن در صورت غیرفعال بودن افزونه
                'desc' => sprintf(
                    esc_html__('برای فعال کردن این تنظیم نصب و فعال بودن %s ضروری میباشد.'),
                    '<a href="https://wordpress.org/plugins/persian-woocommerce-sms/" target="_blank">افزونه پیامک ووکامرس</a>'
                ),
            ),
            array(
                'id' => 'info_warning_sms',
                'type' => 'info',
                'title' => esc_html__('آموزش پیکربندی'),
                'style' => 'warning',
                'desc' => sprintf(
                    esc_html__('برای فعال کردن و آموزش پیکربندی %s کلیک کنید.'),
                    '<a href="https://wordpress.org/plugins/persian-woocommerce-sms/" target="_blank">افزونه پیامک ووکامرس</a>'
                ),
            ),
        ),
    )
);
// Sms Marketing
/**
 * Tracking
 */
Redux::set_section(
    $opt_name,
    array(
        'title'      => 'رهگیری سفارش',
        'id'         => 'order_tracking_section',
        'desc'       => 'فعال‌سازی فرم رهگیری سفارش برای کاربران',
        'icon'       => 'el el-map-marker',
        'subsection' => true,
        'fields'     => array(

            array(
                'id'       => 'order_tracking_help',
                'type'     => 'raw',
                'title'    => 'نحوه استفاده',
                'content'  => '
                <p>برای استفاده از فرم رهگیری سفارش، یک برگه ایجاد کرده و شورت‌کد زیر را در محتوای آن قرار دهید:</p>
                <pre>[order_tracking]</pre>
                <p>کاربر می‌تواند با وارد کردن شماره سفارش یا شماره موبایل، وضعیت سفارش و اطلاعات ارسال را مشاهده کند.</p>

                <p><strong>نمونه فرم رهگیری:</strong></p>
                <img src="' . get_template_directory_uri() . '/assets/image/order-tracking.png" style="max-width:100%; border:1px solid #ccc; border-radius:6px; box-shadow:0 0 8px rgba(0,0,0,0.05);">
            ',
            ),

        )
    ));
// Tracking
/**
 * 404 Page
 */
Redux::set_section(
    $opt_name,
    array(
        'title' => 'صفحه 404',
        'id' => 'option_404_page',
        'customizer_width' => '400px',
        'icon' => 'fas fa-exclamation',
        'fields' => array(
            array(
                'id' => 'choose_404_gif',
                'type' => 'media',
                'title' => 'انتخاب عکس، گیف یا ویدیو',
                'subtitle' => 'اگر کاربر به صفحه 404 برخورد کند ( صفحه ای که وجود ندارد). محتوای انتخابی شما نمایش داده می‌شود',
                'url' => true,
                'default' => array(
                    'url' => get_template_directory_uri() . '/assets/image/404.gif'
                ),
            ),
            array(
                'id' => 'text_404',
                'type' => 'text',
                'title' => 'متن دلخواه خود را وارد کنید.',
                'default' => 'صفحه ای که می خواهید به آن دسترسی پیدا کنید پیدا نشد.',
            ),
            array(
                'id' => 'btn_1_404',
                'type' => 'text',
                'title' => 'متن دلخواه دکمه اول را وارد کنید.',
                'default' => 'صفحه اصلی',
            ),
            array(
                'id' => 'link_btn_1_404',
                'type' => 'text',
                'title' => 'لینک دلخواه دکمه اول را وارد کنید.',
				'placeholder' => 'https://weblabs.ir',
            ),
            array(
                'id' => 'btn_2_404',
                'type' => 'text',
                'title' => 'متن دلخواه دکمه دوم را وارد کنید.',
                'default' => 'فروشگاه',
            ),
            array(
                'id' => 'link_btn_2_404',
                'type' => 'text',
                'title' => 'لینک دلخواه دکمه اول را وارد کنید.',
                'placeholder' => 'https://weblabs.ir',
            ),

        ),
    )
);
// 404 Page

// contact us
Redux::set_section(
    $opt_name,
    array(
        'title' => 'دکمه ارتباط با ما',
        'id' => 'contact_us',
        'customizer_width' => '400px',
        'icon' => 'el el-headphones',
        'fields' => array(
            array(
                'type' => 'raw',
                'title' => 'دکمه ارتباط با ما (شناور پایین سمت راست)',
            ),
            array(
                'id' => 'active_contact_us',
                'type' => 'switch',
                'title' => 'نمایش دکمه در دسکتاپ',
                'default' => true,
                'on' => 'نمایش',
                'off' => 'مخفی',
            ),
            array(
                'id' => 'right_left_contact',
                'type' => 'switch',
                'title' => 'نمایش دکمه',
                'default' => true,
                'on' => 'راست',
                'off' => 'چپ',
                'required' => array('active_contact_us', '=', true),
            ),
            array(
                'id' => 'slider_bottom_px',
                'type' => 'Slider',
                'title' => esc_html__('فاصله اسلایدر از پایین'),
                'default' => 50,
                'min' => 0,
                'step' => 1,
                'max' => 120,
                'display_value' => 'text',
                'required' => array('active_contact_us', '=', true),
            ),
            array(
                'id' => 'slider_right_px',
                'type' => 'Slider',
                'title' => esc_html__('فاصله اسلایدر از سمت راست'),
                'default' => 50,
                'min' => 0,
                'step' => 1,
                'max' => 120,
                'display_value' => 'text',
                'required' => array('right_left_contact', '=', true),
            ),
            array(
                'id' => 'slider_left_px',
                'type' => 'Slider',
                'title' => esc_html__('فاصله اسلایدر از سمت چپ'),
                'default' => 50,
                'min' => 0,
                'step' => 1,
                'max' => 120,
                'display_value' => 'text',
                'required' => array('right_left_contact', '=', false),
            ),
            array(
                'id' => 'active_contact_us_mobile',
                'type' => 'switch',
                'title' => 'نمایش دکمه در موبایل',
                'default' => true,
                'on' => 'نمایش',
                'off' => 'مخفی',
            ),
            array(
                'id' => 'right_left_contact_mobile',
                'type' => 'switch',
                'title' => 'نمایش دکمه',
                'default' => true,
                'on' => 'راست',
                'off' => 'چپ',
                'required' => array('active_contact_us_mobile', '=', true),
            ),
            array(
                'id' => 'slider_bottom_px_mobile',
                'type' => 'Slider',
                'title' => esc_html__('فاصله اسلایدر از پایین'),
                'default' => 50,
                'min' => 0,
                'step' => 1,
                'max' => 120,
                'display_value' => 'text',
                'required' => array('active_contact_us_mobile', '=', true),
            ),
            array(
                'id' => 'slider_right_px_mobile',
                'type' => 'Slider',
                'title' => esc_html__('فاصله اسلایدر از سمت راست'),
                'default' => 50,
                'min' => 0,
                'step' => 1,
                'max' => 120,
                'display_value' => 'text',
                'required' => array('right_left_contact_mobile', '=', true),
            ),
            array(
                'id' => 'slider_left_px_mobile',
                'type' => 'Slider',
                'title' => esc_html__('فاصله اسلایدر از سمت چپ'),
                'default' => 50,
                'min' => 0,
                'step' => 1,
                'max' => 120,
                'display_value' => 'text',
                'required' => array('right_left_contact_mobile', '=', false),
            ),
            array(
                'id' => 'background_contact_us',
                'type' => 'background',
                'title' => 'رنگ دکمه',
                'subtitle' => 'پیشفرض قرمز است',
                'background-repeat' => false,
                'background-attachment' => false,
                'background-position' => false,
                'background-image' => false,
                'background-size' => false,
                'transparent' => false,
                'output' => array('.floatting-contact .floatting-btn'),
                'default' => array(
                    'background-color' => '#f93423',
                ),
            ),
            array(
                'type' => 'raw',
                'title' => 'هرکدام از موارد زیر را پر کنید نمایش داده میشود',
            ),
            array(
                'id' => 'contact_tell',
                'type' => 'text',
                'title' => 'شماره تماس',
            ),
            array(
                'id' => 'contact_telegram',
                'type' => 'text',
                'title' => 'آیدی تلگرام',
            ),
            array(
                'id' => 'contact_instagram',
                'type' => 'text',
                'title' => 'آیدی اینستاگرام',
            ),
            array(
                'id' => 'contact_whatsup',
                'type' => 'text',
                'title' => 'شماره واتساپ',
                'subtitle' => 'شماره را در فرمت بین المللی بنویسید ( مثال : 989101234567',
            ),
            array(
                'id' => 'contact_bale',
                'type' => 'text',
                'title' => 'آدرس حساب پیام رسان بله',
            ),
            array(
                'id' => 'contact_rubika',
                'type' => 'text',
                'title' => 'آدرس حساب پیام رسان روبیکا',
            ),
            array(
                'id' => 'contact_soroush',
                'type' => 'text',
                'title' => 'آدرس حساب پیام رسان سروش',
            ),
            array(
                'id' => 'contact_email',
                'type' => 'text',
                'title' => 'ادرس ایمیل',
            ),
            array(
                'id' => 'switch_custom',
                'type' => 'switch',
                'title' => 'شبکه دلخواه',
                'default' => false,
                'on' => 'فعال',
                'off' => 'غیرفعال',
            ),
            array(
                'id' => 'contact_custom_name',
                'type' => 'text',
                'title' => 'نام اختیاری',
                'required' => array('switch_custom', '=', true),
            ),
            array(
                'id' => 'switch_img_icon',
                'type' => 'switch',
                'title' => 'نوع آیکون',
                'default' => false,
                'on' => 'تصویر',
                'off' => 'آیکون',
                'required' => array('switch_custom', '=', true),
            ),
            array(
                'id' => 'contact_custom_icon',
                'type' => 'icon_select',
                'title' => 'انتخاب آیکون',
                'default' => 'fas fa-bars',
                'required' => array('switch_img_icon', '=', false),
            ),
            array(
                'id' => 'contact_custom_img',
                'type' => 'media',
                'url' => true,
                'title' => esc_html__('تصویر / لینک', 'your-textdomain-here'),
                'default' => array(
                    'url' => get_template_directory_uri() . 'assets/image/crown.png'
                ),
                'required' => array('switch_img_icon', '=', true),
            ),
            array(
                'id' => 'contact_custom_link',
                'type' => 'text',
                'title' => 'لینک اختیاری',
                'required' => array('switch_custom', '=', true),
            ),

        ),
    )
);
// contact us
/**
 * Public Setting
 */
Redux::set_section(
    $opt_name,
    array(
        'title' => 'جستجو',
        'id' => 'ultra-serach',
        'customizer_width' => '400px',
        'icon' => 'el el-search',
        'fields' => array(
            array(
                'id' => 'ultra-search-img',
                'type' => 'media',
                'url' => true,
                'title' => 'تصویر',
                'subtitle' => 'اگر محصولی سرچ زده شد و یافت نشد نمایش داده می شود',
                'important' => true,
                'default' => array(
                    'url' => get_template_directory_uri() . '/assets/image/not-found.jpg'
                ),
            ),
            array(
                'id' => 'ultra-search-text',
                'type' => 'text',
                'title' => 'متن دلخواه خود را وارد کنید',
                'subtitle' => 'این متن در زیر عکس نمایش داده می شود.',
                'default' => 'متاسفانه چیزی پیدا نکردم',
            ),
        ),
    )
);
//Public Setting
/**
 * Disable gutenberge
 */
Redux::set_section(
    $opt_name,
    array(
        'title' => 'انتخاب ویرایشگر',
        'id' => 'ultra_choose_editor',
        'customizer_width' => '400px',
        'icon' => 'el el-edit',
        'fields' => array(
            array(
                'id' => 'choose_editor_blog',
                'type' => 'switch',
                'title' => 'ویرایشگر نوشته ها',
                'default' => true,
                'on' => 'کلاسیک',
                'off' => 'گوتنبرگ',
            ),
            array(
                'id' => 'choose_editor_widget',
                'type' => 'switch',
                'title' => 'ویرایشگر ابزارک ها',
                'default' => false,
                'on' => 'کلاسیک',
                'off' => 'گوتنبرگ',
            ),
        )
    )
);
// End Disable gutenberge
/**
 * OffersPage Setting
 */
Redux::set_section(
    $opt_name,
    array(
        'title' => 'برگه تخفیفات ویژه',
        'id' => 'offers_page_options',
        'customizer_width' => '400px',
        'icon' => 'fa-solid fa-gift',
        'fields' => array(
            array(
                'id' => 'opt-raw',
                'type' => 'raw',
                'title' => esc_html__('ساخت برگه نمایش محصولات تخفیف خورده', 'your-textdomain-here'),
                'subtitle' => esc_html__('برای نمایش تمامی محصولات تخفیف خورده، یک برگه جدید ایجاد کنید و قالب آن را روی "نمایش تمام محصولات تخفیف خورده" قرار دهید.', 'your-textdomain-here'),
                'desc' => esc_html__('مراحل: به بخش "برگه‌ها" بروید، یک برگه جدید اضافه کنید، سپس قالب را انتخاب کنید.', 'your-textdomain-here'),
                'content' => '<strong>توجه:</strong> پس از تنظیم قالب، برگه محصولات تخفیف خورده نمایش داده خواهد شد.',
            ),
            array(
                'id' => 'template-preview',
                'type' => 'raw',
                'title' => esc_html__('پیش‌نمایش قالب برگه', 'your-textdomain-here'),
                'content' => '
                <div style="text-align: center; padding: 15px; background: #f9f9f9; border: 1px solid #ddd; border-radius: 8px;">
                    <img src="' . get_template_directory_uri() . '/assets/image/discount-template-preview.jpg" alt="Preview" style="max-width: 100%; height: auto; border-radius: 5px; box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);">
                    <p style="margin-top: 10px; font-size: 14px; color: #555;">این تصویر قالب انتخابی برای نمایش محصولات تخفیف‌خورده است.</p>
                </div>',
            ),
            array(
                'id' => 'top_down_content',
                'type' => 'switch',
                'title' => 'نمایش توضیحات صفحه',
                'default' => true,
                'on' => 'پایین',
                'off' => 'بالا',
            ),
            array(
                'id' => 'display_timer',
                'type' => 'switch',
                'title' => 'نمایش تایمر محصولات',
                'default' => true,
                'on' => 'نمایش',
                'off' => 'مخفی',
            ),
        ),
    )
);
// end OffersPage Setting

Redux::setSection($opt_name, array(
    'title' => __('حالت تعمیر', 'text-domain'),
    'id' => 'maintenance_mode',
    'icon' => 'el el-wrench',
    'fields' => array(
        array(
            'id' => 'maintenance_enable',
            'type' => 'switch',
            'title' => __('فعال کردن حالت تعمیر', 'text-domain'),
            'default' => false,
            'on' => 'فعال',
            'off' => 'غیرفعال'
        ),
        array(
            'id' => 'h1_maintenance_message',
            'type' => 'text',
            'title' => 'سرتیتر',
            'required' => array('maintenance_enable', '=', true),
        ),
        array(
            'id' => 'maintenance_message',
            'type' => 'textarea',
            'title' => __('متن حالت تعمیر', 'text-domain'),
            'default' => 'سایت در حال بروزرسانی است. لطفاً بعداً مراجعه کنید.',
            'required' => array('maintenance_enable', '=', true),
        ),
        array(
            'id' => 'maintenance_image',
            'type' => 'media',
            'title' => __('تصویر حالت تعمیر', 'text-domain'),
            'default' => '',
            'required' => array('maintenance_enable', '=', true),
        ),
    ),
));

Redux::setSection($opt_name, array(
    'title' => __('تنظیمات پاپ‌آپ', 'your-textdomain'),
    'id' => 'popup_settings',
    'desc' => __('مدیریت نمایش پاپ‌آپ‌ها', 'your-textdomain'),
    'icon' => 'el el-comment-alt',
    'fields' => array(
        array(
            'id' => 'enable_popup',
            'type' => 'switch',
            'title' => esc_html__('فعال‌سازی پاپ‌آپ'),
            'default' => false, // به صورت پیش‌فرض غیرفعال
            'on' => 'فعال',
            'off' => 'غیرفعال',
        ),
        array(
            'id' => 'popup_title',
            'type' => 'text',
            'title' => esc_html__('عنوان پاپ‌آپ'),
            'default' => 'پیام پاپ‌آپ',
            'placeholder' => 'عنوان خود را وارد کنید',
            'required' => array('enable_popup', '=', true),
        ),
        array(
            'id' => 'popup_content',
            'type' => 'editor',
            'title' => esc_html__('محتوای پاپ‌آپ'),
            'default' => '<p>این یک پیام پاپ‌آپ است!</p>',
            'args' => array(
                'wpautop' => true,
                'media_buttons' => true,
                'textarea_rows' => 10,
                'teeny' => false,
            ),
            'required' => array('enable_popup', '=', true),
        ),
        array(
            'id' => 'time_show_popup',
            'type' => 'slider',
            'title' => esc_html__('زمان نمایش'),
            'subtitle' => esc_html__('بعد از گذشت این زمان پاپ آپ نمایش داده میشود.'),
            "default" => 10,
            "min" => 1,
            "step" => 1,
            "max" => 30,
            'display_value' => 'label',
            'required' => array('enable_popup', '=', true),
        ),
    ),
));

Redux::setSection($opt_name, array(
    'title' => __('پاپ آپ محصول', 'your-textdomain'),
    'id' => 'peoduct_pop_settings',
    'desc' => __('محصول', 'your-textdomain'),
    'icon' => 'el el-comment-alt',
    'fields' => array(
        // Add product settings in Redux
        array(
            'id' => 'enable_product_display',
            'type' => 'switch',
            'title' => esc_html__('فعال‌سازی پاپ‌آپ محصول'),
            'default' => false, // به صورت پیش‌فرض غیرفعال
            'on' => 'فعال',
            'off' => 'غیرفعال',
        ),
        array(
            'id' => 'product_display_ids',
            'type' => 'text',
            'title' => esc_html__('IDs محصولات نمایشی'),
            'subtitle' => esc_html__('ID محصولات را که می‌خواهید نمایش دهید وارد کنید (با کاما جدا کنید).'),
            'default' => '',
            'required' => array('enable_product_display', '=', true),
        ),
        array(
            'id' => 'product_display_select',
            'type' => 'select',
            'title' => esc_html__('انتخاب مکان نمایش پاپ آپ'),
            'options' => array(
                'top_right' => 'بالا راست',
                'top_center' => 'بالا وسط',
                'left_center' => 'چپ وسط',
                'top_left' => 'بالا چپ',
                'bottom_right' => 'پایین راست',
                'bottom_center' => 'پایین وسط',
                'right_center' => 'راست وسط',
                'bottom_left' => 'پایین چپ',
            ),
            'default' => 'bottom_right',
            'required' => array('enable_product_display', '=', true),
        )
    ),
));

/**
 * Custom Css
 */
Redux::set_section(
    $opt_name,
    array(
        'title' => 'استایل اختصاصی',
        'id' => 'ultra_custom_css',
        'customizer_width' => '400px',
        'icon' => 'fa-brands fa-css3-alt',
        'fields' => array(
            array(
                'id' => 'custom_css_editor',
                'type' => 'ace_editor',
                'title' => esc_html__('استایل مورد نظر خود را وارد کنید'),
                'subtitle' => esc_html__('استایل مورد نظر خود را جایگذاری کنید.'),
                'mode' => 'css',
                'theme' => 'monokai',
            ),
        ),
    )
);
/**
 *  Header And Footer
 */
Redux::set_section(
    $opt_name,
    array(
        'title' => 'کد سفارشی',
        'id' => 'custom_code_section',
        'customizer_width' => '400px',
        'icon' => 'eicon-code',
        'fields' => array(
            array(
                'id' => 'header_custom_code',
                'type' => 'ace_editor',
                'title' => __('کد سفارشی هدر', 'textdomain'),
                'subtitle' => __('کدی که می‌خواهید در هدر سایت اضافه کنید. میتوانید HTML یا JavaScript وارد کنید.', 'textdomain'),
                'default' => '',
                'mode' => 'html',  // یا 'javascript' بر اساس نیاز شما
                'theme' => 'dracula', // یا هر تم دیگری که دوست دارید
            ),
            array(
                'id' => 'footer_custom_code',
                'type' => 'ace_editor',
                'title' => __('کد سفارشی فوتر', 'textdomain'),
                'subtitle' => __('کدی که می‌خواهید در فوتر سایت اضافه کنید. می‌توانید HTML یا JavaScript وارد کنید.', 'textdomain'),
                'default' => '',
                'mode' => 'html',  // یا 'javascript'
                'theme' => 'monokai', // یا هر تم دیگری که دوست دارید
            ),
        ),
    )
);
/**
 *  Documentation Section
 */
Redux::set_section(
    $opt_name,
    array(
        'title' => 'داکیومنت',
        'id' => 'documentation_section',
        'customizer_width' => '400px',
        'icon' => 'eicon-document-file', // مشابه آیکون کد سفارشی
        'fields' => array(
            array(
                'id' => 'documentation_note',
                'type' => 'info',
                'style' => 'info',
                'title' => __('راهنمای استفاده از پنل', 'textdomain'),
                'desc' => __('برای مشاهده راهنمای کامل کار با پنل، می‌توانید به لینک زیر مراجعه کنید:', 'textdomain') .
                    '<br><a href="https://weblabs.ir/docs/" target="_blank">مشاهده داکیومنت</a>' .
                    '<br>' . __('همچنین می‌توانید در اینترنت عبارت "وبلبز" را جستجو کنید.', 'textdomain'),
            ),
        ),
    )
);