<?php
/**
 * The template for the panel header area.
 * Override this template by specifying the path where it is stored (templates_path) in your Redux config.
 *
 * @author      Redux Framework
 * @package     ReduxFramework/Templates
 * @version:    4.0.0
 */

$tip_title = esc_html__( 'حالت توسعه دهنده فعال است', 'redux-framework' );

if ( $this->parent->args_class->dev_mode_forced ) {
	$is_debug     = false;
	$is_localhost = false;
	$debug_bit    = '';

	if ( Redux_Helpers::is_wp_debug() ) {
		$is_debug  = true;
		$debug_bit = esc_html__( 'WP_DEBUG در فایل wp-config فعال است.', 'redux-framework' );
	}

	$localhost_bit = '';
	if ( Redux_Helpers::is_local_host() ) {
		$is_localhost  = true;
		$localhost_bit = esc_html__( 'شما در محیط لوکال‌ هاست کار می‌کنید', 'redux-framework' );
	}

	$conjunction_bit = '';
	if ( $is_localhost && $is_debug ) {
		$conjunction_bit = ' ' . esc_html__( 'و', 'redux-framework' ) . ' ';
	}

	$tip_msg = esc_html__( 'این به‌طور خودکار فعال شده است زیرا', 'redux-framework' ) . ' ' . $debug_bit . $conjunction_bit . $localhost_bit . '.';
} else {
	$tip_msg = esc_html__( 'اگر شما توسعه‌دهنده نیستید، نویسنده قالب/افزونه شما با حالت توسعه‌دهنده فعال شده است. به‌طور مستقیم با آن‌ها تماس بگیرید تا مشکل را برطرف کنند.', 'redux-framework' );
}

?>
<div id="redux-header">
	<?php if ( ! empty( $this->parent->args['display_name'] ) ) { ?>
		<div class="display_header">
			<?php if ( isset( $this->parent->args['dev_mode'] ) && $this->parent->args['dev_mode'] ) { ?>
				<div
					class="redux-dev-mode-notice-container redux-dev-qtip"
					qtip-title="<?php echo esc_attr( $tip_title ); ?>"
					qtip-content="<?php echo esc_attr( $tip_msg ); ?>">
					<span class="redux-dev-mode-notice"><?php esc_html_e( 'حالت توسعه‌دهنده فعال شده', 'redux-framework' ); ?></span>
				</div>
			<?php } ?>
			<i class="fa-solid fa-store"></i><h2><?php echo wp_kses_post( $this->parent->args['display_name'] ); ?></h2>
			<?php if ( ! empty( $this->parent->args['display_version'] ) ) { ?>
				<span><?php echo wp_kses_post( $this->parent->args['display_version'] ); ?></span>
			<?php } ?>
		</div>
	<?php } ?>
	<div class="clear"></div>
</div>
