<?php
function display_comment_avatar($comment)
{
    $comment_author_email = $comment->comment_author_email;
    $size = 48;
    $default = '';
    echo get_avatar($comment_author_email, $size, $default);
}

remove_action('woocommerce_review_before_comment_meta', 'woocommerce_review_display_rating', 10);

add_action('woocommerce_review_before_comment_meta', 'ultra_before_comment_meta');
function ultra_before_comment_meta()
{
    echo '<div class="meta-comment-pro">';
    global $comment;
    $comment_author_id = $comment->user_id;

    if (!user_can($comment_author_id, 'administrator')) {
        woocommerce_review_display_rating();

        $recommend = get_comment_meta($comment->comment_ID, 'recommentstatus', true);
        if ($recommend !== '') { // فقط در صورتی که فیلد وجود داشته باشد
            if ($recommend == 1) {
                echo '<div class="show-recommend-status"><span class="recommend-status-yes">خرید این محصول را پیشنهاد میکنم</span></div>';
            } elseif ($recommend == 0) {
                echo '<div class="show-recommend-status"><span class="recommend-status-no">خرید این محصول را پیشنهاد نمیکنم</span></div>';
            } elseif ($recommend == 2) {
                echo '<div class="show-recommend-status"><span class="recommend-status-maybe">نظری ندارم</span></div>';
            }
        }
    }
}

add_action('woocommerce_review_before_comment_meta', 'ultra_before_comment_meta_avatar');
function ultra_before_comment_meta_avatar()
{
    echo '<div class="flex-meta-img">';
    global $comment;
    display_comment_avatar($comment);
}

add_action('woocommerce_review_meta', 'ultra_after_comment_meta_avatar');
function ultra_after_comment_meta_avatar()
{
    echo '</div>';
}

add_action('woocommerce_review_before_comment_text', 'ultra_before_comment_text', 15);
function ultra_before_comment_text()
{
    echo '</div>';
}

add_action('woocommerce_review_after_comment_text', 'ultra_after_comment_text', 15);
function ultra_after_comment_text()
{
    global $comment;

    $user = get_user_by('email', $comment->comment_author_email);
    if (user_can($user, 'administrator')) {
        return;
    }

    $packaging = get_comment_meta($comment->comment_ID, 'range1', true);
    $exp = get_comment_meta($comment->comment_ID, 'range2', true);
    $sendingSpeed = get_comment_meta($comment->comment_ID, 'range3', true);
    $price = get_comment_meta($comment->comment_ID, 'range4', true);
    $support = get_comment_meta($comment->comment_ID, 'range5', true);

    global $ultra_options;
    if ($ultra_options['active_reviews_single_product_check'] == 1 &&
        ($packaging || $exp || $sendingSpeed || $price || $support)) :
        ?>
        <div class="show-rate-product">
            <?php if (!empty($packaging)) : ?>
                <div class="rate-item">
                    <span><?php echo $ultra_options['review_value_buy']; ?></span>
                    <div class="rate-content">
                        <div class="rate-result" style="width:<?= esc_attr($packaging); ?>%"></div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if (!empty($exp)) : ?>
                <div class="rate-item">
                    <span><?php echo $ultra_options['review_exp_date']; ?></span>
                    <div class="rate-content">
                        <div class="rate-result" style="width:<?= esc_attr($exp); ?>%"></div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if (!empty($sendingSpeed)) : ?>
                <div class="rate-item">
                    <span><?php echo $ultra_options['review_speed_delivery']; ?></span>
                    <div class="rate-content">
                        <div class="rate-result" style="width:<?= esc_attr($sendingSpeed); ?>%"></div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if (!empty($price)) : ?>
                <div class="rate-item">
                    <span><?php echo $ultra_options['review_quality_packaging']; ?></span>
                    <div class="rate-content">
                        <div class="rate-result" style="width:<?= esc_attr($price); ?>%"></div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if (!empty($support)) : ?>
                <div class="rate-item">
                    <span><?php echo $ultra_options['review_support']; ?></span>
                    <div class="rate-content">
                        <div class="rate-result" style="width:<?= esc_attr($support); ?>%"></div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    <?php
    endif;
}

add_action('comment_form_top', 'add_custom_fields_comment_form_top', 10);
function add_custom_fields_comment_form_top()
{
    if (is_product()) { ?>
        <div class="custom-field-review">
            <div class="review-radio-question">
                <header>آیا خرید این محصول را پیشنهاد میکنید؟</header>
                <div class="radio-list">
                    <div class="radio-item">
                        <input type="radio" name="recommentstatus" value="1" id="yes-suggest" checked>
                        <label for="yes-suggest">بله، پیشنهاد میکنم</label>
                    </div>
                    <div class="radio-item">
                        <input type="radio" name="recommentstatus" value="0" id="no-suggest">
                        <label for="no-suggest">خیر، پیشنهاد نمیکنم</label>
                    </div>
                    <div class="radio-item">
                        <input type="radio" name="recommentstatus" value="2" id="dontknow">
                        <label for="dontknow">نظری ندارم</label>
                    </div>
                </div>
            </div>
            <div class="rate-list">
                <?php global $ultra_options; ?>
                <div class="rate-item">
                    <b><?php echo $ultra_options['review_value_buy']; ?></b>
                    <input type="range" class="emoji-input" name="range1" min="1" max="100" step="1" value="100"/>
                    <div class="emoji">🤩</div>
                </div>
                <div class="rate-item">
                    <b><?php echo $ultra_options['review_exp_date']; ?></b>
                    <input type="range" class="emoji-input" name="range2" min="1" max="100" step="1" value="100"/>
                    <div class="emoji">🤩</div>
                </div>
                <div class="rate-item">
                    <b><?php echo $ultra_options['review_speed_delivery']; ?></b>
                    <input type="range" class="emoji-input" name="range3" min="1" max="100" step="1" value="100"/>
                    <div class="emoji">🤩</div>
                </div>
                <div class="rate-item">
                    <b><?php echo $ultra_options['review_quality_packaging']; ?></b>
                    <input type="range" class="emoji-input" name="range4" min="1" max="100" step="1" value="100"/>
                    <div class="emoji">🤩</div>
                </div>
                <div class="rate-item">
                    <b><?php echo $ultra_options['review_support']; ?></b>
                    <input type="range" class="emoji-input" name="range5" min="1" max="100" step="1" value="100"/>
                    <div class="emoji">🤩</div>
                </div>
            </div>
        </div>
    <?php }
}

add_action('comment_post', 'save_review_pros_and_cons');
function save_review_pros_and_cons($comment_id)
{
    if (isset($_POST['recommentstatus'])) {
        $recommendstatus = sanitize_text_field($_POST['recommentstatus']);
        add_comment_meta($comment_id, 'recommentstatus', $recommendstatus);
    }

    for ($i = 1; $i <= 5; $i++) {
        if (isset($_POST['range' . $i])) {
            $value = sanitize_text_field($_POST['range' . $i]);
            add_comment_meta($comment_id, 'range' . $i, $value);
        }
    }
}