<?php

class Elementor_ultra_why_us extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'ultra_why_us';
    }

    public function get_title()
    {
        return 'چرا اولترا؟';
    }

    public function get_icon()
    {
        return 'eicon-help-o';
    }

    public function get_categories()
    {
        return ['ultra'];
    }

    protected function register_controls()
    {
        // Title Section
        $this->start_controls_section('content_title_section', [
            'label' => __('متن اصلی', 'textdomain'),
        ]);

        $this->add_control('text_why', [
            'label' => __('کلمه اول (مثلاً چرا)', 'textdomain'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => 'چرا',
        ]);

        $this->add_control('text_website', [
            'label' => __('نام برند (مثلاً اولترا پت)', 'textdomain'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => 'اولترا پت؟',
        ]);

        $this->add_control('description_text', [
            'label' => __('توضیحات کوتاه', 'textdomain'),
            'type' => \Elementor\Controls_Manager::TEXTAREA,
            'default' => 'لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.',
        ]);

        $this->end_controls_section();

        // Repeater Section
        $this->start_controls_section('content_boxes_section', [
            'label' => __('باکس‌های چرا ما', 'textdomain'),
        ]);

        $repeater = new \Elementor\Repeater();

        $repeater->add_control('icon', [
            'label' => __('آیکون', 'textdomain'),
            'type' => \Elementor\Controls_Manager::ICONS,
            'default' => [
                'value' => 'fas fa-tv',
                'library' => 'fa-solid',
            ],
        ]);

        $repeater->add_control('title', [
            'label' => __('عنوان', 'textdomain'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => 'ارسال سریع',
        ]);

        $repeater->add_control('desc', [
            'label' => __('توضیح', 'textdomain'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => 'فردای ثبت سفارش',
        ]);

        $this->add_control('items', [
            'label' => __('لیست باکس‌ها', 'textdomain'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [],
        ]);

        $this->end_controls_section();

        // Style: Title
        $this->start_controls_section('style_title', [
            'label' => __('استایل عنوان', 'textdomain'),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]);

        $this->add_control('why_color', [
            'label' => __('رنگ کلمه اول'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ultra-why-us .why-us .why' => 'color: {{VALUE}}'],
        ]);

        $this->add_control('website_color', [
            'label' => __('رنگ نام برند'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ultra-why-us .why-us .website' => 'color: {{VALUE}}'],
        ]);

        $this->add_control('desc_color', [
            'label' => __('رنگ توضیحات'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ultra-why-us .text-side p' => 'color: {{VALUE}}'],
        ]);

        $this->end_controls_section();

        // Style: Boxes
        $this->start_controls_section('style_boxes', [
            'label' => __('استایل باکس‌ها', 'textdomain'),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]);
        
        $this->add_control('icon_bg', [
            'label' => __('رنگ پس‌زمینه آیکون'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .ultra-why-us .box-side .the-box svg' => 'background-color: {{VALUE}}',
            ],
        ]);
        
        $this->add_control('box_icon_color', [
            'label' => __('رنگ آیکون باکس'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ultra-why-us .box-side .the-box svg' => 'fill: {{VALUE}}'],
        ]);

        $this->add_control('box_title_color', [
            'label' => __('رنگ عنوان باکس'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ultra-why-us .the-box .title' => 'color: {{VALUE}}'],
        ]);

        $this->add_control('box_desc_color', [
            'label' => __('رنگ توضیح باکس'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ultra-why-us .the-box .desc' => 'color: {{VALUE}}'],
        ]);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
        <section class="ultra-why-us">
            <div class="text-side">
                <div class="why-us">
                    <span class="why"><?php echo esc_html($settings['text_why']); ?></span>
                    <span class="website"><?php echo esc_html($settings['text_website']); ?></span>
                </div>
                <p><?php echo esc_html($settings['description_text']); ?></p>
            </div>
            <div class="box-side">
                <?php foreach ($settings['items'] as $item) : ?>
                    <div class="the-box">
                        <?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true']); ?>
                        <span class="title"><?php echo esc_html($item['title']); ?></span>
                        <span class="desc"><?php echo esc_html($item['desc']); ?></span>
                    </div>
                <?php endforeach; ?>
            </div>
        </section>
        <?php
    }
}