<?php

class Elementor_ultra_suggest_product_sell extends \Elementor\Widget_Base
{


    public function get_name()
    {
        return 'ultra_suggest_product_sell';
    }

    public function get_title()
    {
        return 'محصولات پیشنهادی';
    }

    public function get_icon()
    {
        return 'eicon-single-product';
    }

    public function get_categories()
    {
        return ['ultra'];
    }

    public function get_keywords()
    {
        return ['product', 'suggest'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('المان محصولات', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'icon',
            [
                'label' => esc_html__('آیکون', 'textdomain'),
                'type' => \Elementor\Controls_Manager::ICONS,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => 'عنوان',
                'type' => \Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'placeholder' => 'پرفروش ترین ها',
            ]
        );
        $this->add_control(
            'hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'title_best',
            [
                'label' => 'عنوان پرفروش ترین محصول',
                'type' => \Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'placeholder' => 'پرفروش ترین محصول',
            ]
        );
        $this->add_control(
            'icon_best',
            [
                'label' => esc_html__('آیکون پرفروش ترین محصول', 'textdomain'),
                'type' => \Elementor\Controls_Manager::ICONS,
            ]
        );

        $this->end_controls_section();
        /**
         * Start Style
         */
//         $this->start_controls_section(
//             'definition_list_styles',
//             [
//                 'label' => __('استایل محصولات', 'demo-elementor-widget'),
//                 'tab' => \Elementor\Controls_Manager::TAB_STYLE,
//             ]
//         );
//     $this->add_group_control(
//     \Elementor\Group_Control_Background::get_type(),
//     [
//         'name' => 'background',
//         'types' => ['classic', 'gradient', 'video'],
//         'selector' => '{{WRAPPER}} .suggest-product .main-suggest-prod, {{WRAPPER}} .suggest-product .main-suggest-prod .add-btn a',
//     ]
// );
//         $this->end_controls_section();
$this->start_controls_section(
    'style_best_product_section',
    [
        'label' => __('استایل پرفروش‌ترین محصول', 'textdomain'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    ]
);

$this->add_control(
    'best_title_color',
    [
        'label' => 'رنگ عنوان محصول',
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .main-suggest-prod h2' => 'color: {{VALUE}}',
        ],
    ]
);

$this->add_control(
    'best_counter_color',
    [
        'label' => 'رنگ شمارنده',
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .main-suggest-prod .num' => 'color: {{VALUE}}',
        ],
    ]
);

$this->add_control(
    'best_counter_bg',
    [
        'label' => 'پس‌زمینه شمارنده',
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .main-suggest-prod .num' => 'background-color: {{VALUE}}',
        ],
    ]
);

$this->add_control(
    'best_price_color',
    [
        'label' => 'رنگ قیمت محصول',
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .main-suggest-prod .price del, .suggest-product .main-suggest-prod .price' => 'color: {{VALUE}}',
        ],
    ]
);

$this->add_control(
    'best_price_sale_color',
    [
        'label' => 'رنگ قیمت تخفیف‌خورده',
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .main-suggest-prod .price ins' => 'color: {{VALUE}}',
        ],
    ]
);

$this->end_controls_section();
$this->start_controls_section(
    'style_other_products_section',
    [
        'label' => __('استایل سایر محصولات', 'textdomain'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    ]
);

$this->add_control(
    'list_bg_color',
    [
        'label' => 'رنگ پس‌زمینه محصول',
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .list-suggest-prod .list-item' => 'background-color: {{VALUE}}',
        ],
    ]
);

$this->add_control(
    'list_title_color',
    [
        'label' => 'رنگ عنوان محصول',
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .list-suggest-prod .prod-info h3' => 'color: {{VALUE}}',
        ],
    ]
);

$this->add_control(
    'list_counter_bg',
    [
        'label' => 'پس‌زمینه شمارنده',
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .list-suggest-prod .num' => 'background-color: {{VALUE}}',
        ],
    ]
);

$this->add_control(
    'list_counter_color',
    [
        'label' => 'رنگ شمارنده',
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .list-suggest-prod .num' => 'color: {{VALUE}}',
        ],
    ]
);

$this->add_control(
    'list_price_color',
    [
        'label' => 'رنگ قیمت',
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .list-suggest-prod .price del, .suggest-product .list-suggest-prod .list-item .price' => 'color: {{VALUE}}',
        ],
    ]
);

$this->add_control(
    'list_price_sale_color',
    [
        'label' => 'رنگ قیمت تخفیف‌خورده',
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .list-suggest-prod .price ins' => 'color: {{VALUE}}',
        ],
    ]
);

$this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>

        <section class="suggest-product">
            <?php if ($settings['title']): ?>
                <div class="title-product">
                    <?php
                    if ($settings['icon']['value']) {
                        echo '<i class="' . esc_attr($settings['icon']['value']) . '"></i>'; ?>
                        <h2><?php echo $settings['title'] ?> </h2>
                    <?php } else { ?>
                        <img src="<?php echo get_template_directory_uri() . '/assets/image/Frame 370.png' ?>"
                             alt="محصولات پیشنهادی">
                        <h2><?php echo $settings['title'] ?></h2>
                    <?php } ?>
                </div>
            <?php endif; ?>

            <div class="s-p-content">
                <?php

                $pro = new WP_Query(array(
                    'post_type' => 'product',
                    'posts_per_page' => 1,
                    'no_found_rows' => 1,
                    'meta_key' => 'total_sales',
                    'orderby' => 'meta_value_num',
                ));

                if ($pro->have_posts()) {
                    while ($pro->have_posts()) : $pro->the_post();
                        global $product;
                        ?>
                        <div class="main-suggest-prod">
                            <div class="head-s-prod">
                                <?php if ($settings['icon_best']['value']) {
                                    echo '<i class="' . esc_attr($settings['icon_best']['value']) . '"></i>';
                                } ?>
                                <span><?php if ($settings['title_best']) {
                                        echo $settings['title_best'];
                                    } else {
                                        echo "پرفروش ترین محصول";
                                    } ?></span>
                                <span class="num">#1</span>
                            </div>
                            <figure class="pulse-suugest-ultra frame-img ">
                                <img class="rotate-suggest-ultra" src="<?php echo get_the_post_thumbnail_url(); ?>"
                                     alt="">
                            </figure>
                            <h2><?php the_title(); ?></h2>
                            <?php if ($product->is_in_stock() && $product->get_price_html()) { ?>
                            <div class="price">
                                <?php echo $product->get_price_html(); ?>
                            </div>
                        <?php } elseif (!$product->is_in_stock()) {
                            echo "<div class='not_stock'>موجود نیست !</div>";
                        } else {
                            echo "<div class='no_price'>تماس بگیرید !</div>";
                        }
                        ?>
                            <div class="add-btn">
                                <a href="<?php the_permalink();?>">+</a>
                            </div>

                        </div>
                    <?php
                    endwhile;
                } else {
                    echo "<p>مطلبی پیدا نشد</p>";
                }
                wp_reset_postdata();
                ?>
                <div class="list-suggest-prod">
                    <?php
                    $n = 1;

                    $pro = new WP_Query(array(
                        'post_type' => 'product',
                        'posts_per_page' => 9,
                        'offset' => 1,
                        'no_found_rows' => 1,
                        'meta_key' => 'total_sales',
                        'orderby' => 'meta_value_num',
                    ));

                    if ($pro->have_posts()) {
                        while ($pro->have_posts()) : $pro->the_post();
                            global $product;
                            ?>
                            <a href="<?php the_permalink(); ?>" class="list-item">
                                <?php echo the_post_thumbnail(); ?>
                                <div class="prod-info">
                                    <h3><?php the_title(); ?></h3>

                                    <div class="desc-prod">
                                <span class="num"><?php
                                    $n = $n + 1;
                                    echo $n;
                                    ?></span>
                                        <?php if ($product->is_in_stock() && $product->get_price_html()) { ?>
                            <div class="price">
                                <?php echo $product->get_price_html(); ?>
                            </div>
                        <?php } elseif (!$product->is_in_stock()) {
                            echo "<div class='not_stock'>موجود نیست !</div>";
                        } else {
                            echo "<div class='no_price'>تماس بگیرید !</div>";
                        }
                        ?>
                                    </div>
                                </div>
                            </a>
                        <?php
                        endwhile;
                    } else {
                        echo "<p>مطلبی پیدا نشد</p>";
                    }
                    wp_reset_postdata();
                    ?>
                </div>

            </div>

        </section>

        <?php
    }
}