<?php

class Elementor_ultra_story_widget extends \Elementor\Widget_Base
{


    public function get_name()
    {
        return 'ultra_story';
    }


    public function get_title()
    {
        return 'استوری';
    }

    public function get_icon()
    {
        return 'eicon-counter-circle';
    }


    public function get_categories()
    {
        return ['ultra'];
    }

    public function get_keywords()
    {
        return ['story'];
    }


    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('استوری', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'title',
            [
                'label' => __('عنوان'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => '',
                'default' => 'اولترا',
            ]
        );
        $repeater->add_control(
            'img_pre',
            [
                'label' => 'تصویر کوچک پیشنمایش استوری',
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );
        $repeater->add_control(
            'time',
            [
                'label' => 'مدت زمان هر استوری (ثانیه)',
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 600,
                'step' => 1,
                'default' => 5,
            ]
        );
        $repeater->add_control(
            'hr_story',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $repeater->add_control(
            'type',
            [
                'label' => 'محتوای استوری',
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'image' => [
                        'title' => 'عکس',
                        'icon' => 'eicon-image-bold',
                    ],
                    'video' => [
                        'title' => 'ویدئو',
                        'icon' => 'eicon-video-camera',
                    ],
                ],
                'default' => 'image',
                'toggle' => false,
            ]
        );
        $repeater->add_control(
            'gallery',
            [
                'label' => 'عکس های استوری',
                'type' => \Elementor\Controls_Manager::GALLERY,
                'show_label' => false,
                'default' => [],
                'condition' => [
                    'type' => 'image',
                ],
            ]
        );
        $repeater->add_control(
            'link_video',
            [
                'label' => 'لینک ویدیو',
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '',
                    'is_external' => false,
                    'nofollow' => false,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
                'condition' => [
                    'type' => 'video',
                ],
            ]
        );
        $repeater->add_control(
            'hr_story2',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $repeater->add_control(
            'title_btn',
            [
                'label' => 'متن دکمه لینک استوری',
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => '',
                'default' => 'کلیک کنید',
            ]
        );
        $repeater->add_control(
            'link_story',
            [
                'label' => 'لینک استوری',
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => false,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );


        $this->add_control(
            'stories',
            [
                'label' => 'استوری',
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'title' => 'اولترا مارکت',
                    ],
                ],
                'title_field' => 'استوری',
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $stories = $settings['stories'];
        ?>
        <section class="story-box">
            <div id="stories" class="storiesWrapper"></div>
            <script src="<?php echo get_template_directory_uri() . '/assets/js/zuck.js' ?>"></script>
            <script src="<?php echo get_template_directory_uri() . '/assets/js/script.js' ?>"></script>
            <script>
                var currentSkin = getCurrentSkin();
                var stories = window.Zuck(document.querySelector('#stories'), {
                    backNative: true,
                    previousTap: true,

                    skin: currentSkin['name'],
                    autoFullScreen: currentSkin['params']['autoFullScreen'],
                    avatars: currentSkin['params']['avatars'],
                    paginationArrows: currentSkin['params']['paginationArrows'],
                    list: currentSkin['params']['list'],
                    cubeEffect: currentSkin['params']['cubeEffect'],
                    localStorage: true,
                    stories: [
                        <?php foreach ($stories as $story) : ?>
                        {
                            id: "<?php echo $story['_id']; ?>",
                            photo:
                                "<?php echo $story['img_pre']['url']; ?>",
                            name: "<?php echo $story['title']; ?>",
                            time: timestamp(),
                            items: [
                                <?php if ( $story['type'] == 'image' ){ ?>
                                <?php foreach ($story['gallery'] as $gallery) : ?>
                                {
                                    id: "<?php echo $story['_id'] . "-" . $gallery['id']; ?>",
                                    type: 'photo',
                                    length: <?php echo $story['time']; ?>,
                                    src: "<?php echo $gallery['url']; ?>",
                                    preview: "<?php echo $gallery['url']; ?>",
                                    link: "<?php echo $story['link_story']['url']; ?>",
                                    linkText: "<?php echo $story['title_btn']; ?>",

                                    time: timestamp()
                                },
                                <?php endforeach;
                                } else { ?>
                                {
                                    id: "<?php echo $story['_id'] . rand(); ?>",
                                    type: 'video',
                                    length: 0,
                                    src: "<?php echo $story['link_video']['url']; ?>",
                                    preview: "<?php echo $story['img_pre']['url']; ?>",
                                    link: "<?php echo $story['link_story']['url']; ?>",
                                    linkText: "<?php echo $story['title_btn']; ?>",

                                    time: timestamp()
                                },
                                <?php } ?>
                            ]
                        },
                        <?php endforeach; ?>
                    ]
                });
            </script>
        </section>
        <?php
    }

}