<?php

class Elementor_ultra_product_soptlight_widget_el extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'ultra_product_soptlight_widget_elementor';
    }

    public function get_title()
    {
        return 'اسلایدر محصولات فروش ویژه طرح خاص';
    }

    public function get_icon()
    {
        return 'eicon-spacer';
    }

    public function get_categories()
    {
        return ['ultra'];
    }

    public function get_keywords()
    {
        return ['product', 'special'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('المان محصولات', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'post_number',
            [
                'label' => 'شامل محصولات',
                'description' => 'شناسه های محصول را با کاما انگلیسی جدا کنید.',
                'type' => \Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'placeholder' => '25,28,36',
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => 'عنوان',
                'type' => \Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'placeholder' => 'فروش ویژه',
                'default' => 'فروش ویژه',
            ]
        );

        $this->end_controls_section();
        /**
         * Start Style
         */
        $this->start_controls_section(
            'definition_list_styles',
            [
                'label' => __('استایل محصولات', 'demo-elementor-widget'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'color_best_sell',
            [
                'label' => esc_html__('رنگ پس زمینه دکمه '),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FFBB91', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .best-selling .best-selling-box .banner-side span, {{WRAPPER}} .best-selling .best-selling-box .banner-side a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .best-selling .product-side .buttom-side .view-btn .view' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'hr1',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $post_in = explode(',', $settings['post_number']);
        ?>
        <section class="ultra-product-soptlight">
			<h3 class="mobile-title"><?php echo $settings['title']; ?></h3>
            <div class="owl-carousel owl-theme ultra-product-soptlight_slider ">
                <?php
                $choosen_product = new WP_Query(array(
                    'post_type' => 'product',
                    'no_found_rows' => true,
                    'post__in' => $post_in,
                ));
                if ($choosen_product->have_posts()) {
                    while ($choosen_product->have_posts()) : $choosen_product->the_post(); ?>

                        <div class="item">
                            <div class="product-content">
                                <h3><?php echo $settings['title']; ?></h3>
                                <h4><?php the_title(); ?></h4>
                                <?php
                                global $product;
                                $full_excerpt = get_the_excerpt();
                                $short_excerpt = wp_html_excerpt($full_excerpt, 100, '...');
                                ?>
                                <p><?php echo esc_html($short_excerpt); ?></p>
                                <div class="bottom-section">
                                    <a href="<?php the_permalink(); ?>">
                                        <span>اطلاعات بیشتر</span>
                                    </a>
                                    <div class="box-price">
                                        <?php
                                        $discount_percent = function_exists('ultra_woocommerce_discount') ? ultra_woocommerce_discount(get_the_ID()) : 0;
                                        if ($product->is_in_stock() && $product->get_price_html()) { ?>
                                            <div class="price">
                                                <?php echo $product->get_price_html(); ?>
                                            </div>
                                        <?php } elseif (!$product->is_in_stock()) { ?>
                                            <span class="not_stock">ناموجود</span>
                                        <?php } else { ?>
                                            <div class="no_price">
                                                <span>تماس بگیرید</span>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="15"
                                                     height="15"
                                                     viewBox="0 0 15 15" fill="none">
                                                    <path d="M3.48438 1.25C4.09773 1.25 4.64916 1.62387 4.87695 2.19336L5.4873 3.71875C5.77691 4.44301 5.46326 5.2683 4.76562 5.61719L4.5 5.75C4.5 5.75 4.875 7.625 6.375 9.125C7.875 10.625 9.75 11 9.75 11L9.88281 10.7344C10.2317 10.0367 11.057 9.72309 11.7812 10.0127L13.3066 10.623C13.8761 10.8508 14.25 11.4023 14.25 12.0156V13.25C14.25 14.0784 13.5784 14.75 12.75 14.75C6.12258 14.75 0.75 9.37742 0.75 2.75C0.75 1.92157 1.42157 1.25 2.25 1.25H3.48438Z"
                                                          fill="white"/>
                                                </svg>
                                            </div>
                                        <?php } ?>
                                        <?php if ($product->is_on_sale()): ?>
                                            <span class="sale">
                                                                    <span class="num"><?php echo ultra_woocommerce_discount(get_the_ID()); ?></span>
                                                                    <span class="sale-symbol">%</span>
                                                                </span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
							<div class="image-box">
                            <?php
                            $gallery_ids = $product->get_gallery_image_ids();
                            if (!empty($gallery_ids)) : ?>
                                <div class="ultra-product-gallery"
                                     style="display: flex; flex-direction: column; height: auto; max-height:380px; overflow:hidden;">
                                    <?php foreach ($gallery_ids as $attachment_id) : ?>
                                        <div class="gallery-item"
                                             style="width:80px; height: 80px; margin:5px 0;">
                                            <?php
                                            echo wp_get_attachment_image($attachment_id, 'soptlight');
                                            ?>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>
                            <figure>
                                <?php if (has_post_thumbnail()) {
                                    the_post_thumbnail('product');
                                } else { ?>
                                    <img src="<?php echo get_template_directory_uri() . '/assets/image/empty.webp'; ?>"
                                         alt="بدون تصویر">
                                <?php } ?>
                            </figure>
							</div>
                        </div>

                    <?php
                    endwhile;
                }
                wp_reset_postdata();
                ?>
            </div>
        </section>
        <script>
            jQuery(document).ready(function ($) {
                $('.ultra-product-soptlight_slider').owlCarousel({
                    loop: true,
                    margin: 10,
                    nav: true,
                    dots: true,
                    rtl: true,
                    responsive: {
                        0: {
                            items: 1
                        },
                        600: {
                            items: 1
                        },
                        1400: {
                            items: 1
                        },
                        1500: {
                            items: 1
                        }
                    }
                });
            });
        </script>
        <?php
    }
}