<?php

class Elementor_ultra_product_amazing2 extends \Elementor\Widget_Base
{


    public function get_name()
    {
        return 'ultra_product_amazing2';
    }

    public function get_title()
    {
        return 'محصولات فروش ویژه طرح 2';
    }

    public function get_icon()
    {
        return 'eicon-product-rating';
    }

    public function get_categories()
    {
        return ['ultra'];
    }

    public function get_keywords()
    {
        return ['product', 'sale', 'amazing'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => 'تنظیمات عمومی ویجت',
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'alert_product_amazing',
            [
                'type' => \Elementor\Controls_Manager::ALERT,
                'alert_type' => 'warning',
                'heading' => esc_html__('نمایش تایمر محصولات دارای تخفیف'),
                'content' => esc_html__('تایمر معکوس محصولات در خروجی نمایش داده میشود.( در حالت ویرایش المنتور نمایش داده نمیشود.)'),
            ]
        );

        $this->add_control(
            'sale_title',
            [
                'label' => 'عنوان تخفیفات شگفــــت انگیـــــــــز',
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'تخفیفات شگفــــت انگیـــــــــز',
                'placeholder' => 'مثلاً: فرصت‌های استثنایی امروز!',
            ]
        );

        $this->add_control(
            'image_amazing',
            [
                'label' => 'تصویر عنوان',
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => get_template_directory_uri() . '/assets/image/image-sale.svg',
                ],
            ]
        );

        $this->add_control(
            'show_all_text',
            [
                'label' => 'متن دکمه مشاهده همه',
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'مشاهده همه',
            ]
        );

        $this->add_control(
            'link',
            [
                'label' => 'لینک دکمه',
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => false,
                ],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'posts_per_page',
            [
                'label' => 'تعداد محصولات قابل نمایش',
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 6,
            ]
        );

        $this->add_control(
            'critical_days',
            [
                'label' => 'تغییر رنگ تایمر',
                'type' => \Elementor\Controls_Manager::NUMBER,
                'description' => 'اگر تعداد روزهای باقی‌مانده کمتر از این عدد باشد، تایمر به رنگ قرمز نمایش داده می‌شود.',
                'default' => 3,
                'min' => 1,
            ]
        );
        $this->add_control(
            'show_special_sale',
            [
                'label'        => esc_html__( 'نمایش فروش ویژه'),
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'label_on'     => esc_html__( 'روشن' ),
                'label_off'    => esc_html__( 'خاموش' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        $this->end_controls_section();

        /*─────────────────────────────*/
        /*         STYLE TAB           */
        /*─────────────────────────────*/
        $this->start_controls_section(
            'style_section',
            [
                'label' => 'استایل کلی ویجت',
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

// Text color for widget title
        $this->add_control(
            'widget_title_color',
            [
                'label' => 'رنگ عنوان',
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ultra-product-sale-in-timer .banner span' => 'color: {{VALUE}}',
                ],
            ]
        );

// Background image for the entire widget wrapper
        $this->add_control(
            'widget_background_image',
            [
                'label' => 'تصویر پس‌زمینه کلی ویجت',
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => get_template_directory_uri() . "/assets/image/Rectangle 1102.svg",
                ],
                'selectors' => [
                    '{{WRAPPER}} .ultra-product-sale-in-timer' => 'background-image: url({{URL}}); background-size:cover; background-repeat:no-repeat;',
                ],
            ]
        );

// Text color for product title
        $this->add_control(
            'product_title_color',
            [
                'label' => 'رنگ نام محصول',
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ultra-product-sale-in-timer h3' => 'color: {{VALUE}}',
                ],
            ]
        );

// Price text color
        $this->add_control(
            'price_text_color',
            [
                'label' => 'رنگ قیمت',
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ultra-product-sale-in-timer .box-price .price' => 'color: {{VALUE}}',
                ],
            ]
        );

// Discount badge background
        $this->add_control(
            'discount_badge_color',
            [
                'label' => 'رنگ تخفیف',
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ultra-product-sale-in-timer .box-price .sale' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'discount_badge_background',
            [
                'label' => 'رنگ پس‌زمینه تخفیف',
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ultra-product-sale-in-timer .box-price .sale' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        ?>
        <section class="ultra-product-sale-in-timer">

            <div class="banner-side">
                <div class="banner">
                    <?php if ($settings['image_amazing']) {
                        ?><img src="<?php echo $settings['image_amazing']['url'] ?>"><?php
                    } else {
                        ?><img src="<?php echo get_template_directory_uri() . '/assets/image/image-sale.svg'; ?>"
                               alt="محصولات شگفت انگیز">
                    <?php } ?>
                    <span><?php echo esc_html($settings['sale_title']); ?></span>
                </div>
                <?php
                $target = $settings['link']['is_external'] ? 'target="_blank"' : '';
                $nofollw = $settings['link']['nofollow'] ? 'rel="nofollow"' : '';
                ?>
                <?php if ($settings['show_all_text']) { ?>
                    <a href="<?php echo $settings['link']['url'];
                    echo $target, $nofollw ?>" class="view-all">
                        <span><?php echo esc_html($settings['show_all_text']); ?></span>
                        <svg xmlns="http://www.w3.org/2000/svg" width="25" height="24"
                             viewBox="0 0 25 24" fill="none">
                            <path d="M10.5 16L6.5 12M6.5 12L10.5 8M6.5 12L18.5 12" stroke="#28303F"
                                  stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                    </a>
                <?php } ?>
            </div>

            <div class="product-box">
				
				    <div class="skeleton-slider">
       <div class="skeleton-item">
    <div class="skeleton-image"></div>
    <div class="skeleton-title"></div>
    <div class="skeleton-price"></div>
</div>
		<div class="skeleton-item">
    <div class="skeleton-image"></div>
    <div class="skeleton-title"></div>
    <div class="skeleton-price"></div>
</div>
		<div class="skeleton-item">
    <div class="skeleton-image"></div>
    <div class="skeleton-title"></div>
    <div class="skeleton-price"></div>
</div>
    </div>
				
                <div class="owl-carousel owl-theme ultra-product-sale-in-timer_slider ">
                    <?php
                    $choosen_product = new WP_Query(array(
                        'post_type' => 'product',
                        'posts_per_page' => $settings['posts_per_page'],
                        'no_found_rows' => true,
                        'meta_query' => array(
                            array(
                                'key' => 'status_timer_offer',
                                'value' => 'yes',
                                'compare' => '=',
                            ),
                        ),
                    ));

                    if ($choosen_product->have_posts()) :
                        while ($choosen_product->have_posts()) : $choosen_product->the_post();
                            global $product;
                            ?>
                            <div class="item">
                                <figure class="image-section">
                                    <?php
                                    $show_special = $settings['show_special_sale'];
                                    if ( 'yes' === $show_special && $product->is_on_sale() && $product->is_in_stock() ) { ?>
                                    <div class="on-sale">
                                        <span>فروش ویژه</span>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                                            <path d="M16.6666 12.5025C16.6666 16.0479 14.4848 17.6036 12.7989 18.1283C12.4394 18.2401 12.2031 17.821 12.4182 17.512C13.1518 16.4576 13.9999 14.849 13.9999 13.3358C13.9999 11.7103 12.6299 9.7912 11.56 8.60754C11.3154 8.33693 10.8888 8.51599 10.8755 8.88051C10.8313 10.0882 10.6407 11.7039 9.81894 12.9702C9.68667 13.1741 9.40588 13.191 9.25517 13.0004C8.99841 12.6756 8.74165 12.2745 8.48489 11.9576C8.34659 11.7869 8.09662 11.7846 7.93709 11.9356C7.31513 12.5245 6.44436 13.4429 6.44436 14.5858C6.44436 15.4102 6.83724 16.4363 7.24223 17.2308C7.42614 17.5917 7.08495 18.0149 6.73444 17.812C5.20457 16.9265 3.33325 15.0915 3.33325 12.5025C3.33325 9.88041 6.92516 6.24814 8.29663 2.81654C8.51304 2.27505 9.17999 2.02061 9.64387 2.37397C12.4532 4.51402 16.6666 8.65088 16.6666 12.5025Z" fill="white" stroke="white" stroke-width="0.833333"/>
                                        </svg>
                                    </div>
                                    <?php }
                                     if (has_post_thumbnail()) {
                                        the_post_thumbnail('product');
                                    } else { ?>
                                        <img src="<?php echo get_template_directory_uri() . '/assets/image/empty.webp'; ?>"
                                             alt="بدون تصویر">
                                    <?php } ?>
                                </figure>

                                <a href="<?php the_permalink(); ?>"><h3><?php the_title(); ?></h3>
                                </a>
                                <div class="middle-section">
                                    <?php $terms = get_the_terms($product->get_id(), 'product_cat'); ?>
                                    <a class="category"
                                       href="<?php echo get_term_link($terms[0]->term_id); ?>"
                                       target="_blank"><?php echo esc_html($terms[0]->name); ?></a>
                                    <span class="rate">
                                                            <?php
                                                            $average = $product->get_average_rating();
                                                            $count = $product->get_rating_count();
                                                            ?>
                                                            <span class="count">(<?php echo number_format_i18n($count); ?>)</span>
                                                            <span><?php echo $average > 0 ? number_format($average, ($average - floor($average) > 0 ? 1 : 0)) : '0'; ?></span>
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="12" height="13"
                                                             viewBox="0 0 12 13" fill="none">
                                                            <path
                                                                    d="M4.57658 3.20419C5.20991 2.06806 5.52657 1.5 6 1.5C6.47343 1.5 6.79009 2.06806 7.42342 3.20419L7.58727 3.49812C7.76724 3.82097 7.85722 3.98239 7.99753 4.0889C8.13783 4.19541 8.31257 4.23495 8.66206 4.31402L8.98023 4.38601C10.2101 4.66428 10.825 4.80341 10.9713 5.27387C11.1176 5.74432 10.6984 6.23454 9.85995 7.21496L9.64304 7.46861C9.40479 7.74722 9.28566 7.88652 9.23207 8.05886C9.17848 8.23119 9.19649 8.41706 9.23251 8.78878L9.2653 9.1272C9.39206 10.4353 9.45544 11.0894 9.07243 11.3801C8.68941 11.6709 8.11366 11.4058 6.96216 10.8756L6.66426 10.7384C6.33704 10.5878 6.17343 10.5124 6 10.5124C5.82657 10.5124 5.66296 10.5878 5.33574 10.7384L5.03784 10.8756C3.88634 11.4058 3.31059 11.6709 2.92757 11.3801C2.54456 11.0894 2.60794 10.4353 2.7347 9.1272L2.76749 8.78878C2.80351 8.41706 2.82152 8.23119 2.76793 8.05886C2.71434 7.88652 2.59521 7.74722 2.35696 7.46861L2.14005 7.21496C1.30162 6.23454 0.882412 5.74432 1.02871 5.27387C1.17501 4.80341 1.78993 4.66428 3.01977 4.38601L3.33794 4.31402C3.68743 4.23495 3.86217 4.19541 4.00247 4.0889C4.14278 3.98239 4.23276 3.82097 4.41273 3.49812L4.57658 3.20419Z"
                                                                    fill="#F58D70"/>
                                                        </svg>
                                                        </span>
                                </div>

                                <?php get_template_part('template/index/box-timer'); ?>

                                <?php
                                $discount_percent = function_exists('ultra_woocommerce_discount') ? ultra_woocommerce_discount(get_the_ID()) : 0;
                                ?>
                                <div class="box-price">
                                    <?php if ($product->is_in_stock() && $product->get_price_html()) { ?>
                                        <div class="price">
                                            <?php echo $product->get_price_html(); ?>
                                        </div>
                                    <?php } elseif (!$product->is_in_stock()) { ?>
                                        <span class="not_stock">ناموجود</span>
                                    <?php } else { ?>
                                        <div class="no_price">
                                            <span>تماس بگیرید</span>
                                            <svg xmlns="http://www.w3.org/2000/svg" width="15"
                                                 height="15"
                                                 viewBox="0 0 15 15" fill="none">
                                                <path d="M3.48438 1.25C4.09773 1.25 4.64916 1.62387 4.87695 2.19336L5.4873 3.71875C5.77691 4.44301 5.46326 5.2683 4.76562 5.61719L4.5 5.75C4.5 5.75 4.875 7.625 6.375 9.125C7.875 10.625 9.75 11 9.75 11L9.88281 10.7344C10.2317 10.0367 11.057 9.72309 11.7812 10.0127L13.3066 10.623C13.8761 10.8508 14.25 11.4023 14.25 12.0156V13.25C14.25 14.0784 13.5784 14.75 12.75 14.75C6.12258 14.75 0.75 9.37742 0.75 2.75C0.75 1.92157 1.42157 1.25 2.25 1.25H3.48438Z"
                                                      fill="white"/>
                                            </svg>
                                        </div>
                                    <?php } ?>

                                    <?php if ($product->is_on_sale() && !empty($discount_percent) && $discount_percent > 0 && $product->is_in_stock()) : ?>
                                        <span class="sale">
                                                                <span class="num"><?php echo esc_html($discount_percent); ?></span>
                                                                <span class="sale-symbol">%</span>
                                                            </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php
                        endwhile;
                    endif;
                    wp_reset_postdata();
                    ?>

                </div>


            </div>


        </section>

        <script>


jQuery(function ($) {

  function initSlider($slider) {
    const $skeleton = $slider.siblings('.skeleton-slider');

    $slider
      .css({ visibility: 'hidden', display: 'block' }) // بازگشت موقت
      .owlCarousel({
        loop: true,
        margin: 20,
        rtl: true,
        dots: false,
        nav: false,
        autoWidth: true
      });

    setTimeout(function () {
      $skeleton.fadeOut(200);
      $slider
        .css('visibility', 'visible')
        .fadeIn(200);
    }, 150);
  }

  $('.ultra-product-sale-in-timer_slider').each(function () {
    const $slider = $(this);
    const $skeleton = $slider.siblings('.skeleton-slider');

    $slider.hide();
    $skeleton.show();
    initSlider($slider);

    let resizeTimer;
    $(window).on('resize', function () {
      clearTimeout(resizeTimer);
      resizeTimer = setTimeout(function () {

        if ($slider.hasClass('owl-loaded')) {
          $slider.trigger('destroy.owl.carousel');
          $slider.removeClass('owl-loaded owl-hidden');
          $slider.find('.owl-stage-outer').children().unwrap();
        }

        $slider.hide().css('visibility', 'hidden');
        $skeleton.show();

        initSlider($slider);
      }, 300);
    });
  });

});


             
            document.addEventListener('DOMContentLoaded', function () {
                const countdownElements = document.querySelectorAll('.box-timer');

                countdownElements.forEach(function (countdownElement) {
                    const daysEl = countdownElement.querySelector('.days-value');
                    const hoursEl = countdownElement.querySelector('.hours-value');
                    const minutesEl = countdownElement.querySelector('.minutes-value');
                    const secondsEl = countdownElement.querySelector('.seconds-value');
                    const selector = countdownElement.dataset.targetSelector;
                    const target = countdownElement.querySelector(selector);

                    const targetDate = new Date(
                        parseInt(countdownElement.dataset.targetYear),
                        parseInt(countdownElement.dataset.targetMonth) - 1,
                        parseInt(countdownElement.dataset.targetDay),
                        parseInt(countdownElement.dataset.targetHour),
                        parseInt(countdownElement.dataset.targetMinute),
                        parseInt(countdownElement.dataset.targetSecond)
                    );

                    function updateTimer() {
                        const now = new Date().getTime();
                        const timeRemaining = targetDate - now;

                        const days = Math.floor(timeRemaining / (1000 * 60 * 60 * 24));
                        const hours = Math.floor((timeRemaining % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                        const minutes = Math.floor((timeRemaining % (1000 * 60 * 60)) / (1000 * 60));
                        const seconds = Math.floor((timeRemaining % (1000 * 60)) / 1000);

                        daysEl.textContent = days;
                        hoursEl.textContent = hours;
                        minutesEl.textContent = minutes;
                        secondsEl.textContent = seconds;

                        // ✅ اینجا کلاس expired رو اضافه کن
                        <?php $days_user = isset($settings['critical_days']) ? (int)$settings['critical_days'] : 3; ?>
                        if (days <= <?php echo $days_user; ?>) {
                            if (target && !target.classList.contains('expired')) {
                                target.classList.add('expired');
                                console.log('✅ کلاس expired اضافه شد به', target);
                            }
                        }

                        if (timeRemaining > 0) {
                            setTimeout(updateTimer, 1000);
                        }
                    }

                    updateTimer();
                });
            });
        </script>


        <?php
    }
}