<?php

class Elementor_ultra_product_amazing extends \Elementor\Widget_Base
{


    public function get_name()
    {
        return 'ultra_product_amazing';
    }

    public function get_title()
    {
        return 'محصولات فروش ویژه';
    }

    public function get_icon()
    {
        return 'eicon-product-rating';
    }

    public function get_categories()
    {
        return ['ultra'];
    }

    public function get_keywords()
    {
        return ['product', 'sale', 'amazing'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => 'تنظیمات محتوا',
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'alert_product_amazing',
            [
                'type' => \Elementor\Controls_Manager::ALERT,
                'alert_type' => 'warning',
                'heading' => esc_html__( 'نمایش تایمر محصولات' ),
                'content' => esc_html__( 'تایمر معکوس محصولات در خروجی نمایش داده میشود.'),
            ]
        );

        $this->add_control(
            'sale_title',
            [
                'label' => 'عنوان فروش ویژه',
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'شگفت انگیز ها',
                'placeholder' => 'عنوانی وارد کنید',
            ]
        );
        $this->add_control(
            'image_amazing',
            [
                'label' => esc_html__( 'تصویر فروش ویژه', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => get_template_directory_uri()."/assets/image/sale.svg",
                ],
            ]
        );
        $this->add_control(
            'show_all_text',
            [
                'label' => 'متن دکمه مشاهده همه',
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'مشاهده همه',
            ]
        );
        $this->add_control(
            'link',
            [
                'label' => 'لینک',
                'type' => \Elementor\Controls_Manager::URL,
                'options' => [ 'url', 'is_external', 'nofollow' ],
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => false,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]

        );

        $this->add_control(
            'posts_per_page',
            [
                'label' => 'تعداد محصولات',
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 5,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'definition_list_styles',
            [
                'label'  => __( 'استایل', 'demo-elementor-widget' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_product_amazing',
            [
                'label' => esc_html__('رنگ متن محصولات شگفت انگیز'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .product-sale .sale-title span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_product_amazing',
            [
                'label' => esc_html__('رنگ متن دکمه محصولات شگفت انگیز'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .product-sale .sale-title a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .product-sale',
                'default' => [
                    'background' => 'gradient',
                    'color' => '#515070',
                    'color_b' => '#FFBB91',
                    'gradient_type' => 'linear',
                    'gradient_angle' => 230.35,
                    'gradient_position' => 'center center',
                ],
            ]
        );
        $this->add_control(
            'hr_amazing1',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'name_product_amazing',
            [
                'label' => esc_html__('رنگ متن محصول'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#515070', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .product-sale .sale-slider .item-content h3' => 'color: {{VALUE}}',
                ],
            ]
        );


        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        ?>
        <section class="product-sale">
            <div class="sale-title">
                <span><?php echo esc_html($settings['sale_title']); ?></span>
                <?php if ($settings['image_amazing']) {
                    ?><img src="<?php echo $settings['image_amazing']['url'] ?>"><?php
                }
                else {
                ?><img src="<?php echo get_template_directory_uri() . '/assets/image/sand.png'; ?>" alt="محصولات شگفت انگیز">
                <?php
                }
                $target = $settings['link']['is_external'] ? 'target="_blank"' : '';
                $nofollw = $settings['link']['nofollow'] ? 'rel="nofollow"' : '';
                ?>
                <a <?php echo $target,$nofollw ?> href="<?php echo $settings['link']['url']; ?>"><?php echo esc_html($settings['show_all_text']); ?></a>
            </div>
            <div class="sale-slider">
                <div class="owl-carousel owl-theme loop">
                    <?php
                    $choosen_product = new WP_Query(array(
                        'post_type' => 'product',
                        'posts_per_page' => $settings['posts_per_page'],
                        'no_found_rows' => true,
                        'meta_query' => array(
                            array(
                                'key' => 'status_timer_offer',
                                'value' => 'yes',
                                'compare' => '=',
                            ),
                        ),
                    ));

                    if ($choosen_product->have_posts()) :
                        while ($choosen_product->have_posts()) : $choosen_product->the_post();
                            global $product;
                            ?>
                            <div class="item">
                                <div class="item-content">
                                    <a href="<?php the_permalink(); ?>">
                                        <figure>
                                            <?php if (has_post_thumbnail()) {
                                                the_post_thumbnail('product');
                                            } else { ?>
                                                <img src="<?php echo get_template_directory_uri() . '/assets/image/empty.webp'; ?>"
                                                     alt="">
                                            <?php } ?>
                                        </figure>

                                        <?php if ($product->is_on_sale()) : ?>
                                            <div class="sale-image">
                                               <svg width="55px" height="40px" viewBox="0 0 112 73" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M102.419 41.4925L111.209 24.3437L96.8749 11.4984L80.325 0.00268555L54.6504 3.84369L0.60498 14.1263L11.3588 72.3025L65.7392 63.8317L91.0789 58.1786L102.419 41.4925ZM87.9999 36C92.4182 36 95.9999 32.4183 95.9999 28C95.9999 23.5818 92.4182 20 87.9999 20C83.5817 20 79.9999 23.5818 79.9999 28C79.9999 32.4183 83.5817 36 87.9999 36Z" fill="#FF8E6E"></path>
</svg>
                                                <span><?php echo ultra_woocommerce_discount(get_the_ID()); ?> % </span>
                                            </div>
                                        <?php endif; ?>

                                        <h3><?php the_title(); ?></h3>

                                        <?php if ($product->is_in_stock() && $product->get_price_html()) { ?>
                                            <div class="price-section">
                                                <?php echo $product->get_price_html(); ?>
                                            </div>
                                        <?php } elseif (!$product->is_in_stock()) { ?>
                                            <div class='not_stock'>موجود نیست !</div>
                                        <?php } else { ?>
                                            <div class='no_price'>تماس بگیرید !</div>
                                        <?php } ?>

                                        <?php get_template_part('template/index/timer'); ?>
                                    </a>
                                </div>
                            </div>
                        <?php
                        endwhile;
                    endif;
                    wp_reset_postdata();
                    ?>
                </div>
            </div>
        </section>

        <script>
            jQuery(document).ready(function ($) {
                $('.loop').owlCarousel({
                    center: false,
                    items: 1,
                    loop: true,
                    dots: false,
					nav:false,
                    margin: 10,
                    rtl: true,
                    responsive: {
						0 : {items: 1.2},
                        430: {items: 1.5},
                        570: {items: 2},
						670: {items: 2},
                        1024: {items: 2},
						1100: {items: 3},
                        1280: {items: 3},
						1366: {items: 3},
						1440: {items: 4},
                        1600: {items: 4},
						1800: {items: 4.8},
                    }
                });
            });
        </script>
        <?php
    }
}