<?php

class Elementor_ultra_minimal_product_widget extends \Elementor\Widget_Base
{


    public function get_name()
    {
        return 'ultra_minimal_product_widget';
    }


    public function get_title()
    {
        return 'شبکه ای کوچک محصول';
    }

    public function get_icon()
    {
        return 'eicon-product-add-to-cart';
    }


    public function get_categories()
    {
        return ['ultra'];
    }

    public function get_keywords()
    {
        return ['product'];
    }

    function get_product_cats()
    {
        $cat_list = [];
        $product_cats = get_terms(array(
            'taxonomy' => 'product_cat',
            'hide_empty' => true,
        ));

        if (!empty($product_cats) && !is_wp_error($product_cats)) {
            foreach ($product_cats as $cat) {
                $cat_list[$cat->term_id] = $cat->name;
            }
        }
        return $cat_list;
    }

    function get_product_tags()
    {
        $tag_list = [];
        $product_tags = get_terms('product_tag');

        if (!empty($product_tags) && !is_wp_error($product_tags)) {
            foreach ($product_tags as $tag) {
                $tag_list[$tag->term_id] = $tag->name;
            }
        }
        return $tag_list;
    }

    function get_product_brands()
    {
        $brand_list = [];
        $product_brands = get_terms('product_brand');

        if (!empty($product_brands) && !is_wp_error($product_brands)) {
            foreach ($product_brands as $brand) {
                $brand_list[$brand->term_id] = $brand->name;
            }
        }
        return $brand_list;
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('المان محصولات', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'product_filter',
            [
                'label' => 'فیلتر محصولات',
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'all',
                'options' => [
                    'all' => 'همه محصولات',
                    'category' => 'براساس دسته بندی',
                    'tag' => 'براساس برچسب',
                    'brand' => 'براساس برند',
                ],
            ]
        );
        $this->add_control(
            'cat',
            [
                'label' => 'دسته بندی',
                'type' => \Elementor\Controls_Manager::SELECT2,
                'multiple' => true,
                'label_block' => true,
                'options' => $this->get_product_cats(),
                'condition' => [
                    'product_filter' => 'category',
                ],
            ]
        );
        $this->add_control(
            'tag',
            [
                'label' => 'برچسب',
                'type' => \Elementor\Controls_Manager::SELECT2,
                'multiple' => true,
                'label_block' => true,
                'options' => $this->get_product_tags(),
                'condition' => [
                    'product_filter' => 'tag',
                ],
            ]
        );
        $this->add_control(
            'brand',
            [
                'label' => 'برند',
                'type' => \Elementor\Controls_Manager::SELECT2,
                'multiple' => true,
                'label_block' => true,
                'options' => $this->get_product_brands(),
                'condition' => [
                    'product_filter' => 'brand',
                ],
            ]
        );
        $this->add_control(
            'product_rand',
            [
                'label' => esc_html__('تصادفی'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('فعال'),
                'label_off' => esc_html__('غیرفعال'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'number',
            [
                'label' => 'تعداد محصولات',
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 24,
                'step' => 1,
                'default' => 6,
            ]
        );
        $this->add_control(
            'stock',
            [
                'label' => 'حذف محصولات ناموجود',
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => 'فعال',
                'label_off' => 'غیرفعال',
                'return_value' => 'yes',
                'default' => '',
            ]
        );

        $this->end_controls_section();
		
		
		$this->start_controls_section(
    'definition_list_styles',
            [
                'label'  => __( 'استایل', 'demo-elementor-widget' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
);
		 $this->add_control(
        'btn_background_color',
        [
            'label' => __('رنگ استایل محصول', 'textdomain'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'default' => '#FFBB91',
            'selectors' => [
                '{{WRAPPER}} a.button' => 'background-color: {{VALUE}}',
				'{{WRAPPER}} .woosw-btn-has-icon.woosw-added .woosw-btn-icon' => 'color: {{VALUE}}',
				'{{WRAPPER}} .product-items .item.prod-style-10 .image-sec .discount' => 'background: {{VALUE}}',
				'{{WRAPPER}} .woosw-btn-has-icon .woosw-btn-icon:hover' => 'color: {{VALUE}}',
				 '{{WRAPPER}}' => '--ultra-hover-shadow-color: {{VALUE}}',
            ],
        ]
    );

    $this->end_controls_section();
    }
	
	
	
	
	
	
	
	
	

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
        <div class="product-items">
            <?php
            $product_args = array(
                'post_type' => 'product',
                'posts_per_page' => $settings['number'],
            );
            if ($settings['product_filter'] == 'category') {
                $tax_query = array(
                    'relation' => 'OR',
                    array(
                        'taxonomy' => 'product_cat',
                        'field' => 'term_id',
                        'terms' => $settings['cat'],
                    ),
                );
                $product_args['tax_query'] = $tax_query;
            }
            if ($settings['product_rand'] == 'yes') {
                $product_args['orderby'] = 'rand';
            } elseif ($settings['product_filter'] == 'tag') {
                $tax_query = array(
                    'relation' => 'OR',
                    array(
                        'taxonomy' => 'product_tag',
                        'field' => 'term_id',
                        'terms' => $settings['tag'],
                    ),
                );
                $product_args['tax_query'] = $tax_query;
            } elseif ($settings['product_filter'] == 'brand') {
                $tax_query = array(
                    'relation' => 'OR',
                    array(
                        'taxonomy' => 'product_brand',
                        'field' => 'term_id',
                        'terms' => $settings['brand'],
                    ),
                );
                $product_args['tax_query'] = $tax_query;
            }
            if ($settings['stock']) {
                $meta_query = array(
                    array(
                        'key' => '_stock_status',
                        'value' => 'instock',
                        'compare' => '=',
                    ),
                );
                $product_args['meta_query'] = $meta_query;
            }
            $pro = new WP_Query($product_args);
            if ($pro->have_posts()) {
                while ($pro->have_posts()) : $pro->the_post();
                    ?>
                    <div class="item prod-style-10">
                        <a href="<?php the_permalink(); ?>" class="image-sec">
                            <figure>
                                <?php global $product;
                                if (has_post_thumbnail()) {
                                    the_post_thumbnail('product');
                                } else { ?>
                                    <img src="<?php echo get_template_directory_uri() . '/assets/image/empty.webp' ?>"
                                <?php } ?>
                            </figure>
                            <?php if ($product->is_on_sale() && $product->is_type('simple')) { ?>
                                <span class="discount"><?php echo ultra_woocommerce_discount(get_the_ID()); ?>%</span>
                            <?php } ?>
                        </a>
                        <div class="prod-info">
                            <?php if ($product->is_in_stock() && $product->get_price_html()) { ?>
                                <?php $id = $product->get_id(); ?>
                                <?php echo do_shortcode("[woosw id=$id]"); ?>
                                <div class="price">
                                    <?php echo $product->get_price_html(); ?>
                                </div>
                            <?php } elseif (!$product->is_in_stock()) {
                                echo "<div class='not_stock'><i class='fa-solid fa-multiply'></i> موجود نیست ! </div>";
                            } else {
                                echo "<div class='no_price'>تماس بگیرید !</div>";
                            } ?>
                            <?php if ($product->is_in_stock() && $product->get_price_html()) { ?>
                            <div class="addtocart_button">
                                <?php
                                if ($product->is_in_stock() && $product->get_price_html()) {
                                    echo sprintf('<a href="%s" data-quantity="1" class="%s add-cart-btn" %s><i class="fa-solid fa-cart-shopping"></i></a>',
                                        esc_url($product->add_to_cart_url()),
                                        esc_attr(implode(' ', array_filter(array(
                                            'button', 'product_type_' . $product->get_type(),
                                            $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
                                            $product->supports('ajax_add_to_cart') ? 'ajax_add_to_cart' : '',
                                        )))),
                                        wc_implode_html_attributes(array(
                                            'data-product_id' => $product->get_id(),
                                            'data-product_sku' => $product->get_sku(),
                                            'aria-label' => $product->add_to_cart_description(),
                                            'rel' => 'nofollow',
                                        )),
                                        esc_html($product->add_to_cart_text())
                                    );
                                } ?>
                            </div>
                            <?php } ?>
                        </div>
                    </div>
                <?php
                endwhile;
            } else {
                echo "<p>مطلبی پیدا نشد</p>";
            }
            wp_reset_postdata();
            ?>
        </div>

        <?php
    }

}