<?php

class Elementor_ultra_slider2_widget extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'ultra_slider2';
    }

    public function get_title()
    {
        return 'اسلایدر  طرح 2 اولترا';
    }

    public function get_icon()
    {
        return 'eicon-slideshow';
    }

    public function get_categories()
    {
        return ['ultra'];
    }

    public function get_keywords()
    {
        return ['slider', 'slideshow'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('محتوای اسلایدر', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'mainSlider',
            [
                'label' => 'اسلایدر',
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'img_slider',
                        'label' => 'انتخاب عکس',
                        'type' => \Elementor\Controls_Manager::MEDIA,
                        'default' => [
                            'url' => \Elementor\Utils::get_placeholder_image_src(),
                        ],
                        'label_block' => true,
                    ],
                    [
                        'name' => 'link_slider',
                        'label' => 'لینک مورد نظر خود را وارد کنید.',
                        'type' => \Elementor\Controls_Manager::URL,
                        'options' => ['url', 'is_external', 'nofollow'],
                        'default' => [
                            'url' => 'https://weblabs.ir/',
                            'is_external' => true,
                            'nofollow' => false,
                        ],
                        'label_block' => true,
                    ],
                ],
            ]
        );
        $this->add_control(
            'show_bullet_slider',
            [
                'label' => 'نقطه های زیر اسلایدر',
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'textdomain'),
                'label_off' => esc_html__('مخفی', 'textdomain'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'slide_border_radius',
            [
                'label' => 'گوشه های گرد',
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('فعال', 'textdomain'),
                'label_off' => esc_html__('غیرفعال', 'textdomain'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'autoplay',
            [
                'label' => 'حرکت خودکار',
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('فعال', 'textdomain'),
                'label_off' => esc_html__('غیرفعال', 'textdomain'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'definition_list_styles',
            [
                'label' => __( 'استایل نقاط اسلایدر', 'ultra-market' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'bullet_color_slider',
            [
                'label' => 'رنگ نقطه فعال',
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'این رنگ برای بولت فعال (نقطه‌ای که اسلاید جاری را نشان می‌دهد) اعمال می‌شود.',
                'selectors' => [
                    '{{WRAPPER}} .ultra-slider .owl-dots .owl-dot.active span' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'background_bullet_color_slider',
            [
                'label' => 'رنگ پس‌زمینه نقاط غیرفعال',
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#D6D6D6',
                'description' => 'این رنگ برای نقاط غیرفعال استفاده می‌شود (اسلایدهایی که در حال نمایش نیستند).',
                'selectors' => [
                    '{{WRAPPER}} .ultra-slider .owl-dots .owl-dot span' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'background_bullet_hover_slider',
            [
                'label' => 'رنگ هاور نقاط',
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#D6D6D6',
                'description' => 'هنگام قرار گرفتن موس روی نقطه‌ها، این رنگ نمایش داده می‌شود.',
                'selectors' => [
                    '{{WRAPPER}} .ultra-slider .owl-dots .owl-dot:hover span' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        if (!empty($settings['mainSlider'])) { ?>
            <div class="main-slider-2 ultra-slider">
                <div class="owl-carousel owl-theme ultra-solo-slider ">
                    <?php foreach ($settings['mainSlider'] as $item) {
                    $link_url = !empty($item['link_slider']['url']) ? esc_url($item['link_slider']['url']) : '#';
                    $link_target = !empty($item['link_slider']['is_external']) ? 'target="_blank"' : 'target="_self"';
                    $link_nofollow = !empty($item['link_slider']['nofollow']) ? 'rel="nofollow"' : '';

                    if (!empty($item['img_slider']['url'])) { ?>
                    <div class="item">
                        <a class="banner-slider" href="<?php echo $link_url; ?>" <?php echo $link_target; ?> <?php echo $link_nofollow; ?>>
                            <img src="<?php echo esc_url($item['img_slider']['url']); ?>" alt="<?php echo esc_attr(get_post_meta($item['img_slider']['id'], '_wp_attachment_image_alt', true ) ?: get_the_title($item['img_slider']['id'])); ?>">
                        </a>
                    </div>
                    <?php }
                    } ?>
                </div>

            </div>
            <script>
                jQuery(function () {
                    jQuery('.ultra-solo-slider').owlCarousel({
                        loop:true,
                        margin:10,
                        rtl:true,
                        autoplay: <?php if ($settings['autoplay']) {
                            echo "true";
                        } else {
                            echo "false";
                        } ?>,
                        nav:<?php if ($settings['show_nav_slider']) {
                            echo "true";
                        } else {
                            echo "false";
                        } ?>,
                        dots:<?php if ($settings['show_bullet_slider']) {
                            echo "true";
                        } else {
                            echo "false";
                        } ?>,
                        responsive: {
                            0: {
                                items: 1
                            },
                            600: {
                                items: 1
                            },
                            1000: {
                                items: 1
                            }
                        }
                    })
                });

            </script>
            <?php
            if (!$settings['slide_border_radius']) {
                ?>
                <style>
                    .ultra-slider .item img {
                        border-radius: 0 !important;
                    }
                </style>
                <?php
            }
        }
    }
}
