<?php
class Elementor_ultra_last_viewed extends \Elementor\Widget_Base {

    public function get_name() {
        return 'ultra_last_viewed';
    }

    public function get_title() {
        return 'آخرین بازدید دسته‌ای';
    }

    public function get_icon() {
        return 'eicon-posts-group';
    }

    public function get_categories() {
        return ['ultra'];
    }

    public function get_keywords() {
        return ['viewed', 'recent', 'product', 'last viewed'];
    }

    protected function register_controls() {
        // محتوا
        $this->start_controls_section('content_section', [
            'label' => __('محتوا', 'textdomain'),
        ]);

        $this->add_control('title', [
            'label' => 'عنوان کلی',
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => 'آخرین',
        ]);

        $this->add_control('bold_title', [
            'label' => 'عنوان برجسته (Bold)',
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => 'بازدید ها',
        ]);

        $this->add_control('desc', [
            'label' => 'توضیح کلی',
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => 'بر اساس آخرین فعالیت‌های شما',
        ]);

        $this->add_control('max_categories', [
    'label' => 'حداکثر دسته برای نمایش',
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 1,
    'max' => 4,
    'default' => 3,
]);


        $this->add_control('total_limit', [
            'label' => 'حداکثر محصولات برای بررسی',
            'type' => \Elementor\Controls_Manager::NUMBER,
            'default' => 20,
        ]);

        $this->end_controls_section();

        // استایل عنوان
        $this->start_controls_section('style_title', [
            'label' => 'استایل عنوان',
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]);

        $this->add_control('title_color', [
            'label' => 'رنگ عنوان',
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ultra-last-viewed .top-title' => 'color: {{VALUE}}'],
        ]);

        $this->add_control('title_font_size', [
            'label' => 'سایز فونت عنوان',
            'type' => \Elementor\Controls_Manager::SLIDER,
            'selectors' => ['{{WRAPPER}} .ultra-last-viewed .top-title' => 'font-size: {{SIZE}}{{UNIT}}'],
        ]);

        $this->end_controls_section();

        $this->start_controls_section('style_button_left', [
            'label' => 'استایل دکمه',
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]);
        $this->add_control('btn_text_color', [
            'label' => 'رنگ متن دکمه',
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ultra-last-viewed header a' => 'color: {{VALUE}}'],
        ]);

        $this->add_control('btn_bg_color', [
            'label' => 'رنگ پس‌زمینه دکمه',
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ultra-last-viewed header a' => 'background-color: {{VALUE}}'],
        ]);

        $this->add_control('btn_bg_hover', [
            'label' => 'رنگ هاور پس‌زمینه دکمه',
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ultra-last-viewed header a:hover' => 'background-color: {{VALUE}}'],
        ]);

        $this->end_controls_section();

        // استایل دکمه
        $this->start_controls_section('style_button', [
            'label' => 'استایل دکمه های دسته بندی',
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]);

        $this->add_control('button_text_color', [
            'label' => 'رنگ متن دکمه',
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ultra-last-viewed .viewed-btn' => 'color: {{VALUE}}'],
        ]);

        $this->add_control('button_bg_color', [
            'label' => 'رنگ پس‌زمینه دکمه',
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ultra-last-viewed .viewed-btn' => 'background-color: {{VALUE}}'],
        ]);

        $this->add_control('button_bg_hover', [
            'label' => 'رنگ هاور پس‌زمینه دکمه',
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ultra-last-viewed .viewed-btn:hover' => 'background-color: {{VALUE}}'],
        ]);

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $viewed_ids = isset($_COOKIE['ultra_viewed']) ? json_decode(stripslashes($_COOKIE['ultra_viewed']), true) : [];

        $args = [
            'post_type' => 'product',
            'posts_per_page' => $settings['total_limit'],
        ];

        if (!empty($viewed_ids)) {
            $args['post__in'] = $viewed_ids;
            $args['orderby'] = 'post__in';
        } else {
            $args['orderby'] = 'rand';
        }

        $query = new WP_Query($args);
        $grouped = [];

        if ($query->have_posts()) {
            while ($query->have_posts()) {
                $query->the_post();
                $product_id = get_the_ID();
                $cats = wp_get_post_terms($product_id, 'product_cat');

                if (!empty($cats)) {
                    $cat = $cats[0];
                    $term_id = $cat->term_id;

                    $grouped[$term_id]['name'] = $cat->name;
                    $grouped[$term_id]['link'] = get_term_link($cat);

                    $thumb_id = get_term_meta($term_id, 'thumbnail_id', true);
                    $thumb_url = $thumb_id ? wp_get_attachment_url($thumb_id) : '';
                    $grouped[$term_id]['category_thumb'] = $thumb_url;

                    $grouped[$term_id]['products'][] = [
                        'title' => get_the_title(),
                        'link' => get_permalink(),
                        'thumb' => get_the_post_thumbnail_url($product_id, 'medium'),
                    ];
                }
            }
            wp_reset_postdata();
            $grouped = array_slice($grouped, 0, $settings['max_categories'], true);
        }

        ?>
        <section class="ultra-last-viewed">
            <header>
                <div class="title">
                    <div class="text">
                        <span class="top-title">
                            <?php echo esc_html($settings['title']); ?>
                            <b><?php echo esc_html($settings['bold_title']); ?></b>
                        </span>
                        <span class="desc"><?php echo esc_html($settings['desc']); ?></span>
                    </div>
                </div>
                <a href="<?php echo wc_get_page_permalink('shop'); ?>">مشاهده همه</a>
            </header>

            <div class="last-viewed-boxes">
                <?php foreach ($grouped as $cat_id => $cat): ?>
                    <div class="view-box">
                        <div class="first-box">
                            <h4><?php echo esc_html($cat['name']); ?></h4>
                            <span>براساس آخرین بازدید شما</span>
                            <?php
                            $image_url = $cat['category_thumb'] ? $cat['category_thumb'] : $cat['products'][0]['thumb'];
                            ?>
                            <a href="<?php echo esc_url($cat['products'][0]['link']); ?>">
                                <img src="<?php echo esc_url($image_url); ?>" alt="<?php echo esc_attr($cat['name']); ?>">
                            </a>
                        </div>

                        <?php
                        $products = array_slice($cat['products'], 0, 3);
                        foreach ($products as $p): ?>
                            <figure class="the-product">
                                <a href="<?php echo esc_url($p['link']); ?>">
                                    <img src="<?php echo esc_url($p['thumb']); ?>" alt="<?php echo esc_attr($p['title']); ?>">
                                </a>
                                <b><?php echo esc_html($p['title']); ?></b>
                            </figure>
                        <?php endforeach; ?>

                        <a href="<?php echo esc_url($cat['link']); ?>" class="viewed-btn">
                            <span>مشاهده همه</span>
                            <i class="fa-solid fa-caret-left"></i>
                        </a>
                    </div>
                <?php endforeach; ?>
            </div>
        </section>
        <?php
    }
}