<?php

class Elementor_ultra_hover_effect_grid_product_widget extends \Elementor\Widget_Base
{


    public function get_name()
    {
        return 'hover_effect_grid_product_widget';
    }


    public function get_title()
    {
        return 'طرح شبکه ای با افکت هاور محصولات';
    }

    public function get_icon()
    {
        return 'eicon-product-description';
    }


    public function get_categories()
    {
        return ['ultra'];
    }

    public function get_keywords()
    {
        return ['product'];
    }

    function get_product_cats()
    {
        $cat_list = [];
        $product_cats = get_terms(array(
            'taxonomy' => 'product_cat',
            'hide_empty' => true,
        ));

        if (!empty($product_cats) && !is_wp_error($product_cats)) {
            foreach ($product_cats as $cat) {
                $cat_list[$cat->term_id] = $cat->name;
            }
        }
        return $cat_list;
    }

    function get_product_tags()
    {
        $tag_list = [];
        $product_tags = get_terms('product_tag');

        if (!empty($product_tags) && !is_wp_error($product_tags)) {
            foreach ($product_tags as $tag) {
                $tag_list[$tag->term_id] = $tag->name;
            }
        }
        return $tag_list;
    }

    function get_product_brands()
    {
        $brand_list = [];
        $product_brands = get_terms('product_brand');

        if (!empty($product_brands) && !is_wp_error($product_brands)) {
            foreach ($product_brands as $brand) {
                $brand_list[$brand->term_id] = $brand->name;
            }
        }
        return $brand_list;
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('المان محصولات', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'product_filter',
            [
                'label' => 'فیلتر محصولات',
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'all',
                'options' => [
                    'all' => 'همه محصولات',
                    'category' => 'براساس دسته بندی',
                    'tag' => 'براساس برچسب',
                    'brand' => 'براساس برند',
                ],
            ]
        );
        $this->add_control(
            'cat',
            [
                'label' => 'دسته بندی',
                'type' => \Elementor\Controls_Manager::SELECT2,
                'multiple' => true,
                'label_block' => true,
                'options' => $this->get_product_cats(),
                'condition' => [
                    'product_filter' => 'category',
                ],
            ]
        );
        $this->add_control(
            'tag',
            [
                'label' => 'برچسب',
                'type' => \Elementor\Controls_Manager::SELECT2,
                'multiple' => true,
                'label_block' => true,
                'options' => $this->get_product_tags(),
                'condition' => [
                    'product_filter' => 'tag',
                ],
            ]
        );
        $this->add_control(
            'brand',
            [
                'label' => 'برند',
                'type' => \Elementor\Controls_Manager::SELECT2,
                'multiple' => true,
                'label_block' => true,
                'options' => $this->get_product_brands(),
                'condition' => [
                    'product_filter' => 'brand',
                ],
            ]
        );
        $this->add_control(
            'product_rand_effect_grid',
            [
                'label' => esc_html__('تصادفی'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('فعال'),
                'label_off' => esc_html__('غیرفعال'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'number',
            [
                'label' => 'تعداد محصولات',
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 12,
                'step' => 1,
                'default' => 6,
            ]
        );

        $this->add_control(
            'stock',
            [
                'label' => 'حذف محصولات ناموجود',
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => 'فعال',
                'label_off' => 'غیرفعال',
                'return_value' => 'yes',
                'default' => '',
            ]
        );

        $this->end_controls_section();
        /**
         * Start Style
         */
        $this->start_controls_section(
            'definition_list_styles',
            [
                'label' => __('استایل محصولات', 'demo-elementor-widget'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_text_color_effect_grid',
            [
                'label' => esc_html__('رنگ متن سرتیتر محصولات'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#000', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .prod-style-7 a h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'hr1',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'price_text_color_effect_grid',
            [
                'label' => esc_html__('رنگ قیمت محصولات'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#000', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .product-items .item .price' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'del_text_color_effect_grid',
            [
                'label' => esc_html__('رنگ قیمت تخفیف خورده محصولات'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#A8ADBE', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .item .price del, .item .price-section del' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'hr2',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'text_btn_color_effect_grid',
            [
                'label' => esc_html__('رنگ متن دکمه'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .prod-style-7 .add-cart-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'bg_btn_color_effect_grid',
            [
                'label' => esc_html__('رنگ پس زمینه دکمه'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FFBB91', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .prod-style-7 .add-cart-btn' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display(); ?>
        <div class="product-items">
            <?php
            $product_args = array(
                'post_type' => 'product',
                'posts_per_page' => $settings['number'],
            );
            if ($settings['product_filter'] == 'category') {
                $tax_query = array(
                    'relation' => 'OR',
                    array(
                        'taxonomy' => 'product_cat',
                        'field' => 'term_id',
                        'terms' => $settings['cat'],
                    ),
                );
                $product_args['tax_query'] = $tax_query;
            } elseif ($settings['product_filter'] == 'tag') {
                $tax_query = array(
                    'relation' => 'OR',
                    array(
                        'taxonomy' => 'product_tag',
                        'field' => 'term_id',
                        'terms' => $settings['tag'],
                    ),
                );
                $product_args['tax_query'] = $tax_query;
            } elseif ($settings['product_filter'] == 'brand') {
                $tax_query = array(
                    'relation' => 'OR',
                    array(
                        'taxonomy' => 'product_brand',
                        'field' => 'term_id',
                        'terms' => $settings['brand'],
                    ),
                );
                $product_args['tax_query'] = $tax_query;
            }
            if ($settings['product_rand_effect_grid'] == 'yes') {
                $product_args['orderby'] = 'rand';
            }
            if ($settings['stock']) {
                $meta_query = array(
                    array(
                        'key' => '_stock_status',
                        'value' => 'instock',
                        'compare' => '=',
                    ),
                );
                $product_args['meta_query'] = $meta_query;
            }
            $pro = new WP_Query($product_args);
            if ($pro->have_posts()) {
                while ($pro->have_posts()) : $pro->the_post();
                    ?>
                    <div class="item prod-style-7">
                        <div class="prod-content">
                            <div class="product-image">
                                <a href="<?php the_permalink(); ?>">
                                    <figure>
                                        <?php if (has_post_thumbnail()) {
                                            the_post_thumbnail('product');
                                        } else { ?>
                                            <img src="<?= get_template_directory_uri() . '/assets/image/empty.webp' ?>"
                                        <?php } ?>
                                    </figure>
                                </a>
                            </div>
                            <a href="<?php the_permalink(); ?>"><h3><?php the_title(); ?></h3></a>
                            <!-- مثل اسلایدر کالا منتخب صفحه اصلی مبلغش رو تبدیل کن استایلاش فیکس میشه کدای اون قسمت رو برداشتم من   -->
                            <?php global $product;
                            if ($product->is_in_stock() && $product->get_price_html()) { ?>
                                <div class="price">
                                    <?= $product->get_price_html(); ?>
                                </div>
                            <?php } elseif (!$product->is_in_stock()) {
                                echo "<div class='not_stock'>موجود نیست !</div>";
                            } else {
                                echo "<div class='no_price'>تماس بگیرید !</div>";
                            }
                            ?>
                        </div>
                        <?php
                        if ($product->is_in_stock() && $product->get_price_html()) {
                            echo sprintf('<a href="%s" data-quantity="1" class="%s add-cart-btn" %s><svg id="Buy" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M5.52377 7.00012C9.41427 5.74398 13.9724 5.45585 16 5.50012C18.0276 5.5444 18.8831 6.26642 19.5 7.50012C20.5 9.50012 20.289 14.4882 18.5 16.0872C16.712 17.6862 9.33015 17.8382 6.87015 16.0872C4.27115 14.2362 5.629 9.19212 5.544 5.74312C5.595 3.81312 3.5 3.50012 3.5 3.50012" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                <path d="M13 10.5001H15.773" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                <path fill-rule="evenodd" clip-rule="evenodd" d="M7.26399 20.1276C7.56399 20.1276 7.80799 20.3716 7.80799 20.6716C7.80799 20.9726 7.56399 21.2166 7.26399 21.2166C6.96299 21.2166 6.71899 20.9726 6.71899 20.6716C6.71899 20.3716 6.96299 20.1276 7.26399 20.1276Z" fill="#000000" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                <path fill-rule="evenodd" clip-rule="evenodd" d="M17.5955 20.1276C17.8965 20.1276 18.1405 20.3716 18.1405 20.6716C18.1405 20.9726 17.8965 21.2166 17.5955 21.2166C17.2955 21.2166 17.0515 20.9726 17.0515 20.6716C17.0515 20.3716 17.2955 20.1276 17.5955 20.1276Z" fill="#000000" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
            </svg><span>افزودن به سبد خرید</span></a>',
                                esc_url($product->add_to_cart_url()),
                                esc_attr(implode(' ', array_filter(array(
                                    'button', 'product_type_' . $product->get_type(),
                                    $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
                                    $product->supports('ajax_add_to_cart') ? 'ajax_add_to_cart' : '',
                                )))),
                                wc_implode_html_attributes(array(
                                    'data-product_id' => $product->get_id(),
                                    'data-product_sku' => $product->get_sku(),
                                    'aria-label' => $product->add_to_cart_description(),
                                    'rel' => 'nofollow',
                                )),
                                esc_html($product->add_to_cart_text())
                            );
                        } ?>
                    </div>
                <?php
                endwhile;
            } else {
                echo "<p>مطلبی پیدا نشد</p>";
            }
            wp_reset_postdata();
            ?>
        </div>
        <?php
    }

}