<?php

class Elementor_ultra_guarantee_widget extends \Elementor\Widget_Base
{


    public function get_name()
    {
        return 'ultra_guarantee_widget';
    }

    public function get_title()
    {
        return 'گارانتی';
    }

    public function get_icon()
    {
        return 'eicon-info-circle-o';
    }

    public function get_categories()
    {
        return ['ultra'];
    }

    public function get_keywords()
    {
        return ['guarantee'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('تنظیمات المان های گارانتی', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'icon_guarantee',
            [
                'label' => 'آیکون',
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'icon',
                        'label' => esc_html__('انتخاب آیکون', 'textdomain'),
                        'type' => \Elementor\Controls_Manager::ICONS,
                        'default' => [
                            'value' => 'fas fa-circle',
                            'library' => 'fa-solid',
                        ],
                    ],
                    [
                        'name' => 'title',
                        'label' => esc_html__('عنوان', 'textdomain'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                    ],
                    [
                        'name' => 'desc',
                        'label' => esc_html__('توضیحات', 'textdomain'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                    ],
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'definition_list_styles',
            [
                'label' => __('استایل', 'demo-elementor-widget'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'color_icon',
            [
                'label' => esc_html__('رنگ آیکون', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .guarantee-ultra svg' => 'fill: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'size_icon',
            [
                'label' => esc_html__( 'سایز آیکون' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 5,
                'max' => 300,
                'step' => 1,
                'default' => 100,
            ]
        );
        $this->add_control(
            'color_title',
            [
                'label' => esc_html__('رنگ عنوان', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .guarantee-ultra .item .info .title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'color_desc',
            [
                'label' => esc_html__('رنگ توضیحات', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#bababa',
                'selectors' => [
                    '{{WRAPPER}} .guarantee-ultra .item .info .desc' => 'color: {{VALUE}}',
                ],
            ]
        );


        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        if (!empty($settings['icon_guarantee'])) { ?>
            <div class="guarantee-ultra">
                <?php foreach ($settings['icon_guarantee'] as $item) { ?>
                    <div class="item">
                        <?php
                        if (!empty($item['icon'])) {
                            \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true']);
                        }
                        ?>
                        <div class="info">
                            <span class="title"><?php echo esc_html($item['title']); ?></span>
                            <span class="desc"><?php echo esc_html($item['desc']); ?></span>
                        </div>
                    </div>
                <?php } ?>
            </div>
            <style>
                .guarantee-ultra .item svg{
                    width: <?php echo $settings['size_icon'];?>px;
                }
            </style>
            <?php
        }
    }
}