<?php
class Elementor_ultra_cutie_products extends \Elementor\Widget_Base {
    public function get_name() {
        return 'ultra_cutie_products';
    }

    public function get_title() {
        return 'محصولات فانتزی اولترا';
    }

    public function get_icon() {
        return 'eicon-bag-light';
    }

    public function get_categories() {
        return ['ultra'];
    }

    public function get_keywords() {
        return ['product', 'cute', 'ultra'];
    }

    private function get_product_cats() {
        $cat_list = [];
        $product_cats = get_terms(['taxonomy' => 'product_cat', 'hide_empty' => true]);
        if (!empty($product_cats) && !is_wp_error($product_cats)) {
            foreach ($product_cats as $cat) {
                $cat_list[$cat->term_id] = $cat->name;
            }
        }
        return $cat_list;
    }

    private function get_product_tags() {
        $tag_list = [];
        $product_tags = get_terms('product_tag');
        if (!empty($product_tags) && !is_wp_error($product_tags)) {
            foreach ($product_tags as $tag) {
                $tag_list[$tag->term_id] = $tag->name;
            }
        }
        return $tag_list;
    }

    private function get_product_brands() {
        $brand_list = [];
        $product_brands = get_terms('product_brand');
        if (!empty($product_brands) && !is_wp_error($product_brands)) {
            foreach ($product_brands as $brand) {
                $brand_list[$brand->term_id] = $brand->name;
            }
        }
        return $brand_list;
    }

    protected function register_controls() {
        // عنوان
        $this->start_controls_section('section_title', [
            'label' => __('عنوان', 'textdomain'),
        ]);

        $this->add_control('title', [
            'label' => __('عنوان', 'textdomain'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => 'جدیدترین محصولات',
        ]);

        $this->end_controls_section();

        // فیلتر محصولات
        $this->start_controls_section('section_filter', [
            'label' => __('فیلتر محصولات', 'textdomain'),
        ]);

        $this->add_control('product_filter', [
            'label' => 'فیلتر محصولات',
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => 'all',
            'options' => [
                'all' => 'همه محصولات',
                'category' => 'براساس دسته بندی',
                'tag' => 'براساس برچسب',
                'brand' => 'براساس برند',
            ],
        ]);

        $this->add_control('cat', [
            'label' => 'دسته بندی',
            'type' => \Elementor\Controls_Manager::SELECT2,
            'multiple' => true,
            'label_block' => true,
            'options' => $this->get_product_cats(),
            'condition' => ['product_filter' => 'category'],
        ]);

        $this->add_control('tag', [
            'label' => 'برچسب',
            'type' => \Elementor\Controls_Manager::SELECT2,
            'multiple' => true,
            'label_block' => true,
            'options' => $this->get_product_tags(),
            'condition' => ['product_filter' => 'tag'],
        ]);

        $this->add_control('brand', [
            'label' => 'برند',
            'type' => \Elementor\Controls_Manager::SELECT2,
            'multiple' => true,
            'label_block' => true,
            'options' => $this->get_product_brands(),
            'condition' => ['product_filter' => 'brand'],
        ]);

        $this->add_control('number', [
            'label' => 'تعداد محصولات',
            'type' => \Elementor\Controls_Manager::NUMBER,
            'default' => 6,
        ]);

        $this->add_control('product_rand', [
            'label' => __('ترتیب تصادفی', 'textdomain'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'label_on' => 'بله',
            'label_off' => 'خیر',
            'default' => '',
        ]);

        $this->add_control('stock', [
            'label' => 'حذف محصولات ناموجود',
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'label_on' => 'فعال',
            'label_off' => 'غیرفعال',
            'return_value' => 'yes',
            'default' => '',
        ]);

        $this->end_controls_section();

        // دکمه مشاهده
        $this->start_controls_section('section_button', [
            'label' => __('دکمه مشاهده همه', 'textdomain'),
        ]);

        $this->add_control('button_text', [
            'label' => 'متن دکمه',
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => 'مشاهده همه محصولات',
        ]);

        $this->add_control('button_link', [
            'label' => 'لینک دکمه',
            'type' => \Elementor\Controls_Manager::URL,
            'default' => [
                'url' => '#',
                'is_external' => false,
            ],
        ]);

        $this->end_controls_section();

        // بخش استایل: عنوان و دکمه
        $this->start_controls_section('style_header_section', [
            'label' => __('استایل عنوان و دکمه', 'textdomain'),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]);
        $this->add_control('title_color', [
            'label' => 'رنگ متن عنوان',
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ultra-cute-product h3' => 'color: {{VALUE}}'],
        ]);
        $this->add_control('button_color', [
            'label' => 'رنگ متن دکمه',
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ultra-cute-product header a' => 'color: {{VALUE}}'],
        ]);
        $this->add_control('button_bg', [
            'label' => 'رنگ زمینه دکمه',
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ultra-cute-product header a' => 'background-color: {{VALUE}}'],
        ]);
        $this->add_control('button_hover_bg', [
            'label' => 'رنگ هاور دکمه',
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ultra-cute-product header a:hover' => 'background-color: {{VALUE}}'],
        ]);
        $this->end_controls_section();

        // بخش استایل: کارت محصول
        $this->start_controls_section('style_card_section', [
            'label' => __('استایل کارت محصول', 'textdomain'),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]);
        $this->add_control('card_bg_color', [
            'label' => 'رنگ بکگراند کارت محصول',
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ultra-item' => 'background-color: {{VALUE}}'],
        ]);
        $this->add_control('inner_bg_color', [
            'label' => 'رنگ زمینه محصول',
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ultra-item .top-section' => 'background-color: {{VALUE}}'],
        ]);
        $this->add_control('image_bg_color', [
            'label' => 'بکگراند عکس',
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ultra-item img' => 'background-color: {{VALUE}}'],
        ]);
        $this->add_control('product_title_color', [
            'label' => 'رنگ نام محصول',
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ultra-item h4' => 'color: {{VALUE}}'],
        ]);
        $this->add_control('price_color', [
            'label' => 'رنگ قیمت محصول',
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ultra-item .price ins' => 'color: {{VALUE}}'],
        ]);
        $this->add_control('old_price_color', [
            'label' => 'رنگ قیمت تخفیف خورده',
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ultra-item .price del' => 'color: {{VALUE}}'],
        ]);
        $this->add_control('buy_button_bg', [
            'label' => 'رنگ زمینه دکمه خرید',
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ultra-item a' => 'background-color: {{VALUE}}'],
        ]);
        $this->add_control('buy_button_color', [
            'label' => 'رنگ متن دکمه خرید',
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ultra-item a' => 'color: {{VALUE}}'],
        ]);
$this->add_control('card_bg_image', [
    'label' => __('تصویر پس‌زمینه کارت محصول', 'textdomain'),
    'type' => \Elementor\Controls_Manager::MEDIA,
    'default' => [
        'url' => get_template_directory_uri() . '/assets/image/product-grid-bg-pattern.png',
    ],
    'selectors' => [
        '{{WRAPPER}} .ultra-cute-product .body-items .ultra-item' => 'background-image: url("{{URL}}");',
    ],
]);
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        $args = [
            'post_type' => 'product',
            'posts_per_page' => $settings['number'],
        ];

        if ($settings['product_rand'] === 'yes') {
            $args['orderby'] = 'rand';
        }

        if ($settings['stock']) {
            $args['meta_query'][] = [
                'key' => '_stock_status',
                'value' => 'instock',
                'compare' => '=',
            ];
        }

        if ($settings['product_filter'] === 'category') {
            $args['tax_query'][] = [
                'taxonomy' => 'product_cat',
                'field' => 'term_id',
                'terms' => $settings['cat'],
            ];
        }

        if ($settings['product_filter'] === 'tag') {
            $args['tax_query'][] = [
                'taxonomy' => 'product_tag',
                'field' => 'term_id',
                'terms' => $settings['tag'],
            ];
        }

        if ($settings['product_filter'] === 'brand') {
            $args['tax_query'][] = [
                'taxonomy' => 'product_brand',
                'field' => 'term_id',
                'terms' => $settings['brand'],
            ];
        }

        $loop = new WP_Query($args);

        echo '<section class="ultra-cute-product">';
        echo '<header>';
        echo '<h3>' . esc_html($settings['title']) . '</h3>';
        if (!empty($settings['button_link']['url'])) {
            $target = $settings['button_link']['is_external'] ? ' target="_blank"' : '';
            $nofollow = $settings['button_link']['nofollow'] ? ' rel="nofollow"' : '';
            echo '<a href="' . esc_url($settings['button_link']['url']) . '"' . $target . $nofollow . '><i class="fa-solid fa-paw"></i> ' . esc_html($settings['button_text']) . '</a>';
        }
        echo '</header>';
        echo '<article class="body-items">';

        if ($loop->have_posts()) {
            while ($loop->have_posts()) {
                $loop->the_post();
                global $product;
                echo '<div class="ultra-item">';
                echo '<div class="top-section">';
                echo '<img src="' . (has_post_thumbnail() ? get_the_post_thumbnail_url() : get_template_directory_uri() . '/assets/image/empty.webp') . '">';
                echo '<h4>' . get_the_title() . '</h4>';
                echo '<div class="price">';
                echo $product->get_price_html();
                echo '</div>';
                echo '</div>';
                echo '<a href="' . get_permalink() . '"><i class="fa-solid fa-cart-shopping"></i> خرید محصول</a>';
                echo '</div>';
            }
            wp_reset_postdata();
        } else {
            echo '<p>محصولی یافت نشد.</p>';
        }

        echo '</article>';
        echo '</section>';
    }
}