<?php

class Elementor_ultra_category_widget extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'ultra_category_widget';
    }

    public function get_title()
    {
        return 'دسته بندی فروشگاه اولترا';
    }

    public function get_icon()
    {
        return 'eicon-folder-o';
    }

    public function get_categories()
    {
        return ['ultra'];
    }

    public function get_keywords()
    {
        return ['category', 'shop', 'ultra'];
    }

    protected function get_product_categories()
    {
        $categories = get_terms([
            'taxonomy' => 'product_cat',
            'orderby' => 'name',
            'hide_empty' => false,
        ]);

        $output = [];
        if (!empty($categories) && !is_wp_error($categories)) {
            foreach ($categories as $term) {
                $output[$term->term_id] = $term->name;
            }
        }
        return $output;
    }

    protected function register_controls()
    {
        $this->start_controls_section('header_section', [
            'label' => __('تنظیمات عنوان و دکمه', 'textdomain'),
        ]);

        $this->add_control('title_text', [
            'label' => __('عنوان', 'textdomain'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => 'دسته بندی',
        ]);

        $this->add_control('highlight_text', [
            'label' => __('کلمه برجسته'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => 'فروشگاه',
        ]);

        $this->add_control('desc', [
            'label' => __('توضیح'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => 'پربازدید ترین دسته بندی ها',
        ]);

        $this->add_control('button_text', [
            'label' => __('متن دکمه'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => 'مشاهده همه',
        ]);

        $this->add_control('button_link', [
            'label' => __('لینک دکمه'),
            'type' => \Elementor\Controls_Manager::URL,
            'default' => ['url' => '#'],
        ]);

        $this->end_controls_section();

        $this->start_controls_section('style_header', [
            'label' => __('استایل عنوان و دکمه'),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]);

        $this->add_control('title_color', [
            'label' => __('رنگ عنوان'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ultra-category .top-title' => 'color: {{VALUE}}'],
        ]);

        $this->add_control('highlight_color', [
            'label' => __('رنگ کلمه برجسته'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ultra-category .top-title b' => 'color: {{VALUE}}'],
        ]);

        $this->add_control('desc_color', [
            'label' => __('رنگ توضیح'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ultra-category .desc' => 'color: {{VALUE}}'],
        ]);

        $this->add_control('button_color', [
            'label' => __('رنگ متن دکمه'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ultra-category header a' => 'color: {{VALUE}}'],
        ]);

        $this->add_control('button_bg', [
            'label' => __('رنگ زمینه دکمه'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ultra-category header a' => 'background-color: {{VALUE}}'],
        ]);

        $this->add_control('button_hover_bg', [
            'label' => __('زمینه هاور دکمه'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ultra-category header a:hover' => 'background-color: {{VALUE}}'],
        ]);

        $this->end_controls_section();

        $this->start_controls_section('style_items', [
            'label' => __('استایل آیتم‌های دسته'),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]);

        $this->add_control('name_color', [
            'label' => __('رنگ نام دسته'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ultra-category .name_category' => 'color: {{VALUE}}'],
        ]);

        $this->add_control('count_color', [
            'label' => __('رنگ تعداد کالا'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ultra-category .num' => 'color: {{VALUE}}'],
        ]);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $categories = get_terms([
            'taxonomy' => 'product_cat',
            'orderby' => 'count',
            'order' => 'DESC',
            'number' => 6,
            'hide_empty' => true,
        ]);

        echo '<section class="ultra-category">';
        echo '<header>';
        echo '<div class="title"><div class="text">';
        echo '<span class="top-title">' . esc_html($settings['title_text']) . ' <b>' . esc_html($settings['highlight_text']) . '</b></span>';
        echo '<span class="desc">' . esc_html($settings['desc']) . '</span>';
        echo '</div></div>';
        if (!empty($settings['button_link']['url'])) {
            $this->add_render_attribute('button_link', 'href', esc_url($settings['button_link']['url']));
            echo '<a ' . $this->get_render_attribute_string('button_link') . '>' . esc_html($settings['button_text']) . '</a>';
        }
        echo '</header>';

        echo '<div class="category-boxes">';
        foreach ($categories as $term) {
            $thumbnail_id = get_term_meta($term->term_id, 'thumbnail_id', true);
            $image = $thumbnail_id ? wp_get_attachment_url($thumbnail_id) : wc_placeholder_img_src();
            $link = get_term_link($term);
            
          
            echo '<a class="category-item" href="' . esc_url($link) . '">';
            echo '<div class="name">';
            echo '<span class="name_category">' . esc_html($term->name) . '</span>';
            echo '<span class="num">+' . esc_html($term->count) . ' کالا</span>';
            echo '</div>';
            echo '<img src="' . esc_url($image) . '" alt="' . esc_attr($term->name) . '" />';
            echo '</a>';
            
        }
        echo '</div></section>';
    }
}
