<?php

class Elementor_ultra_category_product_thumbnail extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'ultra_category_product_thumbnail';
    }

    public function get_title()
    {
        return 'نمایش دسته بندی محصولات با تصویر';
    }

    public function get_icon()
    {
        return 'eicon-products';
    }

    public function get_categories()
    {
        return ['ultra'];
    }

    public function get_keywords()
    {
        return ['product'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('المان محصولات', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        // انتخاب دسته بندی ها برای نمایش
        $this->add_control(
            'selected_categories',
            [
                'label' => esc_html__('دسته بندی‌های انتخابی', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => $this->get_category_options(),
                'multiple' => true,
                'label_block' => true,
            ]
        );

        // نمایش دسته بندی‌های خالی
        $this->add_control(
            'show_empty_categories',
            [
                'label' => esc_html__('نمایش دسته بندی‌های خالی', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'textdomain'),
                'label_off' => esc_html__('خیر', 'textdomain'),
                'return_value' => 'yes',
                'default' => '',
            ]
        );

        $this->add_control(
            'exclude_uncategorized',
            [
                'label'        => 'حذف دسته‌بندی پیش‌فرض (Uncategorized)',
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'label_on'     => 'بله',
                'label_off'    => 'خیر',
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );


        $this->end_controls_section();
    }

    protected function render() {

        // ───── تنظیمات ویجت ────────────────────────────────────────────────────────
        $settings             = $this->get_settings_for_display();
        $selected_categories  = ! empty( $settings['selected_categories'] )
            ? (array) $settings['selected_categories']
            : [];
        $show_empty           = ! empty( $settings['show_empty_categories'] )
            && $settings['show_empty_categories'] === 'yes';

        // ───── آماده‌سازی کوئری ترم‌ها ────────────────────────────────────────────
        $args = [
            'taxonomy'   => 'product_cat',
            'orderby'    => 'name',
            'order'      => 'ASC',
            'hide_empty' => ! $show_empty,
        ];

        if ( $selected_categories ) {
            $args['include'] = $selected_categories; // فقط دسته‌های انتخابی
        }

        $product_categories = get_terms( $args );

        // ───── اگر لازم است «دسته‌بندی نشده» حذف شود ─────────────────────────────
        if ( ! is_wp_error( $product_categories ) &&
            ! empty( $settings['exclude_uncategorized'] ) &&
            $settings['exclude_uncategorized'] === 'yes' ) {

            // آیدی دستهٔ پیش‌فرض ووکامرس (اگر تنظیم شده باشد)
            $default_cat_id   = (int) get_option( 'default_product_cat', 0 );

            // اسلاگ‌هایی که می‌خواهیم حذف شوند (انگلیسی + فارسی)
            $black_list_slugs = [
                'uncategorized',
                'دسته-بندی-نشده',
                sanitize_title( 'دسته‌بندی نشده' ),
            ];

            $product_categories = array_filter(
                $product_categories,
                function ( $cat ) use ( $default_cat_id, $black_list_slugs ) {

                    // حذف بر اساس آیدی پیش‌فرض
                    if ( $default_cat_id && $cat->term_id == $default_cat_id ) {
                        return false;
                    }
                    // حذف بر اساس اسلاگ
                    return ! in_array( $cat->slug, $black_list_slugs, true );
                }
            );
        }

        // ───── خروجی HTML ویجت ────────────────────────────────────────────────────
        if ( empty( $product_categories ) || is_wp_error( $product_categories ) ) {
            echo '<p>' . esc_html__( 'دسته‌بندی‌ای یافت نشد.', 'ultra-market' ) . '</p>';
            return;
        }

        echo '<div class="product-categories-container">';

        foreach ( $product_categories as $category ) {

            $thumb_id  = get_term_meta( $category->term_id, 'thumbnail_id', true );
            $thumb_url = $thumb_id ? wp_get_attachment_url( $thumb_id )
                : wc_placeholder_img_src();
            ?>
            <div class="product-category">
                <a href="<?php echo esc_url( get_term_link( $category ) ); ?>">
                    <img src="<?php echo esc_url( $thumb_url ); ?>"
                         alt="<?php echo esc_attr( $category->name ); ?>" />
                    <h3><?php echo esc_html( $category->name ); ?></h3>
                </a>
            </div>
            <?php
        }

        echo '</div>';
    }


    // دریافت گزینه‌های دسته‌بندی‌ها برای فیلد انتخابی
    private function get_category_options()
    {
        $categories = get_terms([
            'taxonomy'   => 'product_cat',
            'orderby'    => 'name',
            'order'      => 'ASC',
            'hide_empty' => false,
        ]);

        $options = [];
        foreach ($categories as $category) {
            $options[$category->term_id] = $category->name;
        }

        return $options;
    }
}
?>
