<?php

class Elementor_ultra_brand_widget extends \Elementor\Widget_Base
{


    public function get_name()
    {
        return 'ultra_brand_widget';
    }


    public function get_title()
    {
        return 'برندها';
    }

    public function get_icon()
    {
        return 'eicon-logo';
    }


    public function get_categories()
    {
        return ['ultra'];
    }

    public function get_keywords()
    {
        return ['brand'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'المان برند', 'textdomain' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label'       => __('عنوان '),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'input_type'  => 'text',
                'placeholder' => '',
                'default' => 'محبوب ترین برند ها',
            ]
        );

        $this->add_control(
            'number',
            [
                'label' => 'تعداد پست',
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 40,
                'step' => 1,
                'default' => 8,
            ]
        );
        $this->add_control(
            'item_slide_desktop',
            [
                'label' => 'تعداد آیتم های اسلایدر در دسکتاپ',
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 8,
                'step' => 1,
                'default' => 4,
            ]
        );
    
        $this->add_control(
            'autoplay',
            [
                'label' => 'حرکت خودکار',
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'فعال', 'textdomain' ),
                'label_off' => esc_html__( 'غیرفعال', 'textdomain' ),
                'return_value' => 'true',
                'default' => '',
            ]
        );
        $this->add_control(
            'loop',
            [
                'label' => 'حلقه بی نهایت',
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'فعال', 'textdomain' ),
                'label_off' => esc_html__( 'غیرفعال', 'textdomain' ),
                'return_value' => 'true',
                'default' => '',
            ]
        );
        $this->add_control(
            'empty',
            [
                'label' => 'خالی ها پنهان شود',
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'فعال', 'textdomain' ),
                'label_off' => esc_html__( 'غیرفعال', 'textdomain' ),
                'return_value' => 'true',
                'default' => '',
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $empty = ! empty( $settings['empty'] ) ? 1 : 0;
        ?>
        <section class="hero-product">
                <?php if ($settings['title']) { ?>
                    <header class="title-brand">
						<i class="fa-solid fa-tag"></i>
                        <h2><?php echo $settings['title'] ?></h2>
                    </header>
                <?php } ?>
                <div class="box-brand">
                    <div class="inner-brand">
                        <div class="owl-carousel owl-theme brand">
                            <?php
                            $terms = get_terms( array(
                                'taxonomy' => 'product_brand', // set your taxonomy here
                                'hide_empty' => false, // default: true
                            ) );
                            if ( empty( $terms ) || is_wp_error( $terms ) ) {
                                return;
                            }
                            $tm = get_field('brand_thumbnail');
                            echo $tm;
                            foreach( $terms as $term ) : ?>
                                <div class="item product-item">
                                    <a href="<?php echo get_term_link( $term->term_id ); ?>">
                                        <figure>
                                            <?php
                                            echo wp_get_attachment_image(get_term_meta($term->term_id, 'brand_thumbnail', true), 'full');
                                            ?>
                                        </figure>
                                    </a>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
        </section>

        <script>
            jQuery(function (){
                jQuery('.brand').owlCarousel({
                    center: true,
                    items:1,
                    loop:<?php if ($settings['loop']) {echo "true";} else {echo "false";} ?>,
                    autoplay:<?php if ($settings['autoplay']) {echo "true";} else {echo "false";} ?>,
                    dots:false,
                    nav:true,
                    rtl: true,
                    //margin:10,
                    responsive:{
						0:{items:1},
						500:{items:1.2},				                        
						600:{items:2.5},
						768:{items:3.1},										 
                        1024:{items:3.2},
						1280:{items:4},
                        1400:{items:4.5},
                        1920:{items:<?php echo $settings['item_slide_desktop']; ?> }
                    }
                });
            });

        </script>

        <?php
    }

}