<?php

class Elementor_ultra_brand_showcase_widget extends \Elementor\Widget_Base {
    public function get_name() {
        return 'ultra_brand_showcase_widget';
    }

    public function get_title() {
        return 'نمایش برندهای فروشگاه';
    }

    public function get_icon() {
        return 'eicon-post-slider';
    }

    public function get_categories() {
        return ['ultra'];
    }

    public function get_keywords() {
        return ['brand', 'store', 'ultra'];
    }

    protected function register_controls() {
        // Header Section
        $this->start_controls_section('header_section', [
            'label' => __('تنظیمات عنوان و دکمه', 'textdomain'),
        ]);

        $this->add_control('top_title_text', [
            'label' => __('متن قبل از تگ B'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => 'محبوب ترین',
        ]);

        $this->add_control('top_title_bold', [
            'label' => __('متن داخل تگ B'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => 'برندها',
        ]);

        $this->add_control('desc', [
            'label' => __('توضیح'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => 'پرفروش ترین برند ها را در پایین مشاهده میکنید',
        ]);

        $this->add_control('button_text', [
            'label' => __('متن دکمه'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => 'مشاهده همه',
        ]);

        $this->add_control('button_link', [
            'label' => __('لینک دکمه'),
            'type' => \Elementor\Controls_Manager::URL,
            'default' => ['url' => '#', 'is_external' => false],
        ]);

        $this->end_controls_section();

        // Settings Section
        $this->start_controls_section('settings_section', [
            'label' => __('تنظیمات برندها', 'textdomain'),
        ]);

        $this->add_control('number', [
            'label' => __('تعداد برند'),
            'type' => \Elementor\Controls_Manager::NUMBER,
            'default' => 6,
        ]);

        $this->add_control('autoplay', [
            'label' => __('حرکت خودکار'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'return_value' => 'true',
            'default' => '',
        ]);

        $this->add_control('loop', [
            'label' => __('حلقه بی‌نهایت'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'return_value' => 'true',
            'default' => 'true',
        ]);

        $this->add_control('dots', [
            'label' => __('نقاط (Dots)'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'return_value' => 'true',
            'default' => '',
        ]);

        $this->add_control('nav', [
            'label' => __('دکمه‌های ناوبری (Nav)'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'return_value' => 'true',
            'default' => 'true',
        ]);

        $this->end_controls_section();

        // Style Header
        $this->start_controls_section('style_header', [
            'label' => __('استایل هدر'),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]);

        $this->add_control('top_title_color', [
            'label' => __('رنگ عنوان'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ultra-brand-section .top-title' => 'color: {{VALUE}}'],
        ]);

        $this->add_control('top_title_b_color', [
            'label' => __('رنگ تگ B عنوان'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ultra-brand-section .top-title b' => 'color: {{VALUE}}'],
        ]);

        $this->add_control('desc_color', [
            'label' => __('رنگ توضیح'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ultra-brand-section .desc' => 'color: {{VALUE}}'],
        ]);

        $this->add_control('button_color', [
            'label' => __('رنگ متن دکمه'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ultra-brand-section header a' => 'color: {{VALUE}}'],
        ]);

        $this->add_control('button_bg', [
            'label' => __('رنگ زمینه دکمه'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ultra-brand-section header a' => 'background-color: {{VALUE}}'],
        ]);

        $this->add_control('button_hover_bg', [
            'label' => __('زمینه هاور دکمه'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ultra-brand-section header a:hover' => 'background-color: {{VALUE}}'],
        ]);

        $this->end_controls_section();

        // Style Brand Cards
        $this->start_controls_section('style_brands', [
            'label' => __('استایل برندها'),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]);

        $this->add_control('brand_name_color', [
            'label' => __('رنگ نام برند فارسی'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ultra-brand-section .brand-name' => 'color: {{VALUE}}'],
        ]);

        $this->add_control('brand_en_color', [
            'label' => __('رنگ نام برند انگلیسی'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ultra-brand-section .en-name' => 'color: {{VALUE}}'],
        ]);

        $this->add_control('brand_count_color', [
            'label' => __('رنگ تعداد کالا'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => ['{{WRAPPER}} .ultra-brand-section .brand-count' => 'color: {{VALUE}}'],
        ]);

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        $terms = get_terms([
            'taxonomy' => 'product_brand',
            'hide_empty' => false,
            'number' => $settings['number']
        ]);

        echo '<section class="ultra-brand-section">';
        echo '<header><div class="title"><div class="text">';
        echo '<span class="top-title">' . esc_html($settings['top_title_text']) . ' <b>' . esc_html($settings['top_title_bold']) . '</b></span>';
        echo '<span class="desc">' . esc_html($settings['desc']) . '</span>';
        echo '</div></div>';
        if (!empty($settings['button_link']['url'])) {
            $this->add_render_attribute('button_link', 'href', esc_url($settings['button_link']['url']));
            echo '<a ' . $this->get_render_attribute_string('button_link') . '>' . esc_html($settings['button_text']) . '</a>';
        }
        echo '</header>';

        echo '<div class="body-brands"><div class="ultra-brands-widget_slider owl-carousel owl-theme">';

        foreach ($terms as $term) {
            $image_id = get_term_meta($term->term_id, 'brand_thumbnail', true);
            $img_url = wp_get_attachment_url($image_id);
            if (!$img_url) {
                $img_url = get_template_directory_uri() . '/assets/image/empty.webp';
            }
            $link = get_term_link($term);
            echo '<div class="item">';
            echo '<a class="the-brand" href="' . esc_url($link) . '">';
            echo '<img src="' . esc_url($img_url) . '" alt="' . esc_attr($term->name) . '" />';
            echo '<span class="en-name"> <span class="name">' . esc_html(urldecode($term->slug)) . '</span></span>';
            echo '<div class="bottom-section">';
            echo '<span class="brand-name">' . esc_html($term->name) . '</span>';
            echo '<span class="brand-count">+' . $term->count . ' کالا</span>';
            echo '</div></a></div>';
        }

        echo '</div></div></section>';

       echo '<script>
jQuery(function() {
    jQuery(".ultra-brands-widget_slider").owlCarousel({
        loop: ' . (!empty($settings['loop']) ? 'true' : 'false') . ',
        margin: 10,
        nav: ' . (!empty($settings['nav']) ? 'true' : 'false') . ',
        dots: ' . (!empty($settings['dots']) ? 'true' : 'false') . ',
        rtl: true,
        autoplay: ' . (!empty($settings['autoplay']) ? 'true' : 'false') . ',
        responsive: {
            0: { items: 1.5 },
			500: { items: 2.3 },
            600: { items: 3.7 },
			1124: { items: 4.9 },
            1400: { items: 5.2 },
            1500: { items: 6.1 }
        }
    });
});
</script>';

    }
}