<?php

class Elementor_ultra_product_best_sell extends \Elementor\Widget_Base
{


    public function get_name()
    {
        return 'ultra_product_best_sell';
    }

    public function get_title()
    {
        return 'محصولات خاص';
    }

    public function get_icon()
    {
        return 'eicon-thumbnails-right';
    }

    public function get_categories()
    {
        return ['ultra'];
    }

    public function get_keywords()
    {
        return ['product', 'special'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('المان محصولات', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'post_number',
            [
                'label' => 'شامل محصولات',
                'description' => 'شناسه های محصول را با کاما انگلیسی جدا کنید.',
                'type' => \Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'placeholder' => '25,28,36',
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => 'عنوان',
                'type' => \Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'placeholder' => 'پرفروش ترین ها',
				 'default' => 'پرفروش ترین ها',
            ]
        );
        $this->add_control(
            'title_btn',
            [
                'label' => 'عنوان دکمه',
                'type' => \Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'placeholder' => 'همه پرفروش ها',
				'default' => 'همه پرفروش ها',
            ]
        );
        $this->add_control(
            'link_btn',
            [
                'label' => esc_html__( 'لینک', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => [ 'url', 'is_external', 'nofollow' ],
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => false,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );
        $this->end_controls_section();
        /**
         * Start Style
         */
        $this->start_controls_section(
            'definition_list_styles',
            [
                'label'  => __( 'استایل محصولات', 'demo-elementor-widget' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
          $this->add_control(
            'color_best_sell',
            [
                'label' => esc_html__('رنگ پس زمینه دکمه '),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FFBB91', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .best-selling .best-selling-box .banner-side span, {{WRAPPER}} .best-selling .best-selling-box .banner-side a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .best-selling .product-side .buttom-side .view-btn .view' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'hr1',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $post_in = explode(',', $settings['post_number']);
        ?>
        <section class="best-selling">
            <div class="best-selling-box">
                <div class="owl-carousel owl-theme best-prod ">
                    <?php
                    global $product;
                    $choosen_product = new WP_Query(array(
                        'post_type' => 'product',
                        'no_found_rows' => true,
                        'post__in' => $post_in,
                    ));
                    if ($choosen_product->have_posts()) {
                        while ($choosen_product->have_posts()) : $choosen_product->the_post(); ?>

                            <div class="product-side" data-dot="<button>
    <div class='list-product'>
      <img src='<?php echo get_the_post_thumbnail_url(); ?>'>
      <h4><?php the_title(); ?></h4>
    </div>
    </button>">
                                <div class="top-sec">
                                    <?php if (has_post_thumbnail()) {
                                        the_post_thumbnail();
                                    } else { ?>
                                        <img src="<?php echo get_template_directory_uri() . '/assets/image/empty.webp' ?>">
                                    <?php } ?>
                                    <div class="product-info">
                                        <h3><?php the_title(); ?></h3>
                                        <?php
                                        global $product;
                                        $attribute_taxonomies = wc_get_attribute_taxonomies();
                                        foreach ($attribute_taxonomies as $item) {
                                            $att_name = $item->attribute_name;
                                            $terms = get_the_terms(get_the_ID(), 'pa_' . $att_name);
                                            if (is_array($terms)) {
                                                ?>
                                                <div class="varrible">
                                                    <div class="color-varriate">
                                                        <ul>
                                                            <?php
                                                            foreach ($terms as $term) {
                                                                $tooltip = $term->name;
                                                                $colors = get_term_meta($term->term_id, 'product_attribute_color', 1);
                                                                ?>
                                                                <li>
                                                                    <?php if ($colors) { ?>
                                                                        <span class="color-bult" style="background: <?php echo $colors; ?>"></span>
                                                                    <?php } else { ?>
                                                                        <span class="size-bult"><?php echo $tooltip; ?></span>
                                                                    <?php } ?>
                                                                </li>
                                                            <?php } ?>
                                                        </ul>
                                                    </div>
                                                </div>
                                            <?php }
                                        } ?>
                                        <?php if ($product->is_in_stock() && $product->get_price_html()) { ?>
                                            <div class="price">
                                                <?php echo $product->get_price_html(); ?>
                                            </div>
                                        <?php } elseif (!$product->is_in_stock()) {
                                            echo "<div class='not_stock'><i class='fa-solid fa-multiply'></i> موجود نیست ! </div>";
                                        } else {
                                            echo "<div class='no_price'>تماس بگیرید !</div>";
                                        } ?>
                                    </div> <!-- .product-info -->

                                </div> <!-- .top-sec -->
                                <div class="buttom-side">
                                    <div class="view-btn">
                                        <?php $id = $product->get_id(); ?>
                                        <?php echo do_shortcode("[woosw id=$id]"); ?>
                                        <a class="view" href="<?php the_permalink(); ?>" target="_blank">مشاهده</a>
                                    </div> <!-- .view-btn -->

                                </div> <!-- .buttom-side -->
                            </div> <!-- .product-side -->
                        <?php
                        endwhile;
                    }
                    wp_reset_postdata();
                    ?>
                </div> <!-- .owl-carousel -->

                <div class="banner-side">
                    <span><?php echo $settings['title'];?></span>
                    <img src="<?php echo get_template_directory_uri() . '/assets/image/line.svg' ?>" alt="محصولات پرفروش">
                    <?php
                    $target=$settings['link_btn']['is_external'] ? 'target="_blank"' : '';
                    $nofollow=$settings['link_btn']['nofollow'] ? 'rel="nofollow"' : '';
                    ?>
                    <a href="<?php echo $settings['link_btn']['url'];?>" <?php echo $target,$nofollow?>><?php echo $settings['title_btn'];?></a>
                </div> <!-- .banner-side -->

            </div> <!-- .best-selling-box -->
        </section> <!-- .best-selling -->

        <script>
            jQuery(function () {
                jQuery('.best-prod').owlCarousel({
                    loop: true,
                    margin: 10,
                    pullDrag: true,
                    dots: true,
					nav:false,
                    dotsData: true,
                    rtl: true,
                    responsive: {
                        0: { items: 1 },
                        600: { items: 1 },
                        1000: { items: 1 }
                    }
                });
            });
        </script>

        <?php
    }
}