<?php

class Elementor_ultra_basic_product_widget extends \Elementor\Widget_Base
{


    public function get_name()
    {
        return 'ultra_basic_product_widget';
    }


    public function get_title()
    {
        return 'اسلایدر طرح استاندارد محصولات';
    }

    public function get_icon()
    {
        return 'eicon-products';
    }


    public function get_categories()
    {
        return ['ultra'];
    }

    public function get_keywords()
    {
        return ['product'];
    }

    function get_product_cats()
    {
        $cat_list = [];
        $product_cats = get_terms(array(
            'taxonomy' => 'product_cat',
            'hide_empty' => true,
        ));

        if (!empty($product_cats) && !is_wp_error($product_cats)) {
            foreach ($product_cats as $cat) {
                $cat_list[$cat->term_id] = $cat->name;
            }
        }
        return $cat_list;
    }

    function get_product_tags()
    {
        $tag_list = [];
        $product_tags = get_terms('product_tag');

        if (!empty($product_tags) && !is_wp_error($product_tags)) {
            foreach ($product_tags as $tag) {
                $tag_list[$tag->term_id] = $tag->name;
            }
        }
        return $tag_list;
    }

    function get_product_brands()
    {
        $brand_list = [];
        $product_brands = get_terms('product_brand');

        if (!empty($product_brands) && !is_wp_error($product_brands)) {
            foreach ($product_brands as $brand) {
                $brand_list[$brand->term_id] = $brand->name;
            }
        }
        return $brand_list;
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('المان محصولات', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __('عنوان'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'placeholder' => '',
                'default' => 'جدیدترین محصولات اولترا',
            ]
        );
        $this->add_control(
    'title_icon',
    [
        'label' => esc_html__('آیکون عنوان', 'textdomain'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'fas fa-store',
            'library' => 'fa-solid',
        ],
    ]
);

        $this->add_control(
            'product_filter',
            [
                'label' => 'فیلتر محصولات',
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'all',
                'options' => [
                    'all' => 'همه محصولات',
                    'category' => 'براساس دسته بندی',
                    'tag' => 'براساس برچسب',
                    'brand' => 'براساس برند',
                ],
            ]
        );
        $this->add_control(
            'cat',
            [
                'label' => 'دسته بندی',
                'type' => \Elementor\Controls_Manager::SELECT2,
                'multiple' => true,
                'label_block' => true,
                'options' => $this->get_product_cats(),
                'condition' => [
                    'product_filter' => 'category',
                ],
            ]
        );
        $this->add_control(
            'tag',
            [
                'label' => 'برچسب',
                'type' => \Elementor\Controls_Manager::SELECT2,
                'multiple' => true,
                'label_block' => true,
                'options' => $this->get_product_tags(),
                'condition' => [
                    'product_filter' => 'tag',
                ],
            ]
        );
        $this->add_control(
            'brand',
            [
                'label' => 'برند',
                'type' => \Elementor\Controls_Manager::SELECT2,
                'multiple' => true,
                'label_block' => true,
                'options' => $this->get_product_brands(),
                'condition' => [
                    'product_filter' => 'brand',
                ],
            ]
        );
        $this->add_control(
            'product_rand',
            [
                'label' => esc_html__('تصادفی'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('فعال'),
                'label_off' => esc_html__('غیرفعال'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'number',
            [
                'label' => 'تعداد محصولات',
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 40,
                'step' => 1,
                'default' => 6,
            ]
        );
        $this->add_control(
            'item_slide',
            [
                'label' => 'تعداد آیتم های اسلایدر',
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 4,
                'max' => 6,
                'step' => 1,
                'default' => 5,
            ]
        );
        $this->add_control(
            'show_nav',
            [
                'label' => 'نمایش پیکان ها',
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'textdomain'),
                'label_off' => esc_html__('مخفی', 'textdomain'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'stock',
            [
                'label' => 'حذف محصولات ناموجود',
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => 'فعال',
                'label_off' => 'غیرفعال',
                'return_value' => 'yes',
                'default' => '',
            ]
        );

        $this->end_controls_section();
        /**
         * Start Style
         */
        $this->start_controls_section(
            'definition_list_styles',
            [
                'label'  => __( 'استایل محصولات', 'demo-elementor-widget' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_text_color',
            [
                'label' => esc_html__('رنگ متن سرتیتر محصولات'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#000', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .choosen-product .product-items .item a h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'hr1',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'price_text_color',
            [
                'label' => esc_html__('رنگ قیمت محصولات'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#000', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .product-items .item .price' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'del_text_color',
            [
                'label' => esc_html__('رنگ قیمت تخفیف خورده محصولات'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#A8ADBE', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .item .price del, .item .price-section del' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'hr2',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'text_btn_color',
            [
                'label' => esc_html__('رنگ متن دکمه تماس بگیرید'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .product-items .item .no_price' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'background_btn_color',
            [
                'label' => esc_html__('رنگ زمینه دکمه تماس بگیرید'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FFBB91', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .product-items .item .no_price' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
    'title_icon_color',
    [
        'label' => esc_html__('رنگ آیکون عنوان', 'textdomain'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#000000',
        'selectors' => [
            '{{WRAPPER}} .product-title i' => 'color: {{VALUE}};',
        ],
        'condition' => [
            'title_icon[value]!' => '',
        ],
    ]
);
$this->add_control(
    'bg_button_color',
    [
        'label' => esc_html__('رنگ زمینه فلش ها', 'textdomain'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#000000',
        'selectors' => [
            '{{WRAPPER}} .choosen-product button' => 'background-color: {{VALUE}};',
        ],
    ]
);
$this->add_control(
    'bg_hover_button_color',
    [
        'label' => esc_html__('رنگ هاور فلش ها', 'textdomain'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#000000',
        'selectors' => [
            '{{WRAPPER}} .choosen-product button:hover' => 'background-color: {{VALUE}};',
        ],
    ]
);
$this->add_control(
    'button_color',
    [
        'label' => esc_html__('رنگ فلش ها', 'textdomain'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#fff',
        'selectors' => [
            '{{WRAPPER}} .choosen-product button' => 'color: {{VALUE}};',
        ],
    ]
);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
        <section class="choosen-product">
            <div class="product-title">
				<?php if (!empty($settings['title_icon']['value'])): ?>
        <i class="<?php echo esc_attr($settings['title_icon']['value']); ?>"></i>
    <?php endif; ?>
                <h2><?php echo $settings['title']; ?></h2>
            </div>
            <div class="product-items">
				
		
    <div class="skeleton-slider">
       <div class="skeleton-item">
    <div class="skeleton-image"></div>
    <div class="skeleton-title"></div>
    <div class="skeleton-price"></div>
</div>
		<div class="skeleton-item">
    <div class="skeleton-image"></div>
    <div class="skeleton-title"></div>
    <div class="skeleton-price"></div>
</div>
		<div class="skeleton-item">
    <div class="skeleton-image"></div>
    <div class="skeleton-title"></div>
    <div class="skeleton-price"></div>
</div>
    </div>
				
				
                <div class="owl-carousel owl-theme  choosen-prod" data-show-nav="true">
                    <?php
                    $product_args = array(
                        'post_type' => 'product',
                        'posts_per_page' => $settings['number'],
                    );
                    if ($settings['product_filter'] == 'category') {
                        $tax_query = array(
                            'relation' => 'OR',
                            array(
                                'taxonomy' => 'product_cat',
                                'field' => 'term_id',
                                'terms' => $settings['cat'],
                            ),
                        );
                        $product_args['tax_query'] = $tax_query;
                    }
                    if ($settings['product_rand'] == 'yes') {
                        $product_args['orderby'] = 'rand';
                    } elseif ($settings['product_filter'] == 'tag') {
                        $tax_query = array(
                            'relation' => 'OR',
                            array(
                                'taxonomy' => 'product_tag',
                                'field' => 'term_id',
                                'terms' => $settings['tag'],
                            ),
                        );
                        $product_args['tax_query'] = $tax_query;
                    } elseif ($settings['product_filter'] == 'brand') {
                        $tax_query = array(
                            'relation' => 'OR',
                            array(
                                'taxonomy' => 'product_brand',
                                'field' => 'term_id',
                                'terms' => $settings['brand'],
                            ),
                        );
                        $product_args['tax_query'] = $tax_query;
                    }
                    if ($settings['stock']) {
                        $meta_query = array(
                            array(
                                'key' => '_stock_status',
                                'value' => 'instock',
                                'compare' => '=',
                            ),
                        );
                        $product_args['meta_query'] = $meta_query;
                    }
                    $pro = new WP_Query($product_args);
                    if ($pro->have_posts()) {
                        while ($pro->have_posts()) : $pro->the_post();
                            ?>
                            <div class="item">
                                <a class="product-image" href="<?php the_permalink(); ?>">
                                    <figure>
                                        <?php global $product;
                                        if (has_post_thumbnail()) {
                                            the_post_thumbnail('product');
                                        } else { ?>
                                            <img src="<?php echo get_template_directory_uri() . '/assets/image/empty.webp' ?>" />
                                        <?php } ?>
                                    </figure>
                                </a>

                                <a href="<?php the_permalink(); ?>"><h3><?php the_title(); ?></h3></a>
                                <?php if ($product->is_in_stock() && $product->get_price_html()) { ?>
                                    <div class="price">
                                        <?php echo $product->get_price_html(); ?>
                                    </div>
                                <?php } elseif (!$product->is_in_stock()) {
                                    echo "<div class='not_stock'>موجود نیست !</div>";
                                } else {
                                    echo "<div class='no_price'>تماس بگیرید !</div>";
                                }
                                ?>
                            </div>
                        <?php
                        endwhile;
                    } else {
                        echo "<p>مطلبی پیدا نشد</p>";
                    }
                    wp_reset_postdata();
                    ?>
                </div>
            </div>
        </section>

      <script>
jQuery(function ($) {

    function getItemCountByContainerWidth(containerWidth) {
        if (containerWidth >= 1820) return <?php echo $settings['item_slide']; ?>;
       if (containerWidth >= 1500) return 6;
        if (containerWidth >= 1200) return 5;
        if (containerWidth >= 992) return 4;
        if (containerWidth >= 768) return 3;
        if (containerWidth >= 430) return 2;
        return 1;
    }

    function initSlider($slider) {
        let containerWidth = $slider.closest('.product-items').width();
        let itemCount = getItemCountByContainerWidth(containerWidth);
        let navEnabled = $slider.data('show-nav') === true || $slider.data('show-nav') === "true";

        $slider.owlCarousel({
            loop: true,
            margin: 16,
            rtl: true,
            dots: false,
            nav: navEnabled,
            navText: "",
            items: itemCount
        });

        setTimeout(function () {
            $slider.siblings('.skeleton-slider').fadeOut(200);
            $slider.fadeIn(200);
        }, 100);
    }

    $('.choosen-prod').each(function () {
        const $slider = $(this);
        $slider.hide(); // مخفی‌سازی اولیه اسلایدر
        initSlider($slider);

        let resizeTimer;
        $(window).on('resize', function () {
            clearTimeout(resizeTimer);
            resizeTimer = setTimeout(function () {
                if ($slider.hasClass('owl-loaded')) {
                    $slider.trigger('destroy.owl.carousel');
                    $slider.removeClass('owl-loaded owl-hidden');
                    $slider.find('.owl-stage-outer').children().unwrap();
                }
                initSlider($slider);
            }, 300);
        });
    });

});
</script>


        <?php
    }

}