<?php

class Elementor_ultra_tv_slider_widget extends \Elementor\Widget_Base
{


    public function get_name()
    {
        return 'ultra_tv_slider';
    }


    public function get_title()
    {
        return 'اسلایدر تلویزیون اولترا';
    }

    public function get_icon()
    {
        return 'eicon-tv';
    }


    public function get_categories()
    {
        return ['ultra'];
    }

    public function get_keywords()
    {
        return ['tv'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('محتوای تلویزیون اولترا', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'tv_title',
            [
                'label' => esc_html__('عنوان '),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('تلویزیون'),
                'placeholder' => esc_html__('تلویزیون اولترا'),
            ]
        );
        $this->add_control(
            'btn_title',
            [
                'label' => esc_html__('عنوان دکمه'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('مشاهده'),
                'placeholder' => esc_html__('تلویزیون اولترا'),
            ]
        );
        $this->add_control(
            'link',
            [
                'label' => esc_html__('لینک دکمه را وارد کنید.', 'textdomain'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => 'https://yoursite.com/tv',
                'default' => ['url' => ''],
            ]
        );
        $this->add_control(
            'number_post_per_page',
            [
                'label' => esc_html__('تعداد پست را وارد کنید'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 2,
                'max' => 10,
                'step' => 1,
                'default' => 5,
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'definition_list_styles',
            [
                'label' => __('استایل', 'demo-elementor-widget'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_text_color',
            [
                'label' => esc_html__('رنگ متن سرتیتر'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#242424',
                'selectors' => [
                    '{{WRAPPER}} .ultra-tv-showcase-widget .ultra-header-widgets .title h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'background_btn_color',
            [
                'label' => esc_html__('رنگ زمینه دکمه'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FFF', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .ultra-tv-showcase-widget .ultra-header-widgets a' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display(); ?>
        <section class="ultra-tv-showcase-widget ultra-slider-nav-style">
            <div class="ultra-header-widgets">
                <?php if (!empty($settings['tv_title'])): ?>
                    <div class="title">
                        <figure>
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="21"
                                 viewBox="0 0 20 21" fill="none">
                                <path d="M15 1.96594H5.00002C3.15907 1.96594 1.66669 3.45833 1.66669 5.29928V15.2993C1.66669 17.1402 3.15907 18.6326 5.00002 18.6326H15C16.841 18.6326 18.3334 17.1402 18.3334 15.2993V5.29928C18.3334 3.45833 16.841 1.96594 15 1.96594ZM15 1.96594L11.6667 6.96594M1.66669 6.96594H18.3334M8.33335 1.96594L5.00002 6.96594M8.33335 11.8016V13.797C8.33335 14.7953 9.44604 15.3908 10.2767 14.837L11.7733 13.8393C12.5154 13.3446 12.5154 12.254 11.7733 11.7592L10.2767 10.7615C9.44603 10.2077 8.33335 10.8032 8.33335 11.8016Z"
                                      stroke="#007AF4" stroke-width="1.5" stroke-linejoin="round"/>
                            </svg>
                        </figure>
                        <h3><?php echo $settings['tv_title']; ?></h3>
                    </div>
                <?php endif; ?>
                <?php
                $url         = $settings['link']['url'] ?? '';
                $is_external = $settings['link']['is_external'] ? ' target="_blank"' : '';
                $nofollow    = $settings['link']['nofollow']    ? ' rel="nofollow"'  : '';
                ?>
                <a href="<?php echo esc_url( $url ); ?>" <?php echo $is_external . $nofollow; ?> class="view-all"><?php echo esc_html($settings['btn_title']); ?></a>
            </div>
            <div class="owl-carousel owl-theme tv-showcase_slider">
                <?php $big_tv = new WP_Query(array(
                    'post_type' => 'tv',
                    'posts_per_page' => $settings['number_post_per_page'],
                    'no_found_rows' => true,
                ));
                if ($big_tv->have_posts()) :
                    while ($big_tv->have_posts()) : $big_tv->the_post(); ?>
                        <a href="<?php the_permalink(); ?>" class="item">
                            <figure class="image-section">
                                <div class="outer-icon">
                                    <div class="play-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="17"
                                             viewBox="0 0 14 17" fill="none">
                                            <path d="M10.9611 10.5358L2.99228 15.0894C1.65896 15.8513 0 14.8886 0 13.353V8.79932V4.24568C0 2.71003 1.65896 1.7473 2.99228 2.50919L10.9611 7.06283C12.3048 7.83062 12.3048 9.76801 10.9611 10.5358Z"
                                                  fill="#007AF4"/>
                                        </svg>
                                    </div>
                                </div>
                                <?php if (has_post_thumbnail()){
                                    the_post_thumbnail();
                                }
                                else{ ?>
                                    <img src="<?= get_template_directory_uri().'/assets/image/empty.webp' ?>" />
                                <?php } ?>
                            </figure>
                            <h4><?php the_title(); ?></h4>
                            <div class="info-box">
                                <div class="author">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="21"
                                         viewBox="0 0 20 21" fill="none">
                                        <path d="M13.3334 6.63265H12.5834C12.5834 8.05939 11.4268 9.21598 10 9.21598V9.96598V10.716C12.2552 10.716 14.0834 8.88781 14.0834 6.63265H13.3334ZM10 9.96598V9.21598C8.57328 9.21598 7.41669 8.05939 7.41669 6.63265H6.66669H5.91669C5.91669 8.88781 7.74486 10.716 10 10.716V9.96598ZM6.66669 6.63265H7.41669C7.41669 5.20591 8.57328 4.04932 10 4.04932V3.29932V2.54932C7.74486 2.54932 5.91669 4.37749 5.91669 6.63265H6.66669ZM10 3.29932V4.04932C11.4268 4.04932 12.5834 5.20591 12.5834 6.63265H13.3334H14.0834C14.0834 4.37749 12.2552 2.54932 10 2.54932V3.29932ZM15.8334 15.3826H15.0834C15.0834 15.7509 14.7653 16.2863 13.7894 16.7742C12.8584 17.2397 11.5197 17.5493 10 17.5493V18.2993V19.0493C11.702 19.0493 13.28 18.706 14.4602 18.1159C15.5956 17.5482 16.5834 16.6252 16.5834 15.3826H15.8334ZM10 18.2993V17.5493C8.48038 17.5493 7.14168 17.2397 6.21064 16.7742C5.23474 16.2863 4.91669 15.7509 4.91669 15.3826H4.16669H3.41669C3.41669 16.6252 4.40447 17.5482 5.53982 18.1159C6.72004 18.706 8.298 19.0493 10 19.0493V18.2993ZM4.16669 15.3826H4.91669C4.91669 15.0144 5.23474 14.479 6.21064 13.9911C7.14168 13.5256 8.48038 13.216 10 13.216V12.466V11.716C8.298 11.716 6.72004 12.0593 5.53982 12.6494C4.40447 13.2171 3.41669 14.1401 3.41669 15.3826H4.16669ZM10 12.466V13.216C11.5197 13.216 12.8584 13.5256 13.7894 13.9911C14.7653 14.479 15.0834 15.0144 15.0834 15.3826H15.8334H16.5834C16.5834 14.1401 15.5956 13.2171 14.4602 12.6494C13.28 12.0593 11.702 11.716 10 11.716V12.466Z"
                                              fill="#C2C5C6"/>
                                    </svg>
                                    <span><?php echo esc_html( get_the_author()); ?></span>
                                </div>
                                <div class="date">
                                    <span><?php the_date('Y/m/d'); ?></span>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="21"
                                         viewBox="0 0 20 21" fill="none">
                                        <path d="M2.5 7.71607C2.5 5.50693 4.29086 3.71606 6.5 3.71606H13.5C15.7091 3.71606 17.5 5.50693 17.5 7.71606V15.1327C17.5 17.3419 15.7091 19.1327 13.5 19.1327H6.5C4.29086 19.1327 2.5 17.3419 2.5 15.1327V7.71607Z"
                                              stroke="#C2C5C6" stroke-width="1.5"/>
                                        <path d="M2.5 8.29932H17.5" stroke="#C2C5C6" stroke-width="1.5"
                                              stroke-linecap="round"/>
                                        <path d="M6.66667 2.46606L6.66667 4.96606" stroke="#C2C5C6"
                                              stroke-width="1.5" stroke-linecap="round"
                                              stroke-linejoin="round"/>
                                        <path d="M13.3333 2.46606V4.96606" stroke="#C2C5C6"
                                              stroke-width="1.5" stroke-linecap="round"
                                              stroke-linejoin="round"/>
                                        <circle cx="10" cy="13.2994" r="0.833333" fill="#C2C5C6"/>
                                        <circle cx="13.3333" cy="13.2994" r="0.833333" fill="#C2C5C6"/>
                                        <circle cx="6.66666" cy="13.2994" r="0.833333" fill="#C2C5C6"/>
                                    </svg>
                                </div>
                            </div>

                        </a>
                    <?php endwhile;
                endif;
                wp_reset_postdata(); ?>
            </div>
        </section>
        <script>
            jQuery(document).ready(function ($) {
                $('.tv-showcase_slider').owlCarousel({
                    loop:true,
                    margin:10,
                    nav:true,
                    dots:false,
                    rtl:true,
                    responsive:{
                        0:{
                            items:1.2
                        },
                        600:{
                            items:2.2
                        },
                        1400:{
                            items:3
                        },
                        1500:{
                            items:4
                        }
                    }
                });
            });
        </script>
        <?php
    }
}